/*
 * Decompiled with CFR 0.152.
 */
package omrecorder;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public interface AudioChunk {
    public double maxAmplitude();

    public byte[] toBytes();

    public short[] toShorts();

    public static final class Shorts
    implements AudioChunk {
        private static final short SILENCE_THRESHOLD = 2700;
        private static final double REFERENCE = 0.6;
        final short[] shorts;
        int numberOfShortsRead;

        Shorts(short[] bytes) {
            this.shorts = bytes;
        }

        int peakIndex() {
            int arrLen = this.shorts.length;
            for (int peakIndex = 0; peakIndex < arrLen; ++peakIndex) {
                if (this.shorts[peakIndex] < 2700 && this.shorts[peakIndex] > -2700) continue;
                return peakIndex;
            }
            return -1;
        }

        @Override
        public double maxAmplitude() {
            short nMaxAmp = 0;
            int arrLen = this.shorts.length;
            for (int peakIndex = 0; peakIndex < arrLen; ++peakIndex) {
                if (this.shorts[peakIndex] < nMaxAmp) continue;
                nMaxAmp = this.shorts[peakIndex];
            }
            return (int)(20.0 * Math.log10((double)nMaxAmp / 0.6));
        }

        @Override
        public byte[] toBytes() {
            byte[] buffer = new byte[this.numberOfShortsRead * 2];
            int byteIndex = 0;
            int shortIndex = 0;
            while (shortIndex != this.numberOfShortsRead) {
                buffer[byteIndex] = (byte)(this.shorts[shortIndex] & 0xFF);
                buffer[byteIndex + 1] = (byte)((this.shorts[shortIndex] & 0xFF00) >> 8);
                ++shortIndex;
                byteIndex += 2;
            }
            return buffer;
        }

        @Override
        public short[] toShorts() {
            return this.shorts;
        }
    }

    public static final class Bytes
    implements AudioChunk {
        private static final double REFERENCE = 0.6;
        final byte[] bytes;
        int numberOfBytesRead;

        Bytes(byte[] bytes) {
            this.bytes = bytes;
        }

        @Override
        public double maxAmplitude() {
            short[] shorts = this.toShorts();
            short nMaxAmp = 0;
            int arrLen = shorts.length;
            for (int peakIndex = 0; peakIndex < arrLen; ++peakIndex) {
                if (shorts[peakIndex] < nMaxAmp) continue;
                nMaxAmp = shorts[peakIndex];
            }
            return (int)(20.0 * Math.log10((double)nMaxAmp / 0.6));
        }

        @Override
        public byte[] toBytes() {
            return this.bytes;
        }

        @Override
        public short[] toShorts() {
            short[] shorts = new short[this.bytes.length / 2];
            ByteBuffer.wrap(this.bytes).order(ByteOrder.LITTLE_ENDIAN).asShortBuffer().get(shorts);
            return shorts;
        }
    }
}

