/*
 * Decompiled with CFR 0.152.
 */
package omrecorder;

import android.media.AudioRecord;

public interface AudioSource {
    public AudioRecord audioRecorder();

    public int channelPositionMask();

    public int frequency();

    public int minimumBufferSize();

    public byte bitsPerSample();

    public void isEnableToBePulled(boolean var1);

    public boolean isEnableToBePulled();

    public static class Smart
    implements AudioSource {
        private final int audioSource;
        private final AudioRecord audioRecord;
        private final int channelPositionMask;
        private final int audioEncoding;
        private final int frequency;
        private volatile boolean pull;

        public Smart(int audioSource, int audioEncoding, int channelPositionMask, int frequency) {
            this.audioSource = audioSource;
            this.audioEncoding = audioEncoding;
            this.channelPositionMask = channelPositionMask;
            this.frequency = frequency;
            this.audioRecord = new AudioRecord(audioSource, frequency, channelPositionMask, audioEncoding, this.minimumBufferSize());
        }

        @Override
        public AudioRecord audioRecorder() {
            return this.audioRecord;
        }

        @Override
        public int channelPositionMask() {
            return this.channelPositionMask;
        }

        @Override
        public int frequency() {
            return this.frequency;
        }

        @Override
        public int minimumBufferSize() {
            return AudioRecord.getMinBufferSize((int)this.frequency, (int)this.channelPositionMask, (int)this.audioEncoding);
        }

        @Override
        public byte bitsPerSample() {
            if (this.audioEncoding == 2) {
                return 16;
            }
            if (this.audioEncoding == 3) {
                return 8;
            }
            return 16;
        }

        @Override
        public void isEnableToBePulled(boolean enabledToBePulled) {
            this.pull = enabledToBePulled;
        }

        @Override
        public boolean isEnableToBePulled() {
            return this.pull;
        }
    }
}

