/*
 * Decompiled with CFR 0.152.
 */
package omrecorder;

import android.media.AudioRecord;
import java.io.IOException;
import java.io.OutputStream;
import omrecorder.AudioChunk;
import omrecorder.AudioSource;
import omrecorder.Recorder;
import omrecorder.UiThread;
import omrecorder.WriteAction;

public interface PullTransport {
    public void start(OutputStream var1) throws IOException;

    public void stop();

    public AudioSource source();

    public static final class Noise
    extends AbstractPullTransport {
        private final AudioChunk.Shorts audioChunk;
        private final long silenceTimeThreshold;
        private final Recorder.OnSilenceListener silenceListener;
        private final WriteAction writeAction;
        private long firstSilenceMoment = 0L;
        private int noiseRecordedAfterFirstSilenceThreshold = 0;

        public Noise(AudioSource audioRecordSource, OnAudioChunkPulledListener onAudioChunkPulledListener, WriteAction writeAction, Recorder.OnSilenceListener silenceListener, long silenceTimeThreshold) {
            super(audioRecordSource, onAudioChunkPulledListener);
            this.writeAction = writeAction;
            this.silenceListener = silenceListener;
            this.silenceTimeThreshold = silenceTimeThreshold;
            this.audioChunk = new AudioChunk.Shorts(new short[audioRecordSource.minimumBufferSize()]);
        }

        public Noise(AudioSource audioRecordSource, OnAudioChunkPulledListener onAudioChunkPulledListener, Recorder.OnSilenceListener silenceListener, long silenceTimeThreshold) {
            this(audioRecordSource, onAudioChunkPulledListener, new WriteAction.Default(), silenceListener, silenceTimeThreshold);
        }

        public Noise(AudioSource audioRecordSource, WriteAction writeAction, Recorder.OnSilenceListener silenceListener, long silenceTimeThreshold) {
            this(audioRecordSource, null, writeAction, silenceListener, silenceTimeThreshold);
        }

        public Noise(AudioSource audioRecordSource, Recorder.OnSilenceListener silenceListener, long silenceTimeThreshold) {
            this(audioRecordSource, null, new WriteAction.Default(), silenceListener, silenceTimeThreshold);
        }

        public Noise(AudioSource audioRecordSource, Recorder.OnSilenceListener silenceListener) {
            this(audioRecordSource, null, new WriteAction.Default(), silenceListener, 200L);
        }

        public Noise(AudioSource audioRecordSource) {
            this(audioRecordSource, null, new WriteAction.Default(), null, 200L);
        }

        @Override
        public void start(OutputStream outputStream) throws IOException {
            AudioRecord audioRecord = this.audioRecordSource.audioRecorder();
            audioRecord.startRecording();
            this.audioRecordSource.isEnableToBePulled(true);
            while (this.audioRecordSource.isEnableToBePulled()) {
                this.audioChunk.numberOfShortsRead = audioRecord.read(this.audioChunk.shorts, 0, this.audioChunk.shorts.length);
                if (-3 == this.audioChunk.numberOfShortsRead) continue;
                if (this.onAudioChunkPulledListener != null) {
                    this.postPullEvent(this.audioChunk);
                }
                if (this.audioChunk.peakIndex() > -1) {
                    this.writeAction.execute(this.audioChunk.toBytes(), outputStream);
                    this.firstSilenceMoment = 0L;
                    ++this.noiseRecordedAfterFirstSilenceThreshold;
                    continue;
                }
                if (this.firstSilenceMoment == 0L) {
                    this.firstSilenceMoment = System.currentTimeMillis();
                }
                long silenceTime = System.currentTimeMillis() - this.firstSilenceMoment;
                if (this.firstSilenceMoment != 0L && silenceTime > this.silenceTimeThreshold) {
                    if (silenceTime <= 1000L || this.noiseRecordedAfterFirstSilenceThreshold < 3) continue;
                    this.noiseRecordedAfterFirstSilenceThreshold = 0;
                    if (this.silenceListener == null) continue;
                    this.postSilenceEvent(this.silenceListener, silenceTime);
                    continue;
                }
                this.writeAction.execute(this.audioChunk.toBytes(), outputStream);
            }
        }
    }

    public static final class Default
    extends AbstractPullTransport {
        private final WriteAction writeAction;

        public Default(AudioSource audioRecordSource, OnAudioChunkPulledListener onAudioChunkPulledListener, WriteAction writeAction) {
            super(audioRecordSource, onAudioChunkPulledListener);
            this.writeAction = writeAction;
        }

        public Default(AudioSource audioRecordSource, WriteAction writeAction) {
            this(audioRecordSource, null, writeAction);
        }

        public Default(AudioSource audioRecordSource, OnAudioChunkPulledListener onAudioChunkPulledListener) {
            this(audioRecordSource, onAudioChunkPulledListener, new WriteAction.Default());
        }

        public Default(AudioSource audioRecordSource) {
            this(audioRecordSource, null, new WriteAction.Default());
        }

        @Override
        void startPoolingAndWriting(AudioRecord audioRecord, int minimumBufferSize, OutputStream outputStream) throws IOException {
            while (this.audioRecordSource.isEnableToBePulled()) {
                AudioChunk.Bytes audioChunk = new AudioChunk.Bytes(new byte[minimumBufferSize]);
                if (-3 == audioRecord.read(audioChunk.toBytes(), 0, minimumBufferSize)) continue;
                if (this.onAudioChunkPulledListener != null) {
                    this.postPullEvent(audioChunk);
                }
                this.writeAction.execute(audioChunk.toBytes(), outputStream);
            }
        }
    }

    public static abstract class AbstractPullTransport
    implements PullTransport {
        final AudioSource audioRecordSource;
        final OnAudioChunkPulledListener onAudioChunkPulledListener;
        private final UiThread uiThread = new UiThread();

        AbstractPullTransport(AudioSource audioRecordSource, OnAudioChunkPulledListener onAudioChunkPulledListener) {
            this.audioRecordSource = audioRecordSource;
            this.onAudioChunkPulledListener = onAudioChunkPulledListener;
        }

        @Override
        public void start(OutputStream outputStream) throws IOException {
            this.startPoolingAndWriting(this.preparedSourceToBePulled(), this.audioRecordSource.minimumBufferSize(), outputStream);
        }

        void startPoolingAndWriting(AudioRecord audioRecord, int minimumBufferSize, OutputStream outputStream) throws IOException {
        }

        @Override
        public void stop() {
            this.audioRecordSource.isEnableToBePulled(false);
            this.audioRecordSource.audioRecorder().stop();
        }

        @Override
        public AudioSource source() {
            return this.audioRecordSource;
        }

        AudioRecord preparedSourceToBePulled() {
            AudioRecord audioRecord = this.audioRecordSource.audioRecorder();
            audioRecord.startRecording();
            this.audioRecordSource.isEnableToBePulled(true);
            return audioRecord;
        }

        void postSilenceEvent(final Recorder.OnSilenceListener onSilenceListener, final long silenceTime) {
            this.uiThread.execute(new Runnable(){

                @Override
                public void run() {
                    onSilenceListener.onSilence(silenceTime);
                }
            });
        }

        void postPullEvent(final AudioChunk audioChunk) {
            this.uiThread.execute(new Runnable(){

                @Override
                public void run() {
                    AbstractPullTransport.this.onAudioChunkPulledListener.onAudioChunkPulled(audioChunk);
                }
            });
        }
    }

    public static interface OnAudioChunkPulledListener {
        public void onAudioChunkPulled(AudioChunk var1);
    }
}

