/*
 * Decompiled with CFR 0.152.
 */
package omrecorder;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import omrecorder.AbstractRecorder;
import omrecorder.PullTransport;
import omrecorder.WavHeader;

final class Wav
extends AbstractRecorder {
    private final RandomAccessFile wavFile;

    public Wav(PullTransport pullTransport, File file) {
        super(pullTransport, file);
        this.wavFile = this.randomAccessFile(file);
    }

    private RandomAccessFile randomAccessFile(File file) {
        RandomAccessFile randomAccessFile;
        try {
            randomAccessFile = new RandomAccessFile(file, "rw");
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
        return randomAccessFile;
    }

    @Override
    public void stopRecording() {
        super.stopRecording();
        try {
            this.writeWavHeader();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void writeWavHeader() throws IOException {
        long totalAudioLen = new FileInputStream(this.file).getChannel().size();
        try {
            this.wavFile.seek(0L);
            this.wavFile.write(new WavHeader(this.pullTransport.source(), totalAudioLen).toBytes());
            this.wavFile.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

