/*
 * Decompiled with CFR 0.152.
 */
package com.kyanogen.signatureview;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import com.kyanogen.signatureview.R;
import com.kyanogen.signatureview.model.Point;

public class SignatureView
extends View {
    public static final String TAG = SignatureView.class.getSimpleName();
    private Canvas canvasBmp;
    private boolean ignoreTouch;
    private Point previousPoint;
    private Point startPoint;
    private Point currentPoint;
    public static final float MIN_PEN_SIZE = 1.0f;
    private static final float MIN_INCREMENT = 0.01f;
    private static final float INCREMENT_CONSTANT = 5.0E-4f;
    private static final float DRAWING_CONSTANT = 0.0085f;
    public static final float MAX_VELOCITY_BOUND = 15.0f;
    private static final float MIN_VELOCITY_BOUND = 1.6f;
    private static final float STROKE_DES_VELOCITY = 1.0f;
    private static final float VELOCITY_FILTER_WEIGHT = 0.2f;
    private float lastVelocity;
    private float lastWidth;
    private Paint paint;
    private Paint paintBm;
    private Bitmap bmp;
    private int layoutLeft;
    private int layoutTop;
    private int layoutRight;
    private int layoutBottom;
    private Rect drawViewRect;
    private int penColor;
    private int backgroundColor;
    private boolean enableSignature;
    private float penSize;
    private Context context;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SignatureView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.context = context;
        this.setWillNotDraw(false);
        this.setDrawingCacheEnabled(true);
        TypedArray typedArray = context.getTheme().obtainStyledAttributes(attrs, R.styleable.signature, 0, 0);
        try {
            this.backgroundColor = typedArray.getColor(R.styleable.signature_backgroundColor, context.getResources().getColor(R.color.white));
            this.penColor = typedArray.getColor(R.styleable.signature_penColor, context.getResources().getColor(R.color.penRoyalBlue));
            this.penSize = typedArray.getDimension(R.styleable.signature_penSize, context.getResources().getDimension(R.dimen.pen_size));
            this.enableSignature = typedArray.getBoolean(R.styleable.signature_enableSignature, true);
        }
        finally {
            typedArray.recycle();
        }
        this.paint = new Paint(1);
        this.paint.setColor(this.penColor);
        this.paint.setAntiAlias(true);
        this.paint.setStyle(Paint.Style.FILL_AND_STROKE);
        this.paint.setStrokeJoin(Paint.Join.ROUND);
        this.paint.setStrokeCap(Paint.Cap.ROUND);
        this.paint.setStrokeWidth(this.penSize);
        this.paintBm = new Paint(1);
        this.paintBm.setAntiAlias(true);
        this.paintBm.setStyle(Paint.Style.STROKE);
        this.paintBm.setStrokeJoin(Paint.Join.ROUND);
        this.paintBm.setStrokeCap(Paint.Cap.ROUND);
        this.paintBm.setColor(-16777216);
    }

    public float getPenSize() {
        return this.penSize;
    }

    public void setPenSize(float penSize) {
        this.penSize = penSize;
    }

    public boolean isEnableSignature() {
        return this.enableSignature;
    }

    public void setEnableSignature(boolean enableSignature) {
        this.enableSignature = enableSignature;
    }

    public int getPenColor() {
        return this.penColor;
    }

    public void setPenColor(int penColor) {
        this.penColor = penColor;
        this.paint.setColor(penColor);
    }

    public int getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setBackgroundColor(int backgroundColor) {
        this.backgroundColor = backgroundColor;
    }

    public void clearCanvas() {
        this.previousPoint = null;
        this.startPoint = null;
        this.currentPoint = null;
        this.lastVelocity = 0.0f;
        this.lastWidth = 0.0f;
        this.newBitmapCanvas(this.layoutLeft, this.layoutTop, this.layoutRight, this.layoutBottom);
        this.postInvalidate();
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        super.onLayout(changed, left, top, right, bottom);
        this.layoutLeft = left;
        this.layoutTop = top;
        this.layoutRight = right;
        this.layoutBottom = bottom;
        if (this.bmp == null) {
            this.newBitmapCanvas(this.layoutLeft, this.layoutTop, this.layoutRight, this.layoutBottom);
        }
    }

    private void newBitmapCanvas(int left, int top, int right, int bottom) {
        this.bmp = null;
        this.canvasBmp = null;
        if (right - left > 0 && bottom - top > 0) {
            this.bmp = Bitmap.createBitmap((int)(right - left), (int)(bottom - top), (Bitmap.Config)Bitmap.Config.ARGB_8888);
            this.canvasBmp = new Canvas(this.bmp);
            this.canvasBmp.drawColor(this.backgroundColor);
        }
    }

    public boolean onTouchEvent(MotionEvent event) {
        if (!this.isEnableSignature()) {
            return false;
        }
        if (event.getPointerCount() > 1) {
            return false;
        }
        switch (event.getAction()) {
            case 0: {
                this.ignoreTouch = false;
                this.drawViewRect = new Rect(this.getLeft(), this.getTop(), this.getRight(), this.getBottom());
                this.onTouchDownEvent(event.getX(), event.getY());
                break;
            }
            case 2: {
                if (!this.drawViewRect.contains(this.getLeft() + (int)event.getX(), this.getTop() + (int)event.getY())) {
                    if (this.ignoreTouch) break;
                    this.ignoreTouch = true;
                    this.onTouchUpEvent(event.getX(), event.getY());
                    break;
                }
                if (this.ignoreTouch) {
                    this.ignoreTouch = false;
                    this.onTouchDownEvent(event.getX(), event.getY());
                    break;
                }
                this.onTouchMoveEvent(event.getX(), event.getY());
                break;
            }
            case 1: 
            case 3: {
                this.onTouchUpEvent(event.getX(), event.getY());
                break;
            }
        }
        return true;
    }

    private void onTouchDownEvent(float x, float y) {
        this.previousPoint = null;
        this.startPoint = null;
        this.currentPoint = null;
        this.lastVelocity = 0.0f;
        this.lastWidth = this.penSize;
        this.startPoint = this.previousPoint = (this.currentPoint = new Point(x, y, System.currentTimeMillis()));
        this.postInvalidate();
    }

    private void onTouchMoveEvent(float x, float y) {
        if (this.previousPoint == null) {
            return;
        }
        this.startPoint = this.previousPoint;
        this.previousPoint = this.currentPoint;
        this.currentPoint = new Point(x, y, System.currentTimeMillis());
        float velocity = this.currentPoint.velocityFrom(this.previousPoint);
        velocity = 0.2f * velocity + 0.8f * this.lastVelocity;
        float strokeWidth = this.getStrokeWidth(velocity);
        this.drawLine(this.lastWidth, strokeWidth, velocity);
        this.lastVelocity = velocity;
        this.lastWidth = strokeWidth;
        this.postInvalidate();
    }

    private void onTouchUpEvent(float x, float y) {
        if (this.previousPoint == null) {
            return;
        }
        this.startPoint = this.previousPoint;
        this.previousPoint = this.currentPoint;
        this.currentPoint = new Point(x, y, System.currentTimeMillis());
        this.drawLine(this.lastWidth, 0.0f, this.lastVelocity);
        this.postInvalidate();
    }

    private float getStrokeWidth(float velocity) {
        return this.penSize - velocity * 1.0f;
    }

    protected void onDraw(Canvas canvas) {
        canvas.drawBitmap(this.bmp, 0.0f, 0.0f, this.paintBm);
    }

    private void drawLine(float lastWidth, float currentWidth, float velocity) {
        Point mid1 = this.midPoint(this.previousPoint, this.startPoint);
        Point mid2 = this.midPoint(this.currentPoint, this.previousPoint);
        this.draw(mid1, this.previousPoint, mid2, lastWidth, currentWidth, velocity);
    }

    private float getPt(float n1, float n2, float perc) {
        float diff = n2 - n1;
        return n1 + diff * perc;
    }

    private void draw(Point p0, Point p1, Point p2, float lastWidth, float currentWidth, float velocity) {
        if (this.canvasBmp != null) {
            float increment = velocity > 1.6f && velocity < 15.0f ? 0.0085f - velocity * 5.0E-4f : 0.01f;
            for (float i = 0.0f; i < 1.0f; i += increment) {
                float xa = this.getPt(p0.x, p1.x, i);
                float ya = this.getPt(p0.y, p1.y, i);
                float xb = this.getPt(p1.x, p2.x, i);
                float yb = this.getPt(p1.y, p2.y, i);
                float x = this.getPt(xa, xb, i);
                float y = this.getPt(ya, yb, i);
                float strokeVal = lastWidth + (currentWidth - lastWidth) * i;
                this.paint.setStrokeWidth(strokeVal < 1.0f ? 1.0f : strokeVal);
                this.canvasBmp.drawPoint(x, y, this.paint);
            }
        }
    }

    private Point midPoint(Point p1, Point p2) {
        return new Point((p1.x + p2.x) / 2.0f, (p1.y + p2.y) / 2.0f, (p1.time + p2.time) / 2L);
    }

    public Bitmap getSignatureBitmap() {
        if (this.bmp != null) {
            return Bitmap.createScaledBitmap((Bitmap)this.bmp, (int)this.bmp.getWidth(), (int)this.bmp.getHeight(), (boolean)true);
        }
        return null;
    }

    private Bitmap getSignatureBitmap(Bitmap bitmap) {
        return Bitmap.createScaledBitmap((Bitmap)bitmap, (int)bitmap.getWidth(), (int)bitmap.getHeight(), (boolean)true);
    }

    public void setBitmap(Bitmap bitmap) {
        if (bitmap != null) {
            this.bmp = bitmap;
            this.canvasBmp = new Canvas(bitmap);
            this.postInvalidate();
        }
    }

    public boolean isBitmapEmpty() {
        if (this.bmp != null) {
            Bitmap emptyBitmap = Bitmap.createBitmap((int)this.bmp.getWidth(), (int)this.bmp.getHeight(), (Bitmap.Config)this.bmp.getConfig());
            Canvas canvasBmp = new Canvas(emptyBitmap);
            canvasBmp.drawColor(this.backgroundColor);
            if (this.bmp.sameAs(emptyBitmap)) {
                return true;
            }
        }
        return false;
    }

    public String getVersionName() {
        return "1.2";
    }
}

