/*
 * Decompiled with CFR 0.152.
 */
package com.lazerycode.jmeter.mojo;

import com.lazerycode.jmeter.configuration.JMeterArgumentsArray;
import com.lazerycode.jmeter.configuration.JMeterProcessJVMSettings;
import com.lazerycode.jmeter.configuration.ProxyConfiguration;
import com.lazerycode.jmeter.configuration.RemoteConfiguration;
import com.lazerycode.jmeter.properties.ConfigurationFiles;
import com.lazerycode.jmeter.properties.PropertiesMapping;
import com.lazerycode.jmeter.utility.UtilityFunctions;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.settings.Proxy;
import org.apache.maven.settings.Settings;
import org.joda.time.format.DateTimeFormat;

public abstract class AbstractJMeterMojo
extends AbstractMojo {
    @Parameter
    protected List<String> testFilesIncluded = new ArrayList<String>();
    @Parameter
    protected List<String> testFilesExcluded = new ArrayList<String>();
    @Parameter(defaultValue="${basedir}/src/test/conf")
    protected File confFilesDirectory;
    @Parameter(defaultValue="${basedir}/src/test/jmeter")
    protected File testFilesDirectory;
    @Parameter(defaultValue="true")
    protected boolean testResultsTimestamp;
    @Parameter(defaultValue="false")
    protected boolean appendResultsTimestamp;
    @Parameter
    protected String resultsFileNameDateFormat;
    @Parameter(defaultValue="${project.build.directory}/jmeter/results")
    protected File resultsDirectory;
    @Parameter(defaultValue="false")
    protected boolean generateReports;
    @Parameter(defaultValue="${project.build.directory}/jmeter/reports")
    protected File reportDirectory;
    @Parameter(defaultValue="${project.build.directory}/jmeter/testFiles")
    protected File testFilesBuildDirectory;
    @Parameter(defaultValue="${project.build.directory}/jmeter/logs")
    protected File logsDirectory;
    @Parameter
    protected List<File> customPropertiesFiles = new ArrayList<File>();
    @Parameter
    protected boolean useMavenProxy;
    @Parameter(defaultValue="${settings}", readonly=true)
    protected Settings settings;
    @Parameter
    protected ProxyConfiguration proxyConfig;
    @Parameter
    protected RemoteConfiguration remoteConfig;
    @Parameter
    protected JMeterProcessJVMSettings jMeterProcessJVMSettings;
    @Parameter
    protected String overrideRootLogLevel;
    @Parameter(defaultValue="false")
    protected boolean suppressJMeterOutput;
    @Parameter(defaultValue="${mojoExecution}", required=true, readonly=true)
    protected MojoExecution mojoExecution;
    @Parameter(defaultValue="${session}", readonly=true)
    private MavenSession session;
    @Parameter(defaultValue="${skipTests}")
    protected boolean skipTests;
    @Parameter(defaultValue="0")
    protected String postTestPauseInSeconds;
    @Parameter(defaultValue="${project.build.directory}/config.json")
    protected String testConfigFile;
    @Parameter(defaultValue="${project.build.directory}/jmeter")
    protected File jmeterDirectory;
    @Parameter(defaultValue="${project.build.directory}")
    protected File projectBuildDirectory;
    protected static String runtimeJarName;
    protected static JMeterArgumentsArray testArgs;
    protected static File workingDirectory;
    protected static Map<ConfigurationFiles, PropertiesMapping> propertiesMap;

    public final void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skipTests) {
            if (this.session.getGoals().contains("jmeter:gui")) {
                if (!"default-cli".equals(this.mojoExecution.getExecutionId()) && !"compile".equals(this.mojoExecution.getLifecyclePhase())) {
                    this.getLog().info((CharSequence)"Performance tests are skipped.");
                    return;
                }
            } else {
                this.getLog().info((CharSequence)"Performance tests are skipped.");
                return;
            }
        }
        if (this.useMavenProxy && this.proxyConfig == null) {
            this.loadMavenProxy();
        }
        this.doExecute();
    }

    protected abstract void doExecute() throws MojoExecutionException, MojoFailureException;

    protected void initialiseJMeterArgumentsArray(boolean disableGUI, boolean isCSVFormat) throws MojoExecutionException {
        testArgs = new JMeterArgumentsArray(disableGUI, this.jmeterDirectory.getAbsolutePath());
        testArgs.setResultsDirectory(this.resultsDirectory.getAbsolutePath());
        testArgs.setResultFileOutputFormatIsCSV(isCSVFormat);
        if (this.generateReports) {
            testArgs.setReportsDirectory(this.reportDirectory.getAbsolutePath());
        }
        if (this.testResultsTimestamp) {
            testArgs.setResultsTimestamp(true);
            testArgs.appendTimestamp(this.appendResultsTimestamp);
            if (UtilityFunctions.isSet(this.resultsFileNameDateFormat).booleanValue()) {
                try {
                    testArgs.setResultsFileNameDateFormat(DateTimeFormat.forPattern((String)this.resultsFileNameDateFormat));
                }
                catch (Exception ex) {
                    this.getLog().error((CharSequence)("'" + this.resultsFileNameDateFormat + "' is an invalid DateTimeFormat.  Defaulting to Standard ISO_8601."), (Throwable)ex);
                }
            }
        }
        testArgs.setProxyConfig(this.proxyConfig);
        for (File customPropertiesFile : this.customPropertiesFiles) {
            testArgs.setACustomPropertiesFile(customPropertiesFile);
        }
        testArgs.setLogRootOverride(this.overrideRootLogLevel);
        testArgs.setLogsDirectory(this.logsDirectory.getAbsolutePath());
    }

    protected void loadMavenProxy() {
        if (this.settings == null) {
            return;
        }
        try {
            Proxy mvnProxy = this.settings.getActiveProxy();
            if (mvnProxy != null) {
                ProxyConfiguration newProxyConf = new ProxyConfiguration();
                newProxyConf.setHost(mvnProxy.getHost());
                newProxyConf.setPort(mvnProxy.getPort());
                newProxyConf.setUsername(mvnProxy.getUsername());
                newProxyConf.setPassword(mvnProxy.getPassword());
                newProxyConf.setHostExclusions(mvnProxy.getNonProxyHosts());
                this.proxyConfig = newProxyConf;
                this.getLog().info((CharSequence)"Maven proxy loaded successfully");
            } else {
                this.getLog().warn((CharSequence)"No maven proxy found, but useMavenProxy set to true.");
            }
        }
        catch (Exception e) {
            this.getLog().error((CharSequence)"Error while loading maven proxy", (Throwable)e);
        }
    }

    static void copyFilesInTestDirectory(File sourceDirectory, File destinationDirectory) throws com.lazerycode.jmeter.exceptions.IOException {
        try {
            FileUtils.copyDirectory((File)sourceDirectory, (File)destinationDirectory);
        }
        catch (IOException e) {
            throw new com.lazerycode.jmeter.exceptions.IOException(e.getMessage(), e);
        }
    }

    static {
        propertiesMap = new EnumMap<ConfigurationFiles, PropertiesMapping>(ConfigurationFiles.class);
    }
}

