/*
 * Decompiled with CFR 0.152.
 */
package com.lazerycode.jmeter.testrunner;

import com.lazerycode.jmeter.exceptions.ResultsFileNotFoundException;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.Scanner;

public class ResultScanner {
    private static final String REQUEST_FAILURE = "s=\"false\"";
    private static final String REQUEST_SUCCESS = "s=\"true\"";
    private final boolean countFailures;
    private final boolean countSuccesses;
    private int failureCount = 0;
    private int successCount = 0;

    public ResultScanner(boolean countSuccesses, boolean countFailures) {
        this.countFailures = countFailures;
        this.countSuccesses = countSuccesses;
    }

    public void parseResultFile(File file) throws ResultsFileNotFoundException {
        if (this.countFailures) {
            this.failureCount += this.scanFileForPattern(file, REQUEST_FAILURE);
        }
        if (this.countSuccesses) {
            this.successCount += this.scanFileForPattern(file, REQUEST_SUCCESS);
        }
    }

    private int scanFileForPattern(File file, String pattern) throws ResultsFileNotFoundException {
        int patternCount = 0;
        try (Scanner resultFileScanner = new Scanner(file);){
            while (resultFileScanner.findWithinHorizon(pattern, 0) != null) {
                ++patternCount;
            }
        }
        catch (FileNotFoundException ex) {
            throw new ResultsFileNotFoundException("File not found for file:" + file.getAbsolutePath() + ", pattern:" + pattern, ex);
        }
        return patternCount;
    }

    public int getFailureCount() {
        return this.failureCount;
    }

    public int getSuccessCount() {
        return this.successCount;
    }
}

