/*
 * Decompiled with CFR 0.152.
 */
package com.leinardi.android.speeddial;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.ColorInt;
import android.support.annotation.DrawableRes;
import android.support.annotation.IdRes;
import android.support.annotation.Nullable;
import android.support.annotation.StringRes;
import android.support.annotation.StyleRes;
import android.support.v7.content.res.AppCompatResources;
import android.view.ContextThemeWrapper;
import com.leinardi.android.speeddial.FabWithLabelView;

public class SpeedDialActionItem
implements Parcelable {
    public static final int RESOURCE_NOT_SET = Integer.MIN_VALUE;
    @IdRes
    private final int mId;
    @Nullable
    private final String mLabel;
    @StringRes
    private final int mLabelRes;
    @DrawableRes
    private final int mFabImageResource;
    @Nullable
    private final Drawable mFabImageDrawable;
    @ColorInt
    private final int mFabImageTintColor;
    @ColorInt
    private final int mFabBackgroundColor;
    @ColorInt
    private final int mLabelColor;
    @ColorInt
    private final int mLabelBackgroundColor;
    private final boolean mLabelClickable;
    private final int mFabSize;
    @StyleRes
    private final int mTheme;
    public static final Parcelable.Creator<SpeedDialActionItem> CREATOR = new Parcelable.Creator<SpeedDialActionItem>(){

        public SpeedDialActionItem createFromParcel(Parcel source) {
            return new SpeedDialActionItem(source);
        }

        public SpeedDialActionItem[] newArray(int size) {
            return new SpeedDialActionItem[size];
        }
    };

    private SpeedDialActionItem(Builder builder) {
        this.mId = builder.mId;
        this.mLabel = builder.mLabel;
        this.mLabelRes = builder.mLabelRes;
        this.mFabImageTintColor = builder.mFabImageTintColor;
        this.mFabImageResource = builder.mFabImageResource;
        this.mFabImageDrawable = builder.mFabImageDrawable;
        this.mFabBackgroundColor = builder.mFabBackgroundColor;
        this.mLabelColor = builder.mLabelColor;
        this.mLabelBackgroundColor = builder.mLabelBackgroundColor;
        this.mLabelClickable = builder.mLabelClickable;
        this.mFabSize = builder.mFabSize;
        this.mTheme = builder.mTheme;
    }

    public int getId() {
        return this.mId;
    }

    @Nullable
    public String getLabel(Context context) {
        if (this.mLabel != null) {
            return this.mLabel;
        }
        if (this.mLabelRes != Integer.MIN_VALUE) {
            return context.getString(this.mLabelRes);
        }
        return null;
    }

    @Nullable
    public Drawable getFabImageDrawable(Context context) {
        if (this.mFabImageDrawable != null) {
            return this.mFabImageDrawable;
        }
        if (this.mFabImageResource != Integer.MIN_VALUE) {
            return AppCompatResources.getDrawable((Context)context, (int)this.mFabImageResource);
        }
        return null;
    }

    @ColorInt
    public int getFabImageTintColor() {
        return this.mFabImageTintColor;
    }

    @ColorInt
    public int getFabBackgroundColor() {
        return this.mFabBackgroundColor;
    }

    @ColorInt
    public int getLabelColor() {
        return this.mLabelColor;
    }

    public int getLabelBackgroundColor() {
        return this.mLabelBackgroundColor;
    }

    public boolean isLabelClickable() {
        return this.mLabelClickable;
    }

    @StyleRes
    public int getTheme() {
        return this.mTheme;
    }

    public FabWithLabelView createFabWithLabelView(Context context) {
        int theme = this.getTheme();
        FabWithLabelView fabWithLabelView = theme == Integer.MIN_VALUE ? new FabWithLabelView(context) : new FabWithLabelView((Context)new ContextThemeWrapper(context, theme), null, theme);
        fabWithLabelView.setSpeedDialActionItem(this);
        return fabWithLabelView;
    }

    int getFabSize() {
        return this.mFabSize;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.mId);
        dest.writeString(this.mLabel);
        dest.writeInt(this.mLabelRes);
        dest.writeInt(this.mFabImageResource);
        dest.writeInt(this.mFabImageTintColor);
        dest.writeInt(this.mFabBackgroundColor);
        dest.writeInt(this.mLabelColor);
        dest.writeInt(this.mLabelBackgroundColor);
        dest.writeByte(this.mLabelClickable ? (byte)1 : 0);
        dest.writeInt(this.mFabSize);
        dest.writeInt(this.mTheme);
    }

    protected SpeedDialActionItem(Parcel in) {
        this.mId = in.readInt();
        this.mLabel = in.readString();
        this.mLabelRes = in.readInt();
        this.mFabImageResource = in.readInt();
        this.mFabImageDrawable = null;
        this.mFabImageTintColor = in.readInt();
        this.mFabBackgroundColor = in.readInt();
        this.mLabelColor = in.readInt();
        this.mLabelBackgroundColor = in.readInt();
        this.mLabelClickable = in.readByte() != 0;
        this.mFabSize = in.readInt();
        this.mTheme = in.readInt();
    }

    public static class Builder {
        @IdRes
        private final int mId;
        @DrawableRes
        private final int mFabImageResource;
        @Nullable
        private Drawable mFabImageDrawable;
        @ColorInt
        private int mFabImageTintColor = Integer.MIN_VALUE;
        @Nullable
        private String mLabel;
        @StringRes
        private int mLabelRes = Integer.MIN_VALUE;
        @ColorInt
        private int mFabBackgroundColor = Integer.MIN_VALUE;
        @ColorInt
        private int mLabelColor = Integer.MIN_VALUE;
        @ColorInt
        private int mLabelBackgroundColor = Integer.MIN_VALUE;
        private boolean mLabelClickable = true;
        private int mFabSize = -1;
        @StyleRes
        private int mTheme = Integer.MIN_VALUE;

        public Builder(@IdRes int id2, @DrawableRes int fabImageResource) {
            this.mId = id2;
            this.mFabImageResource = fabImageResource;
            this.mFabImageDrawable = null;
        }

        public Builder(@IdRes int id2, @Nullable Drawable drawable) {
            this.mId = id2;
            this.mFabImageDrawable = drawable;
            this.mFabImageResource = Integer.MIN_VALUE;
        }

        public Builder(SpeedDialActionItem speedDialActionItem) {
            this.mId = speedDialActionItem.mId;
            this.mLabel = speedDialActionItem.mLabel;
            this.mLabelRes = speedDialActionItem.mLabelRes;
            this.mFabImageResource = speedDialActionItem.mFabImageResource;
            this.mFabImageDrawable = speedDialActionItem.mFabImageDrawable;
            this.mFabImageTintColor = speedDialActionItem.mFabImageTintColor;
            this.mFabBackgroundColor = speedDialActionItem.mFabBackgroundColor;
            this.mLabelColor = speedDialActionItem.mLabelColor;
            this.mLabelBackgroundColor = speedDialActionItem.mLabelBackgroundColor;
            this.mLabelClickable = speedDialActionItem.mLabelClickable;
            this.mFabSize = speedDialActionItem.mFabSize;
            this.mTheme = speedDialActionItem.mTheme;
        }

        public Builder setLabel(@Nullable String label) {
            this.mLabel = label;
            return this;
        }

        public Builder setLabel(@StringRes int labelRes) {
            this.mLabelRes = labelRes;
            return this;
        }

        public Builder setFabImageTintColor(int fabImageTintColor) {
            this.mFabImageTintColor = fabImageTintColor;
            return this;
        }

        public Builder setFabBackgroundColor(@ColorInt int fabBackgroundColor) {
            this.mFabBackgroundColor = fabBackgroundColor;
            return this;
        }

        public Builder setLabelColor(@ColorInt int labelColor) {
            this.mLabelColor = labelColor;
            return this;
        }

        public Builder setLabelBackgroundColor(@ColorInt int labelBackgroundColor) {
            this.mLabelBackgroundColor = labelBackgroundColor;
            return this;
        }

        public Builder setLabelClickable(boolean labelClickable) {
            this.mLabelClickable = labelClickable;
            return this;
        }

        public Builder setTheme(int mTheme) {
            this.mTheme = mTheme;
            return this;
        }

        public SpeedDialActionItem create() {
            return new SpeedDialActionItem(this);
        }

        Builder setFabSize(int fabSize) {
            this.mFabSize = fabSize;
            return this;
        }
    }
}

