/*
 * Decompiled with CFR 0.152.
 */
package com.android.dx.mockito.inline;

import android.os.AsyncTask;
import android.os.Build;
import android.util.ArraySet;
import com.android.dx.mockito.inline.ClassTransformer;
import com.android.dx.mockito.inline.InvocationHandlerAdapter;
import com.android.dx.mockito.inline.JvmtiAgent;
import com.android.dx.mockito.inline.MockFeatures;
import com.android.dx.mockito.inline.MockMethodAdvice;
import com.android.dx.stock.ProxyBuilder;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.mockito.Mockito;
import org.mockito.creation.instance.InstantiationException;
import org.mockito.creation.instance.Instantiator;
import org.mockito.exceptions.base.MockitoException;
import org.mockito.internal.util.reflection.LenientCopyTool;
import org.mockito.invocation.MockHandler;
import org.mockito.mock.MockCreationSettings;
import org.mockito.plugins.InlineMockMaker;
import org.mockito.plugins.InstantiatorProvider2;
import org.mockito.plugins.MockMaker;

public final class InlineDexmakerMockMaker
implements InlineMockMaker {
    private static final String DISPATCHER_CLASS_NAME = "com.android.dx.mockito.inline.MockMethodDispatcher";
    private static final String DISPATCHER_JAR = "dispatcher.jar";
    private static final JvmtiAgent AGENT;
    private static final Throwable INITIALIZATION_ERROR;
    public static final Class DISPATCHER_CLASS;
    public static ThreadLocal<Object> onSpyInProgressInstance;
    private final Map<Object, InvocationHandlerAdapter> mocks;
    private final ClassTransformer classTransformer;

    public InlineDexmakerMockMaker() {
        if (INITIALIZATION_ERROR != null) {
            throw new RuntimeException("Could not initialize inline mock maker.\n\nRelease: Android " + Build.VERSION.RELEASE + " " + Build.VERSION.INCREMENTAL + "Device: " + Build.BRAND + " " + Build.MODEL, INITIALIZATION_ERROR);
        }
        this.mocks = new MockMap();
        this.classTransformer = new ClassTransformer(AGENT, DISPATCHER_CLASS, this.mocks);
    }

    private <T> Method[] getMethodsToProxy(MockCreationSettings<T> settings) {
        HashSet<ProxyBuilder.MethodSetEntry> abstractMethods = new HashSet<ProxyBuilder.MethodSetEntry>();
        HashSet<ProxyBuilder.MethodSetEntry> nonAbstractMethods = new HashSet<ProxyBuilder.MethodSetEntry>();
        for (Class superClass = settings.getTypeToMock(); superClass != null; superClass = superClass.getSuperclass()) {
            for (GenericDeclaration genericDeclaration : superClass.getDeclaredMethods()) {
                if (Modifier.isAbstract(((Method)genericDeclaration).getModifiers()) && !nonAbstractMethods.contains(new ProxyBuilder.MethodSetEntry((Method)genericDeclaration))) {
                    abstractMethods.add(new ProxyBuilder.MethodSetEntry((Method)genericDeclaration));
                    continue;
                }
                nonAbstractMethods.add(new ProxyBuilder.MethodSetEntry((Method)genericDeclaration));
            }
        }
        for (GenericDeclaration genericDeclaration : settings.getTypeToMock().getInterfaces()) {
            for (Method method : ((Class)genericDeclaration).getMethods()) {
                if (nonAbstractMethods.contains(new ProxyBuilder.MethodSetEntry(method))) continue;
                abstractMethods.add(new ProxyBuilder.MethodSetEntry(method));
            }
        }
        for (Class i : settings.getExtraInterfaces()) {
            for (Method method : i.getMethods()) {
                if (nonAbstractMethods.contains(new ProxyBuilder.MethodSetEntry(method))) continue;
                abstractMethods.add(new ProxyBuilder.MethodSetEntry(method));
            }
        }
        Method[] methodsToProxy = new Method[abstractMethods.size()];
        int i = 0;
        for (ProxyBuilder.MethodSetEntry methodSetEntry : abstractMethods) {
            methodsToProxy[i++] = methodSetEntry.originalMethod;
        }
        return methodsToProxy;
    }

    public <T> T createMock(MockCreationSettings<T> settings, MockHandler handler) {
        Object mock;
        Class typeToMock = settings.getTypeToMock();
        Set interfacesSet = settings.getExtraInterfaces();
        Class[] extraInterfaces = interfacesSet.toArray(new Class[interfacesSet.size()]);
        InvocationHandlerAdapter handlerAdapter = new InvocationHandlerAdapter(handler);
        if (typeToMock.isInterface()) {
            Class[] classesToMock = new Class[extraInterfaces.length + 1];
            classesToMock[0] = typeToMock;
            System.arraycopy(extraInterfaces, 0, classesToMock, 1, extraInterfaces.length);
            mock = Proxy.newProxyInstance(typeToMock.getClassLoader(), classesToMock, (InvocationHandler)handlerAdapter);
        } else {
            boolean subclassingRequired = !interfacesSet.isEmpty() || Modifier.isAbstract(typeToMock.getModifiers());
            this.classTransformer.mockClass(MockFeatures.withMockFeatures(typeToMock, interfacesSet));
            Instantiator instantiator = ((InstantiatorProvider2)Mockito.framework().getPlugins().getDefaultPlugin(InstantiatorProvider2.class)).getInstantiator(settings);
            if (subclassingRequired) {
                Class proxyClass;
                try {
                    ProxyBuilder builder = ProxyBuilder.forClass((Class)typeToMock).implementing(extraInterfaces).onlyMethods(this.getMethodsToProxy(settings)).withSharedClassLoader();
                    if (Build.VERSION.SDK_INT >= 28) {
                        builder.markTrusted();
                    }
                    proxyClass = builder.buildProxyClass();
                }
                catch (RuntimeException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new MockitoException("Failed to mock " + typeToMock, (Throwable)e);
                }
                try {
                    mock = instantiator.newInstance(proxyClass);
                }
                catch (InstantiationException e) {
                    throw new MockitoException("Unable to create mock instance of type '" + proxyClass.getSuperclass().getSimpleName() + "'", (Throwable)e);
                }
                ProxyBuilder.setInvocationHandler((Object)mock, (InvocationHandler)handlerAdapter);
            } else if (settings.getSpiedInstance() != null && onSpyInProgressInstance.get() == settings.getSpiedInstance()) {
                mock = onSpyInProgressInstance.get();
            } else {
                try {
                    mock = instantiator.newInstance(typeToMock);
                }
                catch (InstantiationException e) {
                    throw new MockitoException("Unable to create mock instance of type '" + typeToMock.getSimpleName() + "'", (Throwable)e);
                }
            }
        }
        this.mocks.put(mock, handlerAdapter);
        return (T)mock;
    }

    public void resetMock(Object mock, MockHandler newHandler, MockCreationSettings settings) {
        InvocationHandlerAdapter adapter = this.getInvocationHandlerAdapter(mock);
        if (adapter != null) {
            adapter.setHandler(newHandler);
        }
    }

    public MockMaker.TypeMockability isTypeMockable(final Class<?> type) {
        return new MockMaker.TypeMockability(){

            public boolean mockable() {
                return !type.isPrimitive() && type != String.class;
            }

            public String nonMockableReason() {
                if (type.isPrimitive()) {
                    return "primitive type";
                }
                if (type == String.class) {
                    return "string";
                }
                return "not handled type";
            }
        };
    }

    public void clearMock(Object mock) {
        this.mocks.remove(mock);
    }

    public void clearAllMocks() {
        this.mocks.clear();
    }

    public MockHandler getHandler(Object mock) {
        InvocationHandlerAdapter adapter = this.getInvocationHandlerAdapter(mock);
        return adapter != null ? adapter.getHandler() : null;
    }

    private InvocationHandlerAdapter getInvocationHandlerAdapter(Object instance) {
        if (instance == null) {
            return null;
        }
        return this.mocks.get(instance);
    }

    static {
        JvmtiAgent agent;
        onSpyInProgressInstance = new ThreadLocal();
        Throwable initializationError = null;
        Class<?> dispatcherClass = null;
        try {
            Method allowHiddenApiReflectionFrom;
            try {
                agent = new JvmtiAgent();
                try (InputStream is = InlineDexmakerMockMaker.class.getClassLoader().getResource(DISPATCHER_JAR).openStream();){
                    agent.appendToBootstrapClassLoaderSearch(is);
                }
                try {
                    dispatcherClass = Class.forName(DISPATCHER_CLASS_NAME, true, Object.class.getClassLoader());
                    if (dispatcherClass == null) {
                        throw new IllegalStateException("com.android.dx.mockito.inline.MockMethodDispatcher could not be loaded");
                    }
                }
                catch (ClassNotFoundException cnfe) {
                    throw new IllegalStateException("Mockito failed to inject the MockMethodDispatcher class into the bootstrap class loader\n\nIt seems like your current VM does not support the jvmti API correctly.", cnfe);
                }
            }
            catch (IOException ioe) {
                throw new IllegalStateException("Mockito could not self-attach a jvmti agent to the current VM. This feature is required for inline mocking.\nThis error occured due to an I/O error during the creation of this agent: " + ioe + "\n\nPotentially, the current VM does not support the jvmti API correctly", ioe);
            }
            try {
                Class<?> vmDebug = Class.forName("dalvik.system.VMDebug");
                allowHiddenApiReflectionFrom = vmDebug.getDeclaredMethod("allowHiddenApiReflectionFrom", Class.class);
            }
            catch (ClassNotFoundException | NoSuchMethodException e) {
                throw new IllegalStateException("Cannot find VMDebug#allowHiddenApiReflectionFrom.");
            }
            try {
                allowHiddenApiReflectionFrom.invoke(null, LenientCopyTool.class);
            }
            catch (InvocationTargetException e) {
                throw e.getCause();
            }
            try {
                allowHiddenApiReflectionFrom.invoke(null, MockMethodAdvice.class);
            }
            catch (InvocationTargetException e) {
                throw e.getCause();
            }
        }
        catch (Throwable throwable) {
            agent = null;
            initializationError = throwable;
        }
        AGENT = agent;
        INITIALIZATION_ERROR = initializationError;
        DISPATCHER_CLASS = dispatcherClass;
    }

    private static class MockMap
    extends ReferenceQueue<Object>
    implements Map<Object, InvocationHandlerAdapter> {
        private static final int MIN_CLEAN_INTERVAL_MILLIS = 16000;
        private static final int MAX_GET_WITHOUT_CLEAN = 16384;
        private final Object lock = new Object();
        private StrongKey cachedKey;
        private HashMap<WeakKey, InvocationHandlerAdapter> adapters = new HashMap();
        long mLastCleanup = 0L;
        private boolean isCleaning = false;
        private int getCount = 0;

        private MockMap() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private StrongKey createStrongKey(Object obj) {
            Object object = this.lock;
            synchronized (object) {
                if (this.cachedKey == null) {
                    this.cachedKey = new StrongKey();
                }
                this.cachedKey.obj = obj;
                StrongKey newKey = this.cachedKey;
                this.cachedKey = null;
                return newKey;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void recycleStrongKey(StrongKey key) {
            Object object = this.lock;
            synchronized (object) {
                this.cachedKey = key;
            }
        }

        @Override
        public int size() {
            return this.adapters.size();
        }

        @Override
        public boolean isEmpty() {
            return this.adapters.isEmpty();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean containsKey(Object mock) {
            Object object = this.lock;
            synchronized (object) {
                StrongKey key = this.createStrongKey(mock);
                boolean containsKey = this.adapters.containsKey(key);
                this.recycleStrongKey(key);
                return containsKey;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean containsValue(Object adapter) {
            Object object = this.lock;
            synchronized (object) {
                return this.adapters.containsValue(adapter);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public InvocationHandlerAdapter get(Object mock) {
            Object object = this.lock;
            synchronized (object) {
                if (this.getCount > 16384) {
                    this.cleanStaleReferences();
                    this.getCount = 0;
                } else {
                    ++this.getCount;
                }
                StrongKey key = this.createStrongKey(mock);
                InvocationHandlerAdapter adapter = this.adapters.get(key);
                this.recycleStrongKey(key);
                return adapter;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void cleanStaleReferences() {
            Object object = this.lock;
            synchronized (object) {
                if (!this.isCleaning) {
                    if (System.currentTimeMillis() - 16000L < this.mLastCleanup) {
                        return;
                    }
                    this.isCleaning = true;
                    AsyncTask.THREAD_POOL_EXECUTOR.execute(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            Object object = MockMap.this.lock;
                            synchronized (object) {
                                Reference ref;
                                while ((ref = MockMap.this.poll()) != null) {
                                    MockMap.this.adapters.remove(ref);
                                }
                                MockMap.this.mLastCleanup = System.currentTimeMillis();
                                MockMap.this.isCleaning = false;
                            }
                        }
                    });
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public InvocationHandlerAdapter put(Object mock, InvocationHandlerAdapter adapter) {
            Object object = this.lock;
            synchronized (object) {
                InvocationHandlerAdapter oldValue = this.remove(mock);
                this.adapters.put(new WeakKey(mock), adapter);
                return oldValue;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public InvocationHandlerAdapter remove(Object mock) {
            Object object = this.lock;
            synchronized (object) {
                StrongKey key = this.createStrongKey(mock);
                InvocationHandlerAdapter adapter = this.adapters.remove(key);
                this.recycleStrongKey(key);
                return adapter;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void putAll(Map<?, ? extends InvocationHandlerAdapter> map) {
            Object object = this.lock;
            synchronized (object) {
                for (Map.Entry<?, InvocationHandlerAdapter> entry : map.entrySet()) {
                    this.put(entry.getKey(), entry.getValue());
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void clear() {
            Object object = this.lock;
            synchronized (object) {
                this.adapters.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Set<Object> keySet() {
            Object object = this.lock;
            synchronized (object) {
                ArraySet mocks = new ArraySet(this.adapters.size());
                boolean hasStaleReferences = false;
                for (WeakKey key : this.adapters.keySet()) {
                    Object mock = key.get();
                    if (mock == null) {
                        hasStaleReferences = true;
                        continue;
                    }
                    mocks.add(mock);
                }
                if (hasStaleReferences) {
                    this.cleanStaleReferences();
                }
                return mocks;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Collection<InvocationHandlerAdapter> values() {
            Object object = this.lock;
            synchronized (object) {
                return this.adapters.values();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Set<Map.Entry<Object, InvocationHandlerAdapter>> entrySet() {
            Object object = this.lock;
            synchronized (object) {
                ArraySet entries = new ArraySet(this.adapters.size());
                boolean hasStaleReferences = false;
                for (Map.Entry<WeakKey, InvocationHandlerAdapter> entry : this.adapters.entrySet()) {
                    Object mock = entry.getKey().get();
                    if (mock == null) {
                        hasStaleReferences = true;
                        continue;
                    }
                    entries.add(new AbstractMap.SimpleEntry(mock, entry.getValue()));
                }
                if (hasStaleReferences) {
                    this.cleanStaleReferences();
                }
                return entries;
            }
        }

        private class StrongKey {
            private Object obj;

            private StrongKey() {
            }

            public boolean equals(Object other) {
                if (other instanceof WeakKey) {
                    Object otherObj = ((WeakKey)other).get();
                    if (otherObj == null) {
                        MockMap.this.cleanStaleReferences();
                        return false;
                    }
                    return this.obj == otherObj;
                }
                if (other instanceof StrongKey) {
                    return this.obj == ((StrongKey)other).obj;
                }
                return false;
            }

            public int hashCode() {
                return System.identityHashCode(this.obj);
            }
        }

        private class WeakKey
        extends WeakReference<Object> {
            private final int hashCode;

            private WeakKey(Object obj) {
                super(obj, MockMap.this);
                this.hashCode = System.identityHashCode(obj);
            }

            public boolean equals(Object other) {
                if (other == this) {
                    return true;
                }
                if (other == null) {
                    return false;
                }
                if (other.hashCode() != this.hashCode) {
                    return false;
                }
                Object obj = this.get();
                if (obj == null) {
                    MockMap.this.cleanStaleReferences();
                    return false;
                }
                if (other instanceof WeakKey) {
                    Object otherObj = ((WeakKey)other).get();
                    if (otherObj == null) {
                        MockMap.this.cleanStaleReferences();
                        return false;
                    }
                    return obj == otherObj;
                }
                if (other instanceof StrongKey) {
                    Object otherObj = ((StrongKey)other).obj;
                    return obj == otherObj;
                }
                return false;
            }

            public int hashCode() {
                return this.hashCode;
            }
        }
    }
}

