/*
 * Decompiled with CFR 0.152.
 */
package com.android.dx.mockito.inline;

import android.os.Build;
import android.os.Debug;
import com.android.dx.mockito.inline.ClassTransformer;
import com.android.dx.mockito.inline.IllegalClassFormatException;
import com.android.dx.mockito.inline.UnmodifiableClassException;
import dalvik.system.BaseDexClassLoader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.ProtectionDomain;
import java.util.ArrayList;

class JvmtiAgent {
    private static final String AGENT_LIB_NAME = "libdexmakerjvmtiagent.so";
    private static final Object lock = new Object();
    private final ArrayList<ClassTransformer> transformers = new ArrayList();

    private native void nativeRegisterTransformerHook();

    JvmtiAgent() throws IOException {
        if (Build.VERSION.SDK_INT < 28) {
            throw new IOException("Requires API level 28. API level is " + Build.VERSION.SDK_INT);
        }
        ClassLoader cl = JvmtiAgent.class.getClassLoader();
        if (!(cl instanceof BaseDexClassLoader)) {
            throw new IOException("Could not load jvmti plugin as JvmtiAgent class was not loaded by a BaseDexClassLoader");
        }
        Debug.attachJvmtiAgent((String)AGENT_LIB_NAME, null, (ClassLoader)cl);
        this.nativeRegisterTransformerHook();
    }

    private native void nativeUnregisterTransformerHook();

    protected void finalize() throws Throwable {
        this.nativeUnregisterTransformerHook();
    }

    private static native void nativeAppendToBootstrapClassLoaderSearch(String var0);

    void appendToBootstrapClassLoaderSearch(InputStream jarStream) throws IOException {
        File jarFile = File.createTempFile("mockito-boot", ".jar");
        jarFile.deleteOnExit();
        byte[] buffer = new byte[65536];
        try (FileOutputStream os = new FileOutputStream(jarFile);){
            int numRead;
            while ((numRead = jarStream.read(buffer)) != -1) {
                ((OutputStream)os).write(buffer, 0, numRead);
            }
        }
        JvmtiAgent.nativeAppendToBootstrapClassLoaderSearch(jarFile.getAbsolutePath());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void requestTransformClasses(Class<?>[] classes) throws UnmodifiableClassException {
        Object object = lock;
        synchronized (object) {
            try {
                this.nativeRetransformClasses(classes);
            }
            catch (RuntimeException e) {
                throw new UnmodifiableClassException(e);
            }
        }
    }

    public boolean shouldTransform(Class<?> classBeingRedefined) {
        for (ClassTransformer transformer : this.transformers) {
            if (!transformer.shouldTransform(classBeingRedefined)) continue;
            return true;
        }
        return false;
    }

    void addTransformer(ClassTransformer transformer) {
        this.transformers.add(transformer);
    }

    public byte[] runTransformers(ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws IllegalClassFormatException {
        byte[] transformedByteCode = classfileBuffer;
        for (ClassTransformer transformer : this.transformers) {
            transformedByteCode = transformer.transform(classBeingRedefined, transformedByteCode);
        }
        return transformedByteCode;
    }

    private native void nativeRetransformClasses(Class<?>[] var1);
}

