/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.appcenter.crashes;

import android.annotation.SuppressLint;
import android.content.ComponentCallbacks;
import android.content.ComponentCallbacks2;
import android.content.Context;
import android.content.res.Configuration;
import android.support.annotation.NonNull;
import android.support.annotation.VisibleForTesting;
import android.support.annotation.WorkerThread;
import android.util.Log;
import com.microsoft.appcenter.AbstractAppCenterService;
import com.microsoft.appcenter.Constants;
import com.microsoft.appcenter.channel.Channel;
import com.microsoft.appcenter.crashes.AbstractCrashesListener;
import com.microsoft.appcenter.crashes.CrashesListener;
import com.microsoft.appcenter.crashes.UncaughtExceptionHandler;
import com.microsoft.appcenter.crashes.WrapperSdkExceptionManager;
import com.microsoft.appcenter.crashes.ingestion.models.ErrorAttachmentLog;
import com.microsoft.appcenter.crashes.ingestion.models.Exception;
import com.microsoft.appcenter.crashes.ingestion.models.HandledErrorLog;
import com.microsoft.appcenter.crashes.ingestion.models.ManagedErrorLog;
import com.microsoft.appcenter.crashes.ingestion.models.StackFrame;
import com.microsoft.appcenter.crashes.ingestion.models.json.ErrorAttachmentLogFactory;
import com.microsoft.appcenter.crashes.ingestion.models.json.HandledErrorLogFactory;
import com.microsoft.appcenter.crashes.ingestion.models.json.ManagedErrorLogFactory;
import com.microsoft.appcenter.crashes.model.ErrorReport;
import com.microsoft.appcenter.crashes.model.NativeException;
import com.microsoft.appcenter.crashes.model.TestCrashException;
import com.microsoft.appcenter.crashes.utils.ErrorLogHelper;
import com.microsoft.appcenter.ingestion.models.Device;
import com.microsoft.appcenter.ingestion.models.json.DefaultLogSerializer;
import com.microsoft.appcenter.ingestion.models.json.LogFactory;
import com.microsoft.appcenter.ingestion.models.json.LogSerializer;
import com.microsoft.appcenter.utils.AppCenterLog;
import com.microsoft.appcenter.utils.DeviceInfoHelper;
import com.microsoft.appcenter.utils.HandlerUtils;
import com.microsoft.appcenter.utils.async.AppCenterFuture;
import com.microsoft.appcenter.utils.async.DefaultAppCenterFuture;
import com.microsoft.appcenter.utils.context.SessionContext;
import com.microsoft.appcenter.utils.context.UserIdContext;
import com.microsoft.appcenter.utils.storage.FileManager;
import com.microsoft.appcenter.utils.storage.SharedPreferencesManager;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import org.json.JSONException;

public class Crashes
extends AbstractAppCenterService {
    public static final int SEND = 0;
    public static final int DONT_SEND = 1;
    public static final int ALWAYS_SEND = 2;
    @VisibleForTesting
    public static final String PREF_KEY_ALWAYS_SEND = "com.microsoft.appcenter.crashes.always.send";
    @VisibleForTesting
    static final String PREF_KEY_MEMORY_RUNNING_LEVEL = "com.microsoft.appcenter.crashes.memory";
    @VisibleForTesting
    static final String ERROR_GROUP = "groupErrors";
    @VisibleForTesting
    static final String MINIDUMP_FILE = "minidump";
    private static final String SERVICE_NAME = "Crashes";
    public static final String LOG_TAG = "AppCenterCrashes";
    private static final int MAX_ATTACHMENT_SIZE = 0x700000;
    private static final CrashesListener DEFAULT_ERROR_REPORTING_LISTENER = new DefaultCrashesListener();
    @SuppressLint(value={"StaticFieldLeak"})
    private static Crashes sInstance = null;
    private final Map<String, LogFactory> mFactories = new HashMap<String, LogFactory>();
    private final Map<UUID, ErrorLogReport> mUnprocessedErrorReports;
    private final Map<UUID, ErrorLogReport> mErrorReportCache;
    private LogSerializer mLogSerializer;
    private Context mContext;
    private long mInitializeTimestamp;
    private Device mDevice;
    private UncaughtExceptionHandler mUncaughtExceptionHandler;
    private CrashesListener mCrashesListener;
    private ComponentCallbacks2 mMemoryWarningListener;
    private ErrorReport mLastSessionErrorReport;
    private boolean mSavedUncaughtException;
    private boolean mAutomaticProcessing = true;
    private boolean mHasReceivedMemoryWarningInLastSession;

    private Crashes() {
        this.mFactories.put("managedError", (LogFactory)ManagedErrorLogFactory.getInstance());
        this.mFactories.put("handledError", (LogFactory)HandledErrorLogFactory.getInstance());
        this.mFactories.put("errorAttachment", (LogFactory)ErrorAttachmentLogFactory.getInstance());
        this.mLogSerializer = new DefaultLogSerializer();
        this.mLogSerializer.addLogFactory("managedError", (LogFactory)ManagedErrorLogFactory.getInstance());
        this.mLogSerializer.addLogFactory("errorAttachment", (LogFactory)ErrorAttachmentLogFactory.getInstance());
        this.mCrashesListener = DEFAULT_ERROR_REPORTING_LISTENER;
        this.mUnprocessedErrorReports = new LinkedHashMap<UUID, ErrorLogReport>();
        this.mErrorReportCache = new LinkedHashMap<UUID, ErrorLogReport>();
    }

    @NonNull
    public static synchronized Crashes getInstance() {
        if (sInstance == null) {
            sInstance = new Crashes();
        }
        return sInstance;
    }

    @VisibleForTesting
    static synchronized void unsetInstance() {
        sInstance = null;
    }

    public static AppCenterFuture<Boolean> isEnabled() {
        return Crashes.getInstance().isInstanceEnabledAsync();
    }

    public static AppCenterFuture<Void> setEnabled(boolean enabled) {
        return Crashes.getInstance().setInstanceEnabledAsync(enabled);
    }

    public static void trackError(Throwable throwable) {
        Crashes.trackError(throwable, null, null);
    }

    public static void trackError(Throwable throwable, Map<String, String> properties, Iterable<ErrorAttachmentLog> attachments) {
        Crashes.getInstance().queueException(throwable, properties, attachments);
    }

    public static void generateTestCrash() {
        if (Constants.APPLICATION_DEBUGGABLE) {
            throw new TestCrashException();
        }
        AppCenterLog.warn((String)LOG_TAG, (String)"The application is not debuggable so SDK won't generate test crash");
    }

    public static void setListener(CrashesListener listener) {
        Crashes.getInstance().setInstanceListener(listener);
    }

    public static AppCenterFuture<String> getMinidumpDirectory() {
        return Crashes.getInstance().getNewMinidumpDirectoryAsync();
    }

    public static void notifyUserConfirmation(int userConfirmation) {
        Crashes.getInstance().handleUserConfirmation(userConfirmation);
    }

    public static AppCenterFuture<Boolean> hasCrashedInLastSession() {
        return Crashes.getInstance().hasInstanceCrashedInLastSession();
    }

    public static AppCenterFuture<ErrorReport> getLastSessionCrashReport() {
        return Crashes.getInstance().getInstanceLastSessionCrashReport();
    }

    public static AppCenterFuture<Boolean> hasReceivedMemoryWarningInLastSession() {
        return Crashes.getInstance().hasInstanceReceivedMemoryWarningInLastSession();
    }

    private synchronized AppCenterFuture<String> getNewMinidumpDirectoryAsync() {
        final DefaultAppCenterFuture future = new DefaultAppCenterFuture();
        this.postAsyncGetter(new Runnable(){

            @Override
            public void run() {
                future.complete((Object)ErrorLogHelper.getNewMinidumpSubfolderWithContextData(Crashes.this.mContext).getAbsolutePath());
            }
        }, future, null);
        return future;
    }

    private synchronized AppCenterFuture<Boolean> hasInstanceCrashedInLastSession() {
        final DefaultAppCenterFuture future = new DefaultAppCenterFuture();
        this.postAsyncGetter(new Runnable(){

            @Override
            public void run() {
                future.complete((Object)(Crashes.this.mLastSessionErrorReport != null ? 1 : 0));
            }
        }, future, false);
        return future;
    }

    private synchronized AppCenterFuture<Boolean> hasInstanceReceivedMemoryWarningInLastSession() {
        final DefaultAppCenterFuture future = new DefaultAppCenterFuture();
        this.postAsyncGetter(new Runnable(){

            @Override
            public void run() {
                future.complete((Object)Crashes.this.mHasReceivedMemoryWarningInLastSession);
            }
        }, future, false);
        return future;
    }

    private synchronized AppCenterFuture<ErrorReport> getInstanceLastSessionCrashReport() {
        final DefaultAppCenterFuture future = new DefaultAppCenterFuture();
        this.postAsyncGetter(new Runnable(){

            @Override
            public void run() {
                future.complete((Object)Crashes.this.mLastSessionErrorReport);
            }
        }, future, null);
        return future;
    }

    protected synchronized void applyEnabledState(boolean enabled) {
        this.initialize();
        if (enabled) {
            this.mMemoryWarningListener = new ComponentCallbacks2(){

                public void onTrimMemory(int level) {
                    Crashes.saveMemoryRunningLevel(level);
                }

                public void onConfigurationChanged(@NonNull Configuration newConfig) {
                }

                public void onLowMemory() {
                    Crashes.saveMemoryRunningLevel(80);
                }
            };
            this.mContext.registerComponentCallbacks((ComponentCallbacks)this.mMemoryWarningListener);
        } else {
            File[] files = ErrorLogHelper.getErrorStorageDirectory().listFiles();
            if (files != null) {
                for (File file : files) {
                    AppCenterLog.debug((String)LOG_TAG, (String)("Deleting file " + file));
                    if (file.delete()) continue;
                    AppCenterLog.warn((String)LOG_TAG, (String)("Failed to delete file " + file));
                }
            }
            AppCenterLog.info((String)LOG_TAG, (String)"Deleted crashes local files");
            this.mErrorReportCache.clear();
            this.mLastSessionErrorReport = null;
            this.mContext.unregisterComponentCallbacks((ComponentCallbacks)this.mMemoryWarningListener);
            this.mMemoryWarningListener = null;
            SharedPreferencesManager.remove((String)PREF_KEY_MEMORY_RUNNING_LEVEL);
        }
    }

    public synchronized void onStarted(@NonNull Context context, @NonNull Channel channel, String appSecret, String transmissionTargetToken, boolean startedFromApp) {
        this.mContext = context;
        if (!this.isInstanceEnabled()) {
            ErrorLogHelper.removeMinidumpFolder();
            AppCenterLog.debug((String)LOG_TAG, (String)"Clean up minidump folder.");
        }
        super.onStarted(context, channel, appSecret, transmissionTargetToken, startedFromApp);
        if (this.isInstanceEnabled()) {
            this.processPendingErrors();
            if (this.mErrorReportCache.isEmpty()) {
                ErrorLogHelper.removeLostThrowableFiles();
            }
        }
    }

    public Map<String, LogFactory> getLogFactories() {
        return this.mFactories;
    }

    protected String getGroupName() {
        return ERROR_GROUP;
    }

    public String getServiceName() {
        return SERVICE_NAME;
    }

    protected String getLoggerTag() {
        return LOG_TAG;
    }

    protected int getTriggerCount() {
        return 1;
    }

    protected Channel.GroupListener getChannelListener() {
        return new Channel.GroupListener(){

            private void processCallback(final com.microsoft.appcenter.ingestion.models.Log log, final CallbackProcessor callbackProcessor) {
                Crashes.this.post(new Runnable(){

                    @Override
                    public void run() {
                        if (log instanceof ManagedErrorLog) {
                            ManagedErrorLog errorLog = (ManagedErrorLog)log;
                            final ErrorReport report = Crashes.this.buildErrorReport(errorLog);
                            UUID id = errorLog.getId();
                            if (report != null) {
                                HandlerUtils.runOnUiThread((Runnable)new Runnable(){

                                    @Override
                                    public void run() {
                                        callbackProcessor.onCallBack(report);
                                    }
                                });
                            } else {
                                AppCenterLog.warn((String)Crashes.LOG_TAG, (String)("Cannot find crash report for the error log: " + id));
                            }
                        } else if (!(log instanceof ErrorAttachmentLog) && !(log instanceof HandledErrorLog)) {
                            AppCenterLog.warn((String)Crashes.LOG_TAG, (String)("A different type of log comes to crashes: " + log.getClass().getName()));
                        }
                    }
                });
            }

            public void onBeforeSending(com.microsoft.appcenter.ingestion.models.Log log) {
                this.processCallback(log, new CallbackProcessor(){

                    @Override
                    public void onCallBack(ErrorReport report) {
                        Crashes.this.mCrashesListener.onBeforeSending(report);
                    }
                });
            }

            public void onSuccess(com.microsoft.appcenter.ingestion.models.Log log) {
                this.processCallback(log, new CallbackProcessor(){

                    @Override
                    public void onCallBack(ErrorReport report) {
                        Crashes.this.mCrashesListener.onSendingSucceeded(report);
                    }
                });
            }

            public void onFailure(com.microsoft.appcenter.ingestion.models.Log log, final java.lang.Exception e) {
                this.processCallback(log, new CallbackProcessor(){

                    @Override
                    public void onCallBack(ErrorReport report) {
                        Crashes.this.mCrashesListener.onSendingFailed(report, e);
                    }
                });
            }
        };
    }

    synchronized Device getDeviceInfo(Context context) throws DeviceInfoHelper.DeviceInfoException {
        if (this.mDevice == null) {
            this.mDevice = DeviceInfoHelper.getDeviceInfo((Context)context);
        }
        return this.mDevice;
    }

    synchronized long getInitializeTimestamp() {
        return this.mInitializeTimestamp;
    }

    private synchronized void queueException(final @NonNull Throwable throwable, Map<String, String> properties, Iterable<ErrorAttachmentLog> attachments) {
        this.queueException(new ExceptionModelBuilder(){

            @Override
            public Exception buildExceptionModel() {
                return ErrorLogHelper.getModelExceptionFromThrowable(throwable);
            }
        }, properties, attachments);
    }

    synchronized UUID queueException(final @NonNull Exception modelException, Map<String, String> properties, Iterable<ErrorAttachmentLog> attachments) {
        return this.queueException(new ExceptionModelBuilder(){

            @Override
            public Exception buildExceptionModel() {
                return modelException;
            }
        }, properties, attachments);
    }

    private synchronized UUID queueException(final @NonNull ExceptionModelBuilder exceptionModelBuilder, Map<String, String> properties, final Iterable<ErrorAttachmentLog> attachments) {
        final String userId = UserIdContext.getInstance().getUserId();
        final UUID errorId = UUID.randomUUID();
        final Map<String, String> validatedProperties = ErrorLogHelper.validateProperties(properties, "HandledError");
        this.post(new Runnable(){

            @Override
            public void run() {
                HandledErrorLog errorLog = new HandledErrorLog();
                errorLog.setId(errorId);
                errorLog.setUserId(userId);
                errorLog.setException(exceptionModelBuilder.buildExceptionModel());
                errorLog.setProperties(validatedProperties);
                Crashes.this.mChannel.enqueue((com.microsoft.appcenter.ingestion.models.Log)errorLog, Crashes.ERROR_GROUP, 1);
                Crashes.this.sendErrorAttachment(errorId, attachments);
            }
        });
        return errorId;
    }

    private void initialize() {
        boolean enabled = this.isInstanceEnabled();
        long l = this.mInitializeTimestamp = enabled ? System.currentTimeMillis() : -1L;
        if (!enabled) {
            if (this.mUncaughtExceptionHandler != null) {
                this.mUncaughtExceptionHandler.unregister();
                this.mUncaughtExceptionHandler = null;
            }
        } else {
            this.mUncaughtExceptionHandler = new UncaughtExceptionHandler();
            this.mUncaughtExceptionHandler.register();
            this.processMinidumpFiles();
        }
    }

    private void processMinidumpFiles() {
        for (File minidumpSubfolder : ErrorLogHelper.getNewMinidumpFiles()) {
            if (!minidumpSubfolder.isDirectory()) {
                AppCenterLog.debug((String)LOG_TAG, (String)"Found a minidump from a previous SDK version.");
                this.processSingleMinidump(minidumpSubfolder, minidumpSubfolder);
                continue;
            }
            File[] minidumpSubfolderFiles = minidumpSubfolder.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String filename) {
                    return filename.endsWith(".dmp");
                }
            });
            if (minidumpSubfolderFiles == null || minidumpSubfolderFiles.length == 0) continue;
            for (File minidumpFile : minidumpSubfolderFiles) {
                this.processSingleMinidump(minidumpFile, minidumpSubfolder);
            }
        }
        File logFile = ErrorLogHelper.getLastErrorLogFile();
        while (logFile != null && logFile.length() == 0L) {
            AppCenterLog.warn((String)LOG_TAG, (String)("Deleting empty error file: " + logFile));
            logFile.delete();
            logFile = ErrorLogHelper.getLastErrorLogFile();
        }
        if (logFile != null) {
            AppCenterLog.debug((String)LOG_TAG, (String)"Processing crash report for the last session.");
            String logFileContents = FileManager.read((File)logFile);
            if (logFileContents == null) {
                AppCenterLog.error((String)LOG_TAG, (String)"Error reading last session error log.");
            } else {
                try {
                    ManagedErrorLog log = (ManagedErrorLog)this.mLogSerializer.deserializeLog(logFileContents, null);
                    this.mLastSessionErrorReport = this.buildErrorReport(log);
                    AppCenterLog.debug((String)LOG_TAG, (String)"Processed crash report for the last session.");
                }
                catch (JSONException e) {
                    AppCenterLog.error((String)LOG_TAG, (String)"Error parsing last session error log.", (Throwable)e);
                }
            }
        }
        ErrorLogHelper.removeStaleMinidumpSubfolders();
    }

    private void processSingleMinidump(File minidumpFile, File minidumpFolder) {
        AppCenterLog.debug((String)LOG_TAG, (String)("Process pending minidump file: " + minidumpFile));
        long minidumpDate = minidumpFile.lastModified();
        File dest = new File(ErrorLogHelper.getPendingMinidumpDirectory(), minidumpFile.getName());
        Exception modelException = new Exception();
        modelException.setType(MINIDUMP_FILE);
        modelException.setWrapperSdkName("appcenter.ndk");
        modelException.setMinidumpFilePath(dest.getPath());
        ManagedErrorLog errorLog = new ManagedErrorLog();
        errorLog.setException(modelException);
        errorLog.setTimestamp(new Date(minidumpDate));
        errorLog.setFatal(true);
        errorLog.setId(ErrorLogHelper.parseLogFolderUuid(minidumpFolder));
        SessionContext.SessionInfo session = SessionContext.getInstance().getSessionAt(minidumpDate);
        if (session != null && session.getAppLaunchTimestamp() <= minidumpDate) {
            errorLog.setAppLaunchTimestamp(new Date(session.getAppLaunchTimestamp()));
        } else {
            errorLog.setAppLaunchTimestamp(errorLog.getTimestamp());
        }
        errorLog.setProcessId(0);
        errorLog.setProcessName("");
        errorLog.setUserId(UserIdContext.getInstance().getUserId());
        try {
            Device savedDeviceInfo = ErrorLogHelper.getStoredDeviceInfo(minidumpFolder);
            if (savedDeviceInfo == null) {
                savedDeviceInfo = this.getDeviceInfo(this.mContext);
                savedDeviceInfo.setWrapperSdkName("appcenter.ndk");
            }
            errorLog.setDevice(savedDeviceInfo);
            this.saveErrorLogFiles(new NativeException(), errorLog);
            if (!minidumpFile.renameTo(dest)) {
                throw new IOException("Failed to move file");
            }
        }
        catch (java.lang.Exception e) {
            minidumpFile.delete();
            this.removeAllStoredErrorLogFiles(errorLog.getId());
            AppCenterLog.error((String)LOG_TAG, (String)("Failed to process new minidump file: " + minidumpFile), (Throwable)e);
        }
    }

    private void processPendingErrors() {
        for (File logFile : ErrorLogHelper.getStoredErrorLogFiles()) {
            AppCenterLog.debug((String)LOG_TAG, (String)("Process pending error file: " + logFile));
            String logfileContents = FileManager.read((File)logFile);
            if (logfileContents == null) continue;
            try {
                ManagedErrorLog log = (ManagedErrorLog)this.mLogSerializer.deserializeLog(logfileContents, null);
                UUID id = log.getId();
                ErrorReport report = this.buildErrorReport(log);
                if (report == null) {
                    this.removeAllStoredErrorLogFiles(id);
                    continue;
                }
                if (!this.mAutomaticProcessing || this.mCrashesListener.shouldProcess(report)) {
                    if (!this.mAutomaticProcessing) {
                        AppCenterLog.debug((String)LOG_TAG, (String)("CrashesListener.shouldProcess returned true, continue processing log: " + id.toString()));
                    }
                    this.mUnprocessedErrorReports.put(id, this.mErrorReportCache.get(id));
                    continue;
                }
                AppCenterLog.debug((String)LOG_TAG, (String)("CrashesListener.shouldProcess returned false, clean up and ignore log: " + id.toString()));
                this.removeAllStoredErrorLogFiles(id);
            }
            catch (JSONException e) {
                AppCenterLog.error((String)LOG_TAG, (String)("Error parsing error log. Deleting invalid file: " + logFile), (Throwable)e);
                logFile.delete();
            }
        }
        this.mHasReceivedMemoryWarningInLastSession = Crashes.isMemoryRunningLevelWasReceived(SharedPreferencesManager.getInt((String)PREF_KEY_MEMORY_RUNNING_LEVEL, (int)-1));
        if (this.mHasReceivedMemoryWarningInLastSession) {
            AppCenterLog.debug((String)LOG_TAG, (String)"The application received a low memory warning in the last session.");
        }
        SharedPreferencesManager.remove((String)PREF_KEY_MEMORY_RUNNING_LEVEL);
        if (this.mAutomaticProcessing) {
            this.sendCrashReportsOrAwaitUserConfirmation();
        }
    }

    private static boolean isMemoryRunningLevelWasReceived(int memoryLevel) {
        return memoryLevel == 5 || memoryLevel == 10 || memoryLevel == 15 || memoryLevel == 80;
    }

    private boolean sendCrashReportsOrAwaitUserConfirmation() {
        final boolean alwaysSend = SharedPreferencesManager.getBoolean((String)PREF_KEY_ALWAYS_SEND, (boolean)false);
        HandlerUtils.runOnUiThread((Runnable)new Runnable(){

            @Override
            public void run() {
                if (Crashes.this.mUnprocessedErrorReports.size() > 0) {
                    if (alwaysSend) {
                        AppCenterLog.debug((String)Crashes.LOG_TAG, (String)"The flag for user confirmation is set to ALWAYS_SEND, will send logs.");
                        Crashes.this.handleUserConfirmation(0);
                        return;
                    }
                    if (!Crashes.this.mAutomaticProcessing) {
                        AppCenterLog.debug((String)Crashes.LOG_TAG, (String)"Automatic processing disabled, will wait for explicit user confirmation.");
                        return;
                    }
                    if (!Crashes.this.mCrashesListener.shouldAwaitUserConfirmation()) {
                        AppCenterLog.debug((String)Crashes.LOG_TAG, (String)"CrashesListener.shouldAwaitUserConfirmation returned false, will send logs.");
                        Crashes.this.handleUserConfirmation(0);
                    } else {
                        AppCenterLog.debug((String)Crashes.LOG_TAG, (String)"CrashesListener.shouldAwaitUserConfirmation returned true, wait sending logs.");
                    }
                }
            }
        });
        return alwaysSend;
    }

    private void removeAllStoredErrorLogFiles(UUID id) {
        ErrorLogHelper.removeStoredErrorLogFile(id);
        this.removeStoredThrowable(id);
    }

    private void removeStoredThrowable(UUID id) {
        this.mErrorReportCache.remove(id);
        WrapperSdkExceptionManager.deleteWrapperExceptionData(id);
    }

    @VisibleForTesting
    UncaughtExceptionHandler getUncaughtExceptionHandler() {
        return this.mUncaughtExceptionHandler;
    }

    @VisibleForTesting
    void setUncaughtExceptionHandler(UncaughtExceptionHandler handler) {
        this.mUncaughtExceptionHandler = handler;
    }

    @VisibleForTesting
    String buildStackTrace(Exception exception) {
        String stacktrace = String.format("%s: %s", exception.getType(), exception.getMessage());
        if (exception.getFrames() == null) {
            return stacktrace;
        }
        for (StackFrame frame : exception.getFrames()) {
            stacktrace = stacktrace + String.format("\n %s.%s(%s:%s)", frame.getClassName(), frame.getMethodName(), frame.getFileName(), frame.getLineNumber());
        }
        return stacktrace;
    }

    @VisibleForTesting
    ErrorReport buildErrorReport(ManagedErrorLog log) {
        UUID id = log.getId();
        if (this.mErrorReportCache.containsKey(id)) {
            ErrorReport report = this.mErrorReportCache.get(id).report;
            report.setDevice(log.getDevice());
            return report;
        }
        String stackTrace = null;
        File file = ErrorLogHelper.getStoredThrowableFile(id);
        if (file != null && file.length() > 0L) {
            stackTrace = FileManager.read((File)file);
        }
        if (stackTrace == null) {
            stackTrace = MINIDUMP_FILE.equals(log.getException().getType()) ? Log.getStackTraceString((Throwable)new NativeException()) : this.buildStackTrace(log.getException());
        }
        ErrorReport report = ErrorLogHelper.getErrorReportFromErrorLog(log, stackTrace);
        this.mErrorReportCache.put(id, new ErrorLogReport(log, report));
        return report;
    }

    @VisibleForTesting
    CrashesListener getInstanceListener() {
        return this.mCrashesListener;
    }

    @VisibleForTesting
    synchronized void setInstanceListener(CrashesListener listener) {
        if (listener == null) {
            listener = DEFAULT_ERROR_REPORTING_LISTENER;
        }
        this.mCrashesListener = listener;
    }

    @VisibleForTesting
    private synchronized void handleUserConfirmation(final int userConfirmation) {
        this.post(new Runnable(){

            @Override
            public void run() {
                if (userConfirmation == 1) {
                    Iterator iterator = Crashes.this.mUnprocessedErrorReports.keySet().iterator();
                    while (iterator.hasNext()) {
                        UUID id = (UUID)iterator.next();
                        iterator.remove();
                        Crashes.this.removeAllStoredErrorLogFiles(id);
                    }
                    ErrorLogHelper.cleanPendingMinidumps();
                } else {
                    if (userConfirmation == 2) {
                        SharedPreferencesManager.putBoolean((String)Crashes.PREF_KEY_ALWAYS_SEND, (boolean)true);
                    }
                    Iterator unprocessedIterator = Crashes.this.mUnprocessedErrorReports.entrySet().iterator();
                    while (unprocessedIterator.hasNext()) {
                        File dumpFile = null;
                        ErrorAttachmentLog dumpAttachment = null;
                        Map.Entry unprocessedEntry = unprocessedIterator.next();
                        ErrorLogReport errorLogReport = (ErrorLogReport)unprocessedEntry.getValue();
                        if (errorLogReport.report.getDevice() != null && "appcenter.ndk".equals(errorLogReport.report.getDevice().getWrapperSdkName())) {
                            Exception exception = errorLogReport.log.getException();
                            String minidumpFilePath = exception.getMinidumpFilePath();
                            exception.setMinidumpFilePath(null);
                            if (minidumpFilePath == null) {
                                minidumpFilePath = exception.getStackTrace();
                                exception.setStackTrace(null);
                            }
                            if (minidumpFilePath != null) {
                                dumpFile = new File(minidumpFilePath);
                                byte[] logfileContents = FileManager.readBytes((File)dumpFile);
                                dumpAttachment = ErrorAttachmentLog.attachmentWithBinary(logfileContents, "minidump.dmp", "application/octet-stream");
                            } else {
                                AppCenterLog.warn((String)Crashes.LOG_TAG, (String)"NativeException found without minidump.");
                            }
                        }
                        Crashes.this.mChannel.enqueue((com.microsoft.appcenter.ingestion.models.Log)errorLogReport.log, Crashes.ERROR_GROUP, 2);
                        if (dumpAttachment != null) {
                            Crashes.this.sendErrorAttachment(errorLogReport.log.getId(), Collections.singleton(dumpAttachment));
                            dumpFile.delete();
                        }
                        if (Crashes.this.mAutomaticProcessing) {
                            Iterable<ErrorAttachmentLog> attachments = Crashes.this.mCrashesListener.getErrorAttachments(errorLogReport.report);
                            Crashes.this.sendErrorAttachment(errorLogReport.log.getId(), attachments);
                        }
                        unprocessedIterator.remove();
                        ErrorLogHelper.removeStoredErrorLogFile((UUID)unprocessedEntry.getKey());
                    }
                }
            }
        });
    }

    @WorkerThread
    private void sendErrorAttachment(UUID errorId, Iterable<ErrorAttachmentLog> attachments) {
        if (attachments == null) {
            AppCenterLog.debug((String)LOG_TAG, (String)("Error report: " + errorId.toString() + " does not have any attachment."));
        } else {
            for (ErrorAttachmentLog attachment : attachments) {
                if (attachment != null) {
                    attachment.setId(UUID.randomUUID());
                    attachment.setErrorId(errorId);
                    if (!attachment.isValid()) {
                        AppCenterLog.error((String)LOG_TAG, (String)"Not all required fields are present in ErrorAttachmentLog.");
                        continue;
                    }
                    if (attachment.getData().length > 0x700000) {
                        AppCenterLog.error((String)LOG_TAG, (String)String.format(Locale.ENGLISH, "Discarding attachment with size above %d bytes: size=%d, fileName=%s.", 0x700000, attachment.getData().length, attachment.getFileName()));
                        continue;
                    }
                    this.mChannel.enqueue((com.microsoft.appcenter.ingestion.models.Log)attachment, ERROR_GROUP, 1);
                    continue;
                }
                AppCenterLog.warn((String)LOG_TAG, (String)"Skipping null ErrorAttachmentLog.");
            }
        }
    }

    @VisibleForTesting
    void setLogSerializer(LogSerializer logSerializer) {
        this.mLogSerializer = logSerializer;
    }

    public UUID saveUncaughtException(Thread thread, Throwable throwable) {
        UUID reportUUID = null;
        try {
            reportUUID = this.saveUncaughtException(thread, throwable, ErrorLogHelper.getModelExceptionFromThrowable(throwable));
        }
        catch (JSONException e) {
            AppCenterLog.error((String)LOG_TAG, (String)"Error serializing error log to JSON", (Throwable)e);
        }
        catch (IOException e) {
            AppCenterLog.error((String)LOG_TAG, (String)"Error writing error log to file", (Throwable)e);
        }
        return reportUUID;
    }

    UUID saveUncaughtException(Thread thread, Throwable throwable, Exception modelException) throws JSONException, IOException {
        if (!((Boolean)Crashes.isEnabled().get()).booleanValue()) {
            return null;
        }
        if (this.mSavedUncaughtException) {
            return null;
        }
        this.mSavedUncaughtException = true;
        ManagedErrorLog errorLog = ErrorLogHelper.createErrorLog(this.mContext, thread, modelException, Thread.getAllStackTraces(), this.mInitializeTimestamp, true);
        return this.saveErrorLogFiles(throwable, errorLog);
    }

    @NonNull
    private UUID saveErrorLogFiles(Throwable throwable, ManagedErrorLog errorLog) throws JSONException, IOException {
        File errorStorageDirectory = ErrorLogHelper.getErrorStorageDirectory();
        UUID errorLogId = errorLog.getId();
        String filename = errorLogId.toString();
        AppCenterLog.debug((String)LOG_TAG, (String)"Saving uncaught exception.");
        File errorLogFile = new File(errorStorageDirectory, filename + ".json");
        String errorLogString = this.mLogSerializer.serializeLog((com.microsoft.appcenter.ingestion.models.Log)errorLog);
        FileManager.write((File)errorLogFile, (String)errorLogString);
        AppCenterLog.debug((String)LOG_TAG, (String)("Saved JSON content for ingestion into " + errorLogFile));
        return errorLogId;
    }

    void setAutomaticProcessing(boolean automaticProcessing) {
        this.mAutomaticProcessing = automaticProcessing;
    }

    AppCenterFuture<Collection<ErrorReport>> getUnprocessedErrorReports() {
        final DefaultAppCenterFuture future = new DefaultAppCenterFuture();
        this.postAsyncGetter(new Runnable(){

            @Override
            public void run() {
                ArrayList<ErrorReport> reports = new ArrayList<ErrorReport>(Crashes.this.mUnprocessedErrorReports.size());
                for (ErrorLogReport entry : Crashes.this.mUnprocessedErrorReports.values()) {
                    reports.add(entry.report);
                }
                future.complete(reports);
            }
        }, future, Collections.emptyList());
        return future;
    }

    AppCenterFuture<Boolean> sendCrashReportsOrAwaitUserConfirmation(final Collection<String> filteredReportIds) {
        final DefaultAppCenterFuture future = new DefaultAppCenterFuture();
        this.postAsyncGetter(new Runnable(){

            @Override
            public void run() {
                Iterator iterator = Crashes.this.mUnprocessedErrorReports.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry entry = iterator.next();
                    UUID id = (UUID)entry.getKey();
                    String idString = ((ErrorLogReport)entry.getValue()).report.getId();
                    if (filteredReportIds != null && filteredReportIds.contains(idString)) {
                        AppCenterLog.debug((String)Crashes.LOG_TAG, (String)("CrashesListener.shouldProcess returned true, continue processing log: " + idString));
                        continue;
                    }
                    AppCenterLog.debug((String)Crashes.LOG_TAG, (String)("CrashesListener.shouldProcess returned false, clean up and ignore log: " + idString));
                    Crashes.this.removeAllStoredErrorLogFiles(id);
                    iterator.remove();
                }
                future.complete((Object)Crashes.this.sendCrashReportsOrAwaitUserConfirmation());
            }
        }, future, false);
        return future;
    }

    @WorkerThread
    void sendErrorAttachments(final String errorReportId, final Iterable<ErrorAttachmentLog> attachments) {
        this.post(new Runnable(){

            @Override
            public void run() {
                UUID errorId;
                try {
                    errorId = UUID.fromString(errorReportId);
                }
                catch (RuntimeException e) {
                    AppCenterLog.error((String)Crashes.LOG_TAG, (String)"Error report identifier has an invalid format for sending attachments.");
                    return;
                }
                Crashes.this.sendErrorAttachment(errorId, attachments);
            }
        });
    }

    @WorkerThread
    private static void saveMemoryRunningLevel(int level) {
        SharedPreferencesManager.putInt((String)PREF_KEY_MEMORY_RUNNING_LEVEL, (int)level);
        AppCenterLog.debug((String)LOG_TAG, (String)String.format("The memory running level (%s) was saved.", level));
    }

    private static class ErrorLogReport {
        private final ManagedErrorLog log;
        private final ErrorReport report;

        private ErrorLogReport(ManagedErrorLog log, ErrorReport report) {
            this.log = log;
            this.report = report;
        }
    }

    private static class DefaultCrashesListener
    extends AbstractCrashesListener {
        private DefaultCrashesListener() {
        }
    }

    private static interface CallbackProcessor {
        public void onCallBack(ErrorReport var1);
    }

    private static interface ExceptionModelBuilder {
        public Exception buildExceptionModel();
    }
}

