/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.appcenter.crashes.ingestion.models;

import com.microsoft.appcenter.crashes.ingestion.models.AbstractErrorLog;
import com.microsoft.appcenter.crashes.ingestion.models.Exception;
import com.microsoft.appcenter.crashes.ingestion.models.Thread;
import com.microsoft.appcenter.crashes.ingestion.models.json.ThreadFactory;
import com.microsoft.appcenter.ingestion.models.json.JSONUtils;
import com.microsoft.appcenter.ingestion.models.json.ModelFactory;
import java.util.List;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONStringer;

public class ManagedErrorLog
extends AbstractErrorLog {
    public static final String TYPE = "managedError";
    private static final String EXCEPTION = "exception";
    private static final String THREADS = "threads";
    private Exception exception;
    private List<Thread> threads;

    public String getType() {
        return TYPE;
    }

    public Exception getException() {
        return this.exception;
    }

    public void setException(Exception exception) {
        this.exception = exception;
    }

    public List<Thread> getThreads() {
        return this.threads;
    }

    public void setThreads(List<Thread> threads) {
        this.threads = threads;
    }

    @Override
    public void read(JSONObject object) throws JSONException {
        super.read(object);
        if (object.has(EXCEPTION)) {
            JSONObject jException = object.getJSONObject(EXCEPTION);
            Exception exception = new Exception();
            exception.read(jException);
            this.setException(exception);
        }
        this.setThreads(JSONUtils.readArray((JSONObject)object, (String)THREADS, (ModelFactory)ThreadFactory.getInstance()));
    }

    @Override
    public void write(JSONStringer writer) throws JSONException {
        super.write(writer);
        if (this.getException() != null) {
            writer.key(EXCEPTION).object();
            this.exception.write(writer);
            writer.endObject();
        }
        JSONUtils.writeArray((JSONStringer)writer, (String)THREADS, this.getThreads());
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ManagedErrorLog that = (ManagedErrorLog)((Object)o);
        if (this.exception != null ? !this.exception.equals(that.exception) : that.exception != null) {
            return false;
        }
        return this.threads != null ? this.threads.equals(that.threads) : that.threads == null;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.exception != null ? this.exception.hashCode() : 0);
        result = 31 * result + (this.threads != null ? this.threads.hashCode() : 0);
        return result;
    }
}

