/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.keyvault.webkey;

import com.microsoft.azure.keyvault.webkey.Base64UrlDeserializer;
import com.microsoft.azure.keyvault.webkey.Base64UrlSerializer;
import java.io.IOException;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.RSAPrivateCrtKeySpec;
import java.security.spec.RSAPrivateKeySpec;
import java.security.spec.RSAPublicKeySpec;
import java.util.Arrays;
import org.codehaus.jackson.JsonGenerationException;
import org.codehaus.jackson.annotate.JsonAutoDetect;
import org.codehaus.jackson.annotate.JsonMethod;
import org.codehaus.jackson.annotate.JsonProperty;
import org.codehaus.jackson.map.JsonMappingException;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.annotate.JsonDeserialize;
import org.codehaus.jackson.map.annotate.JsonSerialize;

@JsonAutoDetect(value={JsonMethod.GETTER, JsonMethod.SETTER}, getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY)
public class JsonWebKey {
    private String kid;
    private String kty;
    private String[] keyOps;
    private byte[] n;
    private byte[] e;
    private byte[] d;
    private byte[] dp;
    private byte[] dq;
    private byte[] qi;
    private byte[] p;
    private byte[] q;
    private byte[] k;
    private byte[] t;

    @JsonProperty(value="kid")
    public String getKid() {
        return this.kid;
    }

    public void setKid(String kid) {
        this.kid = kid;
    }

    @JsonProperty(value="kty")
    public String getKty() {
        return this.kty;
    }

    public void setKty(String kty) {
        this.kty = kty;
    }

    @JsonProperty(value="key_ops")
    public String[] getKeyOps() {
        return this.keyOps;
    }

    public void setKeyOps(String[] keyOps) {
        this.keyOps = keyOps;
    }

    @JsonProperty(value="n")
    @JsonSerialize(using=Base64UrlSerializer.class)
    @JsonDeserialize(using=Base64UrlDeserializer.class)
    public byte[] getN() {
        return this.n;
    }

    public void setN(byte[] n) {
        this.n = n;
    }

    @JsonProperty(value="e")
    @JsonSerialize(using=Base64UrlSerializer.class)
    @JsonDeserialize(using=Base64UrlDeserializer.class)
    public byte[] getE() {
        return this.e;
    }

    public void setE(byte[] e) {
        this.e = e;
    }

    @JsonProperty(value="d")
    @JsonSerialize(using=Base64UrlSerializer.class)
    @JsonDeserialize(using=Base64UrlDeserializer.class)
    public byte[] getD() {
        return this.d;
    }

    public void setD(byte[] d) {
        this.d = d;
    }

    @JsonProperty(value="dp")
    @JsonSerialize(using=Base64UrlSerializer.class)
    @JsonDeserialize(using=Base64UrlDeserializer.class)
    public byte[] getDP() {
        return this.dp;
    }

    public void setDP(byte[] dp) {
        this.dp = dp;
    }

    @JsonProperty(value="dq")
    @JsonSerialize(using=Base64UrlSerializer.class)
    @JsonDeserialize(using=Base64UrlDeserializer.class)
    public byte[] getDQ() {
        return this.dq;
    }

    public void setDQ(byte[] dq) {
        this.dq = dq;
    }

    @JsonProperty(value="qi")
    @JsonSerialize(using=Base64UrlSerializer.class)
    @JsonDeserialize(using=Base64UrlDeserializer.class)
    public byte[] getQI() {
        return this.qi;
    }

    public void setQI(byte[] qi) {
        this.qi = qi;
    }

    @JsonProperty(value="p")
    @JsonSerialize(using=Base64UrlSerializer.class)
    @JsonDeserialize(using=Base64UrlDeserializer.class)
    public byte[] getP() {
        return this.p;
    }

    public void setP(byte[] p) {
        this.p = p;
    }

    @JsonProperty(value="q")
    @JsonSerialize(using=Base64UrlSerializer.class)
    @JsonDeserialize(using=Base64UrlDeserializer.class)
    public byte[] getQ() {
        return this.q;
    }

    public void setQ(byte[] q) {
        this.q = q;
    }

    @JsonProperty(value="k")
    @JsonSerialize(using=Base64UrlSerializer.class)
    @JsonDeserialize(using=Base64UrlDeserializer.class)
    public byte[] getk() {
        return this.k;
    }

    public void setK(byte[] k) {
        this.k = k;
    }

    @JsonProperty(value="key_hsm")
    @JsonSerialize(using=Base64UrlSerializer.class)
    @JsonDeserialize(using=Base64UrlDeserializer.class)
    public byte[] getT() {
        return this.t;
    }

    public void setT(byte[] t) {
        this.t = t;
    }

    public String toString() {
        ObjectMapper mapper = new ObjectMapper();
        try {
            return mapper.writeValueAsString((Object)this);
        }
        catch (JsonGenerationException e) {
            throw new IllegalStateException(e);
        }
        catch (JsonMappingException e) {
            throw new IllegalStateException(e);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    private RSAPublicKeySpec getRSAPublicKeySpec() {
        return new RSAPublicKeySpec(JsonWebKey.toBigInteger(this.n), JsonWebKey.toBigInteger(this.e));
    }

    private RSAPrivateKeySpec getRSAPrivateKeySpec() {
        return new RSAPrivateCrtKeySpec(JsonWebKey.toBigInteger(this.n), JsonWebKey.toBigInteger(this.e), JsonWebKey.toBigInteger(this.d), JsonWebKey.toBigInteger(this.p), JsonWebKey.toBigInteger(this.q), JsonWebKey.toBigInteger(this.dp), JsonWebKey.toBigInteger(this.dq), JsonWebKey.toBigInteger(this.qi));
    }

    private PublicKey getRSAPublicKey() {
        try {
            RSAPublicKeySpec publicKeySpec = this.getRSAPublicKeySpec();
            KeyFactory factory = KeyFactory.getInstance("RSA");
            return factory.generatePublic(publicKeySpec);
        }
        catch (GeneralSecurityException e) {
            throw new IllegalStateException(e);
        }
    }

    private PrivateKey getRSAPrivateKey() {
        try {
            RSAPrivateKeySpec privateKeySpec = this.getRSAPrivateKeySpec();
            KeyFactory factory = KeyFactory.getInstance("RSA");
            return factory.generatePrivate(privateKeySpec);
        }
        catch (GeneralSecurityException e) {
            throw new IllegalStateException(e);
        }
    }

    private void checkRSACompatible() {
        if (!"RSA".equals(this.kty) && !"RSA-HSM".equals(this.kty)) {
            throw new UnsupportedOperationException("Not an RSA key");
        }
    }

    private static byte[] toByteArray(BigInteger n) {
        byte[] result = n.toByteArray();
        if (result[0] == 0) {
            return Arrays.copyOfRange(result, 1, result.length);
        }
        return result;
    }

    private static BigInteger toBigInteger(byte[] b) {
        if (b[0] < 0) {
            byte[] temp = new byte[1 + b.length];
            System.arraycopy(b, 0, temp, 1, b.length);
            b = temp;
        }
        return new BigInteger(b);
    }

    public static JsonWebKey fromRSA(KeyPair keyPair) {
        RSAPrivateCrtKey privateKey = (RSAPrivateCrtKey)keyPair.getPrivate();
        JsonWebKey key = null;
        if (privateKey != null) {
            key = new JsonWebKey();
            key.setKty("RSA");
            key.setN(JsonWebKey.toByteArray(privateKey.getModulus()));
            key.setE(JsonWebKey.toByteArray(privateKey.getPublicExponent()));
            key.setD(JsonWebKey.toByteArray(privateKey.getPrivateExponent()));
            key.setP(JsonWebKey.toByteArray(privateKey.getPrimeP()));
            key.setQ(JsonWebKey.toByteArray(privateKey.getPrimeQ()));
            key.setDP(JsonWebKey.toByteArray(privateKey.getPrimeExponentP()));
            key.setDQ(JsonWebKey.toByteArray(privateKey.getPrimeExponentQ()));
            key.setQI(JsonWebKey.toByteArray(privateKey.getCrtCoefficient()));
        } else {
            RSAPublicKey publicKey = (RSAPublicKey)keyPair.getPublic();
            key = new JsonWebKey();
            key.setKty("RSA");
            key.setN(JsonWebKey.toByteArray(publicKey.getModulus()));
            key.setE(JsonWebKey.toByteArray(publicKey.getPublicExponent()));
            key.setD(null);
            key.setP(null);
            key.setQ(null);
            key.setDP(null);
            key.setDQ(null);
            key.setQI(null);
        }
        return key;
    }

    public KeyPair toRSA() {
        return this.toRSA(false);
    }

    public KeyPair toRSA(boolean includePrivateParameters) {
        this.checkRSACompatible();
        if (includePrivateParameters) {
            return new KeyPair(this.getRSAPublicKey(), this.getRSAPrivateKey());
        }
        return new KeyPair(this.getRSAPublicKey(), null);
    }
}

