/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.network;

import com.fasterxml.jackson.annotation.JsonValue;

/**
 * Defines values for ApplicationGatewayCookieBasedAffinity.
 */
public final class ApplicationGatewayCookieBasedAffinity {
    /** Static value Enabled for ApplicationGatewayCookieBasedAffinity. */
    public static final ApplicationGatewayCookieBasedAffinity ENABLED = new ApplicationGatewayCookieBasedAffinity("Enabled");

    /** Static value Disabled for ApplicationGatewayCookieBasedAffinity. */
    public static final ApplicationGatewayCookieBasedAffinity DISABLED = new ApplicationGatewayCookieBasedAffinity("Disabled");

    private String value;

    /**
     * Creates a custom value for ApplicationGatewayCookieBasedAffinity.
     * @param value the custom value
     */
    public ApplicationGatewayCookieBasedAffinity(String value) {
        this.value = value;
    }

    @JsonValue
    @Override
    public String toString() {
        return value;
    }

    @Override
    public int hashCode() {
        return value.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof ApplicationGatewayCookieBasedAffinity)) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        ApplicationGatewayCookieBasedAffinity rhs = (ApplicationGatewayCookieBasedAffinity) obj;
        if (value == null) {
            return rhs.value == null;
        } else {
            return value.equals(rhs.value);
        }
    }
}
