/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.network;

import com.fasterxml.jackson.annotation.JsonValue;

/**
 * Defines values for ApplicationGatewayFirewallMode.
 */
public final class ApplicationGatewayFirewallMode {
    /** Static value Detection for ApplicationGatewayFirewallMode. */
    public static final ApplicationGatewayFirewallMode DETECTION = new ApplicationGatewayFirewallMode("Detection");

    /** Static value Prevention for ApplicationGatewayFirewallMode. */
    public static final ApplicationGatewayFirewallMode PREVENTION = new ApplicationGatewayFirewallMode("Prevention");

    private String value;

    /**
     * Creates a custom value for ApplicationGatewayFirewallMode.
     * @param value the custom value
     */
    public ApplicationGatewayFirewallMode(String value) {
        this.value = value;
    }

    @JsonValue
    @Override
    public String toString() {
        return value;
    }

    @Override
    public int hashCode() {
        return value.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof ApplicationGatewayFirewallMode)) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        ApplicationGatewayFirewallMode rhs = (ApplicationGatewayFirewallMode) obj;
        if (value == null) {
            return rhs.value == null;
        } else {
            return value.equals(rhs.value);
        }
    }
}
