/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.network;

import com.fasterxml.jackson.annotation.JsonValue;

/**
 * Defines values for ApplicationGatewaySslProtocol.
 */
public final class ApplicationGatewaySslProtocol {
    /** Static value TLSv1_0 for ApplicationGatewaySslProtocol. */
    public static final ApplicationGatewaySslProtocol TLSV1_0 = new ApplicationGatewaySslProtocol("TLSv1_0");

    /** Static value TLSv1_1 for ApplicationGatewaySslProtocol. */
    public static final ApplicationGatewaySslProtocol TLSV1_1 = new ApplicationGatewaySslProtocol("TLSv1_1");

    /** Static value TLSv1_2 for ApplicationGatewaySslProtocol. */
    public static final ApplicationGatewaySslProtocol TLSV1_2 = new ApplicationGatewaySslProtocol("TLSv1_2");

    private String value;

    /**
     * Creates a custom value for ApplicationGatewaySslProtocol.
     * @param value the custom value
     */
    public ApplicationGatewaySslProtocol(String value) {
        this.value = value;
    }

    @JsonValue
    @Override
    public String toString() {
        return value;
    }

    @Override
    public int hashCode() {
        return value.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof ApplicationGatewaySslProtocol)) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        ApplicationGatewaySslProtocol rhs = (ApplicationGatewaySslProtocol) obj;
        if (value == null) {
            return rhs.value == null;
        } else {
            return value.equals(rhs.value);
        }
    }
}
