/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.network;

import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Application gateway web application firewall configuration.
 */
public class ApplicationGatewayWebApplicationFirewallConfiguration {
    /**
     * Whether the web application firewall is enabled.
     */
    @JsonProperty(required = true)
    private boolean enabled;

    /**
     * Web application firewall mode. Possible values are: 'Detection' and
     * 'Prevention'. Possible values include: 'Detection', 'Prevention'.
     */
    private ApplicationGatewayFirewallMode firewallMode;

    /**
     * Get the enabled value.
     *
     * @return the enabled value
     */
    public boolean enabled() {
        return this.enabled;
    }

    /**
     * Set the enabled value.
     *
     * @param enabled the enabled value to set
     * @return the ApplicationGatewayWebApplicationFirewallConfiguration object itself.
     */
    public ApplicationGatewayWebApplicationFirewallConfiguration withEnabled(boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    /**
     * Get the firewallMode value.
     *
     * @return the firewallMode value
     */
    public ApplicationGatewayFirewallMode firewallMode() {
        return this.firewallMode;
    }

    /**
     * Set the firewallMode value.
     *
     * @param firewallMode the firewallMode value to set
     * @return the ApplicationGatewayWebApplicationFirewallConfiguration object itself.
     */
    public ApplicationGatewayWebApplicationFirewallConfiguration withFirewallMode(ApplicationGatewayFirewallMode firewallMode) {
        this.firewallMode = firewallMode;
        return this;
    }

}
