/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.network;

import com.fasterxml.jackson.annotation.JsonValue;

/**
 * Defines values for VirtualNetworkGatewayConnectionType.
 */
public final class VirtualNetworkGatewayConnectionType {
    /** Static value IPsec for VirtualNetworkGatewayConnectionType. */
    public static final VirtualNetworkGatewayConnectionType IPSEC = new VirtualNetworkGatewayConnectionType("IPsec");

    /** Static value Vnet2Vnet for VirtualNetworkGatewayConnectionType. */
    public static final VirtualNetworkGatewayConnectionType VNET2VNET = new VirtualNetworkGatewayConnectionType("Vnet2Vnet");

    /** Static value ExpressRoute for VirtualNetworkGatewayConnectionType. */
    public static final VirtualNetworkGatewayConnectionType EXPRESS_ROUTE = new VirtualNetworkGatewayConnectionType("ExpressRoute");

    /** Static value VPNClient for VirtualNetworkGatewayConnectionType. */
    public static final VirtualNetworkGatewayConnectionType VPNCLIENT = new VirtualNetworkGatewayConnectionType("VPNClient");

    private String value;

    /**
     * Creates a custom value for VirtualNetworkGatewayConnectionType.
     * @param value the custom value
     */
    public VirtualNetworkGatewayConnectionType(String value) {
        this.value = value;
    }

    @JsonValue
    @Override
    public String toString() {
        return value;
    }

    @Override
    public int hashCode() {
        return value.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof VirtualNetworkGatewayConnectionType)) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        VirtualNetworkGatewayConnectionType rhs = (VirtualNetworkGatewayConnectionType) obj;
        if (value == null) {
            return rhs.value == null;
        } else {
            return value.equals(rhs.value);
        }
    }
}
