/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.network;

import com.microsoft.azure.management.apigeneration.Fluent;
import com.microsoft.azure.management.apigeneration.Method;
import com.microsoft.azure.management.network.ApplicationGatewayBackend;
import com.microsoft.azure.management.network.ApplicationGatewayBackendHttpConfiguration;
import com.microsoft.azure.management.network.ApplicationGatewayFrontend;
import com.microsoft.azure.management.network.ApplicationGatewayIpConfiguration;
import com.microsoft.azure.management.network.ApplicationGatewayListener;
import com.microsoft.azure.management.network.ApplicationGatewayOperationalState;
import com.microsoft.azure.management.network.ApplicationGatewayRequestRoutingRule;
import com.microsoft.azure.management.network.ApplicationGatewaySku;
import com.microsoft.azure.management.network.ApplicationGatewaySkuName;
import com.microsoft.azure.management.network.ApplicationGatewaySslCertificate;
import com.microsoft.azure.management.network.ApplicationGatewaySslPolicy;
import com.microsoft.azure.management.network.ApplicationGatewayTier;
import com.microsoft.azure.management.network.Network;
import com.microsoft.azure.management.network.Subnet;
import com.microsoft.azure.management.network.implementation.ApplicationGatewayInner;
import com.microsoft.azure.management.network.implementation.NetworkManager;
import com.microsoft.azure.management.network.model.HasPrivateIpAddress;
import com.microsoft.azure.management.network.model.HasPublicIpAddress;
import com.microsoft.azure.management.resources.fluentcore.arm.models.GroupableResource;
import com.microsoft.azure.management.resources.fluentcore.arm.models.HasManager;
import com.microsoft.azure.management.resources.fluentcore.arm.models.HasSubnet;
import com.microsoft.azure.management.resources.fluentcore.arm.models.Resource;
import com.microsoft.azure.management.resources.fluentcore.model.Appliable;
import com.microsoft.azure.management.resources.fluentcore.model.Creatable;
import com.microsoft.azure.management.resources.fluentcore.model.Refreshable;
import com.microsoft.azure.management.resources.fluentcore.model.Updatable;
import com.microsoft.azure.management.resources.fluentcore.model.Wrapper;
import java.util.Map;

@Fluent
public interface ApplicationGateway
extends GroupableResource,
Refreshable<ApplicationGateway>,
Wrapper<ApplicationGatewayInner>,
Updatable<Update>,
HasSubnet,
HasPrivateIpAddress,
HasManager<NetworkManager> {
    public boolean isPrivate();

    public boolean isPublic();

    public ApplicationGatewayFrontend defaultPublicFrontend();

    public ApplicationGatewayFrontend defaultPrivateFrontend();

    public ApplicationGatewaySku sku();

    public int instanceCount();

    public ApplicationGatewaySkuName size();

    public ApplicationGatewayTier tier();

    public ApplicationGatewayOperationalState operationalState();

    public ApplicationGatewaySslPolicy sslPolicy();

    public Map<String, ApplicationGatewayIpConfiguration> ipConfigurations();

    public Map<String, ApplicationGatewayBackend> backends();

    public ApplicationGatewayIpConfiguration defaultIpConfiguration();

    public Map<String, ApplicationGatewayFrontend> frontends();

    public Map<String, ApplicationGatewayFrontend> publicFrontends();

    public Map<String, ApplicationGatewayFrontend> privateFrontends();

    public Map<String, Integer> frontendPorts();

    public Map<String, ApplicationGatewayBackendHttpConfiguration> backendHttpConfigurations();

    public Map<String, ApplicationGatewaySslCertificate> sslCertificates();

    public Map<String, ApplicationGatewayListener> listeners();

    public Map<String, ApplicationGatewayRequestRoutingRule> requestRoutingRules();

    public String frontendPortNameFromNumber(int var1);

    public ApplicationGatewayListener listenerByPortNumber(int var1);

    public static interface Update
    extends Appliable<ApplicationGateway>,
    Resource.UpdateWithTags<Update>,
    UpdateStages.WithSize,
    UpdateStages.WithInstanceCount,
    UpdateStages.WithBackend,
    UpdateStages.WithBackendHttpConfig,
    UpdateStages.WithIpConfig,
    UpdateStages.WithFrontend,
    UpdateStages.WithPublicIpAddress,
    UpdateStages.WithFrontendPort,
    UpdateStages.WithSslCert,
    UpdateStages.WithListener,
    UpdateStages.WithRequestRoutingRule,
    UpdateStages.WithExistingSubnet {
    }

    public static interface UpdateStages {

        public static interface WithRequestRoutingRule {
            public ApplicationGatewayRequestRoutingRule.UpdateDefinitionStages.Blank<Update> defineRequestRoutingRule(String var1);

            public Update withoutRequestRoutingRule(String var1);

            public ApplicationGatewayRequestRoutingRule.Update updateRequestRoutingRule(String var1);
        }

        public static interface WithBackendHttpConfig {
            public ApplicationGatewayBackendHttpConfiguration.UpdateDefinitionStages.Blank<Update> defineBackendHttpConfiguration(String var1);

            public Update withoutBackendHttpConfiguration(String var1);

            public ApplicationGatewayBackendHttpConfiguration.Update updateBackendHttpConfiguration(String var1);
        }

        public static interface WithListener {
            public ApplicationGatewayListener.UpdateDefinitionStages.Blank<Update> defineListener(String var1);

            public Update withoutListener(String var1);

            public ApplicationGatewayListener.Update updateListener(String var1);
        }

        public static interface WithSslCert {
            public ApplicationGatewaySslCertificate.UpdateDefinitionStages.Blank<Update> defineSslCertificate(String var1);

            public Update withoutCertificate(String var1);
        }

        public static interface WithInstanceCount {
            public Update withInstanceCount(int var1);
        }

        public static interface WithSize {
            public Update withSize(ApplicationGatewaySkuName var1);
        }

        public static interface WithBackend {
            public ApplicationGatewayBackend.UpdateDefinitionStages.Blank<Update> defineBackend(String var1);

            public Update withoutBackendFqdn(String var1);

            public Update withoutBackendIpAddress(String var1);

            public Update withoutBackend(String var1);

            public ApplicationGatewayBackend.Update updateBackend(String var1);
        }

        public static interface WithFrontend {
            public Update withoutFrontend(String var1);

            public ApplicationGatewayFrontend.Update updateFrontend(String var1);

            @Method
            public Update withoutPublicFrontend();

            @Method
            public Update withoutPrivateFrontend();

            @Method
            public ApplicationGatewayFrontend.Update updatePublicFrontend();

            @Method
            public ApplicationGatewayFrontend.UpdateDefinitionStages.Blank<Update> definePublicFrontend();

            @Method
            public ApplicationGatewayFrontend.UpdateDefinitionStages.Blank<Update> definePrivateFrontend();
        }

        public static interface WithPublicIpAddress
        extends HasPublicIpAddress.UpdateStages.WithPublicIpAddressNoDnsLabel<Update> {
        }

        public static interface WithFrontendPort {
            public Update withFrontendPort(int var1);

            public Update withFrontendPort(int var1, String var2);

            public Update withoutFrontendPort(String var1);

            public Update withoutFrontendPort(int var1);
        }

        public static interface WithIpConfig {
            public Update withoutIpConfiguration(String var1);

            public ApplicationGatewayIpConfiguration.Update updateIpConfiguration(String var1);

            @Method
            public ApplicationGatewayIpConfiguration.Update updateDefaultIpConfiguration();

            @Method
            public ApplicationGatewayIpConfiguration.UpdateDefinitionStages.Blank<Update> defineDefaultIpConfiguration();
        }

        public static interface WithExistingSubnet
        extends HasSubnet.UpdateStages.WithSubnet<Update> {
            public Update withExistingSubnet(Subnet var1);

            public Update withExistingSubnet(Network var1, String var2);
        }

        public static interface WithPrivateFrontend {
            @Method
            public Update withPrivateFrontend();

            @Method
            public Update withoutPrivateFrontend();
        }
    }

    public static interface DefinitionStages {

        public static interface WithCreate
        extends Creatable<ApplicationGateway>,
        Resource.DefinitionWithTags<WithCreate>,
        WithSize,
        WithInstanceCount,
        WithSslCert,
        WithFrontendPort,
        WithListener,
        WithBackendHttpConfig,
        WithBackend,
        WithExistingSubnet,
        WithPrivateIpAddress,
        WithPrivateFrontend,
        WithPublicFrontend,
        WithPublicIpAddress {
        }

        public static interface WithPrivateIpAddress
        extends HasPrivateIpAddress.DefinitionStages.WithPrivateIpAddress<WithCreate> {
        }

        public static interface WithExistingSubnet
        extends HasSubnet.DefinitionStages.WithSubnet<WithCreate> {
            public WithCreate withExistingSubnet(Subnet var1);

            public WithCreate withExistingSubnet(Network var1, String var2);
        }

        public static interface WithInstanceCount {
            public WithCreate withInstanceCount(int var1);
        }

        public static interface WithSize {
            public WithCreate withSize(ApplicationGatewaySkuName var1);
        }

        public static interface WithRequestRoutingRuleOrCreate
        extends WithRequestRoutingRule,
        WithCreate {
        }

        public static interface WithRequestRoutingRule {
            public ApplicationGatewayRequestRoutingRule.DefinitionStages.Blank<WithRequestRoutingRuleOrCreate> defineRequestRoutingRule(String var1);
        }

        public static interface WithBackendHttpConfig {
            public ApplicationGatewayBackendHttpConfiguration.DefinitionStages.Blank<WithCreate> defineBackendHttpConfiguration(String var1);
        }

        public static interface WithBackend {
            public ApplicationGatewayBackend.DefinitionStages.Blank<WithCreate> defineBackend(String var1);
        }

        public static interface WithSslCert {
            public ApplicationGatewaySslCertificate.DefinitionStages.Blank<WithCreate> defineSslCertificate(String var1);
        }

        public static interface WithFrontendPort {
            public WithCreate withFrontendPort(int var1);

            public WithCreate withFrontendPort(int var1, String var2);
        }

        public static interface WithListener {
            public ApplicationGatewayListener.DefinitionStages.Blank<WithCreate> defineListener(String var1);
        }

        public static interface WithPrivateFrontend {
            @Method
            public WithCreate withPrivateFrontend();

            @Method
            public WithCreate withoutPrivateFrontend();
        }

        public static interface WithPublicFrontend
        extends WithPublicIpAddress {
            @Method
            public WithCreate withoutPublicFrontend();
        }

        public static interface WithPublicIpAddress
        extends HasPublicIpAddress.DefinitionStages.WithPublicIpAddressNoDnsLabel<WithCreate> {
        }

        public static interface WithGroup
        extends GroupableResource.DefinitionStages.WithGroup<WithRequestRoutingRule> {
        }

        public static interface Blank
        extends Resource.DefinitionWithRegion<WithGroup> {
        }
    }

    public static interface Definition
    extends DefinitionStages.Blank,
    DefinitionStages.WithGroup,
    DefinitionStages.WithCreate,
    DefinitionStages.WithRequestRoutingRule,
    DefinitionStages.WithRequestRoutingRuleOrCreate {
    }
}

