/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.network;

import com.microsoft.azure.management.apigeneration.Fluent;
import com.microsoft.azure.management.network.LoadBalancerBackend;
import com.microsoft.azure.management.network.LoadBalancerFrontend;
import com.microsoft.azure.management.network.LoadBalancerHttpProbe;
import com.microsoft.azure.management.network.LoadBalancerInboundNatPool;
import com.microsoft.azure.management.network.LoadBalancerInboundNatRule;
import com.microsoft.azure.management.network.LoadBalancerPrivateFrontend;
import com.microsoft.azure.management.network.LoadBalancerPublicFrontend;
import com.microsoft.azure.management.network.LoadBalancerTcpProbe;
import com.microsoft.azure.management.network.LoadBalancingRule;
import com.microsoft.azure.management.network.Network;
import com.microsoft.azure.management.network.TransportProtocol;
import com.microsoft.azure.management.network.implementation.LoadBalancerInner;
import com.microsoft.azure.management.network.model.HasLoadBalancingRules;
import com.microsoft.azure.management.network.model.HasNetworkInterfaces;
import com.microsoft.azure.management.network.model.HasPublicIpAddress;
import com.microsoft.azure.management.resources.fluentcore.arm.models.GroupableResource;
import com.microsoft.azure.management.resources.fluentcore.arm.models.Resource;
import com.microsoft.azure.management.resources.fluentcore.model.Appliable;
import com.microsoft.azure.management.resources.fluentcore.model.Creatable;
import com.microsoft.azure.management.resources.fluentcore.model.Refreshable;
import com.microsoft.azure.management.resources.fluentcore.model.Updatable;
import com.microsoft.azure.management.resources.fluentcore.model.Wrapper;
import java.util.List;
import java.util.Map;

@Fluent
public interface LoadBalancer
extends GroupableResource,
Refreshable<LoadBalancer>,
Wrapper<LoadBalancerInner>,
Updatable<Update>,
HasLoadBalancingRules {
    public List<String> publicIpAddressIds();

    public Map<String, LoadBalancerTcpProbe> tcpProbes();

    public Map<String, LoadBalancerHttpProbe> httpProbes();

    public Map<String, LoadBalancerBackend> backends();

    public Map<String, LoadBalancerInboundNatRule> inboundNatRules();

    public Map<String, LoadBalancerFrontend> frontends();

    public Map<String, LoadBalancerInboundNatPool> inboundNatPools();

    public static interface Update
    extends Appliable<LoadBalancer>,
    Resource.UpdateWithTags<Update>,
    UpdateStages.WithProbe,
    UpdateStages.WithBackend,
    UpdateStages.WithLoadBalancingRule,
    UpdateStages.WithInternetFrontend,
    UpdateStages.WithInternalFrontend,
    UpdateStages.WithNetworkSubnet,
    UpdateStages.WithInboundNatRule,
    UpdateStages.WithInboundNatPool {
    }

    public static interface UpdateStages {

        public static interface WithInboundNatPool {
            public Update withoutInboundNatPool(String var1);

            public LoadBalancerInboundNatPool.UpdateDefinitionStages.Blank<Update> defineInboundNatPool(String var1);

            public LoadBalancerInboundNatPool.Update updateInboundNatPool(String var1);
        }

        public static interface WithInboundNatRule {
            public Update withoutInboundNatRule(String var1);

            public LoadBalancerInboundNatRule.UpdateDefinitionStages.Blank<Update> defineInboundNatRule(String var1);

            public LoadBalancerInboundNatRule.Update updateInboundNatRule(String var1);
        }

        public static interface WithNetworkSubnet {
            public Update withFrontendSubnet(Network var1, String var2);
        }

        public static interface WithInternalFrontend
        extends WithNetworkSubnet {
            public LoadBalancerPrivateFrontend.UpdateDefinitionStages.Blank<Update> definePrivateFrontend(String var1);

            public LoadBalancerPrivateFrontend.Update updateInternalFrontend(String var1);
        }

        public static interface WithPublicIpAddress
        extends HasPublicIpAddress.UpdateDefinitionStages.WithPublicIpAddress<Update> {
        }

        public static interface WithInternetFrontend
        extends WithPublicIpAddress {
            public LoadBalancerPublicFrontend.UpdateDefinitionStages.Blank<Update> definePublicFrontend(String var1);

            public Update withoutFrontend(String var1);

            public LoadBalancerPublicFrontend.Update updateInternetFrontend(String var1);
        }

        public static interface WithLoadBalancingRule {
            public Update withLoadBalancingRule(int var1, TransportProtocol var2, int var3);

            public Update withLoadBalancingRule(int var1, TransportProtocol var2);

            public LoadBalancingRule.UpdateDefinitionStages.Blank<Update> defineLoadBalancingRule(String var1);

            public Update withoutLoadBalancingRule(String var1);

            public LoadBalancingRule.Update updateLoadBalancingRule(String var1);
        }

        public static interface WithProbe {
            public Update withTcpProbe(int var1);

            public Update withHttpProbe(String var1);

            public LoadBalancerHttpProbe.UpdateDefinitionStages.Blank<Update> defineHttpProbe(String var1);

            public LoadBalancerTcpProbe.UpdateDefinitionStages.Blank<Update> defineTcpProbe(String var1);

            public Update withoutProbe(String var1);

            public LoadBalancerTcpProbe.Update updateTcpProbe(String var1);

            public LoadBalancerHttpProbe.Update updateHttpProbe(String var1);
        }

        public static interface WithBackend {
            public Update withoutBackend(String var1);

            public LoadBalancerBackend.UpdateDefinitionStages.Blank<Update> defineBackend(String var1);

            public LoadBalancerBackend.Update updateBackend(String var1);
        }
    }

    public static interface DefinitionStages {

        public static interface WithInboundNatPool {
            public LoadBalancerInboundNatPool.DefinitionStages.Blank<WithCreateAndInboundNatPool> defineInboundNatPool(String var1);
        }

        public static interface WithInboundNatRule {
            public LoadBalancerInboundNatRule.DefinitionStages.Blank<WithCreateAndInboundNatRule> defineInboundNatRule(String var1);
        }

        public static interface WithCreateAndInboundNatRule
        extends WithCreate,
        WithInboundNatRule {
        }

        public static interface WithCreateAndInboundNatPool
        extends WithCreate,
        WithInboundNatPool {
        }

        public static interface WithCreateAndNatChoice
        extends WithCreate,
        WithInboundNatRule,
        WithInboundNatPool {
        }

        public static interface WithCreate
        extends Creatable<LoadBalancer>,
        Resource.DefinitionWithTags<WithCreate> {
        }

        public static interface WithLoadBalancingRuleOrCreate
        extends WithLoadBalancingRule,
        WithCreateAndNatChoice {
        }

        public static interface WithLoadBalancingRule {
            public WithLoadBalancingRuleOrCreate withLoadBalancingRule(int var1, TransportProtocol var2, int var3);

            public WithLoadBalancingRuleOrCreate withLoadBalancingRule(int var1, TransportProtocol var2);

            public LoadBalancingRule.DefinitionStages.Blank<WithLoadBalancingRuleOrCreate> defineLoadBalancingRule(String var1);
        }

        public static interface WithNetworkSubnet {
            public WithPrivateFrontendOrBackend withFrontendSubnet(Network var1, String var2);
        }

        public static interface WithPublicIpAddress<ReturnT>
        extends HasPublicIpAddress.DefinitionStages.WithPublicIpAddress<ReturnT> {
        }

        public static interface WithVirtualMachine<ReturnT> {
            public ReturnT withExistingVirtualMachines(HasNetworkInterfaces ... var1);
        }

        public static interface WithProbeOrLoadBalancingRule
        extends WithProbe,
        WithLoadBalancingRule {
        }

        public static interface WithProbe {
            public WithProbeOrLoadBalancingRule withTcpProbe(int var1);

            public WithProbeOrLoadBalancingRule withHttpProbe(String var1);

            public LoadBalancerTcpProbe.DefinitionStages.Blank<WithProbeOrLoadBalancingRule> defineTcpProbe(String var1);

            public LoadBalancerHttpProbe.DefinitionStages.Blank<WithProbeOrLoadBalancingRule> defineHttpProbe(String var1);
        }

        public static interface WithBackendOrProbe
        extends WithBackend,
        WithProbe {
        }

        public static interface WithBackend
        extends WithVirtualMachine<WithBackendOrProbe> {
            public LoadBalancerBackend.DefinitionStages.Blank<WithBackendOrProbe> defineBackend(String var1);
        }

        public static interface WithPublicFrontendOrBackend
        extends WithPublicFrontend,
        WithBackend {
        }

        public static interface WithPublicFrontend {
            public LoadBalancerPublicFrontend.DefinitionStages.Blank<WithPublicFrontendOrBackend> definePublicFrontend(String var1);
        }

        public static interface WithPrivateFrontendOrBackend
        extends WithPrivateFrontend,
        WithBackend {
        }

        public static interface WithPrivateFrontend
        extends WithNetworkSubnet {
            public LoadBalancerPrivateFrontend.DefinitionStages.Blank<WithPrivateFrontendOrBackend> definePrivateFrontend(String var1);
        }

        public static interface WithFrontend
        extends WithPublicIpAddress<WithPublicFrontendOrBackend>,
        WithPublicFrontend,
        WithPrivateFrontend {
        }

        public static interface WithGroup
        extends GroupableResource.DefinitionStages.WithGroup<WithFrontend> {
        }

        public static interface Blank
        extends Resource.DefinitionWithRegion<WithGroup> {
        }
    }

    public static interface Definition
    extends DefinitionStages.Blank,
    DefinitionStages.WithGroup,
    DefinitionStages.WithFrontend,
    DefinitionStages.WithCreate,
    DefinitionStages.WithPublicFrontendOrBackend,
    DefinitionStages.WithPrivateFrontendOrBackend,
    DefinitionStages.WithNetworkSubnet,
    DefinitionStages.WithBackend,
    DefinitionStages.WithBackendOrProbe,
    DefinitionStages.WithProbe,
    DefinitionStages.WithProbeOrLoadBalancingRule,
    DefinitionStages.WithLoadBalancingRule,
    DefinitionStages.WithLoadBalancingRuleOrCreate,
    DefinitionStages.WithCreateAndInboundNatPool,
    DefinitionStages.WithCreateAndInboundNatRule,
    DefinitionStages.WithCreateAndNatChoice {
    }
}

