/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.network;

import com.microsoft.azure.management.apigeneration.Fluent;
import com.microsoft.azure.management.network.LoadBalancer;
import com.microsoft.azure.management.network.Network;
import com.microsoft.azure.management.network.NetworkInterfaceBase;
import com.microsoft.azure.management.network.NetworkSecurityGroup;
import com.microsoft.azure.management.network.NicIpConfiguration;
import com.microsoft.azure.management.network.PublicIpAddress;
import com.microsoft.azure.management.network.implementation.NetworkInterfaceInner;
import com.microsoft.azure.management.resources.fluentcore.arm.models.GroupableResource;
import com.microsoft.azure.management.resources.fluentcore.arm.models.Resource;
import com.microsoft.azure.management.resources.fluentcore.model.Appliable;
import com.microsoft.azure.management.resources.fluentcore.model.Creatable;
import com.microsoft.azure.management.resources.fluentcore.model.Refreshable;
import com.microsoft.azure.management.resources.fluentcore.model.Updatable;
import com.microsoft.azure.management.resources.fluentcore.model.Wrapper;
import java.util.Map;

@Fluent
public interface NetworkInterface
extends NetworkInterfaceBase,
GroupableResource,
Refreshable<NetworkInterface>,
Wrapper<NetworkInterfaceInner>,
Updatable<Update> {
    public Map<String, NicIpConfiguration> ipConfigurations();

    public NicIpConfiguration primaryIpConfiguration();

    public static interface Update
    extends Appliable<NetworkInterface>,
    Resource.UpdateWithTags<Update>,
    UpdateStages.WithPrimaryNetworkSubnet,
    UpdateStages.WithPrimaryPrivateIp,
    UpdateStages.WithPrimaryPublicIpAddress,
    UpdateStages.WithNetworkSecurityGroup,
    UpdateStages.WithIpForwarding,
    UpdateStages.WithDnsServer,
    UpdateStages.WithIpConfiguration,
    UpdateStages.WithLoadBalancer {
    }

    public static interface UpdateStages {

        public static interface WithLoadBalancer {
            public Update withExistingLoadBalancerBackend(LoadBalancer var1, String var2);

            public Update withExistingLoadBalancerInboundNatRule(LoadBalancer var1, String var2);

            public Update withoutLoadBalancerBackends();

            public Update withoutLoadBalancerInboundNatRules();
        }

        public static interface WithIpConfiguration {
            public NicIpConfiguration.UpdateDefinitionStages.Blank<Update> defineSecondaryIpConfiguration(String var1);

            public NicIpConfiguration.Update updateIpConfiguration(String var1);
        }

        public static interface WithDnsServer {
            public Update withDnsServer(String var1);

            public Update withoutDnsServer(String var1);

            public Update withAzureDnsServer();
        }

        public static interface WithIpForwarding {
            public Update withIpForwarding();

            public Update withoutIpForwarding();
        }

        public static interface WithNetworkSecurityGroup {
            public Update withNewNetworkSecurityGroup(Creatable<NetworkSecurityGroup> var1);

            public Update withExistingNetworkSecurityGroup(NetworkSecurityGroup var1);

            public Update withoutNetworkSecurityGroup();
        }

        public static interface WithPrimaryPublicIpAddress {
            public Update withNewPrimaryPublicIpAddress(Creatable<PublicIpAddress> var1);

            public Update withNewPrimaryPublicIpAddress();

            public Update withNewPrimaryPublicIpAddress(String var1);

            public Update withoutPrimaryPublicIpAddress();

            public Update withExistingPrimaryPublicIpAddress(PublicIpAddress var1);
        }

        public static interface WithPrimaryPrivateIp {
            public Update withPrimaryPrivateIpAddressDynamic();

            public Update withPrimaryPrivateIpAddressStatic(String var1);
        }

        public static interface WithPrimaryNetworkSubnet {
            public Update withSubnet(String var1);
        }
    }

    public static interface DefinitionStages {

        public static interface WithCreate
        extends Creatable<NetworkInterface>,
        Resource.DefinitionWithTags<WithCreate>,
        WithPrimaryPublicIpAddress,
        WithNetworkSecurityGroup,
        WithSecondaryIpConfiguration,
        WithLoadBalancer {
            public WithCreate withIpForwarding();

            public WithCreate withDnsServer(String var1);

            public WithCreate withInternalDnsNameLabel(String var1);
        }

        public static interface WithSecondaryIpConfiguration {
            public NicIpConfiguration.DefinitionStages.Blank<WithCreate> defineSecondaryIpConfiguration(String var1);
        }

        public static interface WithNetworkSecurityGroup {
            public WithCreate withNewNetworkSecurityGroup(Creatable<NetworkSecurityGroup> var1);

            public WithCreate withExistingNetworkSecurityGroup(NetworkSecurityGroup var1);
        }

        public static interface WithPrimaryPublicIpAddress {
            public WithCreate withNewPrimaryPublicIpAddress(Creatable<PublicIpAddress> var1);

            public WithCreate withNewPrimaryPublicIpAddress();

            public WithCreate withNewPrimaryPublicIpAddress(String var1);

            public WithCreate withExistingPrimaryPublicIpAddress(PublicIpAddress var1);
        }

        public static interface WithPrimaryPrivateIp {
            public WithCreate withPrimaryPrivateIpAddressDynamic();

            public WithCreate withPrimaryPrivateIpAddressStatic(String var1);
        }

        public static interface WithPrimaryNetworkSubnet {
            public WithPrimaryPrivateIp withSubnet(String var1);
        }

        public static interface WithPrimaryNetwork {
            public WithPrimaryPrivateIp withNewPrimaryNetwork(Creatable<Network> var1);

            public WithPrimaryPrivateIp withNewPrimaryNetwork(String var1, String var2);

            public WithPrimaryPrivateIp withNewPrimaryNetwork(String var1);

            public WithPrimaryNetworkSubnet withExistingPrimaryNetwork(Network var1);
        }

        public static interface WithGroup
        extends GroupableResource.DefinitionStages.WithGroup<WithPrimaryNetwork> {
        }

        public static interface Blank
        extends Resource.DefinitionWithRegion<WithGroup> {
        }

        public static interface WithLoadBalancer {
            public WithCreate withExistingLoadBalancerBackend(LoadBalancer var1, String var2);

            public WithCreate withExistingLoadBalancerInboundNatRule(LoadBalancer var1, String var2);
        }
    }

    public static interface Definition
    extends DefinitionStages.Blank,
    DefinitionStages.WithGroup,
    DefinitionStages.WithPrimaryNetwork,
    DefinitionStages.WithPrimaryNetworkSubnet,
    DefinitionStages.WithPrimaryPrivateIp,
    DefinitionStages.WithCreate {
    }
}

