/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.network;

import com.microsoft.azure.management.apigeneration.Fluent;
import com.microsoft.azure.management.network.IPAllocationMethod;
import com.microsoft.azure.management.network.IPVersion;
import com.microsoft.azure.management.network.LoadBalancerPublicFrontend;
import com.microsoft.azure.management.network.NicIpConfiguration;
import com.microsoft.azure.management.network.implementation.PublicIPAddressInner;
import com.microsoft.azure.management.resources.fluentcore.arm.models.GroupableResource;
import com.microsoft.azure.management.resources.fluentcore.arm.models.Resource;
import com.microsoft.azure.management.resources.fluentcore.model.Appliable;
import com.microsoft.azure.management.resources.fluentcore.model.Creatable;
import com.microsoft.azure.management.resources.fluentcore.model.Refreshable;
import com.microsoft.azure.management.resources.fluentcore.model.Updatable;
import com.microsoft.azure.management.resources.fluentcore.model.Wrapper;

@Fluent
public interface PublicIpAddress
extends GroupableResource,
Refreshable<PublicIpAddress>,
Wrapper<PublicIPAddressInner>,
Updatable<Update> {
    public IPVersion version();

    public String ipAddress();

    public String leafDomainLabel();

    public String fqdn();

    public String reverseFqdn();

    public IPAllocationMethod ipAllocationMethod();

    public int idleTimeoutInMinutes();

    public LoadBalancerPublicFrontend getAssignedLoadBalancerFrontend();

    public boolean hasAssignedLoadBalancer();

    public NicIpConfiguration getAssignedNetworkInterfaceIpConfiguration();

    public boolean hasAssignedNetworkInterface();

    public static interface UpdateStages {

        public static interface WithIdleTimout {
            public Update withIdleTimeoutInMinutes(int var1);
        }

        public static interface WithReverseFQDN {
            public Update withReverseFqdn(String var1);

            public Update withoutReverseFqdn();
        }

        public static interface WithLeafDomainLabel {
            public Update withLeafDomainLabel(String var1);

            public Update withoutLeafDomainLabel();
        }

        public static interface WithIpAddress {
            public Update withStaticIp();

            public Update withDynamicIp();
        }
    }

    public static interface Update
    extends Appliable<PublicIpAddress>,
    UpdateStages.WithIpAddress,
    UpdateStages.WithLeafDomainLabel,
    UpdateStages.WithReverseFQDN,
    UpdateStages.WithIdleTimout,
    Resource.UpdateWithTags<Update> {
    }

    public static interface DefinitionStages {

        public static interface WithCreate
        extends Creatable<PublicIpAddress>,
        WithLeafDomainLabel,
        WithIpAddress,
        WithReverseFQDN,
        WithIdleTimeout,
        Resource.DefinitionWithTags<WithCreate> {
        }

        public static interface WithIdleTimeout {
            public WithCreate withIdleTimeoutInMinutes(int var1);
        }

        public static interface WithReverseFQDN {
            public WithCreate withReverseFqdn(String var1);

            public WithCreate withoutReverseFqdn();
        }

        public static interface WithLeafDomainLabel {
            public WithCreate withLeafDomainLabel(String var1);

            public WithCreate withoutLeafDomainLabel();
        }

        public static interface WithIpAddress {
            public WithCreate withStaticIp();

            public WithCreate withDynamicIp();
        }

        public static interface WithGroup
        extends GroupableResource.DefinitionStages.WithGroup<WithCreate> {
        }

        public static interface Blank
        extends Resource.DefinitionWithRegion<WithGroup> {
        }
    }

    public static interface Definition
    extends DefinitionStages.Blank,
    DefinitionStages.WithGroup,
    DefinitionStages.WithCreate {
    }
}

