/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.network.implementation;

import com.microsoft.azure.Resource;
import com.microsoft.azure.SubResource;
import com.microsoft.azure.management.apigeneration.LangDefinition;
import com.microsoft.azure.management.network.ApplicationGateway;
import com.microsoft.azure.management.network.ApplicationGatewayBackend;
import com.microsoft.azure.management.network.ApplicationGatewayBackendHttpConfiguration;
import com.microsoft.azure.management.network.ApplicationGatewayFrontend;
import com.microsoft.azure.management.network.ApplicationGatewayIpConfiguration;
import com.microsoft.azure.management.network.ApplicationGatewayListener;
import com.microsoft.azure.management.network.ApplicationGatewayOperationalState;
import com.microsoft.azure.management.network.ApplicationGatewayRequestRoutingRule;
import com.microsoft.azure.management.network.ApplicationGatewaySku;
import com.microsoft.azure.management.network.ApplicationGatewaySkuName;
import com.microsoft.azure.management.network.ApplicationGatewaySslCertificate;
import com.microsoft.azure.management.network.ApplicationGatewaySslPolicy;
import com.microsoft.azure.management.network.ApplicationGatewayTier;
import com.microsoft.azure.management.network.IPAllocationMethod;
import com.microsoft.azure.management.network.Network;
import com.microsoft.azure.management.network.PublicIpAddress;
import com.microsoft.azure.management.network.Subnet;
import com.microsoft.azure.management.network.implementation.ApplicationGatewayBackendAddressPoolInner;
import com.microsoft.azure.management.network.implementation.ApplicationGatewayBackendHttpConfigurationImpl;
import com.microsoft.azure.management.network.implementation.ApplicationGatewayBackendHttpSettingsInner;
import com.microsoft.azure.management.network.implementation.ApplicationGatewayBackendImpl;
import com.microsoft.azure.management.network.implementation.ApplicationGatewayFrontendIPConfigurationInner;
import com.microsoft.azure.management.network.implementation.ApplicationGatewayFrontendImpl;
import com.microsoft.azure.management.network.implementation.ApplicationGatewayFrontendPortInner;
import com.microsoft.azure.management.network.implementation.ApplicationGatewayHttpListenerInner;
import com.microsoft.azure.management.network.implementation.ApplicationGatewayIPConfigurationInner;
import com.microsoft.azure.management.network.implementation.ApplicationGatewayInner;
import com.microsoft.azure.management.network.implementation.ApplicationGatewayIpConfigurationImpl;
import com.microsoft.azure.management.network.implementation.ApplicationGatewayListenerImpl;
import com.microsoft.azure.management.network.implementation.ApplicationGatewayRequestRoutingRuleImpl;
import com.microsoft.azure.management.network.implementation.ApplicationGatewayRequestRoutingRuleInner;
import com.microsoft.azure.management.network.implementation.ApplicationGatewaySslCertificateImpl;
import com.microsoft.azure.management.network.implementation.ApplicationGatewaySslCertificateInner;
import com.microsoft.azure.management.network.implementation.ApplicationGatewaysInner;
import com.microsoft.azure.management.network.implementation.NetworkManager;
import com.microsoft.azure.management.resources.fluentcore.arm.ResourceUtils;
import com.microsoft.azure.management.resources.fluentcore.arm.implementation.ManagerBase;
import com.microsoft.azure.management.resources.fluentcore.arm.models.implementation.GroupableParentResourceImpl;
import com.microsoft.azure.management.resources.fluentcore.model.Creatable;
import com.microsoft.azure.management.resources.fluentcore.utils.ResourceNamer;
import com.microsoft.azure.management.resources.fluentcore.utils.Utils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import rx.Observable;
import rx.functions.Func1;

@LangDefinition
class ApplicationGatewayImpl
extends GroupableParentResourceImpl<ApplicationGateway, ApplicationGatewayInner, ApplicationGatewayImpl, NetworkManager>
implements ApplicationGateway,
ApplicationGateway.Definition,
ApplicationGateway.Update {
    private Map<String, ApplicationGatewayIpConfiguration> ipConfigs;
    private Map<String, ApplicationGatewayFrontend> frontends;
    private Map<String, ApplicationGatewayBackend> backends;
    private Map<String, ApplicationGatewayBackendHttpConfiguration> backendHttpConfigs;
    private Map<String, ApplicationGatewayListener> listeners;
    private Map<String, ApplicationGatewayRequestRoutingRule> rules;
    private Map<String, ApplicationGatewaySslCertificate> sslCerts;
    private static final String DEFAULT = "default";
    private final ApplicationGatewaysInner innerCollection;
    private ApplicationGatewayFrontendImpl defaultPrivateFrontend;
    private ApplicationGatewayFrontendImpl defaultPublicFrontend;
    private Map<String, String> creatablePipsByFrontend;
    private Creatable<Network> creatableNetwork = null;
    private Creatable<PublicIpAddress> creatablePip = null;

    ApplicationGatewayImpl(String name, ApplicationGatewayInner innerModel, ApplicationGatewaysInner innerCollection, NetworkManager networkManager) {
        super(name, (Resource)innerModel, (ManagerBase)networkManager);
        this.innerCollection = innerCollection;
    }

    public ApplicationGatewayImpl refresh() {
        ApplicationGatewayInner inner = this.innerCollection.get(this.resourceGroupName(), this.name());
        this.setInner((Object)inner);
        this.initializeChildrenFromInner();
        return this;
    }

    protected void initializeChildrenFromInner() {
        this.initializeConfigsFromInner();
        this.initializeFrontendsFromInner();
        this.initializeBackendsFromInner();
        this.initializeBackendHttpConfigsFromInner();
        this.initializeHttpListenersFromInner();
        this.initializeRequestRoutingRulesFromInner();
        this.initializeSslCertificatesFromInner();
        this.defaultPrivateFrontend = null;
        this.defaultPublicFrontend = null;
        this.creatablePipsByFrontend = new HashMap<String, String>();
    }

    private void initializeSslCertificatesFromInner() {
        this.sslCerts = new TreeMap<String, ApplicationGatewaySslCertificate>();
        List<ApplicationGatewaySslCertificateInner> inners = ((ApplicationGatewayInner)((Object)this.inner())).sslCertificates();
        if (inners != null) {
            for (ApplicationGatewaySslCertificateInner inner : inners) {
                ApplicationGatewaySslCertificateImpl cert = new ApplicationGatewaySslCertificateImpl(inner, this);
                this.sslCerts.put(inner.name(), cert);
            }
        }
    }

    private void initializeFrontendsFromInner() {
        this.frontends = new TreeMap<String, ApplicationGatewayFrontend>();
        List<ApplicationGatewayFrontendIPConfigurationInner> inners = ((ApplicationGatewayInner)((Object)this.inner())).frontendIPConfigurations();
        if (inners != null) {
            for (ApplicationGatewayFrontendIPConfigurationInner inner : inners) {
                ApplicationGatewayFrontendImpl frontend = new ApplicationGatewayFrontendImpl(inner, this);
                this.frontends.put(inner.name(), frontend);
            }
        }
    }

    private void initializeBackendsFromInner() {
        this.backends = new TreeMap<String, ApplicationGatewayBackend>();
        List<ApplicationGatewayBackendAddressPoolInner> inners = ((ApplicationGatewayInner)((Object)this.inner())).backendAddressPools();
        if (inners != null) {
            for (ApplicationGatewayBackendAddressPoolInner inner : inners) {
                ApplicationGatewayBackendImpl backend = new ApplicationGatewayBackendImpl(inner, this);
                this.backends.put(inner.name(), backend);
            }
        }
    }

    private void initializeBackendHttpConfigsFromInner() {
        this.backendHttpConfigs = new TreeMap<String, ApplicationGatewayBackendHttpConfiguration>();
        List<ApplicationGatewayBackendHttpSettingsInner> inners = ((ApplicationGatewayInner)((Object)this.inner())).backendHttpSettingsCollection();
        if (inners != null) {
            for (ApplicationGatewayBackendHttpSettingsInner inner : inners) {
                ApplicationGatewayBackendHttpConfigurationImpl httpConfig = new ApplicationGatewayBackendHttpConfigurationImpl(inner, this);
                this.backendHttpConfigs.put(inner.name(), httpConfig);
            }
        }
    }

    private void initializeHttpListenersFromInner() {
        this.listeners = new TreeMap<String, ApplicationGatewayListener>();
        List<ApplicationGatewayHttpListenerInner> inners = ((ApplicationGatewayInner)((Object)this.inner())).httpListeners();
        if (inners != null) {
            for (ApplicationGatewayHttpListenerInner inner : inners) {
                ApplicationGatewayListenerImpl httpListener = new ApplicationGatewayListenerImpl(inner, this);
                this.listeners.put(inner.name(), httpListener);
            }
        }
    }

    private void initializeRequestRoutingRulesFromInner() {
        this.rules = new TreeMap<String, ApplicationGatewayRequestRoutingRule>();
        List<ApplicationGatewayRequestRoutingRuleInner> inners = ((ApplicationGatewayInner)((Object)this.inner())).requestRoutingRules();
        if (inners != null) {
            for (ApplicationGatewayRequestRoutingRuleInner inner : inners) {
                ApplicationGatewayRequestRoutingRuleImpl rule = new ApplicationGatewayRequestRoutingRuleImpl(inner, this);
                this.rules.put(inner.name(), rule);
            }
        }
    }

    private void initializeConfigsFromInner() {
        this.ipConfigs = new TreeMap<String, ApplicationGatewayIpConfiguration>();
        List<ApplicationGatewayIPConfigurationInner> inners = ((ApplicationGatewayInner)((Object)this.inner())).gatewayIPConfigurations();
        if (inners != null) {
            for (ApplicationGatewayIPConfigurationInner inner : inners) {
                ApplicationGatewayIpConfigurationImpl config = new ApplicationGatewayIpConfigurationImpl(inner, this);
                this.ipConfigs.put(inner.name(), config);
            }
        }
    }

    protected void beforeCreating() {
        SubResource ref;
        for (Map.Entry<String, String> frontendPipPair : this.creatablePipsByFrontend.entrySet()) {
            com.microsoft.azure.management.resources.fluentcore.arm.models.Resource createdPip = this.createdResource(frontendPipPair.getValue());
            this.updateFrontend(frontendPipPair.getKey()).withExistingPublicIpAddress(createdPip.id());
        }
        this.creatablePipsByFrontend.clear();
        this.ensureDefaultIpConfig();
        ((ApplicationGatewayInner)((Object)this.inner())).withGatewayIPConfigurations(this.innersFromWrappers(this.ipConfigs.values()));
        ((ApplicationGatewayInner)((Object)this.inner())).withFrontendIPConfigurations(this.innersFromWrappers(this.frontends.values()));
        ((ApplicationGatewayInner)((Object)this.inner())).withBackendAddressPools(this.innersFromWrappers(this.backends.values()));
        ((ApplicationGatewayInner)((Object)this.inner())).withBackendHttpSettingsCollection(this.innersFromWrappers(this.backendHttpConfigs.values()));
        ((ApplicationGatewayInner)((Object)this.inner())).withHttpListeners(this.innersFromWrappers(this.listeners.values()));
        for (ApplicationGatewayListener listener : this.listeners.values()) {
            ref = ((ApplicationGatewayHttpListenerInner)((Object)listener.inner())).frontendIPConfiguration();
            if (ref != null && !this.frontends().containsKey(ResourceUtils.nameFromResourceId((String)ref.id()))) {
                ((ApplicationGatewayHttpListenerInner)((Object)listener.inner())).withFrontendIPConfiguration(null);
            }
            if ((ref = ((ApplicationGatewayHttpListenerInner)((Object)listener.inner())).frontendPort()) != null && !this.frontendPorts().containsKey(ResourceUtils.nameFromResourceId((String)ref.id()))) {
                ((ApplicationGatewayHttpListenerInner)((Object)listener.inner())).withFrontendPort(null);
            }
            if ((ref = ((ApplicationGatewayHttpListenerInner)((Object)listener.inner())).sslCertificate()) == null || this.sslCertificates().containsKey(ResourceUtils.nameFromResourceId((String)ref.id()))) continue;
            ((ApplicationGatewayHttpListenerInner)((Object)listener.inner())).withSslCertificate(null);
        }
        ((ApplicationGatewayInner)((Object)this.inner())).withRequestRoutingRules(this.innersFromWrappers(this.rules.values()));
        for (ApplicationGatewayRequestRoutingRule rule : this.rules.values()) {
            ref = ((ApplicationGatewayRequestRoutingRuleInner)((Object)rule.inner())).backendAddressPool();
            if (ref != null && !this.backends().containsKey(ResourceUtils.nameFromResourceId((String)ref.id()))) {
                ((ApplicationGatewayRequestRoutingRuleInner)((Object)rule.inner())).withBackendAddressPool(null);
            }
            if ((ref = ((ApplicationGatewayRequestRoutingRuleInner)((Object)rule.inner())).backendHttpSettings()) != null && !this.backendHttpConfigurations().containsKey(ResourceUtils.nameFromResourceId((String)ref.id()))) {
                ((ApplicationGatewayRequestRoutingRuleInner)((Object)rule.inner())).withBackendHttpSettings(null);
            }
            if ((ref = ((ApplicationGatewayRequestRoutingRuleInner)((Object)rule.inner())).httpListener()) == null || this.listeners().containsKey(ResourceUtils.nameFromResourceId((String)ref.id()))) continue;
            ((ApplicationGatewayRequestRoutingRuleInner)((Object)rule.inner())).withHttpListener(null);
        }
        ((ApplicationGatewayInner)((Object)this.inner())).withSslCertificates(this.innersFromWrappers(this.sslCerts.values()));
    }

    protected void afterCreating() {
    }

    private ApplicationGatewayIpConfigurationImpl ensureDefaultIpConfig() {
        ApplicationGatewayIpConfigurationImpl ipConfig = (ApplicationGatewayIpConfigurationImpl)this.defaultIpConfiguration();
        if (ipConfig == null) {
            String name = ResourceNamer.randomResourceName((String)"ipcfg", (int)11);
            ipConfig = this.defineIpConfiguration(name);
            ipConfig.attach();
        }
        return ipConfig;
    }

    protected ApplicationGatewayFrontendImpl ensureDefaultPrivateFrontend() {
        ApplicationGatewayFrontendImpl frontend = (ApplicationGatewayFrontendImpl)this.defaultPrivateFrontend();
        if (frontend != null) {
            return frontend;
        }
        String name = ResourceNamer.randomResourceName((String)"frontend", (int)14);
        frontend = this.defineFrontend(name);
        frontend.attach();
        this.defaultPrivateFrontend = frontend;
        return frontend;
    }

    protected ApplicationGatewayFrontendImpl ensureDefaultPublicFrontend() {
        ApplicationGatewayFrontendImpl frontend = (ApplicationGatewayFrontendImpl)this.defaultPublicFrontend();
        if (frontend != null) {
            return frontend;
        }
        String name = ResourceNamer.randomResourceName((String)"frontend", (int)14);
        frontend = this.defineFrontend(name);
        frontend.attach();
        this.defaultPublicFrontend = frontend;
        return frontend;
    }

    private Creatable<Network> ensureDefaultNetworkDefinition() {
        if (this.creatableNetwork == null) {
            String vnetName = ResourceNamer.randomResourceName((String)"vnet", (int)10);
            this.creatableNetwork = ((Network.DefinitionStages.WithCreate)((Network.DefinitionStages.WithGroup)((Network.DefinitionStages.Blank)this.manager().networks().define(vnetName)).withRegion(this.region())).withExistingResourceGroup(this.resourceGroupName())).withAddressSpace("10.0.0.0/24").withSubnet(DEFAULT, "10.0.0.0/25").withSubnet("apps", "10.0.0.128/25");
        }
        return this.creatableNetwork;
    }

    private Creatable<PublicIpAddress> ensureDefaultPipDefinition() {
        if (this.creatablePip == null) {
            String pipName = ResourceNamer.randomResourceName((String)"pip", (int)9);
            this.creatablePip = (Creatable)((PublicIpAddress.DefinitionStages.WithGroup)((PublicIpAddress.DefinitionStages.Blank)this.manager().publicIpAddresses().define(pipName)).withRegion(this.regionName())).withExistingResourceGroup(this.resourceGroupName());
        }
        return this.creatablePip;
    }

    private static ApplicationGatewayFrontendImpl useSubnetFromIpConfigForFrontend(ApplicationGatewayIpConfigurationImpl ipConfig, ApplicationGatewayFrontendImpl frontend) {
        if (frontend != null) {
            frontend.withExistingSubnet(ipConfig.networkId(), ipConfig.subnetName());
            if (frontend.privateIpAddress() == null) {
                frontend.withPrivateIpAddressDynamic();
            } else if (frontend.privateIpAllocationMethod() == null) {
                frontend.withPrivateIpAddressDynamic();
            }
        }
        return frontend;
    }

    protected Observable<ApplicationGatewayInner> createInner() {
        Observable networkObservable;
        final ApplicationGatewayFrontendImpl defaultPublicFrontend = (ApplicationGatewayFrontendImpl)this.defaultPublicFrontend();
        Observable pipObservable = defaultPublicFrontend != null && defaultPublicFrontend.publicIpAddressId() == null ? Utils.rootResource((Observable)this.ensureDefaultPipDefinition().createAsync()).map((Func1)new Func1<PublicIpAddress, com.microsoft.azure.management.resources.fluentcore.arm.models.Resource>(){

            public com.microsoft.azure.management.resources.fluentcore.arm.models.Resource call(PublicIpAddress publicIpAddress) {
                defaultPublicFrontend.withExistingPublicIpAddress(publicIpAddress);
                return publicIpAddress;
            }
        }) : Observable.empty();
        final ApplicationGatewayIpConfigurationImpl defaultIpConfig = this.ensureDefaultIpConfig();
        final ApplicationGatewayFrontendImpl defaultPrivateFrontend = (ApplicationGatewayFrontendImpl)this.defaultPrivateFrontend();
        if (defaultIpConfig.subnetName() != null) {
            if (defaultPrivateFrontend != null) {
                ApplicationGatewayImpl.useSubnetFromIpConfigForFrontend(defaultIpConfig, defaultPrivateFrontend);
            }
            networkObservable = Observable.empty();
        } else {
            networkObservable = Utils.rootResource((Observable)this.ensureDefaultNetworkDefinition().createAsync()).map((Func1)new Func1<Network, com.microsoft.azure.management.resources.fluentcore.arm.models.Resource>(){

                public com.microsoft.azure.management.resources.fluentcore.arm.models.Resource call(Network network) {
                    defaultIpConfig.withExistingSubnet(network, ApplicationGatewayImpl.DEFAULT);
                    if (defaultPrivateFrontend != null) {
                        ApplicationGatewayImpl.useSubnetFromIpConfigForFrontend(defaultIpConfig, defaultPrivateFrontend);
                    }
                    return network;
                }
            });
        }
        return Observable.merge((Observable)networkObservable, (Observable)pipObservable).defaultIfEmpty(null).last().flatMap((Func1)new Func1<com.microsoft.azure.management.resources.fluentcore.arm.models.Resource, Observable<ApplicationGatewayInner>>(){

            public Observable<ApplicationGatewayInner> call(com.microsoft.azure.management.resources.fluentcore.arm.models.Resource resource) {
                return ApplicationGatewayImpl.this.innerCollection.createOrUpdateAsync(ApplicationGatewayImpl.this.resourceGroupName(), ApplicationGatewayImpl.this.name(), (ApplicationGatewayInner)((Object)ApplicationGatewayImpl.this.inner()));
            }
        });
    }

    <T> Boolean needToCreate(T byName, T byPort, String name) {
        if (byName != null && byPort != null) {
            if (byName == byPort) {
                return false;
            }
            return null;
        }
        if (byPort != null) {
            if (name == null) {
                return false;
            }
            return null;
        }
        return true;
    }

    String futureResourceId() {
        return super.resourceIdBase() + "/providers/Microsoft.Network/applicationGateways/" + this.name();
    }

    @Override
    public ApplicationGatewayImpl withInstanceCount(int capacity) {
        if (((ApplicationGatewayInner)((Object)this.inner())).sku() == null) {
            this.withSize(ApplicationGatewaySkuName.STANDARD_SMALL);
        }
        ((ApplicationGatewayInner)((Object)this.inner())).sku().withCapacity(capacity);
        return this;
    }

    @Override
    public ApplicationGatewayImpl withPrivateIpAddressDynamic() {
        this.ensureDefaultPrivateFrontend().withPrivateIpAddressDynamic();
        return this;
    }

    @Override
    public ApplicationGatewayImpl withPrivateIpAddressStatic(String ipAddress) {
        this.ensureDefaultPrivateFrontend().withPrivateIpAddressStatic(ipAddress);
        return this;
    }

    ApplicationGatewayImpl withFrontend(ApplicationGatewayFrontendImpl frontend) {
        if (frontend != null) {
            this.frontends.put(frontend.name(), frontend);
        }
        return this;
    }

    ApplicationGatewayImpl withBackend(ApplicationGatewayBackendImpl backend) {
        if (backend != null) {
            this.backends.put(backend.name(), backend);
        }
        return this;
    }

    ApplicationGatewayImpl withSslCertificate(ApplicationGatewaySslCertificateImpl cert) {
        if (cert != null) {
            this.sslCerts.put(cert.name(), cert);
        }
        return this;
    }

    ApplicationGatewayImpl withHttpListener(ApplicationGatewayListenerImpl httpListener) {
        if (httpListener != null) {
            this.listeners.put(httpListener.name(), httpListener);
        }
        return this;
    }

    ApplicationGatewayImpl withRequestRoutingRule(ApplicationGatewayRequestRoutingRuleImpl rule) {
        if (rule != null) {
            this.rules.put(rule.name(), rule);
        }
        return this;
    }

    ApplicationGatewayImpl withBackendHttpConfiguration(ApplicationGatewayBackendHttpConfigurationImpl httpConfig) {
        if (httpConfig != null) {
            this.backendHttpConfigs.put(httpConfig.name(), httpConfig);
        }
        return this;
    }

    @Override
    public ApplicationGatewayImpl withSize(ApplicationGatewaySkuName skuName) {
        int count = this.sku() != null ? this.sku().capacity() : 1;
        ApplicationGatewaySku sku = new ApplicationGatewaySku().withName(skuName).withCapacity(count);
        ((ApplicationGatewayInner)((Object)this.inner())).withSku(sku);
        return this;
    }

    @Override
    public ApplicationGatewayImpl withExistingSubnet(Subnet subnet) {
        this.ensureDefaultIpConfig().withExistingSubnet(subnet);
        return this;
    }

    @Override
    public ApplicationGatewayImpl withExistingSubnet(Network network, String subnetName) {
        this.ensureDefaultIpConfig().withExistingSubnet(network, subnetName);
        return this;
    }

    public ApplicationGatewayImpl withExistingSubnet(String networkResourceId, String subnetName) {
        this.ensureDefaultIpConfig().withExistingSubnet(networkResourceId, subnetName);
        return this;
    }

    ApplicationGatewayImpl withConfig(ApplicationGatewayIpConfigurationImpl config) {
        if (config != null) {
            this.ipConfigs.put(config.name(), config);
        }
        return this;
    }

    public ApplicationGatewaySslCertificateImpl defineSslCertificate(String name) {
        ApplicationGatewaySslCertificate cert = this.sslCerts.get(name);
        if (cert == null) {
            ApplicationGatewaySslCertificateInner inner = new ApplicationGatewaySslCertificateInner().withName(name);
            return new ApplicationGatewaySslCertificateImpl(inner, this);
        }
        return (ApplicationGatewaySslCertificateImpl)cert;
    }

    private ApplicationGatewayIpConfigurationImpl defineIpConfiguration(String name) {
        ApplicationGatewayIpConfiguration config = this.ipConfigs.get(name);
        if (config == null) {
            ApplicationGatewayIPConfigurationInner inner = new ApplicationGatewayIPConfigurationInner().withName(name);
            return new ApplicationGatewayIpConfigurationImpl(inner, this);
        }
        return (ApplicationGatewayIpConfigurationImpl)config;
    }

    private ApplicationGatewayFrontendImpl defineFrontend(String name) {
        ApplicationGatewayFrontend frontend = this.frontends.get(name);
        if (frontend == null) {
            ApplicationGatewayFrontendIPConfigurationInner inner = new ApplicationGatewayFrontendIPConfigurationInner().withName(name);
            return new ApplicationGatewayFrontendImpl(inner, this);
        }
        return (ApplicationGatewayFrontendImpl)frontend;
    }

    public ApplicationGatewayBackendImpl defineBackend(String name) {
        ApplicationGatewayBackend backend = this.backends.get(name);
        if (backend == null) {
            ApplicationGatewayBackendAddressPoolInner inner = new ApplicationGatewayBackendAddressPoolInner().withName(name);
            return new ApplicationGatewayBackendImpl(inner, this);
        }
        return (ApplicationGatewayBackendImpl)backend;
    }

    public ApplicationGatewayListenerImpl defineListener(String name) {
        ApplicationGatewayListener httpListener = this.listeners.get(name);
        if (httpListener == null) {
            ApplicationGatewayHttpListenerInner inner = new ApplicationGatewayHttpListenerInner().withName(name);
            return new ApplicationGatewayListenerImpl(inner, this);
        }
        return (ApplicationGatewayListenerImpl)httpListener;
    }

    public ApplicationGatewayRequestRoutingRuleImpl defineRequestRoutingRule(String name) {
        ApplicationGatewayRequestRoutingRule rule = this.rules.get(name);
        if (rule == null) {
            ApplicationGatewayRequestRoutingRuleInner inner = new ApplicationGatewayRequestRoutingRuleInner().withName(name);
            return new ApplicationGatewayRequestRoutingRuleImpl(inner, this);
        }
        return (ApplicationGatewayRequestRoutingRuleImpl)rule;
    }

    public ApplicationGatewayBackendHttpConfigurationImpl defineBackendHttpConfiguration(String name) {
        ApplicationGatewayBackendHttpConfiguration httpConfig = this.backendHttpConfigs.get(name);
        if (httpConfig == null) {
            ApplicationGatewayBackendHttpSettingsInner inner = new ApplicationGatewayBackendHttpSettingsInner().withName(name).withPort(80);
            return new ApplicationGatewayBackendHttpConfigurationImpl(inner, this);
        }
        return (ApplicationGatewayBackendHttpConfigurationImpl)httpConfig;
    }

    @Override
    public ApplicationGatewayImpl withoutPrivateFrontend() {
        ArrayList<String> toDelete = new ArrayList<String>();
        for (ApplicationGatewayFrontend frontend : this.frontends.values()) {
            if (!frontend.isPrivate()) continue;
            toDelete.add(frontend.name());
        }
        for (String frontendName : toDelete) {
            this.frontends.remove(frontendName);
        }
        this.defaultPrivateFrontend = null;
        return this;
    }

    @Override
    public ApplicationGatewayImpl withoutPublicFrontend() {
        ArrayList<String> toDelete = new ArrayList<String>();
        for (ApplicationGatewayFrontend frontend : this.frontends.values()) {
            if (!frontend.isPublic()) continue;
            toDelete.add(frontend.name());
        }
        for (String frontendName : toDelete) {
            this.frontends.remove(frontendName);
        }
        this.defaultPublicFrontend = null;
        return this;
    }

    @Override
    public ApplicationGatewayImpl withFrontendPort(int portNumber) {
        return this.withFrontendPort(portNumber, null);
    }

    @Override
    public ApplicationGatewayImpl withFrontendPort(int portNumber, String name) {
        List<ApplicationGatewayFrontendPortInner> frontendPorts = ((ApplicationGatewayInner)((Object)this.inner())).frontendPorts();
        if (frontendPorts == null) {
            frontendPorts = new ArrayList<ApplicationGatewayFrontendPortInner>();
            ((ApplicationGatewayInner)((Object)this.inner())).withFrontendPorts(frontendPorts);
        }
        ApplicationGatewayFrontendPortInner frontendPortByName = null;
        ApplicationGatewayFrontendPortInner frontendPortByNumber = null;
        for (ApplicationGatewayFrontendPortInner inner : ((ApplicationGatewayInner)((Object)this.inner())).frontendPorts()) {
            if (name != null && name.equalsIgnoreCase(inner.name())) {
                frontendPortByName = inner;
            }
            if (inner.port() != portNumber) continue;
            frontendPortByNumber = inner;
        }
        Boolean needToCreate = this.needToCreate(frontendPortByName, frontendPortByNumber, name);
        if (Boolean.TRUE.equals(needToCreate)) {
            if (name == null) {
                name = ResourceNamer.randomResourceName((String)"port", (int)9);
            }
            frontendPortByName = new ApplicationGatewayFrontendPortInner().withName(name).withPort(portNumber);
            frontendPorts.add(frontendPortByName);
            return this;
        }
        if (Boolean.FALSE.equals(needToCreate)) {
            return this;
        }
        return null;
    }

    @Override
    public ApplicationGatewayImpl withPrivateFrontend() {
        this.ensureDefaultPrivateFrontend();
        return this;
    }

    @Override
    public ApplicationGatewayImpl withExistingPublicIpAddress(PublicIpAddress publicIpAddress) {
        this.ensureDefaultPublicFrontend().withExistingPublicIpAddress(publicIpAddress);
        return this;
    }

    @Override
    public ApplicationGatewayImpl withExistingPublicIpAddress(String resourceId) {
        this.ensureDefaultPublicFrontend().withExistingPublicIpAddress(resourceId);
        return this;
    }

    @Override
    public ApplicationGatewayImpl withNewPublicIpAddress(Creatable<PublicIpAddress> creatable) {
        String name = this.ensureDefaultPublicFrontend().name();
        this.creatablePipsByFrontend.put(name, creatable.key());
        this.addCreatableDependency(creatable);
        return this;
    }

    @Override
    public ApplicationGatewayImpl withNewPublicIpAddress() {
        this.ensureDefaultPublicFrontend();
        return this;
    }

    @Override
    public ApplicationGatewayImpl withoutBackendFqdn(String fqdn) {
        for (ApplicationGatewayBackend backend : this.backends.values()) {
            ((ApplicationGatewayBackendImpl)backend).withoutFqdn(fqdn);
        }
        return this;
    }

    @Override
    public ApplicationGatewayImpl withoutBackendIpAddress(String ipAddress) {
        for (ApplicationGatewayBackend backend : this.backends.values()) {
            ApplicationGatewayBackendImpl backendImpl = (ApplicationGatewayBackendImpl)backend;
            backendImpl.withoutIpAddress(ipAddress);
        }
        return this;
    }

    @Override
    public ApplicationGatewayImpl withoutIpConfiguration(String ipConfigurationName) {
        this.ipConfigs.remove(ipConfigurationName);
        return this;
    }

    @Override
    public ApplicationGatewayImpl withoutFrontend(String frontendName) {
        this.frontends.remove(frontendName);
        return this;
    }

    @Override
    public ApplicationGatewayImpl withoutFrontendPort(String name) {
        if (((ApplicationGatewayInner)((Object)this.inner())).frontendPorts() == null) {
            return this;
        }
        for (int i = 0; i < ((ApplicationGatewayInner)((Object)this.inner())).frontendPorts().size(); ++i) {
            ApplicationGatewayFrontendPortInner inner = ((ApplicationGatewayInner)((Object)this.inner())).frontendPorts().get(i);
            if (!inner.name().equalsIgnoreCase(name)) continue;
            ((ApplicationGatewayInner)((Object)this.inner())).frontendPorts().remove(i);
            break;
        }
        return this;
    }

    @Override
    public ApplicationGatewayImpl withoutFrontendPort(int portNumber) {
        for (int i = 0; i < ((ApplicationGatewayInner)((Object)this.inner())).frontendPorts().size(); ++i) {
            ApplicationGatewayFrontendPortInner inner = ((ApplicationGatewayInner)((Object)this.inner())).frontendPorts().get(i);
            if (!inner.port().equals(portNumber)) continue;
            ((ApplicationGatewayInner)((Object)this.inner())).frontendPorts().remove(i);
            break;
        }
        return this;
    }

    @Override
    public ApplicationGatewayImpl withoutCertificate(String name) {
        this.sslCerts.remove(name);
        return this;
    }

    @Override
    public ApplicationGatewayImpl withoutListener(String name) {
        this.listeners.remove(name);
        return this;
    }

    @Override
    public ApplicationGatewayImpl withoutRequestRoutingRule(String name) {
        this.rules.remove(name);
        return this;
    }

    @Override
    public ApplicationGatewayImpl withoutBackend(String backendName) {
        this.backends.remove(backendName);
        return this;
    }

    @Override
    public ApplicationGatewayBackendImpl updateBackend(String name) {
        return (ApplicationGatewayBackendImpl)this.backends.get(name);
    }

    @Override
    public ApplicationGatewayFrontendImpl updatePublicFrontend() {
        return (ApplicationGatewayFrontendImpl)this.defaultPublicFrontend();
    }

    @Override
    public ApplicationGatewayListenerImpl updateListener(String name) {
        return (ApplicationGatewayListenerImpl)this.listeners.get(name);
    }

    @Override
    public ApplicationGatewayRequestRoutingRuleImpl updateRequestRoutingRule(String name) {
        return (ApplicationGatewayRequestRoutingRuleImpl)this.rules.get(name);
    }

    @Override
    public ApplicationGatewayImpl withoutBackendHttpConfiguration(String name) {
        this.backendHttpConfigs.remove(name);
        return this;
    }

    @Override
    public ApplicationGatewayBackendHttpConfigurationImpl updateBackendHttpConfiguration(String name) {
        return (ApplicationGatewayBackendHttpConfigurationImpl)this.backendHttpConfigs.get(name);
    }

    @Override
    public ApplicationGatewayIpConfigurationImpl updateIpConfiguration(String ipConfigurationName) {
        return (ApplicationGatewayIpConfigurationImpl)this.ipConfigs.get(ipConfigurationName);
    }

    @Override
    public ApplicationGatewayIpConfigurationImpl updateDefaultIpConfiguration() {
        return (ApplicationGatewayIpConfigurationImpl)this.defaultIpConfiguration();
    }

    public ApplicationGatewayIpConfigurationImpl defineDefaultIpConfiguration() {
        return this.ensureDefaultIpConfig();
    }

    public ApplicationGatewayFrontendImpl definePublicFrontend() {
        return this.ensureDefaultPublicFrontend();
    }

    public ApplicationGatewayFrontendImpl definePrivateFrontend() {
        return this.ensureDefaultPrivateFrontend();
    }

    @Override
    public ApplicationGatewayFrontendImpl updateFrontend(String frontendName) {
        return (ApplicationGatewayFrontendImpl)this.frontends.get(frontendName);
    }

    @Override
    public ApplicationGatewayFrontend defaultPrivateFrontend() {
        Map<String, ApplicationGatewayFrontend> privateFrontends = this.privateFrontends();
        if (privateFrontends.size() == 1) {
            this.defaultPrivateFrontend = (ApplicationGatewayFrontendImpl)privateFrontends.values().iterator().next();
        } else if (this.frontends().size() == 0) {
            this.defaultPrivateFrontend = null;
        }
        return this.defaultPrivateFrontend;
    }

    @Override
    public ApplicationGatewayFrontend defaultPublicFrontend() {
        Map<String, ApplicationGatewayFrontend> publicFrontends = this.publicFrontends();
        if (publicFrontends.size() == 1) {
            this.defaultPublicFrontend = (ApplicationGatewayFrontendImpl)publicFrontends.values().iterator().next();
        } else if (this.frontends().size() == 0) {
            this.defaultPublicFrontend = null;
        }
        return this.defaultPublicFrontend;
    }

    @Override
    public ApplicationGatewayIpConfiguration defaultIpConfiguration() {
        if (this.ipConfigs.size() == 1) {
            return this.ipConfigs.values().iterator().next();
        }
        return null;
    }

    @Override
    public ApplicationGatewayListener listenerByPortNumber(int portNumber) {
        ApplicationGatewayListener listener = null;
        for (ApplicationGatewayListener l : this.listeners.values()) {
            if (l.frontendPortNumber() != portNumber) continue;
            listener = l;
            break;
        }
        return listener;
    }

    @Override
    public Map<String, ApplicationGatewayBackendHttpConfiguration> backendHttpConfigurations() {
        return Collections.unmodifiableMap(this.backendHttpConfigs);
    }

    @Override
    public Map<String, ApplicationGatewayBackend> backends() {
        return Collections.unmodifiableMap(this.backends);
    }

    @Override
    public Map<String, ApplicationGatewayRequestRoutingRule> requestRoutingRules() {
        return Collections.unmodifiableMap(this.rules);
    }

    @Override
    public Map<String, ApplicationGatewayFrontend> frontends() {
        return Collections.unmodifiableMap(this.frontends);
    }

    @Override
    public Map<String, ApplicationGatewaySslCertificate> sslCertificates() {
        return Collections.unmodifiableMap(this.sslCerts);
    }

    @Override
    public Map<String, ApplicationGatewayListener> listeners() {
        return Collections.unmodifiableMap(this.listeners);
    }

    @Override
    public Map<String, ApplicationGatewayIpConfiguration> ipConfigurations() {
        return Collections.unmodifiableMap(this.ipConfigs);
    }

    @Override
    public ApplicationGatewaySku sku() {
        return ((ApplicationGatewayInner)((Object)this.inner())).sku();
    }

    @Override
    public ApplicationGatewayOperationalState operationalState() {
        return ((ApplicationGatewayInner)((Object)this.inner())).operationalState();
    }

    @Override
    public ApplicationGatewaySslPolicy sslPolicy() {
        return ((ApplicationGatewayInner)((Object)this.inner())).sslPolicy();
    }

    @Override
    public Map<String, Integer> frontendPorts() {
        TreeMap<String, Integer> ports = new TreeMap<String, Integer>();
        if (((ApplicationGatewayInner)((Object)this.inner())).frontendPorts() != null) {
            for (ApplicationGatewayFrontendPortInner portInner : ((ApplicationGatewayInner)((Object)this.inner())).frontendPorts()) {
                ports.put(portInner.name(), portInner.port());
            }
        }
        return Collections.unmodifiableMap(ports);
    }

    @Override
    public String frontendPortNameFromNumber(int portNumber) {
        String portName = null;
        for (Map.Entry<String, Integer> portEntry : this.frontendPorts().entrySet()) {
            if (portNumber != portEntry.getValue()) continue;
            portName = portEntry.getKey();
            break;
        }
        return portName;
    }

    private SubResource defaultSubnetRef() {
        ApplicationGatewayIpConfiguration ipConfig = this.defaultIpConfiguration();
        if (ipConfig == null) {
            return null;
        }
        return ((ApplicationGatewayIPConfigurationInner)((Object)ipConfig.inner())).subnet();
    }

    public String networkId() {
        SubResource subnetRef = this.defaultSubnetRef();
        if (subnetRef == null) {
            return null;
        }
        return ResourceUtils.parentResourceIdFromResourceId((String)subnetRef.id());
    }

    public String subnetName() {
        SubResource subnetRef = this.defaultSubnetRef();
        if (subnetRef == null) {
            return null;
        }
        return ResourceUtils.nameFromResourceId((String)subnetRef.id());
    }

    public NetworkManager manager() {
        return (NetworkManager)this.myManager;
    }

    @Override
    public String privateIpAddress() {
        ApplicationGatewayFrontend frontend = this.defaultPrivateFrontend();
        if (frontend == null) {
            return null;
        }
        return frontend.privateIpAddress();
    }

    @Override
    public IPAllocationMethod privateIpAllocationMethod() {
        ApplicationGatewayFrontend frontend = this.defaultPrivateFrontend();
        if (frontend == null) {
            return null;
        }
        return frontend.privateIpAllocationMethod();
    }

    @Override
    public boolean isPrivate() {
        for (ApplicationGatewayFrontend frontend : this.frontends.values()) {
            if (!frontend.isPrivate()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isPublic() {
        for (ApplicationGatewayFrontend frontend : this.frontends.values()) {
            if (!frontend.isPublic()) continue;
            return true;
        }
        return false;
    }

    @Override
    public Map<String, ApplicationGatewayFrontend> publicFrontends() {
        TreeMap<String, ApplicationGatewayFrontend> publicFrontends = new TreeMap<String, ApplicationGatewayFrontend>();
        for (ApplicationGatewayFrontend frontend : this.frontends().values()) {
            if (!frontend.isPublic()) continue;
            publicFrontends.put(frontend.name(), frontend);
        }
        return Collections.unmodifiableMap(publicFrontends);
    }

    @Override
    public Map<String, ApplicationGatewayFrontend> privateFrontends() {
        TreeMap<String, ApplicationGatewayFrontend> privateFrontends = new TreeMap<String, ApplicationGatewayFrontend>();
        for (ApplicationGatewayFrontend frontend : this.frontends.values()) {
            if (!frontend.isPrivate()) continue;
            privateFrontends.put(frontend.name(), frontend);
        }
        return Collections.unmodifiableMap(privateFrontends);
    }

    @Override
    public int instanceCount() {
        if (this.sku() != null && this.sku().capacity() != null) {
            return this.sku().capacity();
        }
        return 1;
    }

    @Override
    public ApplicationGatewaySkuName size() {
        if (this.sku() != null && this.sku().name() != null) {
            return this.sku().name();
        }
        return ApplicationGatewaySkuName.STANDARD_SMALL;
    }

    @Override
    public ApplicationGatewayTier tier() {
        if (this.sku() != null && this.sku().tier() != null) {
            return this.sku().tier();
        }
        return ApplicationGatewayTier.STANDARD;
    }

    @Override
    public ApplicationGateway.Update withoutPublicIpAddress() {
        return this.withoutPublicFrontend();
    }
}

