/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.network.implementation;

import com.microsoft.azure.SubResource;
import com.microsoft.azure.management.apigeneration.LangDefinition;
import com.microsoft.azure.management.network.ApplicationGateway;
import com.microsoft.azure.management.network.ApplicationGatewayFrontend;
import com.microsoft.azure.management.network.ApplicationGatewayListener;
import com.microsoft.azure.management.network.ApplicationGatewayProtocol;
import com.microsoft.azure.management.network.ApplicationGatewaySslCertificate;
import com.microsoft.azure.management.network.PublicIpAddress;
import com.microsoft.azure.management.network.implementation.ApplicationGatewayHttpListenerInner;
import com.microsoft.azure.management.network.implementation.ApplicationGatewayImpl;
import com.microsoft.azure.management.network.implementation.ApplicationGatewaySslCertificateImpl;
import com.microsoft.azure.management.resources.fluentcore.arm.ResourceUtils;
import com.microsoft.azure.management.resources.fluentcore.arm.models.implementation.ChildResourceImpl;
import com.microsoft.azure.management.resources.fluentcore.utils.ResourceNamer;
import java.io.File;
import java.io.IOException;

@LangDefinition
class ApplicationGatewayListenerImpl
extends ChildResourceImpl<ApplicationGatewayHttpListenerInner, ApplicationGatewayImpl, ApplicationGateway>
implements ApplicationGatewayListener,
ApplicationGatewayListener.Definition<ApplicationGateway.DefinitionStages.WithCreate>,
ApplicationGatewayListener.UpdateDefinition<ApplicationGateway.Update>,
ApplicationGatewayListener.Update {
    ApplicationGatewayListenerImpl(ApplicationGatewayHttpListenerInner inner, ApplicationGatewayImpl parent) {
        super((Object)inner, (Object)parent);
    }

    public String networkId() {
        ApplicationGatewayFrontend frontend = this.frontend();
        if (frontend != null) {
            return frontend.networkId();
        }
        return null;
    }

    public String subnetName() {
        ApplicationGatewayFrontend frontend = this.frontend();
        if (frontend != null) {
            return frontend.subnetName();
        }
        return null;
    }

    @Override
    public boolean requiresServerNameIndication() {
        if (((ApplicationGatewayHttpListenerInner)((Object)this.inner())).requireServerNameIndication() != null) {
            return ((ApplicationGatewayHttpListenerInner)((Object)this.inner())).requireServerNameIndication();
        }
        return false;
    }

    @Override
    public String hostName() {
        return ((ApplicationGatewayHttpListenerInner)((Object)this.inner())).hostName();
    }

    @Override
    public String publicIpAddressId() {
        ApplicationGatewayFrontend frontend = this.frontend();
        if (frontend == null) {
            return null;
        }
        return frontend.publicIpAddressId();
    }

    @Override
    public PublicIpAddress getPublicIpAddress() {
        String pipId = this.publicIpAddressId();
        if (pipId == null) {
            return null;
        }
        return (PublicIpAddress)((ApplicationGatewayImpl)this.parent()).manager().publicIpAddresses().getById(pipId);
    }

    public String name() {
        return ((ApplicationGatewayHttpListenerInner)((Object)this.inner())).name();
    }

    @Override
    public ApplicationGatewaySslCertificate sslCertificate() {
        SubResource certRef = ((ApplicationGatewayHttpListenerInner)((Object)this.inner())).sslCertificate();
        if (certRef == null) {
            return null;
        }
        String name = ResourceUtils.nameFromResourceId((String)certRef.id());
        return ((ApplicationGatewayImpl)this.parent()).sslCertificates().get(name);
    }

    @Override
    public ApplicationGatewayProtocol protocol() {
        return ((ApplicationGatewayHttpListenerInner)((Object)this.inner())).protocol();
    }

    @Override
    public int frontendPortNumber() {
        String name = this.frontendPortName();
        if (name == null) {
            return 0;
        }
        if (!((ApplicationGatewayImpl)this.parent()).frontendPorts().containsKey(name)) {
            return 0;
        }
        return ((ApplicationGatewayImpl)this.parent()).frontendPorts().get(name);
    }

    @Override
    public String frontendPortName() {
        if (((ApplicationGatewayHttpListenerInner)((Object)this.inner())).frontendPort() != null) {
            return ResourceUtils.nameFromResourceId((String)((ApplicationGatewayHttpListenerInner)((Object)this.inner())).frontendPort().id());
        }
        return null;
    }

    @Override
    public ApplicationGatewayFrontend frontend() {
        SubResource frontendInner = ((ApplicationGatewayHttpListenerInner)((Object)this.inner())).frontendIPConfiguration();
        if (frontendInner == null) {
            return null;
        }
        String frontendName = ResourceUtils.nameFromResourceId((String)frontendInner.id());
        return ((ApplicationGatewayImpl)this.parent()).frontends().get(frontendName);
    }

    public ApplicationGatewayImpl attach() {
        ((ApplicationGatewayImpl)this.parent()).withHttpListener(this);
        return (ApplicationGatewayImpl)this.parent();
    }

    private ApplicationGatewayListenerImpl withFrontend(String name) {
        SubResource frontendRef = new SubResource().withId(((ApplicationGatewayImpl)this.parent()).futureResourceId() + "/frontendIPConfigurations/" + name);
        ((ApplicationGatewayHttpListenerInner)((Object)this.inner())).withFrontendIPConfiguration(frontendRef);
        return this;
    }

    @Override
    public ApplicationGatewayListenerImpl withFrontendPort(String name) {
        SubResource portRef = new SubResource().withId(((ApplicationGatewayImpl)this.parent()).futureResourceId() + "/frontendPorts/" + name);
        ((ApplicationGatewayHttpListenerInner)((Object)this.inner())).withFrontendPort(portRef);
        return this;
    }

    @Override
    public ApplicationGatewayListenerImpl withFrontendPort(int portNumber) {
        String portName = ((ApplicationGatewayImpl)this.parent()).frontendPortNameFromNumber(portNumber);
        if (portName == null) {
            portName = ResourceNamer.randomResourceName((String)"port", (int)9);
            ((ApplicationGatewayImpl)this.parent()).withFrontendPort(portNumber, portName);
        }
        return this.withFrontendPort(portName);
    }

    @Override
    public ApplicationGatewayListenerImpl withSslCertificate(String name) {
        SubResource certRef = new SubResource().withId(((ApplicationGatewayImpl)this.parent()).futureResourceId() + "/sslCertificates/" + name);
        ((ApplicationGatewayHttpListenerInner)((Object)this.inner())).withSslCertificate(certRef);
        return this;
    }

    public ApplicationGatewayListenerImpl withSslCertificateFromPfxFile(File pfxFile) throws IOException {
        return this.withSslCertificateFromPfxFile(pfxFile, null);
    }

    private ApplicationGatewayListenerImpl withSslCertificateFromPfxFile(File pfxFile, String name) throws IOException {
        if (name == null) {
            name = ResourceNamer.randomResourceName((String)"cert", (int)10);
        }
        ((ApplicationGatewayImpl)this.parent()).defineSslCertificate(name).withPfxFromFile(pfxFile).attach();
        return this.withSslCertificate(name);
    }

    @Override
    public ApplicationGatewayListenerImpl withSslCertificatePassword(String password) {
        ApplicationGatewaySslCertificateImpl sslCert = (ApplicationGatewaySslCertificateImpl)this.sslCertificate();
        if (sslCert != null) {
            sslCert.withPfxPassword(password);
        }
        return this;
    }

    @Override
    public ApplicationGatewayListenerImpl withHttp() {
        ((ApplicationGatewayHttpListenerInner)((Object)this.inner())).withProtocol(ApplicationGatewayProtocol.HTTP);
        return this;
    }

    @Override
    public ApplicationGatewayListenerImpl withHttps() {
        ((ApplicationGatewayHttpListenerInner)((Object)this.inner())).withProtocol(ApplicationGatewayProtocol.HTTPS);
        return this;
    }

    @Override
    public ApplicationGatewayListenerImpl withHostName(String hostname) {
        ((ApplicationGatewayHttpListenerInner)((Object)this.inner())).withHostName(hostname);
        return this;
    }

    @Override
    public ApplicationGatewayListenerImpl withServerNameIndication() {
        ((ApplicationGatewayHttpListenerInner)((Object)this.inner())).withRequireServerNameIndication(true);
        return this;
    }

    @Override
    public ApplicationGatewayListenerImpl withoutServerNameIndication() {
        ((ApplicationGatewayHttpListenerInner)((Object)this.inner())).withRequireServerNameIndication(false);
        return this;
    }

    @Override
    public ApplicationGatewayListenerImpl withPrivateFrontend() {
        this.withFrontend(((ApplicationGatewayImpl)this.parent()).ensureDefaultPrivateFrontend().name());
        return this;
    }

    @Override
    public ApplicationGatewayListenerImpl withPublicFrontend() {
        this.withFrontend(((ApplicationGatewayImpl)this.parent()).ensureDefaultPublicFrontend().name());
        return this;
    }
}

