/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.network.implementation;

import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.apigeneration.LangDefinition;
import com.microsoft.azure.management.network.ApplicationGateway;
import com.microsoft.azure.management.network.ApplicationGatewaySkuName;
import com.microsoft.azure.management.network.ApplicationGateways;
import com.microsoft.azure.management.network.implementation.ApplicationGatewayImpl;
import com.microsoft.azure.management.network.implementation.ApplicationGatewayInner;
import com.microsoft.azure.management.network.implementation.ApplicationGatewaysInner;
import com.microsoft.azure.management.network.implementation.NetworkManagementClientImpl;
import com.microsoft.azure.management.network.implementation.NetworkManager;
import com.microsoft.azure.management.resources.fluentcore.arm.collection.implementation.GroupableResourcesImpl;
import com.microsoft.azure.management.resources.fluentcore.arm.implementation.ManagerBase;
import rx.Observable;

@LangDefinition
class ApplicationGatewaysImpl
extends GroupableResourcesImpl<ApplicationGateway, ApplicationGatewayImpl, ApplicationGatewayInner, ApplicationGatewaysInner, NetworkManager>
implements ApplicationGateways {
    ApplicationGatewaysImpl(NetworkManagementClientImpl networkClient, NetworkManager networkManager) {
        super((Object)networkClient.applicationGateways(), (ManagerBase)networkManager);
    }

    public PagedList<ApplicationGateway> list() {
        return this.wrapList(((ApplicationGatewaysInner)this.innerCollection).listAll());
    }

    public PagedList<ApplicationGateway> listByGroup(String groupName) {
        return this.wrapList(((ApplicationGatewaysInner)this.innerCollection).list(groupName));
    }

    public ApplicationGatewayImpl getByGroup(String groupName, String name) {
        return this.wrapModel(((ApplicationGatewaysInner)this.innerCollection).get(groupName, name));
    }

    public Observable<Void> deleteByGroupAsync(String groupName, String name) {
        return ((ApplicationGatewaysInner)this.innerCollection).deleteAsync(groupName, name);
    }

    public ApplicationGatewayImpl define(String name) {
        return this.wrapModel(name).withSize(ApplicationGatewaySkuName.STANDARD_SMALL).withInstanceCount(1);
    }

    protected ApplicationGatewayImpl wrapModel(String name) {
        ApplicationGatewayInner inner = new ApplicationGatewayInner();
        return new ApplicationGatewayImpl(name, inner, (ApplicationGatewaysInner)this.innerCollection, (NetworkManager)this.myManager);
    }

    protected ApplicationGatewayImpl wrapModel(ApplicationGatewayInner inner) {
        return inner == null ? null : new ApplicationGatewayImpl(inner.name(), inner, (ApplicationGatewaysInner)this.innerCollection, (NetworkManager)this.myManager);
    }
}

