/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.network.implementation;

import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureServiceCall;
import com.microsoft.azure.AzureServiceResponseBuilder;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.network.implementation.ApplicationGatewayBackendHealthInner;
import com.microsoft.azure.management.network.implementation.ApplicationGatewayInner;
import com.microsoft.azure.management.network.implementation.NetworkManagementClientImpl;
import com.microsoft.azure.management.network.implementation.PageImpl;
import com.microsoft.rest.ServiceCall;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.Validator;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.HTTP;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.POST;
import retrofit2.http.PUT;
import retrofit2.http.Path;
import retrofit2.http.Query;
import rx.Observable;
import rx.functions.Func1;

public final class ApplicationGatewaysInner {
    private ApplicationGatewaysService service;
    private NetworkManagementClientImpl client;

    public ApplicationGatewaysInner(Retrofit retrofit, NetworkManagementClientImpl client) {
        this.service = (ApplicationGatewaysService)retrofit.create(ApplicationGatewaysService.class);
        this.client = client;
    }

    public void delete(String resourceGroupName, String applicationGatewayName) {
        ((ServiceResponse)this.deleteWithServiceResponseAsync(resourceGroupName, applicationGatewayName).toBlocking().last()).getBody();
    }

    public ServiceCall<Void> deleteAsync(String resourceGroupName, String applicationGatewayName, ServiceCallback<Void> serviceCallback) {
        return ServiceCall.create(this.deleteWithServiceResponseAsync(resourceGroupName, applicationGatewayName), serviceCallback);
    }

    public Observable<Void> deleteAsync(String resourceGroupName, String applicationGatewayName) {
        return this.deleteWithServiceResponseAsync(resourceGroupName, applicationGatewayName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.getBody();
            }
        });
    }

    public Observable<ServiceResponse<Void>> deleteWithServiceResponseAsync(String resourceGroupName, String applicationGatewayName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (applicationGatewayName == null) {
            throw new IllegalArgumentException("Parameter applicationGatewayName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2016-09-01";
        Observable<Response<ResponseBody>> observable = this.service.delete(resourceGroupName, applicationGatewayName, this.client.subscriptionId(), "2016-09-01", this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<Void>(){}.getType());
    }

    public void beginDelete(String resourceGroupName, String applicationGatewayName) {
        ((ServiceResponse)this.beginDeleteWithServiceResponseAsync(resourceGroupName, applicationGatewayName).toBlocking().single()).getBody();
    }

    public ServiceCall<Void> beginDeleteAsync(String resourceGroupName, String applicationGatewayName, ServiceCallback<Void> serviceCallback) {
        return ServiceCall.create(this.beginDeleteWithServiceResponseAsync(resourceGroupName, applicationGatewayName), serviceCallback);
    }

    public Observable<Void> beginDeleteAsync(String resourceGroupName, String applicationGatewayName) {
        return this.beginDeleteWithServiceResponseAsync(resourceGroupName, applicationGatewayName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.getBody();
            }
        });
    }

    public Observable<ServiceResponse<Void>> beginDeleteWithServiceResponseAsync(String resourceGroupName, String applicationGatewayName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (applicationGatewayName == null) {
            throw new IllegalArgumentException("Parameter applicationGatewayName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2016-09-01";
        return this.service.beginDelete(resourceGroupName, applicationGatewayName, this.client.subscriptionId(), "2016-09-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = ApplicationGatewaysInner.this.beginDeleteDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> beginDeleteDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return new AzureServiceResponseBuilder(this.client.mapperAdapter()).register(202, new TypeToken<Void>(){}.getType()).register(204, new TypeToken<Void>(){}.getType()).register(200, new TypeToken<Void>(){}.getType()).build(response);
    }

    public ApplicationGatewayInner get(String resourceGroupName, String applicationGatewayName) {
        return (ApplicationGatewayInner)((Object)((ServiceResponse)this.getWithServiceResponseAsync(resourceGroupName, applicationGatewayName).toBlocking().single()).getBody());
    }

    public ServiceCall<ApplicationGatewayInner> getAsync(String resourceGroupName, String applicationGatewayName, ServiceCallback<ApplicationGatewayInner> serviceCallback) {
        return ServiceCall.create(this.getWithServiceResponseAsync(resourceGroupName, applicationGatewayName), serviceCallback);
    }

    public Observable<ApplicationGatewayInner> getAsync(String resourceGroupName, String applicationGatewayName) {
        return this.getWithServiceResponseAsync(resourceGroupName, applicationGatewayName).map((Func1)new Func1<ServiceResponse<ApplicationGatewayInner>, ApplicationGatewayInner>(){

            public ApplicationGatewayInner call(ServiceResponse<ApplicationGatewayInner> response) {
                return (ApplicationGatewayInner)((Object)response.getBody());
            }
        });
    }

    public Observable<ServiceResponse<ApplicationGatewayInner>> getWithServiceResponseAsync(String resourceGroupName, String applicationGatewayName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (applicationGatewayName == null) {
            throw new IllegalArgumentException("Parameter applicationGatewayName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2016-09-01";
        return this.service.get(resourceGroupName, applicationGatewayName, this.client.subscriptionId(), "2016-09-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<ApplicationGatewayInner>>>(){

            public Observable<ServiceResponse<ApplicationGatewayInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = ApplicationGatewaysInner.this.getDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<ApplicationGatewayInner> getDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return new AzureServiceResponseBuilder(this.client.mapperAdapter()).register(200, new TypeToken<ApplicationGatewayInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public ApplicationGatewayInner createOrUpdate(String resourceGroupName, String applicationGatewayName, ApplicationGatewayInner parameters) {
        return (ApplicationGatewayInner)((Object)((ServiceResponse)this.createOrUpdateWithServiceResponseAsync(resourceGroupName, applicationGatewayName, parameters).toBlocking().last()).getBody());
    }

    public ServiceCall<ApplicationGatewayInner> createOrUpdateAsync(String resourceGroupName, String applicationGatewayName, ApplicationGatewayInner parameters, ServiceCallback<ApplicationGatewayInner> serviceCallback) {
        return ServiceCall.create(this.createOrUpdateWithServiceResponseAsync(resourceGroupName, applicationGatewayName, parameters), serviceCallback);
    }

    public Observable<ApplicationGatewayInner> createOrUpdateAsync(String resourceGroupName, String applicationGatewayName, ApplicationGatewayInner parameters) {
        return this.createOrUpdateWithServiceResponseAsync(resourceGroupName, applicationGatewayName, parameters).map((Func1)new Func1<ServiceResponse<ApplicationGatewayInner>, ApplicationGatewayInner>(){

            public ApplicationGatewayInner call(ServiceResponse<ApplicationGatewayInner> response) {
                return (ApplicationGatewayInner)((Object)response.getBody());
            }
        });
    }

    public Observable<ServiceResponse<ApplicationGatewayInner>> createOrUpdateWithServiceResponseAsync(String resourceGroupName, String applicationGatewayName, ApplicationGatewayInner parameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (applicationGatewayName == null) {
            throw new IllegalArgumentException("Parameter applicationGatewayName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        Validator.validate((Object)((Object)parameters));
        String apiVersion = "2016-09-01";
        Observable<Response<ResponseBody>> observable = this.service.createOrUpdate(resourceGroupName, applicationGatewayName, this.client.subscriptionId(), parameters, "2016-09-01", this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<ApplicationGatewayInner>(){}.getType());
    }

    public ApplicationGatewayInner beginCreateOrUpdate(String resourceGroupName, String applicationGatewayName, ApplicationGatewayInner parameters) {
        return (ApplicationGatewayInner)((Object)((ServiceResponse)this.beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, applicationGatewayName, parameters).toBlocking().single()).getBody());
    }

    public ServiceCall<ApplicationGatewayInner> beginCreateOrUpdateAsync(String resourceGroupName, String applicationGatewayName, ApplicationGatewayInner parameters, ServiceCallback<ApplicationGatewayInner> serviceCallback) {
        return ServiceCall.create(this.beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, applicationGatewayName, parameters), serviceCallback);
    }

    public Observable<ApplicationGatewayInner> beginCreateOrUpdateAsync(String resourceGroupName, String applicationGatewayName, ApplicationGatewayInner parameters) {
        return this.beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, applicationGatewayName, parameters).map((Func1)new Func1<ServiceResponse<ApplicationGatewayInner>, ApplicationGatewayInner>(){

            public ApplicationGatewayInner call(ServiceResponse<ApplicationGatewayInner> response) {
                return (ApplicationGatewayInner)((Object)response.getBody());
            }
        });
    }

    public Observable<ServiceResponse<ApplicationGatewayInner>> beginCreateOrUpdateWithServiceResponseAsync(String resourceGroupName, String applicationGatewayName, ApplicationGatewayInner parameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (applicationGatewayName == null) {
            throw new IllegalArgumentException("Parameter applicationGatewayName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        Validator.validate((Object)((Object)parameters));
        String apiVersion = "2016-09-01";
        return this.service.beginCreateOrUpdate(resourceGroupName, applicationGatewayName, this.client.subscriptionId(), parameters, "2016-09-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<ApplicationGatewayInner>>>(){

            public Observable<ServiceResponse<ApplicationGatewayInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = ApplicationGatewaysInner.this.beginCreateOrUpdateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<ApplicationGatewayInner> beginCreateOrUpdateDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return new AzureServiceResponseBuilder(this.client.mapperAdapter()).register(201, new TypeToken<ApplicationGatewayInner>(){}.getType()).register(200, new TypeToken<ApplicationGatewayInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<ApplicationGatewayInner> list(String resourceGroupName) {
        ServiceResponse response = (ServiceResponse)this.listSinglePageAsync(resourceGroupName).toBlocking().single();
        return new PagedList<ApplicationGatewayInner>((Page)response.getBody()){

            public Page<ApplicationGatewayInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)ApplicationGatewaysInner.this.listNextSinglePageAsync(nextPageLink).toBlocking().single()).getBody();
            }
        };
    }

    public ServiceCall<List<ApplicationGatewayInner>> listAsync(String resourceGroupName, ListOperationCallback<ApplicationGatewayInner> serviceCallback) {
        return AzureServiceCall.create(this.listSinglePageAsync(resourceGroupName), (Func1)new Func1<String, Observable<ServiceResponse<Page<ApplicationGatewayInner>>>>(){

            public Observable<ServiceResponse<Page<ApplicationGatewayInner>>> call(String nextPageLink) {
                return ApplicationGatewaysInner.this.listNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<ApplicationGatewayInner>> listAsync(String resourceGroupName) {
        return this.listWithServiceResponseAsync(resourceGroupName).map((Func1)new Func1<ServiceResponse<Page<ApplicationGatewayInner>>, Page<ApplicationGatewayInner>>(){

            public Page<ApplicationGatewayInner> call(ServiceResponse<Page<ApplicationGatewayInner>> response) {
                return (Page)response.getBody();
            }
        });
    }

    public Observable<ServiceResponse<Page<ApplicationGatewayInner>>> listWithServiceResponseAsync(String resourceGroupName) {
        return this.listSinglePageAsync(resourceGroupName).concatMap((Func1)new Func1<ServiceResponse<Page<ApplicationGatewayInner>>, Observable<ServiceResponse<Page<ApplicationGatewayInner>>>>(){

            public Observable<ServiceResponse<Page<ApplicationGatewayInner>>> call(ServiceResponse<Page<ApplicationGatewayInner>> page) {
                String nextPageLink = ((Page)page.getBody()).getNextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(ApplicationGatewaysInner.this.listNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<ApplicationGatewayInner>>> listSinglePageAsync(String resourceGroupName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2016-09-01";
        return this.service.list(resourceGroupName, this.client.subscriptionId(), "2016-09-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<ApplicationGatewayInner>>>>(){

            public Observable<ServiceResponse<Page<ApplicationGatewayInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = ApplicationGatewaysInner.this.listDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.getBody(), result.getResponse()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<ApplicationGatewayInner>> listDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return new AzureServiceResponseBuilder(this.client.mapperAdapter()).register(200, new TypeToken<PageImpl<ApplicationGatewayInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<ApplicationGatewayInner> listAll() {
        ServiceResponse response = (ServiceResponse)this.listAllSinglePageAsync().toBlocking().single();
        return new PagedList<ApplicationGatewayInner>((Page)response.getBody()){

            public Page<ApplicationGatewayInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)ApplicationGatewaysInner.this.listAllNextSinglePageAsync(nextPageLink).toBlocking().single()).getBody();
            }
        };
    }

    public ServiceCall<List<ApplicationGatewayInner>> listAllAsync(ListOperationCallback<ApplicationGatewayInner> serviceCallback) {
        return AzureServiceCall.create(this.listAllSinglePageAsync(), (Func1)new Func1<String, Observable<ServiceResponse<Page<ApplicationGatewayInner>>>>(){

            public Observable<ServiceResponse<Page<ApplicationGatewayInner>>> call(String nextPageLink) {
                return ApplicationGatewaysInner.this.listAllNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<ApplicationGatewayInner>> listAllAsync() {
        return this.listAllWithServiceResponseAsync().map((Func1)new Func1<ServiceResponse<Page<ApplicationGatewayInner>>, Page<ApplicationGatewayInner>>(){

            public Page<ApplicationGatewayInner> call(ServiceResponse<Page<ApplicationGatewayInner>> response) {
                return (Page)response.getBody();
            }
        });
    }

    public Observable<ServiceResponse<Page<ApplicationGatewayInner>>> listAllWithServiceResponseAsync() {
        return this.listAllSinglePageAsync().concatMap((Func1)new Func1<ServiceResponse<Page<ApplicationGatewayInner>>, Observable<ServiceResponse<Page<ApplicationGatewayInner>>>>(){

            public Observable<ServiceResponse<Page<ApplicationGatewayInner>>> call(ServiceResponse<Page<ApplicationGatewayInner>> page) {
                String nextPageLink = ((Page)page.getBody()).getNextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(ApplicationGatewaysInner.this.listAllNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<ApplicationGatewayInner>>> listAllSinglePageAsync() {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2016-09-01";
        return this.service.listAll(this.client.subscriptionId(), "2016-09-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<ApplicationGatewayInner>>>>(){

            public Observable<ServiceResponse<Page<ApplicationGatewayInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = ApplicationGatewaysInner.this.listAllDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.getBody(), result.getResponse()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<ApplicationGatewayInner>> listAllDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return new AzureServiceResponseBuilder(this.client.mapperAdapter()).register(200, new TypeToken<PageImpl<ApplicationGatewayInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public void start(String resourceGroupName, String applicationGatewayName) {
        ((ServiceResponse)this.startWithServiceResponseAsync(resourceGroupName, applicationGatewayName).toBlocking().last()).getBody();
    }

    public ServiceCall<Void> startAsync(String resourceGroupName, String applicationGatewayName, ServiceCallback<Void> serviceCallback) {
        return ServiceCall.create(this.startWithServiceResponseAsync(resourceGroupName, applicationGatewayName), serviceCallback);
    }

    public Observable<Void> startAsync(String resourceGroupName, String applicationGatewayName) {
        return this.startWithServiceResponseAsync(resourceGroupName, applicationGatewayName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.getBody();
            }
        });
    }

    public Observable<ServiceResponse<Void>> startWithServiceResponseAsync(String resourceGroupName, String applicationGatewayName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (applicationGatewayName == null) {
            throw new IllegalArgumentException("Parameter applicationGatewayName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2016-09-01";
        Observable<Response<ResponseBody>> observable = this.service.start(resourceGroupName, applicationGatewayName, this.client.subscriptionId(), "2016-09-01", this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<Void>(){}.getType());
    }

    public void beginStart(String resourceGroupName, String applicationGatewayName) {
        ((ServiceResponse)this.beginStartWithServiceResponseAsync(resourceGroupName, applicationGatewayName).toBlocking().single()).getBody();
    }

    public ServiceCall<Void> beginStartAsync(String resourceGroupName, String applicationGatewayName, ServiceCallback<Void> serviceCallback) {
        return ServiceCall.create(this.beginStartWithServiceResponseAsync(resourceGroupName, applicationGatewayName), serviceCallback);
    }

    public Observable<Void> beginStartAsync(String resourceGroupName, String applicationGatewayName) {
        return this.beginStartWithServiceResponseAsync(resourceGroupName, applicationGatewayName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.getBody();
            }
        });
    }

    public Observable<ServiceResponse<Void>> beginStartWithServiceResponseAsync(String resourceGroupName, String applicationGatewayName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (applicationGatewayName == null) {
            throw new IllegalArgumentException("Parameter applicationGatewayName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2016-09-01";
        return this.service.beginStart(resourceGroupName, applicationGatewayName, this.client.subscriptionId(), "2016-09-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = ApplicationGatewaysInner.this.beginStartDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> beginStartDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return new AzureServiceResponseBuilder(this.client.mapperAdapter()).register(200, new TypeToken<Void>(){}.getType()).register(202, new TypeToken<Void>(){}.getType()).build(response);
    }

    public void stop(String resourceGroupName, String applicationGatewayName) {
        ((ServiceResponse)this.stopWithServiceResponseAsync(resourceGroupName, applicationGatewayName).toBlocking().last()).getBody();
    }

    public ServiceCall<Void> stopAsync(String resourceGroupName, String applicationGatewayName, ServiceCallback<Void> serviceCallback) {
        return ServiceCall.create(this.stopWithServiceResponseAsync(resourceGroupName, applicationGatewayName), serviceCallback);
    }

    public Observable<Void> stopAsync(String resourceGroupName, String applicationGatewayName) {
        return this.stopWithServiceResponseAsync(resourceGroupName, applicationGatewayName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.getBody();
            }
        });
    }

    public Observable<ServiceResponse<Void>> stopWithServiceResponseAsync(String resourceGroupName, String applicationGatewayName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (applicationGatewayName == null) {
            throw new IllegalArgumentException("Parameter applicationGatewayName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2016-09-01";
        Observable<Response<ResponseBody>> observable = this.service.stop(resourceGroupName, applicationGatewayName, this.client.subscriptionId(), "2016-09-01", this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<Void>(){}.getType());
    }

    public void beginStop(String resourceGroupName, String applicationGatewayName) {
        ((ServiceResponse)this.beginStopWithServiceResponseAsync(resourceGroupName, applicationGatewayName).toBlocking().single()).getBody();
    }

    public ServiceCall<Void> beginStopAsync(String resourceGroupName, String applicationGatewayName, ServiceCallback<Void> serviceCallback) {
        return ServiceCall.create(this.beginStopWithServiceResponseAsync(resourceGroupName, applicationGatewayName), serviceCallback);
    }

    public Observable<Void> beginStopAsync(String resourceGroupName, String applicationGatewayName) {
        return this.beginStopWithServiceResponseAsync(resourceGroupName, applicationGatewayName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.getBody();
            }
        });
    }

    public Observable<ServiceResponse<Void>> beginStopWithServiceResponseAsync(String resourceGroupName, String applicationGatewayName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (applicationGatewayName == null) {
            throw new IllegalArgumentException("Parameter applicationGatewayName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2016-09-01";
        return this.service.beginStop(resourceGroupName, applicationGatewayName, this.client.subscriptionId(), "2016-09-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = ApplicationGatewaysInner.this.beginStopDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> beginStopDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return new AzureServiceResponseBuilder(this.client.mapperAdapter()).register(200, new TypeToken<Void>(){}.getType()).register(202, new TypeToken<Void>(){}.getType()).build(response);
    }

    public ApplicationGatewayBackendHealthInner backendHealth(String resourceGroupName, String applicationGatewayName) {
        return (ApplicationGatewayBackendHealthInner)((ServiceResponse)this.backendHealthWithServiceResponseAsync(resourceGroupName, applicationGatewayName).toBlocking().last()).getBody();
    }

    public ServiceCall<ApplicationGatewayBackendHealthInner> backendHealthAsync(String resourceGroupName, String applicationGatewayName, ServiceCallback<ApplicationGatewayBackendHealthInner> serviceCallback) {
        return ServiceCall.create(this.backendHealthWithServiceResponseAsync(resourceGroupName, applicationGatewayName), serviceCallback);
    }

    public Observable<ApplicationGatewayBackendHealthInner> backendHealthAsync(String resourceGroupName, String applicationGatewayName) {
        return this.backendHealthWithServiceResponseAsync(resourceGroupName, applicationGatewayName).map((Func1)new Func1<ServiceResponse<ApplicationGatewayBackendHealthInner>, ApplicationGatewayBackendHealthInner>(){

            public ApplicationGatewayBackendHealthInner call(ServiceResponse<ApplicationGatewayBackendHealthInner> response) {
                return (ApplicationGatewayBackendHealthInner)response.getBody();
            }
        });
    }

    public Observable<ServiceResponse<ApplicationGatewayBackendHealthInner>> backendHealthWithServiceResponseAsync(String resourceGroupName, String applicationGatewayName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (applicationGatewayName == null) {
            throw new IllegalArgumentException("Parameter applicationGatewayName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2016-09-01";
        String expand = null;
        Observable<Response<ResponseBody>> observable = this.service.backendHealth(resourceGroupName, applicationGatewayName, this.client.subscriptionId(), "2016-09-01", expand, this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<ApplicationGatewayBackendHealthInner>(){}.getType());
    }

    public ApplicationGatewayBackendHealthInner backendHealth(String resourceGroupName, String applicationGatewayName, String expand) {
        return (ApplicationGatewayBackendHealthInner)((ServiceResponse)this.backendHealthWithServiceResponseAsync(resourceGroupName, applicationGatewayName, expand).toBlocking().last()).getBody();
    }

    public ServiceCall<ApplicationGatewayBackendHealthInner> backendHealthAsync(String resourceGroupName, String applicationGatewayName, String expand, ServiceCallback<ApplicationGatewayBackendHealthInner> serviceCallback) {
        return ServiceCall.create(this.backendHealthWithServiceResponseAsync(resourceGroupName, applicationGatewayName, expand), serviceCallback);
    }

    public Observable<ApplicationGatewayBackendHealthInner> backendHealthAsync(String resourceGroupName, String applicationGatewayName, String expand) {
        return this.backendHealthWithServiceResponseAsync(resourceGroupName, applicationGatewayName, expand).map((Func1)new Func1<ServiceResponse<ApplicationGatewayBackendHealthInner>, ApplicationGatewayBackendHealthInner>(){

            public ApplicationGatewayBackendHealthInner call(ServiceResponse<ApplicationGatewayBackendHealthInner> response) {
                return (ApplicationGatewayBackendHealthInner)response.getBody();
            }
        });
    }

    public Observable<ServiceResponse<ApplicationGatewayBackendHealthInner>> backendHealthWithServiceResponseAsync(String resourceGroupName, String applicationGatewayName, String expand) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (applicationGatewayName == null) {
            throw new IllegalArgumentException("Parameter applicationGatewayName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2016-09-01";
        Observable<Response<ResponseBody>> observable = this.service.backendHealth(resourceGroupName, applicationGatewayName, this.client.subscriptionId(), "2016-09-01", expand, this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<ApplicationGatewayBackendHealthInner>(){}.getType());
    }

    public ApplicationGatewayBackendHealthInner beginBackendHealth(String resourceGroupName, String applicationGatewayName) {
        return (ApplicationGatewayBackendHealthInner)((ServiceResponse)this.beginBackendHealthWithServiceResponseAsync(resourceGroupName, applicationGatewayName).toBlocking().single()).getBody();
    }

    public ServiceCall<ApplicationGatewayBackendHealthInner> beginBackendHealthAsync(String resourceGroupName, String applicationGatewayName, ServiceCallback<ApplicationGatewayBackendHealthInner> serviceCallback) {
        return ServiceCall.create(this.beginBackendHealthWithServiceResponseAsync(resourceGroupName, applicationGatewayName), serviceCallback);
    }

    public Observable<ApplicationGatewayBackendHealthInner> beginBackendHealthAsync(String resourceGroupName, String applicationGatewayName) {
        return this.beginBackendHealthWithServiceResponseAsync(resourceGroupName, applicationGatewayName).map((Func1)new Func1<ServiceResponse<ApplicationGatewayBackendHealthInner>, ApplicationGatewayBackendHealthInner>(){

            public ApplicationGatewayBackendHealthInner call(ServiceResponse<ApplicationGatewayBackendHealthInner> response) {
                return (ApplicationGatewayBackendHealthInner)response.getBody();
            }
        });
    }

    public Observable<ServiceResponse<ApplicationGatewayBackendHealthInner>> beginBackendHealthWithServiceResponseAsync(String resourceGroupName, String applicationGatewayName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (applicationGatewayName == null) {
            throw new IllegalArgumentException("Parameter applicationGatewayName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2016-09-01";
        String expand = null;
        return this.service.beginBackendHealth(resourceGroupName, applicationGatewayName, this.client.subscriptionId(), "2016-09-01", expand, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<ApplicationGatewayBackendHealthInner>>>(){

            public Observable<ServiceResponse<ApplicationGatewayBackendHealthInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = ApplicationGatewaysInner.this.beginBackendHealthDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    public ApplicationGatewayBackendHealthInner beginBackendHealth(String resourceGroupName, String applicationGatewayName, String expand) {
        return (ApplicationGatewayBackendHealthInner)((ServiceResponse)this.beginBackendHealthWithServiceResponseAsync(resourceGroupName, applicationGatewayName, expand).toBlocking().single()).getBody();
    }

    public ServiceCall<ApplicationGatewayBackendHealthInner> beginBackendHealthAsync(String resourceGroupName, String applicationGatewayName, String expand, ServiceCallback<ApplicationGatewayBackendHealthInner> serviceCallback) {
        return ServiceCall.create(this.beginBackendHealthWithServiceResponseAsync(resourceGroupName, applicationGatewayName, expand), serviceCallback);
    }

    public Observable<ApplicationGatewayBackendHealthInner> beginBackendHealthAsync(String resourceGroupName, String applicationGatewayName, String expand) {
        return this.beginBackendHealthWithServiceResponseAsync(resourceGroupName, applicationGatewayName, expand).map((Func1)new Func1<ServiceResponse<ApplicationGatewayBackendHealthInner>, ApplicationGatewayBackendHealthInner>(){

            public ApplicationGatewayBackendHealthInner call(ServiceResponse<ApplicationGatewayBackendHealthInner> response) {
                return (ApplicationGatewayBackendHealthInner)response.getBody();
            }
        });
    }

    public Observable<ServiceResponse<ApplicationGatewayBackendHealthInner>> beginBackendHealthWithServiceResponseAsync(String resourceGroupName, String applicationGatewayName, String expand) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (applicationGatewayName == null) {
            throw new IllegalArgumentException("Parameter applicationGatewayName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2016-09-01";
        return this.service.beginBackendHealth(resourceGroupName, applicationGatewayName, this.client.subscriptionId(), "2016-09-01", expand, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<ApplicationGatewayBackendHealthInner>>>(){

            public Observable<ServiceResponse<ApplicationGatewayBackendHealthInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = ApplicationGatewaysInner.this.beginBackendHealthDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<ApplicationGatewayBackendHealthInner> beginBackendHealthDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return new AzureServiceResponseBuilder(this.client.mapperAdapter()).register(200, new TypeToken<ApplicationGatewayBackendHealthInner>(){}.getType()).register(202, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<ApplicationGatewayInner> listNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<ApplicationGatewayInner>((Page)response.getBody()){

            public Page<ApplicationGatewayInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)ApplicationGatewaysInner.this.listNextSinglePageAsync(nextPageLink).toBlocking().single()).getBody();
            }
        };
    }

    public ServiceCall<List<ApplicationGatewayInner>> listNextAsync(String nextPageLink, ServiceCall<List<ApplicationGatewayInner>> serviceCall, ListOperationCallback<ApplicationGatewayInner> serviceCallback) {
        return AzureServiceCall.create(this.listNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<ApplicationGatewayInner>>>>(){

            public Observable<ServiceResponse<Page<ApplicationGatewayInner>>> call(String nextPageLink) {
                return ApplicationGatewaysInner.this.listNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<ApplicationGatewayInner>> listNextAsync(String nextPageLink) {
        return this.listNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<ApplicationGatewayInner>>, Page<ApplicationGatewayInner>>(){

            public Page<ApplicationGatewayInner> call(ServiceResponse<Page<ApplicationGatewayInner>> response) {
                return (Page)response.getBody();
            }
        });
    }

    public Observable<ServiceResponse<Page<ApplicationGatewayInner>>> listNextWithServiceResponseAsync(String nextPageLink) {
        return this.listNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<ApplicationGatewayInner>>, Observable<ServiceResponse<Page<ApplicationGatewayInner>>>>(){

            public Observable<ServiceResponse<Page<ApplicationGatewayInner>>> call(ServiceResponse<Page<ApplicationGatewayInner>> page) {
                String nextPageLink = ((Page)page.getBody()).getNextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(ApplicationGatewaysInner.this.listNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<ApplicationGatewayInner>>> listNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        return this.service.listNext(nextPageLink, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<ApplicationGatewayInner>>>>(){

            public Observable<ServiceResponse<Page<ApplicationGatewayInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = ApplicationGatewaysInner.this.listNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.getBody(), result.getResponse()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<ApplicationGatewayInner>> listNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return new AzureServiceResponseBuilder(this.client.mapperAdapter()).register(200, new TypeToken<PageImpl<ApplicationGatewayInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<ApplicationGatewayInner> listAllNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listAllNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<ApplicationGatewayInner>((Page)response.getBody()){

            public Page<ApplicationGatewayInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)ApplicationGatewaysInner.this.listAllNextSinglePageAsync(nextPageLink).toBlocking().single()).getBody();
            }
        };
    }

    public ServiceCall<List<ApplicationGatewayInner>> listAllNextAsync(String nextPageLink, ServiceCall<List<ApplicationGatewayInner>> serviceCall, ListOperationCallback<ApplicationGatewayInner> serviceCallback) {
        return AzureServiceCall.create(this.listAllNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<ApplicationGatewayInner>>>>(){

            public Observable<ServiceResponse<Page<ApplicationGatewayInner>>> call(String nextPageLink) {
                return ApplicationGatewaysInner.this.listAllNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<ApplicationGatewayInner>> listAllNextAsync(String nextPageLink) {
        return this.listAllNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<ApplicationGatewayInner>>, Page<ApplicationGatewayInner>>(){

            public Page<ApplicationGatewayInner> call(ServiceResponse<Page<ApplicationGatewayInner>> response) {
                return (Page)response.getBody();
            }
        });
    }

    public Observable<ServiceResponse<Page<ApplicationGatewayInner>>> listAllNextWithServiceResponseAsync(String nextPageLink) {
        return this.listAllNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<ApplicationGatewayInner>>, Observable<ServiceResponse<Page<ApplicationGatewayInner>>>>(){

            public Observable<ServiceResponse<Page<ApplicationGatewayInner>>> call(ServiceResponse<Page<ApplicationGatewayInner>> page) {
                String nextPageLink = ((Page)page.getBody()).getNextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(ApplicationGatewaysInner.this.listAllNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<ApplicationGatewayInner>>> listAllNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        return this.service.listAllNext(nextPageLink, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<ApplicationGatewayInner>>>>(){

            public Observable<ServiceResponse<Page<ApplicationGatewayInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = ApplicationGatewaysInner.this.listAllNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.getBody(), result.getResponse()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<ApplicationGatewayInner>> listAllNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return new AzureServiceResponseBuilder(this.client.mapperAdapter()).register(200, new TypeToken<PageImpl<ApplicationGatewayInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    static interface ApplicationGatewaysService {
        @Headers(value={"Content-Type: application/json; charset=utf-8"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/applicationGateways/{applicationGatewayName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> delete(@Path(value="resourceGroupName") String var1, @Path(value="applicationGatewayName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/applicationGateways/{applicationGatewayName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> beginDelete(@Path(value="resourceGroupName") String var1, @Path(value="applicationGatewayName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/applicationGateways/{applicationGatewayName}")
        public Observable<Response<ResponseBody>> get(@Path(value="resourceGroupName") String var1, @Path(value="applicationGatewayName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/applicationGateways/{applicationGatewayName}")
        public Observable<Response<ResponseBody>> createOrUpdate(@Path(value="resourceGroupName") String var1, @Path(value="applicationGatewayName") String var2, @Path(value="subscriptionId") String var3, @Body ApplicationGatewayInner var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/applicationGateways/{applicationGatewayName}")
        public Observable<Response<ResponseBody>> beginCreateOrUpdate(@Path(value="resourceGroupName") String var1, @Path(value="applicationGatewayName") String var2, @Path(value="subscriptionId") String var3, @Body ApplicationGatewayInner var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/applicationGateways")
        public Observable<Response<ResponseBody>> list(@Path(value="resourceGroupName") String var1, @Path(value="subscriptionId") String var2, @Query(value="api-version") String var3, @Header(value="accept-language") String var4, @Header(value="User-Agent") String var5);

        @Headers(value={"Content-Type: application/json; charset=utf-8"})
        @GET(value="subscriptions/{subscriptionId}/providers/Microsoft.Network/applicationGateways")
        public Observable<Response<ResponseBody>> listAll(@Path(value="subscriptionId") String var1, @Query(value="api-version") String var2, @Header(value="accept-language") String var3, @Header(value="User-Agent") String var4);

        @Headers(value={"Content-Type: application/json; charset=utf-8"})
        @POST(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/applicationGateways/{applicationGatewayName}/start")
        public Observable<Response<ResponseBody>> start(@Path(value="resourceGroupName") String var1, @Path(value="applicationGatewayName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8"})
        @POST(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/applicationGateways/{applicationGatewayName}/start")
        public Observable<Response<ResponseBody>> beginStart(@Path(value="resourceGroupName") String var1, @Path(value="applicationGatewayName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8"})
        @POST(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/applicationGateways/{applicationGatewayName}/stop")
        public Observable<Response<ResponseBody>> stop(@Path(value="resourceGroupName") String var1, @Path(value="applicationGatewayName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8"})
        @POST(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/applicationGateways/{applicationGatewayName}/stop")
        public Observable<Response<ResponseBody>> beginStop(@Path(value="resourceGroupName") String var1, @Path(value="applicationGatewayName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8"})
        @POST(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/applicationGateways/{applicationGatewayName}/backendhealth")
        public Observable<Response<ResponseBody>> backendHealth(@Path(value="resourceGroupName") String var1, @Path(value="applicationGatewayName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Query(value="$expand") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8"})
        @POST(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/applicationGateways/{applicationGatewayName}/backendhealth")
        public Observable<Response<ResponseBody>> beginBackendHealth(@Path(value="resourceGroupName") String var1, @Path(value="applicationGatewayName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Query(value="$expand") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8"})
        @GET(value="{nextLink}")
        public Observable<Response<ResponseBody>> listNext(@Path(value="nextLink", encoded=true) String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);

        @Headers(value={"Content-Type: application/json; charset=utf-8"})
        @GET(value="{nextLink}")
        public Observable<Response<ResponseBody>> listAllNext(@Path(value="nextLink", encoded=true) String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);
    }
}

