/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.network.implementation;

import com.microsoft.azure.CloudException;
import com.microsoft.azure.SubResource;
import com.microsoft.azure.management.apigeneration.LangDefinition;
import com.microsoft.azure.management.network.LoadBalancer;
import com.microsoft.azure.management.network.LoadBalancerBackend;
import com.microsoft.azure.management.network.LoadBalancingRule;
import com.microsoft.azure.management.network.NetworkInterface;
import com.microsoft.azure.management.network.implementation.BackendAddressPoolInner;
import com.microsoft.azure.management.network.implementation.LoadBalancerImpl;
import com.microsoft.azure.management.network.implementation.NetworkInterfaceIPConfigurationInner;
import com.microsoft.azure.management.resources.fluentcore.arm.ResourceUtils;
import com.microsoft.azure.management.resources.fluentcore.arm.models.implementation.ChildResourceImpl;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

@LangDefinition
class LoadBalancerBackendImpl
extends ChildResourceImpl<BackendAddressPoolInner, LoadBalancerImpl, LoadBalancer>
implements LoadBalancerBackend,
LoadBalancerBackend.Definition<LoadBalancer.DefinitionStages.WithBackendOrProbe>,
LoadBalancerBackend.UpdateDefinition<LoadBalancer.Update>,
LoadBalancerBackend.Update {
    LoadBalancerBackendImpl(BackendAddressPoolInner inner, LoadBalancerImpl parent) {
        super((Object)inner, (Object)parent);
    }

    @Override
    public Map<String, String> backendNicIpConfigurationNames() {
        TreeMap<String, String> ipConfigNames = new TreeMap<String, String>();
        if (((BackendAddressPoolInner)((Object)this.inner())).backendIPConfigurations() != null) {
            for (NetworkInterfaceIPConfigurationInner inner : ((BackendAddressPoolInner)((Object)this.inner())).backendIPConfigurations()) {
                String nicId = ResourceUtils.parentResourceIdFromResourceId((String)inner.id());
                String ipConfigName = ResourceUtils.nameFromResourceId((String)inner.id());
                ipConfigNames.put(nicId, ipConfigName);
            }
        }
        return Collections.unmodifiableMap(ipConfigNames);
    }

    @Override
    public Map<String, LoadBalancingRule> loadBalancingRules() {
        TreeMap<String, LoadBalancingRule> rules = new TreeMap<String, LoadBalancingRule>();
        if (((BackendAddressPoolInner)((Object)this.inner())).loadBalancingRules() != null) {
            for (SubResource inner : ((BackendAddressPoolInner)((Object)this.inner())).loadBalancingRules()) {
                String name = ResourceUtils.nameFromResourceId((String)inner.id());
                LoadBalancingRule rule = ((LoadBalancerImpl)this.parent()).loadBalancingRules().get(name);
                if (rule == null) continue;
                rules.put(name, rule);
            }
        }
        return Collections.unmodifiableMap(rules);
    }

    public String name() {
        return ((BackendAddressPoolInner)((Object)this.inner())).name();
    }

    @Override
    public Set<String> getVirtualMachineIds() {
        HashSet<String> vmIds = new HashSet<String>();
        Map<String, String> nicConfigs = this.backendNicIpConfigurationNames();
        if (nicConfigs != null) {
            for (String nicId : nicConfigs.keySet()) {
                try {
                    NetworkInterface nic = (NetworkInterface)((LoadBalancerImpl)this.parent()).manager().networkInterfaces().getById(nicId);
                    if (nic == null || nic.virtualMachineId() == null) continue;
                    vmIds.add(nic.virtualMachineId());
                }
                catch (CloudException | IllegalArgumentException e) {}
            }
        }
        return vmIds;
    }

    public LoadBalancerImpl attach() {
        ((LoadBalancerImpl)this.parent()).withBackend(this);
        return (LoadBalancerImpl)this.parent();
    }
}

