/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.network.implementation;

import com.microsoft.azure.SubResource;
import com.microsoft.azure.management.apigeneration.LangDefinition;
import com.microsoft.azure.management.network.IPAllocationMethod;
import com.microsoft.azure.management.network.LoadBalancer;
import com.microsoft.azure.management.network.LoadBalancerFrontend;
import com.microsoft.azure.management.network.LoadBalancerInboundNatPool;
import com.microsoft.azure.management.network.LoadBalancerInboundNatRule;
import com.microsoft.azure.management.network.LoadBalancerPrivateFrontend;
import com.microsoft.azure.management.network.LoadBalancerPublicFrontend;
import com.microsoft.azure.management.network.LoadBalancingRule;
import com.microsoft.azure.management.network.Network;
import com.microsoft.azure.management.network.PublicIpAddress;
import com.microsoft.azure.management.network.Subnet;
import com.microsoft.azure.management.network.implementation.FrontendIPConfigurationInner;
import com.microsoft.azure.management.network.implementation.LoadBalancerImpl;
import com.microsoft.azure.management.resources.fluentcore.arm.ResourceUtils;
import com.microsoft.azure.management.resources.fluentcore.arm.models.implementation.ChildResourceImpl;
import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;

@LangDefinition
class LoadBalancerFrontendImpl
extends ChildResourceImpl<FrontendIPConfigurationInner, LoadBalancerImpl, LoadBalancer>
implements LoadBalancerFrontend,
LoadBalancerPrivateFrontend,
LoadBalancerPrivateFrontend.Definition<LoadBalancer.DefinitionStages.WithPrivateFrontendOrBackend>,
LoadBalancerPrivateFrontend.UpdateDefinition<LoadBalancer.Update>,
LoadBalancerPrivateFrontend.Update,
LoadBalancerPublicFrontend,
LoadBalancerPublicFrontend.Definition<LoadBalancer.DefinitionStages.WithPublicFrontendOrBackend>,
LoadBalancerPublicFrontend.UpdateDefinition<LoadBalancer.Update>,
LoadBalancerPublicFrontend.Update {
    LoadBalancerFrontendImpl(FrontendIPConfigurationInner inner, LoadBalancerImpl parent) {
        super((Object)inner, (Object)parent);
    }

    public String networkId() {
        SubResource subnetRef = ((FrontendIPConfigurationInner)((Object)this.inner())).subnet();
        if (subnetRef != null) {
            return ResourceUtils.parentResourceIdFromResourceId((String)subnetRef.id());
        }
        return null;
    }

    public String subnetName() {
        SubResource subnetRef = ((FrontendIPConfigurationInner)((Object)this.inner())).subnet();
        if (subnetRef != null) {
            return ResourceUtils.nameFromResourceId((String)subnetRef.id());
        }
        return null;
    }

    @Override
    public String privateIpAddress() {
        return ((FrontendIPConfigurationInner)((Object)this.inner())).privateIPAddress();
    }

    @Override
    public IPAllocationMethod privateIpAllocationMethod() {
        return ((FrontendIPConfigurationInner)((Object)this.inner())).privateIPAllocationMethod();
    }

    public String name() {
        return ((FrontendIPConfigurationInner)((Object)this.inner())).name();
    }

    @Override
    public String publicIpAddressId() {
        return ((FrontendIPConfigurationInner)((Object)this.inner())).publicIPAddress().id();
    }

    @Override
    public boolean isPublic() {
        return ((FrontendIPConfigurationInner)((Object)this.inner())).publicIPAddress() != null;
    }

    @Override
    public Map<String, LoadBalancingRule> loadBalancingRules() {
        TreeMap<String, LoadBalancingRule> rules = new TreeMap<String, LoadBalancingRule>();
        if (((FrontendIPConfigurationInner)((Object)this.inner())).loadBalancingRules() != null) {
            for (SubResource innerRef : ((FrontendIPConfigurationInner)((Object)this.inner())).loadBalancingRules()) {
                String name = ResourceUtils.nameFromResourceId((String)innerRef.id());
                LoadBalancingRule rule = ((LoadBalancerImpl)this.parent()).loadBalancingRules().get(name);
                if (rule == null) continue;
                rules.put(name, rule);
            }
        }
        return Collections.unmodifiableMap(rules);
    }

    @Override
    public Map<String, LoadBalancerInboundNatPool> inboundNatPools() {
        TreeMap<String, LoadBalancerInboundNatPool> pools = new TreeMap<String, LoadBalancerInboundNatPool>();
        if (((FrontendIPConfigurationInner)((Object)this.inner())).inboundNatPools() != null) {
            for (SubResource innerRef : ((FrontendIPConfigurationInner)((Object)this.inner())).inboundNatPools()) {
                String name = ResourceUtils.nameFromResourceId((String)innerRef.id());
                LoadBalancerInboundNatPool pool = ((LoadBalancerImpl)this.parent()).inboundNatPools().get(name);
                if (pool == null) continue;
                pools.put(name, pool);
            }
        }
        return Collections.unmodifiableMap(pools);
    }

    @Override
    public Map<String, LoadBalancerInboundNatRule> inboundNatRules() {
        TreeMap<String, LoadBalancerInboundNatRule> rules = new TreeMap<String, LoadBalancerInboundNatRule>();
        if (((FrontendIPConfigurationInner)((Object)this.inner())).inboundNatRules() != null) {
            for (SubResource innerRef : ((FrontendIPConfigurationInner)((Object)this.inner())).inboundNatRules()) {
                String name = ResourceUtils.nameFromResourceId((String)innerRef.id());
                LoadBalancerInboundNatRule rule = ((LoadBalancerImpl)this.parent()).inboundNatRules().get(name);
                if (rule == null) continue;
                rules.put(name, rule);
            }
        }
        return Collections.unmodifiableMap(rules);
    }

    @Override
    public LoadBalancerFrontendImpl withExistingSubnet(Network network, String subnetName) {
        return this.withExistingSubnet(network.id(), subnetName);
    }

    public LoadBalancerFrontendImpl withExistingSubnet(String parentNetworkResourceId, String subnetName) {
        SubResource subnetRef = new SubResource().withId(parentNetworkResourceId + "/subnets/" + subnetName);
        ((FrontendIPConfigurationInner)((Object)this.inner())).withSubnet(subnetRef).withPublicIPAddress(null);
        return this;
    }

    @Override
    public LoadBalancerFrontendImpl withExistingPublicIpAddress(PublicIpAddress pip) {
        return this.withExistingPublicIpAddress(pip.id());
    }

    @Override
    public LoadBalancerFrontendImpl withExistingPublicIpAddress(String resourceId) {
        SubResource pipRef = new SubResource().withId(resourceId);
        ((FrontendIPConfigurationInner)((Object)this.inner())).withPublicIPAddress(pipRef).withSubnet(null).withPrivateIPAddress(null).withPrivateIPAllocationMethod(null);
        return this;
    }

    @Override
    public LoadBalancerFrontendImpl withoutPublicIpAddress() {
        ((FrontendIPConfigurationInner)((Object)this.inner())).withPublicIPAddress(null);
        return this;
    }

    @Override
    public LoadBalancerFrontendImpl withPrivateIpAddressDynamic() {
        ((FrontendIPConfigurationInner)((Object)this.inner())).withPrivateIPAddress(null).withPrivateIPAllocationMethod(IPAllocationMethod.DYNAMIC).withPublicIPAddress(null);
        return this;
    }

    @Override
    public LoadBalancerFrontendImpl withPrivateIpAddressStatic(String ipAddress) {
        ((FrontendIPConfigurationInner)((Object)this.inner())).withPrivateIPAddress(ipAddress).withPrivateIPAllocationMethod(IPAllocationMethod.STATIC).withPublicIPAddress(null);
        return this;
    }

    public LoadBalancerImpl attach() {
        return ((LoadBalancerImpl)this.parent()).withFrontend(this);
    }

    @Override
    public PublicIpAddress getPublicIpAddress() {
        String pipId = this.publicIpAddressId();
        if (pipId == null) {
            return null;
        }
        return (PublicIpAddress)((LoadBalancerImpl)this.parent()).manager().publicIpAddresses().getById(pipId);
    }

    @Override
    public Subnet getSubnet() {
        return ((LoadBalancerImpl)this.parent()).manager().getAssociatedSubnet(((FrontendIPConfigurationInner)((Object)this.inner())).subnet());
    }
}

