/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.network.implementation;

import com.microsoft.azure.SubResource;
import com.microsoft.azure.management.apigeneration.LangDefinition;
import com.microsoft.azure.management.network.LoadBalancer;
import com.microsoft.azure.management.network.LoadBalancerBackend;
import com.microsoft.azure.management.network.LoadBalancerFrontend;
import com.microsoft.azure.management.network.LoadBalancerProbe;
import com.microsoft.azure.management.network.LoadBalancingRule;
import com.microsoft.azure.management.network.LoadDistribution;
import com.microsoft.azure.management.network.TransportProtocol;
import com.microsoft.azure.management.network.implementation.LoadBalancerImpl;
import com.microsoft.azure.management.network.implementation.LoadBalancingRuleInner;
import com.microsoft.azure.management.resources.fluentcore.arm.ResourceUtils;
import com.microsoft.azure.management.resources.fluentcore.arm.models.implementation.ChildResourceImpl;
import com.microsoft.azure.management.resources.fluentcore.utils.Utils;

@LangDefinition
class LoadBalancingRuleImpl
extends ChildResourceImpl<LoadBalancingRuleInner, LoadBalancerImpl, LoadBalancer>
implements LoadBalancingRule,
LoadBalancingRule.Definition<LoadBalancer.DefinitionStages.WithLoadBalancingRuleOrCreate>,
LoadBalancingRule.UpdateDefinition<LoadBalancer.Update>,
LoadBalancingRule.Update {
    LoadBalancingRuleImpl(LoadBalancingRuleInner inner, LoadBalancerImpl parent) {
        super((Object)inner, (Object)parent);
    }

    public String name() {
        return ((LoadBalancingRuleInner)((Object)this.inner())).name();
    }

    @Override
    public TransportProtocol protocol() {
        return ((LoadBalancingRuleInner)((Object)this.inner())).protocol();
    }

    @Override
    public boolean floatingIpEnabled() {
        return ((LoadBalancingRuleInner)((Object)this.inner())).enableFloatingIP();
    }

    @Override
    public int idleTimeoutInMinutes() {
        return Utils.toPrimitiveInt((Integer)((LoadBalancingRuleInner)((Object)this.inner())).idleTimeoutInMinutes());
    }

    @Override
    public int frontendPort() {
        return Utils.toPrimitiveInt((Integer)((LoadBalancingRuleInner)((Object)this.inner())).frontendPort());
    }

    @Override
    public int backendPort() {
        return Utils.toPrimitiveInt((Integer)((LoadBalancingRuleInner)((Object)this.inner())).backendPort());
    }

    @Override
    public LoadDistribution loadDistribution() {
        return ((LoadBalancingRuleInner)((Object)this.inner())).loadDistribution();
    }

    @Override
    public LoadBalancerFrontend frontend() {
        SubResource frontendRef = ((LoadBalancingRuleInner)((Object)this.inner())).frontendIPConfiguration();
        if (frontendRef == null) {
            return null;
        }
        String frontendName = ResourceUtils.nameFromResourceId((String)frontendRef.id());
        return ((LoadBalancerImpl)this.parent()).frontends().get(frontendName);
    }

    @Override
    public LoadBalancerBackend backend() {
        SubResource backendRef = ((LoadBalancingRuleInner)((Object)this.inner())).backendAddressPool();
        if (backendRef == null) {
            return null;
        }
        String backendName = ResourceUtils.nameFromResourceId((String)backendRef.id());
        return ((LoadBalancerImpl)this.parent()).backends().get(backendName);
    }

    @Override
    public LoadBalancerProbe probe() {
        SubResource probeRef = ((LoadBalancingRuleInner)((Object)this.inner())).probe();
        if (probeRef == null) {
            return null;
        }
        String probeName = ResourceUtils.nameFromResourceId((String)probeRef.id());
        if (((LoadBalancerImpl)this.parent()).httpProbes().containsKey(probeName)) {
            return ((LoadBalancerImpl)this.parent()).httpProbes().get(probeName);
        }
        if (((LoadBalancerImpl)this.parent()).tcpProbes().containsKey(probeName)) {
            return ((LoadBalancerImpl)this.parent()).tcpProbes().get(probeName);
        }
        return null;
    }

    @Override
    public LoadBalancingRuleImpl withIdleTimeoutInMinutes(int minutes) {
        ((LoadBalancingRuleInner)((Object)this.inner())).withIdleTimeoutInMinutes(minutes);
        return this;
    }

    @Override
    public LoadBalancingRuleImpl withFloatingIp(boolean enable) {
        ((LoadBalancingRuleInner)((Object)this.inner())).withEnableFloatingIP(enable);
        return this;
    }

    @Override
    public LoadBalancingRuleImpl withFloatingIpEnabled() {
        return this.withFloatingIp(true);
    }

    @Override
    public LoadBalancingRuleImpl withFloatingIpDisabled() {
        return this.withFloatingIp(false);
    }

    @Override
    public LoadBalancingRuleImpl withProtocol(TransportProtocol protocol) {
        ((LoadBalancingRuleInner)((Object)this.inner())).withProtocol(protocol);
        return this;
    }

    @Override
    public LoadBalancingRuleImpl withFrontendPort(int port) {
        ((LoadBalancingRuleInner)((Object)this.inner())).withFrontendPort(port);
        if (((LoadBalancingRuleInner)((Object)this.inner())).backendPort() == null || ((LoadBalancingRuleInner)((Object)this.inner())).backendPort() == 0) {
            ((LoadBalancingRuleInner)((Object)this.inner())).withBackendPort(port);
        }
        return this;
    }

    @Override
    public LoadBalancingRuleImpl withBackendPort(int port) {
        ((LoadBalancingRuleInner)((Object)this.inner())).withBackendPort(port);
        return this;
    }

    @Override
    public LoadBalancingRuleImpl withLoadDistribution(LoadDistribution loadDistribution) {
        ((LoadBalancingRuleInner)((Object)this.inner())).withLoadDistribution(loadDistribution);
        return this;
    }

    @Override
    public LoadBalancingRuleImpl withFrontend(String frontendName) {
        SubResource frontendRef = new SubResource().withId(((LoadBalancerImpl)this.parent()).futureResourceId() + "/frontendIPConfigurations/" + frontendName);
        ((LoadBalancingRuleInner)((Object)this.inner())).withFrontendIPConfiguration(frontendRef);
        return this;
    }

    public LoadBalancingRuleImpl withBackend(String backendName) {
        SubResource backendRef = new SubResource().withId(((LoadBalancerImpl)this.parent()).futureResourceId() + "/backendAddressPools/" + backendName);
        ((LoadBalancingRuleInner)((Object)this.inner())).withBackendAddressPool(backendRef);
        return this;
    }

    public LoadBalancingRuleImpl withProbe(String name) {
        SubResource probeRef = new SubResource().withId(((LoadBalancerImpl)this.parent()).futureResourceId() + "/probes/" + name);
        ((LoadBalancingRuleInner)((Object)this.inner())).withProbe(probeRef);
        return this;
    }

    public LoadBalancerImpl attach() {
        return ((LoadBalancerImpl)this.parent()).withLoadBalancingRule(this);
    }
}

