/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.network.implementation;

import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.apigeneration.LangDefinition;
import com.microsoft.azure.management.network.NetworkInterface;
import com.microsoft.azure.management.network.NetworkInterfaceDnsSettings;
import com.microsoft.azure.management.network.NetworkInterfaces;
import com.microsoft.azure.management.network.VirtualMachineScaleSetNetworkInterface;
import com.microsoft.azure.management.network.implementation.NetworkInterfaceIPConfigurationInner;
import com.microsoft.azure.management.network.implementation.NetworkInterfaceImpl;
import com.microsoft.azure.management.network.implementation.NetworkInterfaceInner;
import com.microsoft.azure.management.network.implementation.NetworkInterfacesInner;
import com.microsoft.azure.management.network.implementation.NetworkManager;
import com.microsoft.azure.management.network.implementation.VirtualMachineScaleSetNetworkInterfacesImpl;
import com.microsoft.azure.management.resources.fluentcore.arm.ResourceUtils;
import com.microsoft.azure.management.resources.fluentcore.arm.collection.implementation.GroupableResourcesImpl;
import com.microsoft.azure.management.resources.fluentcore.arm.implementation.ManagerBase;
import java.util.ArrayList;
import rx.Observable;

@LangDefinition
class NetworkInterfacesImpl
extends GroupableResourcesImpl<NetworkInterface, NetworkInterfaceImpl, NetworkInterfaceInner, NetworkInterfacesInner, NetworkManager>
implements NetworkInterfaces {
    NetworkInterfacesImpl(NetworkInterfacesInner client, NetworkManager networkManager) {
        super((Object)client, (ManagerBase)networkManager);
    }

    public PagedList<NetworkInterface> list() {
        return this.wrapList(((NetworkInterfacesInner)this.innerCollection).listAll());
    }

    public PagedList<NetworkInterface> listByGroup(String groupName) {
        return this.wrapList(((NetworkInterfacesInner)this.innerCollection).list(groupName));
    }

    public NetworkInterface getByGroup(String groupName, String name) {
        return this.wrapModel(((NetworkInterfacesInner)this.innerCollection).get(groupName, name));
    }

    public Observable<Void> deleteByGroupAsync(String groupName, String name) {
        return ((NetworkInterfacesInner)this.innerCollection).deleteAsync(groupName, name);
    }

    @Override
    public VirtualMachineScaleSetNetworkInterface getByVirtualMachineScaleSetInstanceId(String resourceGroupName, String scaleSetName, String instanceId, String name) {
        VirtualMachineScaleSetNetworkInterfacesImpl scaleSetNetworkInterfaces = new VirtualMachineScaleSetNetworkInterfacesImpl(resourceGroupName, scaleSetName, (NetworkInterfacesInner)this.innerCollection, (NetworkManager)this.myManager);
        return scaleSetNetworkInterfaces.getByVirtualMachineInstanceId(instanceId, name);
    }

    @Override
    public PagedList<VirtualMachineScaleSetNetworkInterface> listByVirtualMachineScaleSet(String resourceGroupName, String scaleSetName) {
        VirtualMachineScaleSetNetworkInterfacesImpl scaleSetNetworkInterfaces = new VirtualMachineScaleSetNetworkInterfacesImpl(resourceGroupName, scaleSetName, (NetworkInterfacesInner)this.innerCollection, (NetworkManager)this.myManager);
        return scaleSetNetworkInterfaces.list();
    }

    @Override
    public PagedList<VirtualMachineScaleSetNetworkInterface> listByVirtualMachineScaleSetId(String id) {
        return this.listByVirtualMachineScaleSet(ResourceUtils.groupFromResourceId((String)id), ResourceUtils.nameFromResourceId((String)id));
    }

    @Override
    public PagedList<VirtualMachineScaleSetNetworkInterface> listByVirtualMachineScaleSetInstanceId(String resourceGroupName, String scaleSetName, String instanceId) {
        VirtualMachineScaleSetNetworkInterfacesImpl scaleSetNetworkInterfaces = new VirtualMachineScaleSetNetworkInterfacesImpl(resourceGroupName, scaleSetName, (NetworkInterfacesInner)this.innerCollection, (NetworkManager)this.myManager);
        return scaleSetNetworkInterfaces.listByVirtualMachineInstanceId(instanceId);
    }

    public NetworkInterfaceImpl define(String name) {
        return this.wrapModel(name);
    }

    protected NetworkInterfaceImpl wrapModel(String name) {
        NetworkInterfaceInner inner = new NetworkInterfaceInner();
        inner.withIpConfigurations(new ArrayList<NetworkInterfaceIPConfigurationInner>());
        inner.withDnsSettings(new NetworkInterfaceDnsSettings());
        return new NetworkInterfaceImpl(name, inner, (NetworkInterfacesInner)this.innerCollection, (NetworkManager)this.myManager);
    }

    protected NetworkInterfaceImpl wrapModel(NetworkInterfaceInner inner) {
        if (inner == null) {
            return null;
        }
        return new NetworkInterfaceImpl(inner.name(), inner, (NetworkInterfacesInner)this.innerCollection, (NetworkManager)this.myManager);
    }
}

