/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.network.implementation;

import com.microsoft.azure.Resource;
import com.microsoft.azure.management.apigeneration.LangDefinition;
import com.microsoft.azure.management.network.NetworkSecurityGroup;
import com.microsoft.azure.management.network.NetworkSecurityRule;
import com.microsoft.azure.management.network.Subnet;
import com.microsoft.azure.management.network.implementation.NetworkInterfaceInner;
import com.microsoft.azure.management.network.implementation.NetworkManager;
import com.microsoft.azure.management.network.implementation.NetworkSecurityGroupInner;
import com.microsoft.azure.management.network.implementation.NetworkSecurityGroupsInner;
import com.microsoft.azure.management.network.implementation.NetworkSecurityRuleImpl;
import com.microsoft.azure.management.network.implementation.SecurityRuleInner;
import com.microsoft.azure.management.resources.fluentcore.arm.implementation.ManagerBase;
import com.microsoft.azure.management.resources.fluentcore.arm.models.implementation.GroupableParentResourceImpl;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import rx.Observable;

@LangDefinition
class NetworkSecurityGroupImpl
extends GroupableParentResourceImpl<NetworkSecurityGroup, NetworkSecurityGroupInner, NetworkSecurityGroupImpl, NetworkManager>
implements NetworkSecurityGroup,
NetworkSecurityGroup.Definition,
NetworkSecurityGroup.Update {
    private final NetworkSecurityGroupsInner innerCollection;
    private Map<String, NetworkSecurityRule> rules;
    private Map<String, NetworkSecurityRule> defaultRules;

    NetworkSecurityGroupImpl(String name, NetworkSecurityGroupInner innerModel, NetworkSecurityGroupsInner innerCollection, NetworkManager networkManager) {
        super(name, (Resource)innerModel, (ManagerBase)networkManager);
        this.innerCollection = innerCollection;
    }

    protected void initializeChildrenFromInner() {
        this.rules = new TreeMap<String, NetworkSecurityRule>();
        List<SecurityRuleInner> inners = ((NetworkSecurityGroupInner)((Object)this.inner())).securityRules();
        if (inners != null) {
            for (SecurityRuleInner inner : inners) {
                this.rules.put(inner.name(), new NetworkSecurityRuleImpl(inner, this));
            }
        }
        this.defaultRules = new TreeMap<String, NetworkSecurityRule>();
        inners = ((NetworkSecurityGroupInner)((Object)this.inner())).defaultSecurityRules();
        if (inners != null) {
            for (SecurityRuleInner inner : inners) {
                this.defaultRules.put(inner.name(), new NetworkSecurityRuleImpl(inner, this));
            }
        }
    }

    @Override
    public NetworkSecurityRuleImpl updateRule(String name) {
        return (NetworkSecurityRuleImpl)this.rules.get(name);
    }

    public NetworkSecurityRuleImpl defineRule(String name) {
        SecurityRuleInner inner = new SecurityRuleInner();
        inner.withName(name);
        inner.withPriority(100);
        return new NetworkSecurityRuleImpl(inner, this);
    }

    public NetworkSecurityGroupImpl refresh() {
        NetworkSecurityGroupInner response = this.innerCollection.get(this.resourceGroupName(), this.name());
        this.setInner((Object)response);
        this.initializeChildrenFromInner();
        return this;
    }

    @Override
    public List<Subnet> listAssociatedSubnets() {
        return ((NetworkManager)this.myManager).listAssociatedSubnets(((NetworkSecurityGroupInner)((Object)this.inner())).subnets());
    }

    @Override
    public NetworkSecurityGroup.Update withoutRule(String name) {
        this.rules.remove(name);
        return this;
    }

    NetworkSecurityGroupImpl withRule(NetworkSecurityRuleImpl rule) {
        this.rules.put(rule.name(), rule);
        return this;
    }

    @Override
    public Map<String, NetworkSecurityRule> securityRules() {
        return Collections.unmodifiableMap(this.rules);
    }

    @Override
    public Map<String, NetworkSecurityRule> defaultSecurityRules() {
        return Collections.unmodifiableMap(this.defaultRules);
    }

    @Override
    public List<String> networkInterfaceIds() {
        ArrayList<String> ids = new ArrayList<String>();
        if (((NetworkSecurityGroupInner)((Object)this.inner())).networkInterfaces() != null) {
            for (NetworkInterfaceInner inner : ((NetworkSecurityGroupInner)((Object)this.inner())).networkInterfaces()) {
                ids.add(inner.id());
            }
        }
        return Collections.unmodifiableList(ids);
    }

    protected void beforeCreating() {
        ((NetworkSecurityGroupInner)((Object)this.inner())).withSecurityRules(this.innersFromWrappers(this.rules.values()));
    }

    protected void afterCreating() {
    }

    protected Observable<NetworkSecurityGroupInner> createInner() {
        return this.innerCollection.createOrUpdateAsync(this.resourceGroupName(), this.name(), (NetworkSecurityGroupInner)((Object)this.inner()));
    }
}

