/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.network.implementation;

import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.apigeneration.LangDefinition;
import com.microsoft.azure.management.network.AddressSpace;
import com.microsoft.azure.management.network.DhcpOptions;
import com.microsoft.azure.management.network.Network;
import com.microsoft.azure.management.network.Networks;
import com.microsoft.azure.management.network.implementation.NetworkImpl;
import com.microsoft.azure.management.network.implementation.NetworkManagementClientImpl;
import com.microsoft.azure.management.network.implementation.NetworkManager;
import com.microsoft.azure.management.network.implementation.SubnetInner;
import com.microsoft.azure.management.network.implementation.VirtualNetworkInner;
import com.microsoft.azure.management.network.implementation.VirtualNetworksInner;
import com.microsoft.azure.management.resources.fluentcore.arm.collection.implementation.GroupableResourcesImpl;
import com.microsoft.azure.management.resources.fluentcore.arm.implementation.ManagerBase;
import java.util.ArrayList;
import rx.Observable;

@LangDefinition
class NetworksImpl
extends GroupableResourcesImpl<Network, NetworkImpl, VirtualNetworkInner, VirtualNetworksInner, NetworkManager>
implements Networks {
    NetworksImpl(NetworkManagementClientImpl networkClient, NetworkManager networkManager) {
        super((Object)networkClient.virtualNetworks(), (ManagerBase)networkManager);
    }

    public PagedList<Network> list() {
        return this.wrapList(((VirtualNetworksInner)this.innerCollection).listAll());
    }

    public PagedList<Network> listByGroup(String groupName) {
        return this.wrapList(((VirtualNetworksInner)this.innerCollection).list(groupName));
    }

    public NetworkImpl getByGroup(String groupName, String name) {
        return this.wrapModel(((VirtualNetworksInner)this.innerCollection).get(groupName, name));
    }

    public Observable<Void> deleteByGroupAsync(String groupName, String name) {
        return ((VirtualNetworksInner)this.innerCollection).deleteAsync(groupName, name);
    }

    public NetworkImpl define(String name) {
        return this.wrapModel(name);
    }

    protected NetworkImpl wrapModel(String name) {
        DhcpOptions dhcp;
        VirtualNetworkInner inner = new VirtualNetworkInner();
        AddressSpace addressSpace = inner.addressSpace();
        if (addressSpace == null) {
            addressSpace = new AddressSpace();
            inner.withAddressSpace(addressSpace);
        }
        if (addressSpace.addressPrefixes() == null) {
            addressSpace.withAddressPrefixes(new ArrayList<String>());
        }
        if (inner.subnets() == null) {
            inner.withSubnets(new ArrayList<SubnetInner>());
        }
        if ((dhcp = inner.dhcpOptions()) == null) {
            dhcp = new DhcpOptions();
            inner.withDhcpOptions(dhcp);
        }
        if (dhcp.dnsServers() == null) {
            dhcp.withDnsServers(new ArrayList<String>());
        }
        return new NetworkImpl(name, inner, (VirtualNetworksInner)this.innerCollection, (NetworkManager)this.myManager);
    }

    protected NetworkImpl wrapModel(VirtualNetworkInner inner) {
        if (inner == null) {
            return null;
        }
        return new NetworkImpl(inner.name(), inner, (VirtualNetworksInner)this.innerCollection, (NetworkManager)this.myManager);
    }
}

