/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.network.implementation;

import com.microsoft.azure.SubResource;
import com.microsoft.azure.management.apigeneration.LangDefinition;
import com.microsoft.azure.management.network.IPAllocationMethod;
import com.microsoft.azure.management.network.IPVersion;
import com.microsoft.azure.management.network.LoadBalancer;
import com.microsoft.azure.management.network.Network;
import com.microsoft.azure.management.network.NetworkInterface;
import com.microsoft.azure.management.network.NicIpConfiguration;
import com.microsoft.azure.management.network.PublicIpAddress;
import com.microsoft.azure.management.network.implementation.BackendAddressPoolInner;
import com.microsoft.azure.management.network.implementation.InboundNatRuleInner;
import com.microsoft.azure.management.network.implementation.LoadBalancerInner;
import com.microsoft.azure.management.network.implementation.NetworkInterfaceIPConfigurationInner;
import com.microsoft.azure.management.network.implementation.NetworkInterfaceImpl;
import com.microsoft.azure.management.network.implementation.NetworkManager;
import com.microsoft.azure.management.network.implementation.NicIpConfigurationBaseImpl;
import com.microsoft.azure.management.network.implementation.SubnetInner;
import com.microsoft.azure.management.network.implementation.VirtualNetworkInner;
import com.microsoft.azure.management.resources.fluentcore.model.Creatable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

@LangDefinition
class NicIpConfigurationImpl
extends NicIpConfigurationBaseImpl<NetworkInterfaceImpl, NetworkInterface>
implements NicIpConfiguration,
NicIpConfiguration.Definition<NetworkInterface.DefinitionStages.WithCreate>,
NicIpConfiguration.UpdateDefinition<NetworkInterface.Update>,
NicIpConfiguration.Update {
    private final NetworkManager networkManager;
    private final boolean isInCreateMode;
    private String creatableVirtualNetworkKey;
    private String creatablePublicIpKey;
    private Network existingVirtualNetworkToAssociate;
    private String existingPublicIpAddressIdToAssociate;
    private String subnetToAssociate;
    private boolean removePrimaryPublicIPAssociation;

    protected NicIpConfigurationImpl(NetworkInterfaceIPConfigurationInner inner, NetworkInterfaceImpl parent, NetworkManager networkManager, boolean isInCreateModel) {
        super(inner, parent, networkManager);
        this.isInCreateMode = isInCreateModel;
        this.networkManager = networkManager;
    }

    protected static NicIpConfigurationImpl prepareNicIpConfiguration(String name, NetworkInterfaceImpl parent, NetworkManager networkManager) {
        NetworkInterfaceIPConfigurationInner ipConfigurationInner = new NetworkInterfaceIPConfigurationInner();
        ipConfigurationInner.withName(name);
        return new NicIpConfigurationImpl(ipConfigurationInner, parent, networkManager, true);
    }

    @Override
    public String publicIpAddressId() {
        if (((NetworkInterfaceIPConfigurationInner)((Object)this.inner())).publicIPAddress() == null) {
            return null;
        }
        return ((NetworkInterfaceIPConfigurationInner)((Object)this.inner())).publicIPAddress().id();
    }

    @Override
    public PublicIpAddress getPublicIpAddress() {
        String id = this.publicIpAddressId();
        if (id == null) {
            return null;
        }
        return (PublicIpAddress)this.networkManager.publicIpAddresses().getById(id);
    }

    public NetworkInterfaceImpl attach() {
        return ((NetworkInterfaceImpl)this.parent()).withIpConfiguration(this);
    }

    public NicIpConfigurationImpl withNewNetwork(Creatable<Network> creatable) {
        this.creatableVirtualNetworkKey = creatable.key();
        ((NetworkInterfaceImpl)this.parent()).addToCreatableDependencies(creatable);
        return this;
    }

    public NicIpConfigurationImpl withNewNetwork(String name, String addressSpaceCidr) {
        Network.DefinitionStages.WithGroup definitionWithGroup = (Network.DefinitionStages.WithGroup)((Network.DefinitionStages.Blank)this.networkManager.networks().define(name)).withRegion(((NetworkInterfaceImpl)this.parent()).regionName());
        Network.DefinitionStages.WithCreate definitionAfterGroup = ((NetworkInterfaceImpl)this.parent()).newGroup() != null ? (Network.DefinitionStages.WithCreate)definitionWithGroup.withNewResourceGroup(((NetworkInterfaceImpl)this.parent()).newGroup()) : (Network.DefinitionStages.WithCreate)definitionWithGroup.withExistingResourceGroup(((NetworkInterfaceImpl)this.parent()).resourceGroupName());
        return this.withNewNetwork(definitionAfterGroup.withAddressSpace(addressSpaceCidr));
    }

    public NicIpConfigurationImpl withNewNetwork(String addressSpaceCidr) {
        return this.withNewNetwork(((NetworkInterfaceImpl)this.parent()).namer.randomName("vnet", 20), addressSpaceCidr);
    }

    public NicIpConfigurationImpl withExistingNetwork(Network network) {
        this.existingVirtualNetworkToAssociate = network;
        return this;
    }

    @Override
    public NicIpConfigurationImpl withPrivateIpAddressDynamic() {
        ((NetworkInterfaceIPConfigurationInner)((Object)this.inner())).withPrivateIPAllocationMethod(IPAllocationMethod.DYNAMIC);
        ((NetworkInterfaceIPConfigurationInner)((Object)this.inner())).withPrivateIPAddress(null);
        return this;
    }

    @Override
    public NicIpConfigurationImpl withPrivateIpAddressStatic(String staticPrivateIpAddress) {
        ((NetworkInterfaceIPConfigurationInner)((Object)this.inner())).withPrivateIPAllocationMethod(IPAllocationMethod.STATIC);
        ((NetworkInterfaceIPConfigurationInner)((Object)this.inner())).withPrivateIPAddress(staticPrivateIpAddress);
        return this;
    }

    @Override
    public NicIpConfigurationImpl withNewPublicIpAddress(Creatable<PublicIpAddress> creatable) {
        if (this.creatablePublicIpKey == null) {
            this.creatablePublicIpKey = creatable.key();
            ((NetworkInterfaceImpl)this.parent()).addToCreatableDependencies(creatable);
        }
        return this;
    }

    @Override
    public NicIpConfigurationImpl withNewPublicIpAddress() {
        String name = ((NetworkInterfaceImpl)this.parent()).namer.randomName("pip", 15);
        return this.withNewPublicIpAddress((Creatable)this.prepareCreatablePublicIp(name, name));
    }

    @Override
    public NicIpConfigurationImpl withNewPublicIpAddress(String leafDnsLabel) {
        return this.withNewPublicIpAddress((Creatable)this.prepareCreatablePublicIp(((NetworkInterfaceImpl)this.parent()).namer.randomName("pip", 15), leafDnsLabel));
    }

    @Override
    public NicIpConfigurationImpl withExistingPublicIpAddress(PublicIpAddress publicIpAddress) {
        return this.withExistingPublicIpAddress(publicIpAddress.id());
    }

    @Override
    public NicIpConfigurationImpl withExistingPublicIpAddress(String resourceId) {
        this.existingPublicIpAddressIdToAssociate = resourceId;
        return this;
    }

    @Override
    public NicIpConfigurationImpl withoutPublicIpAddress() {
        this.removePrimaryPublicIPAssociation = true;
        return this;
    }

    @Override
    public NicIpConfigurationImpl withSubnet(String name) {
        this.subnetToAssociate = name;
        return this;
    }

    @Override
    public NicIpConfigurationImpl withExistingLoadBalancerBackend(LoadBalancer loadBalancer, String backendName) {
        for (BackendAddressPoolInner pool : ((LoadBalancerInner)((Object)loadBalancer.inner())).backendAddressPools()) {
            if (!pool.name().equalsIgnoreCase(backendName)) continue;
            this.ensureBackendAddressPools().add(pool);
            return this;
        }
        return null;
    }

    @Override
    public NicIpConfigurationImpl withExistingLoadBalancerInboundNatRule(LoadBalancer loadBalancer, String inboundNatRuleName) {
        for (InboundNatRuleInner rule : ((LoadBalancerInner)((Object)loadBalancer.inner())).inboundNatRules()) {
            if (!rule.name().equalsIgnoreCase(inboundNatRuleName)) continue;
            this.ensureInboundNatRules().add(rule);
            return this;
        }
        return null;
    }

    private List<BackendAddressPoolInner> ensureBackendAddressPools() {
        List<BackendAddressPoolInner> poolRefs = ((NetworkInterfaceIPConfigurationInner)((Object)this.inner())).loadBalancerBackendAddressPools();
        if (poolRefs == null) {
            poolRefs = new ArrayList<BackendAddressPoolInner>();
            ((NetworkInterfaceIPConfigurationInner)((Object)this.inner())).withLoadBalancerBackendAddressPools(poolRefs);
        }
        return poolRefs;
    }

    private List<InboundNatRuleInner> ensureInboundNatRules() {
        List<InboundNatRuleInner> natRefs = ((NetworkInterfaceIPConfigurationInner)((Object)this.inner())).loadBalancerInboundNatRules();
        if (natRefs == null) {
            natRefs = new ArrayList<InboundNatRuleInner>();
            ((NetworkInterfaceIPConfigurationInner)((Object)this.inner())).withLoadBalancerInboundNatRules(natRefs);
        }
        return natRefs;
    }

    protected static void ensureConfigurations(Collection<NicIpConfiguration> nicIpConfigurations) {
        for (NicIpConfiguration nicIpConfiguration : nicIpConfigurations) {
            NicIpConfigurationImpl config = (NicIpConfigurationImpl)nicIpConfiguration;
            ((NetworkInterfaceIPConfigurationInner)((Object)config.inner())).withSubnet(config.subnetToAssociate());
            ((NetworkInterfaceIPConfigurationInner)((Object)config.inner())).withPublicIPAddress(config.publicIpToAssociate());
        }
    }

    private Creatable<PublicIpAddress> prepareCreatablePublicIp(String name, String leafDnsLabel) {
        PublicIpAddress.DefinitionStages.WithGroup definitionWithGroup = (PublicIpAddress.DefinitionStages.WithGroup)((PublicIpAddress.DefinitionStages.Blank)this.networkManager.publicIpAddresses().define(name)).withRegion(((NetworkInterfaceImpl)this.parent()).regionName());
        PublicIpAddress.DefinitionStages.WithCreate definitionAfterGroup = ((NetworkInterfaceImpl)this.parent()).newGroup() != null ? (PublicIpAddress.DefinitionStages.WithCreate)definitionWithGroup.withNewResourceGroup(((NetworkInterfaceImpl)this.parent()).newGroup()) : (PublicIpAddress.DefinitionStages.WithCreate)definitionWithGroup.withExistingResourceGroup(((NetworkInterfaceImpl)this.parent()).resourceGroupName());
        return definitionAfterGroup.withLeafDomainLabel(leafDnsLabel);
    }

    private SubnetInner subnetToAssociate() {
        SubnetInner subnetInner = new SubnetInner();
        if (this.isInCreateMode) {
            if (this.creatableVirtualNetworkKey != null) {
                Network network = (Network)((NetworkInterfaceImpl)this.parent()).createdDependencyResource(this.creatableVirtualNetworkKey);
                subnetInner.withId(((VirtualNetworkInner)((Object)network.inner())).subnets().get(0).id());
                return subnetInner;
            }
            for (SubnetInner subnet : ((VirtualNetworkInner)((Object)this.existingVirtualNetworkToAssociate.inner())).subnets()) {
                if (subnet.name().compareToIgnoreCase(this.subnetToAssociate) != 0) continue;
                subnetInner.withId(subnet.id());
                return subnetInner;
            }
            throw new RuntimeException("A subnet with name '" + this.subnetToAssociate + "' not found under the network '" + this.existingVirtualNetworkToAssociate.name() + "'");
        }
        if (this.subnetToAssociate != null) {
            int idx = ((NetworkInterfaceIPConfigurationInner)((Object)this.inner())).subnet().id().lastIndexOf(47);
            subnetInner.withId(((NetworkInterfaceIPConfigurationInner)((Object)this.inner())).subnet().id().substring(0, idx) + this.subnetToAssociate);
        } else {
            subnetInner.withId(((NetworkInterfaceIPConfigurationInner)((Object)this.inner())).subnet().id());
        }
        return subnetInner;
    }

    private SubResource publicIpToAssociate() {
        String pipId = null;
        if (this.removePrimaryPublicIPAssociation) {
            return null;
        }
        if (this.creatablePublicIpKey != null) {
            pipId = ((PublicIpAddress)((NetworkInterfaceImpl)this.parent()).createdDependencyResource(this.creatablePublicIpKey)).id();
        } else if (this.existingPublicIpAddressIdToAssociate != null) {
            pipId = this.existingPublicIpAddressIdToAssociate;
        }
        if (pipId != null) {
            return new SubResource().withId(pipId);
        }
        if (!this.isInCreateMode) {
            return ((NetworkInterfaceIPConfigurationInner)((Object)this.inner())).publicIPAddress();
        }
        return null;
    }

    @Override
    public NicIpConfigurationImpl withPrivateIpVersion(IPVersion ipVersion) {
        ((NetworkInterfaceIPConfigurationInner)((Object)this.inner())).withPrivateIPAddressVersion(ipVersion);
        return this;
    }

    @Override
    public NicIpConfigurationImpl withoutLoadBalancerBackends() {
        ((NetworkInterfaceIPConfigurationInner)((Object)this.inner())).withLoadBalancerBackendAddressPools(null);
        return this;
    }

    @Override
    public NicIpConfigurationImpl withoutLoadBalancerInboundNatRules() {
        ((NetworkInterfaceIPConfigurationInner)((Object)this.inner())).withLoadBalancerInboundNatRules(null);
        return this;
    }
}

