/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.network.implementation;

import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureServiceCall;
import com.microsoft.azure.AzureServiceResponseBuilder;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.network.implementation.NetworkManagementClientImpl;
import com.microsoft.azure.management.network.implementation.PageImpl;
import com.microsoft.azure.management.network.implementation.PublicIPAddressInner;
import com.microsoft.rest.ServiceCall;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.Validator;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.HTTP;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.PUT;
import retrofit2.http.Path;
import retrofit2.http.Query;
import rx.Observable;
import rx.functions.Func1;

public final class PublicIPAddressesInner {
    private PublicIPAddressesService service;
    private NetworkManagementClientImpl client;

    public PublicIPAddressesInner(Retrofit retrofit, NetworkManagementClientImpl client) {
        this.service = (PublicIPAddressesService)retrofit.create(PublicIPAddressesService.class);
        this.client = client;
    }

    public void delete(String resourceGroupName, String publicIpAddressName) {
        ((ServiceResponse)this.deleteWithServiceResponseAsync(resourceGroupName, publicIpAddressName).toBlocking().last()).getBody();
    }

    public ServiceCall<Void> deleteAsync(String resourceGroupName, String publicIpAddressName, ServiceCallback<Void> serviceCallback) {
        return ServiceCall.create(this.deleteWithServiceResponseAsync(resourceGroupName, publicIpAddressName), serviceCallback);
    }

    public Observable<Void> deleteAsync(String resourceGroupName, String publicIpAddressName) {
        return this.deleteWithServiceResponseAsync(resourceGroupName, publicIpAddressName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.getBody();
            }
        });
    }

    public Observable<ServiceResponse<Void>> deleteWithServiceResponseAsync(String resourceGroupName, String publicIpAddressName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (publicIpAddressName == null) {
            throw new IllegalArgumentException("Parameter publicIpAddressName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2016-09-01";
        Observable<Response<ResponseBody>> observable = this.service.delete(resourceGroupName, publicIpAddressName, this.client.subscriptionId(), "2016-09-01", this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<Void>(){}.getType());
    }

    public void beginDelete(String resourceGroupName, String publicIpAddressName) {
        ((ServiceResponse)this.beginDeleteWithServiceResponseAsync(resourceGroupName, publicIpAddressName).toBlocking().single()).getBody();
    }

    public ServiceCall<Void> beginDeleteAsync(String resourceGroupName, String publicIpAddressName, ServiceCallback<Void> serviceCallback) {
        return ServiceCall.create(this.beginDeleteWithServiceResponseAsync(resourceGroupName, publicIpAddressName), serviceCallback);
    }

    public Observable<Void> beginDeleteAsync(String resourceGroupName, String publicIpAddressName) {
        return this.beginDeleteWithServiceResponseAsync(resourceGroupName, publicIpAddressName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.getBody();
            }
        });
    }

    public Observable<ServiceResponse<Void>> beginDeleteWithServiceResponseAsync(String resourceGroupName, String publicIpAddressName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (publicIpAddressName == null) {
            throw new IllegalArgumentException("Parameter publicIpAddressName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2016-09-01";
        return this.service.beginDelete(resourceGroupName, publicIpAddressName, this.client.subscriptionId(), "2016-09-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = PublicIPAddressesInner.this.beginDeleteDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> beginDeleteDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return new AzureServiceResponseBuilder(this.client.mapperAdapter()).register(204, new TypeToken<Void>(){}.getType()).register(202, new TypeToken<Void>(){}.getType()).register(200, new TypeToken<Void>(){}.getType()).build(response);
    }

    public PublicIPAddressInner get(String resourceGroupName, String publicIpAddressName) {
        return (PublicIPAddressInner)((Object)((ServiceResponse)this.getWithServiceResponseAsync(resourceGroupName, publicIpAddressName).toBlocking().single()).getBody());
    }

    public ServiceCall<PublicIPAddressInner> getAsync(String resourceGroupName, String publicIpAddressName, ServiceCallback<PublicIPAddressInner> serviceCallback) {
        return ServiceCall.create(this.getWithServiceResponseAsync(resourceGroupName, publicIpAddressName), serviceCallback);
    }

    public Observable<PublicIPAddressInner> getAsync(String resourceGroupName, String publicIpAddressName) {
        return this.getWithServiceResponseAsync(resourceGroupName, publicIpAddressName).map((Func1)new Func1<ServiceResponse<PublicIPAddressInner>, PublicIPAddressInner>(){

            public PublicIPAddressInner call(ServiceResponse<PublicIPAddressInner> response) {
                return (PublicIPAddressInner)((Object)response.getBody());
            }
        });
    }

    public Observable<ServiceResponse<PublicIPAddressInner>> getWithServiceResponseAsync(String resourceGroupName, String publicIpAddressName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (publicIpAddressName == null) {
            throw new IllegalArgumentException("Parameter publicIpAddressName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2016-09-01";
        String expand = null;
        return this.service.get(resourceGroupName, publicIpAddressName, this.client.subscriptionId(), "2016-09-01", expand, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<PublicIPAddressInner>>>(){

            public Observable<ServiceResponse<PublicIPAddressInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = PublicIPAddressesInner.this.getDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    public PublicIPAddressInner get(String resourceGroupName, String publicIpAddressName, String expand) {
        return (PublicIPAddressInner)((Object)((ServiceResponse)this.getWithServiceResponseAsync(resourceGroupName, publicIpAddressName, expand).toBlocking().single()).getBody());
    }

    public ServiceCall<PublicIPAddressInner> getAsync(String resourceGroupName, String publicIpAddressName, String expand, ServiceCallback<PublicIPAddressInner> serviceCallback) {
        return ServiceCall.create(this.getWithServiceResponseAsync(resourceGroupName, publicIpAddressName, expand), serviceCallback);
    }

    public Observable<PublicIPAddressInner> getAsync(String resourceGroupName, String publicIpAddressName, String expand) {
        return this.getWithServiceResponseAsync(resourceGroupName, publicIpAddressName, expand).map((Func1)new Func1<ServiceResponse<PublicIPAddressInner>, PublicIPAddressInner>(){

            public PublicIPAddressInner call(ServiceResponse<PublicIPAddressInner> response) {
                return (PublicIPAddressInner)((Object)response.getBody());
            }
        });
    }

    public Observable<ServiceResponse<PublicIPAddressInner>> getWithServiceResponseAsync(String resourceGroupName, String publicIpAddressName, String expand) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (publicIpAddressName == null) {
            throw new IllegalArgumentException("Parameter publicIpAddressName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2016-09-01";
        return this.service.get(resourceGroupName, publicIpAddressName, this.client.subscriptionId(), "2016-09-01", expand, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<PublicIPAddressInner>>>(){

            public Observable<ServiceResponse<PublicIPAddressInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = PublicIPAddressesInner.this.getDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PublicIPAddressInner> getDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return new AzureServiceResponseBuilder(this.client.mapperAdapter()).register(200, new TypeToken<PublicIPAddressInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PublicIPAddressInner createOrUpdate(String resourceGroupName, String publicIpAddressName, PublicIPAddressInner parameters) {
        return (PublicIPAddressInner)((Object)((ServiceResponse)this.createOrUpdateWithServiceResponseAsync(resourceGroupName, publicIpAddressName, parameters).toBlocking().last()).getBody());
    }

    public ServiceCall<PublicIPAddressInner> createOrUpdateAsync(String resourceGroupName, String publicIpAddressName, PublicIPAddressInner parameters, ServiceCallback<PublicIPAddressInner> serviceCallback) {
        return ServiceCall.create(this.createOrUpdateWithServiceResponseAsync(resourceGroupName, publicIpAddressName, parameters), serviceCallback);
    }

    public Observable<PublicIPAddressInner> createOrUpdateAsync(String resourceGroupName, String publicIpAddressName, PublicIPAddressInner parameters) {
        return this.createOrUpdateWithServiceResponseAsync(resourceGroupName, publicIpAddressName, parameters).map((Func1)new Func1<ServiceResponse<PublicIPAddressInner>, PublicIPAddressInner>(){

            public PublicIPAddressInner call(ServiceResponse<PublicIPAddressInner> response) {
                return (PublicIPAddressInner)((Object)response.getBody());
            }
        });
    }

    public Observable<ServiceResponse<PublicIPAddressInner>> createOrUpdateWithServiceResponseAsync(String resourceGroupName, String publicIpAddressName, PublicIPAddressInner parameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (publicIpAddressName == null) {
            throw new IllegalArgumentException("Parameter publicIpAddressName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        Validator.validate((Object)((Object)parameters));
        String apiVersion = "2016-09-01";
        Observable<Response<ResponseBody>> observable = this.service.createOrUpdate(resourceGroupName, publicIpAddressName, this.client.subscriptionId(), parameters, "2016-09-01", this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<PublicIPAddressInner>(){}.getType());
    }

    public PublicIPAddressInner beginCreateOrUpdate(String resourceGroupName, String publicIpAddressName, PublicIPAddressInner parameters) {
        return (PublicIPAddressInner)((Object)((ServiceResponse)this.beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, publicIpAddressName, parameters).toBlocking().single()).getBody());
    }

    public ServiceCall<PublicIPAddressInner> beginCreateOrUpdateAsync(String resourceGroupName, String publicIpAddressName, PublicIPAddressInner parameters, ServiceCallback<PublicIPAddressInner> serviceCallback) {
        return ServiceCall.create(this.beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, publicIpAddressName, parameters), serviceCallback);
    }

    public Observable<PublicIPAddressInner> beginCreateOrUpdateAsync(String resourceGroupName, String publicIpAddressName, PublicIPAddressInner parameters) {
        return this.beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, publicIpAddressName, parameters).map((Func1)new Func1<ServiceResponse<PublicIPAddressInner>, PublicIPAddressInner>(){

            public PublicIPAddressInner call(ServiceResponse<PublicIPAddressInner> response) {
                return (PublicIPAddressInner)((Object)response.getBody());
            }
        });
    }

    public Observable<ServiceResponse<PublicIPAddressInner>> beginCreateOrUpdateWithServiceResponseAsync(String resourceGroupName, String publicIpAddressName, PublicIPAddressInner parameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (publicIpAddressName == null) {
            throw new IllegalArgumentException("Parameter publicIpAddressName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        Validator.validate((Object)((Object)parameters));
        String apiVersion = "2016-09-01";
        return this.service.beginCreateOrUpdate(resourceGroupName, publicIpAddressName, this.client.subscriptionId(), parameters, "2016-09-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<PublicIPAddressInner>>>(){

            public Observable<ServiceResponse<PublicIPAddressInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = PublicIPAddressesInner.this.beginCreateOrUpdateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PublicIPAddressInner> beginCreateOrUpdateDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return new AzureServiceResponseBuilder(this.client.mapperAdapter()).register(201, new TypeToken<PublicIPAddressInner>(){}.getType()).register(200, new TypeToken<PublicIPAddressInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<PublicIPAddressInner> listAll() {
        ServiceResponse response = (ServiceResponse)this.listAllSinglePageAsync().toBlocking().single();
        return new PagedList<PublicIPAddressInner>((Page)response.getBody()){

            public Page<PublicIPAddressInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)PublicIPAddressesInner.this.listAllNextSinglePageAsync(nextPageLink).toBlocking().single()).getBody();
            }
        };
    }

    public ServiceCall<List<PublicIPAddressInner>> listAllAsync(ListOperationCallback<PublicIPAddressInner> serviceCallback) {
        return AzureServiceCall.create(this.listAllSinglePageAsync(), (Func1)new Func1<String, Observable<ServiceResponse<Page<PublicIPAddressInner>>>>(){

            public Observable<ServiceResponse<Page<PublicIPAddressInner>>> call(String nextPageLink) {
                return PublicIPAddressesInner.this.listAllNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<PublicIPAddressInner>> listAllAsync() {
        return this.listAllWithServiceResponseAsync().map((Func1)new Func1<ServiceResponse<Page<PublicIPAddressInner>>, Page<PublicIPAddressInner>>(){

            public Page<PublicIPAddressInner> call(ServiceResponse<Page<PublicIPAddressInner>> response) {
                return (Page)response.getBody();
            }
        });
    }

    public Observable<ServiceResponse<Page<PublicIPAddressInner>>> listAllWithServiceResponseAsync() {
        return this.listAllSinglePageAsync().concatMap((Func1)new Func1<ServiceResponse<Page<PublicIPAddressInner>>, Observable<ServiceResponse<Page<PublicIPAddressInner>>>>(){

            public Observable<ServiceResponse<Page<PublicIPAddressInner>>> call(ServiceResponse<Page<PublicIPAddressInner>> page) {
                String nextPageLink = ((Page)page.getBody()).getNextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(PublicIPAddressesInner.this.listAllNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<PublicIPAddressInner>>> listAllSinglePageAsync() {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2016-09-01";
        return this.service.listAll(this.client.subscriptionId(), "2016-09-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<PublicIPAddressInner>>>>(){

            public Observable<ServiceResponse<Page<PublicIPAddressInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = PublicIPAddressesInner.this.listAllDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.getBody(), result.getResponse()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<PublicIPAddressInner>> listAllDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return new AzureServiceResponseBuilder(this.client.mapperAdapter()).register(200, new TypeToken<PageImpl<PublicIPAddressInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<PublicIPAddressInner> list(String resourceGroupName) {
        ServiceResponse response = (ServiceResponse)this.listSinglePageAsync(resourceGroupName).toBlocking().single();
        return new PagedList<PublicIPAddressInner>((Page)response.getBody()){

            public Page<PublicIPAddressInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)PublicIPAddressesInner.this.listNextSinglePageAsync(nextPageLink).toBlocking().single()).getBody();
            }
        };
    }

    public ServiceCall<List<PublicIPAddressInner>> listAsync(String resourceGroupName, ListOperationCallback<PublicIPAddressInner> serviceCallback) {
        return AzureServiceCall.create(this.listSinglePageAsync(resourceGroupName), (Func1)new Func1<String, Observable<ServiceResponse<Page<PublicIPAddressInner>>>>(){

            public Observable<ServiceResponse<Page<PublicIPAddressInner>>> call(String nextPageLink) {
                return PublicIPAddressesInner.this.listNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<PublicIPAddressInner>> listAsync(String resourceGroupName) {
        return this.listWithServiceResponseAsync(resourceGroupName).map((Func1)new Func1<ServiceResponse<Page<PublicIPAddressInner>>, Page<PublicIPAddressInner>>(){

            public Page<PublicIPAddressInner> call(ServiceResponse<Page<PublicIPAddressInner>> response) {
                return (Page)response.getBody();
            }
        });
    }

    public Observable<ServiceResponse<Page<PublicIPAddressInner>>> listWithServiceResponseAsync(String resourceGroupName) {
        return this.listSinglePageAsync(resourceGroupName).concatMap((Func1)new Func1<ServiceResponse<Page<PublicIPAddressInner>>, Observable<ServiceResponse<Page<PublicIPAddressInner>>>>(){

            public Observable<ServiceResponse<Page<PublicIPAddressInner>>> call(ServiceResponse<Page<PublicIPAddressInner>> page) {
                String nextPageLink = ((Page)page.getBody()).getNextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(PublicIPAddressesInner.this.listNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<PublicIPAddressInner>>> listSinglePageAsync(String resourceGroupName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2016-09-01";
        return this.service.list(resourceGroupName, this.client.subscriptionId(), "2016-09-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<PublicIPAddressInner>>>>(){

            public Observable<ServiceResponse<Page<PublicIPAddressInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = PublicIPAddressesInner.this.listDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.getBody(), result.getResponse()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<PublicIPAddressInner>> listDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return new AzureServiceResponseBuilder(this.client.mapperAdapter()).register(200, new TypeToken<PageImpl<PublicIPAddressInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<PublicIPAddressInner> listAllNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listAllNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<PublicIPAddressInner>((Page)response.getBody()){

            public Page<PublicIPAddressInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)PublicIPAddressesInner.this.listAllNextSinglePageAsync(nextPageLink).toBlocking().single()).getBody();
            }
        };
    }

    public ServiceCall<List<PublicIPAddressInner>> listAllNextAsync(String nextPageLink, ServiceCall<List<PublicIPAddressInner>> serviceCall, ListOperationCallback<PublicIPAddressInner> serviceCallback) {
        return AzureServiceCall.create(this.listAllNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<PublicIPAddressInner>>>>(){

            public Observable<ServiceResponse<Page<PublicIPAddressInner>>> call(String nextPageLink) {
                return PublicIPAddressesInner.this.listAllNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<PublicIPAddressInner>> listAllNextAsync(String nextPageLink) {
        return this.listAllNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<PublicIPAddressInner>>, Page<PublicIPAddressInner>>(){

            public Page<PublicIPAddressInner> call(ServiceResponse<Page<PublicIPAddressInner>> response) {
                return (Page)response.getBody();
            }
        });
    }

    public Observable<ServiceResponse<Page<PublicIPAddressInner>>> listAllNextWithServiceResponseAsync(String nextPageLink) {
        return this.listAllNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<PublicIPAddressInner>>, Observable<ServiceResponse<Page<PublicIPAddressInner>>>>(){

            public Observable<ServiceResponse<Page<PublicIPAddressInner>>> call(ServiceResponse<Page<PublicIPAddressInner>> page) {
                String nextPageLink = ((Page)page.getBody()).getNextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(PublicIPAddressesInner.this.listAllNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<PublicIPAddressInner>>> listAllNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        return this.service.listAllNext(nextPageLink, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<PublicIPAddressInner>>>>(){

            public Observable<ServiceResponse<Page<PublicIPAddressInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = PublicIPAddressesInner.this.listAllNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.getBody(), result.getResponse()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<PublicIPAddressInner>> listAllNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return new AzureServiceResponseBuilder(this.client.mapperAdapter()).register(200, new TypeToken<PageImpl<PublicIPAddressInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<PublicIPAddressInner> listNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<PublicIPAddressInner>((Page)response.getBody()){

            public Page<PublicIPAddressInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)PublicIPAddressesInner.this.listNextSinglePageAsync(nextPageLink).toBlocking().single()).getBody();
            }
        };
    }

    public ServiceCall<List<PublicIPAddressInner>> listNextAsync(String nextPageLink, ServiceCall<List<PublicIPAddressInner>> serviceCall, ListOperationCallback<PublicIPAddressInner> serviceCallback) {
        return AzureServiceCall.create(this.listNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<PublicIPAddressInner>>>>(){

            public Observable<ServiceResponse<Page<PublicIPAddressInner>>> call(String nextPageLink) {
                return PublicIPAddressesInner.this.listNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<PublicIPAddressInner>> listNextAsync(String nextPageLink) {
        return this.listNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<PublicIPAddressInner>>, Page<PublicIPAddressInner>>(){

            public Page<PublicIPAddressInner> call(ServiceResponse<Page<PublicIPAddressInner>> response) {
                return (Page)response.getBody();
            }
        });
    }

    public Observable<ServiceResponse<Page<PublicIPAddressInner>>> listNextWithServiceResponseAsync(String nextPageLink) {
        return this.listNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<PublicIPAddressInner>>, Observable<ServiceResponse<Page<PublicIPAddressInner>>>>(){

            public Observable<ServiceResponse<Page<PublicIPAddressInner>>> call(ServiceResponse<Page<PublicIPAddressInner>> page) {
                String nextPageLink = ((Page)page.getBody()).getNextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(PublicIPAddressesInner.this.listNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<PublicIPAddressInner>>> listNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        return this.service.listNext(nextPageLink, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<PublicIPAddressInner>>>>(){

            public Observable<ServiceResponse<Page<PublicIPAddressInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = PublicIPAddressesInner.this.listNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.getBody(), result.getResponse()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<PublicIPAddressInner>> listNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return new AzureServiceResponseBuilder(this.client.mapperAdapter()).register(200, new TypeToken<PageImpl<PublicIPAddressInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    static interface PublicIPAddressesService {
        @Headers(value={"Content-Type: application/json; charset=utf-8"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/publicIPAddresses/{publicIpAddressName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> delete(@Path(value="resourceGroupName") String var1, @Path(value="publicIpAddressName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/publicIPAddresses/{publicIpAddressName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> beginDelete(@Path(value="resourceGroupName") String var1, @Path(value="publicIpAddressName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/publicIPAddresses/{publicIpAddressName}")
        public Observable<Response<ResponseBody>> get(@Path(value="resourceGroupName") String var1, @Path(value="publicIpAddressName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Query(value="$expand") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/publicIPAddresses/{publicIpAddressName}")
        public Observable<Response<ResponseBody>> createOrUpdate(@Path(value="resourceGroupName") String var1, @Path(value="publicIpAddressName") String var2, @Path(value="subscriptionId") String var3, @Body PublicIPAddressInner var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/publicIPAddresses/{publicIpAddressName}")
        public Observable<Response<ResponseBody>> beginCreateOrUpdate(@Path(value="resourceGroupName") String var1, @Path(value="publicIpAddressName") String var2, @Path(value="subscriptionId") String var3, @Body PublicIPAddressInner var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8"})
        @GET(value="subscriptions/{subscriptionId}/providers/Microsoft.Network/publicIPAddresses")
        public Observable<Response<ResponseBody>> listAll(@Path(value="subscriptionId") String var1, @Query(value="api-version") String var2, @Header(value="accept-language") String var3, @Header(value="User-Agent") String var4);

        @Headers(value={"Content-Type: application/json; charset=utf-8"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/publicIPAddresses")
        public Observable<Response<ResponseBody>> list(@Path(value="resourceGroupName") String var1, @Path(value="subscriptionId") String var2, @Query(value="api-version") String var3, @Header(value="accept-language") String var4, @Header(value="User-Agent") String var5);

        @Headers(value={"Content-Type: application/json; charset=utf-8"})
        @GET(value="{nextLink}")
        public Observable<Response<ResponseBody>> listAllNext(@Path(value="nextLink", encoded=true) String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);

        @Headers(value={"Content-Type: application/json; charset=utf-8"})
        @GET(value="{nextLink}")
        public Observable<Response<ResponseBody>> listNext(@Path(value="nextLink", encoded=true) String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);
    }
}

