/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.network.implementation;

import com.microsoft.azure.Resource;
import com.microsoft.azure.management.apigeneration.LangDefinition;
import com.microsoft.azure.management.network.Route;
import com.microsoft.azure.management.network.RouteNextHopType;
import com.microsoft.azure.management.network.RouteTable;
import com.microsoft.azure.management.network.Subnet;
import com.microsoft.azure.management.network.implementation.NetworkManager;
import com.microsoft.azure.management.network.implementation.RouteImpl;
import com.microsoft.azure.management.network.implementation.RouteInner;
import com.microsoft.azure.management.network.implementation.RouteTableInner;
import com.microsoft.azure.management.network.implementation.RouteTablesInner;
import com.microsoft.azure.management.resources.fluentcore.arm.implementation.ManagerBase;
import com.microsoft.azure.management.resources.fluentcore.arm.models.implementation.GroupableParentResourceImpl;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import rx.Observable;

@LangDefinition
class RouteTableImpl
extends GroupableParentResourceImpl<RouteTable, RouteTableInner, RouteTableImpl, NetworkManager>
implements RouteTable,
RouteTable.Definition,
RouteTable.Update {
    private final RouteTablesInner innerCollection;
    private Map<String, Route> routes;

    RouteTableImpl(String name, RouteTableInner innerModel, RouteTablesInner innerCollection, NetworkManager networkManager) {
        super(name, (Resource)innerModel, (ManagerBase)networkManager);
        this.innerCollection = innerCollection;
    }

    protected void initializeChildrenFromInner() {
        this.routes = new TreeMap<String, Route>();
        List<RouteInner> inners = ((RouteTableInner)((Object)this.inner())).routes();
        if (inners != null) {
            for (RouteInner inner : inners) {
                RouteImpl route = new RouteImpl(inner, this);
                this.routes.put(inner.name(), route);
            }
        }
    }

    public RouteTableImpl refresh() {
        RouteTableInner inner = this.innerCollection.get(this.resourceGroupName(), this.name());
        this.setInner((Object)inner);
        this.initializeChildrenFromInner();
        return this;
    }

    @Override
    public List<Subnet> listAssociatedSubnets() {
        return ((NetworkManager)this.myManager).listAssociatedSubnets(((RouteTableInner)((Object)this.inner())).subnets());
    }

    public RouteImpl defineRoute(String name) {
        RouteInner inner = new RouteInner().withName(name);
        return new RouteImpl(inner, this);
    }

    @Override
    public RouteImpl updateRoute(String name) {
        return (RouteImpl)this.routes.get(name);
    }

    @Override
    public RouteTable.Update withoutRoute(String name) {
        this.routes.remove(name);
        return this;
    }

    @Override
    public RouteTableImpl withRoute(String destinationAddressPrefix, RouteNextHopType nextHop) {
        return this.defineRoute("route_" + this.name() + System.currentTimeMillis()).withDestinationAddressPrefix(destinationAddressPrefix).withNextHop(nextHop).attach();
    }

    @Override
    public RouteTableImpl withRouteViaVirtualAppliance(String destinationAddressPrefix, String ipAddress) {
        return this.defineRoute("route_" + this.name() + System.currentTimeMillis()).withDestinationAddressPrefix(destinationAddressPrefix).withNextHopToVirtualAppliance(ipAddress).attach();
    }

    RouteTableImpl withRoute(RouteImpl route) {
        this.routes.put(route.name(), route);
        return this;
    }

    NetworkManager manager() {
        return (NetworkManager)this.myManager;
    }

    protected void beforeCreating() {
        ((RouteTableInner)((Object)this.inner())).withRoutes(this.innersFromWrappers(this.routes.values()));
    }

    protected void afterCreating() {
        this.initializeChildrenFromInner();
    }

    protected Observable<RouteTableInner> createInner() {
        return this.innerCollection.createOrUpdateAsync(this.resourceGroupName(), this.name(), (RouteTableInner)((Object)this.inner()));
    }

    @Override
    public Map<String, Route> routes() {
        return Collections.unmodifiableMap(this.routes);
    }
}

