/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.network.implementation;

import com.microsoft.azure.Resource;
import com.microsoft.azure.management.network.IPAllocationMethod;
import com.microsoft.azure.management.network.NetworkSecurityGroup;
import com.microsoft.azure.management.network.VirtualMachineScaleSetNetworkInterface;
import com.microsoft.azure.management.network.VirtualMachineScaleSetNicIpConfiguration;
import com.microsoft.azure.management.network.implementation.NetworkInterfaceIPConfigurationInner;
import com.microsoft.azure.management.network.implementation.NetworkInterfaceInner;
import com.microsoft.azure.management.network.implementation.NetworkInterfacesInner;
import com.microsoft.azure.management.network.implementation.NetworkManager;
import com.microsoft.azure.management.network.implementation.VirtualMachineScaleSetNicIpConfigurationImpl;
import com.microsoft.azure.management.resources.fluentcore.arm.ResourceUtils;
import com.microsoft.azure.management.resources.fluentcore.arm.models.implementation.ResourceImpl;
import com.microsoft.azure.management.resources.fluentcore.utils.Utils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import rx.Observable;

class VirtualMachineScaleSetNetworkInterfaceImpl
extends ResourceImpl<VirtualMachineScaleSetNetworkInterface, NetworkInterfaceInner, VirtualMachineScaleSetNetworkInterfaceImpl>
implements VirtualMachineScaleSetNetworkInterface {
    private final NetworkInterfacesInner client;
    private final NetworkManager networkManager;
    private final String scaleSetName;
    private final String resourceGroupName;

    VirtualMachineScaleSetNetworkInterfaceImpl(String name, String scaleSetName, String resourceGroupName, NetworkInterfaceInner innerObject, NetworkInterfacesInner client, NetworkManager networkManager) {
        super(name, (Resource)innerObject);
        this.scaleSetName = scaleSetName;
        this.resourceGroupName = resourceGroupName;
        this.client = client;
        this.networkManager = networkManager;
    }

    @Override
    public boolean isIpForwardingEnabled() {
        return Utils.toPrimitiveBoolean((Boolean)((NetworkInterfaceInner)((Object)this.inner())).enableIPForwarding());
    }

    @Override
    public String macAddress() {
        return ((NetworkInterfaceInner)((Object)this.inner())).macAddress();
    }

    @Override
    public String internalDnsNameLabel() {
        if (((NetworkInterfaceInner)((Object)this.inner())).dnsSettings() == null) {
            return null;
        }
        return ((NetworkInterfaceInner)((Object)this.inner())).dnsSettings().internalDnsNameLabel();
    }

    @Override
    public String internalFqdn() {
        if (((NetworkInterfaceInner)((Object)this.inner())).dnsSettings() == null) {
            return null;
        }
        return ((NetworkInterfaceInner)((Object)this.inner())).dnsSettings().internalFqdn();
    }

    @Override
    public String internalDomainNameSuffix() {
        if (((NetworkInterfaceInner)((Object)this.inner())).dnsSettings() == null) {
            return null;
        }
        return ((NetworkInterfaceInner)((Object)this.inner())).dnsSettings().internalDomainNameSuffix();
    }

    @Override
    public List<String> dnsServers() {
        if (((NetworkInterfaceInner)((Object)this.inner())).dnsSettings() == null || ((NetworkInterfaceInner)((Object)this.inner())).dnsSettings().dnsServers() == null) {
            return Collections.unmodifiableList(new ArrayList());
        }
        return Collections.unmodifiableList(((NetworkInterfaceInner)((Object)this.inner())).dnsSettings().dnsServers());
    }

    @Override
    public List<String> appliedDnsServers() {
        ArrayList dnsServers = new ArrayList();
        if (((NetworkInterfaceInner)((Object)this.inner())).dnsSettings() == null || ((NetworkInterfaceInner)((Object)this.inner())).dnsSettings().appliedDnsServers() == null) {
            return Collections.unmodifiableList(dnsServers);
        }
        return Collections.unmodifiableList(((NetworkInterfaceInner)((Object)this.inner())).dnsSettings().appliedDnsServers());
    }

    @Override
    public String primaryPrivateIp() {
        VirtualMachineScaleSetNicIpConfiguration primaryIpConfig = this.primaryIpConfiguration();
        if (primaryIpConfig == null) {
            return null;
        }
        return primaryIpConfig.privateIpAddress();
    }

    @Override
    public IPAllocationMethod primaryPrivateIpAllocationMethod() {
        VirtualMachineScaleSetNicIpConfiguration primaryIpConfig = this.primaryIpConfiguration();
        if (primaryIpConfig == null) {
            return null;
        }
        return primaryIpConfig.privateIpAllocationMethod();
    }

    @Override
    public Map<String, VirtualMachineScaleSetNicIpConfiguration> ipConfigurations() {
        List<NetworkInterfaceIPConfigurationInner> inners = ((NetworkInterfaceInner)((Object)this.inner())).ipConfigurations();
        if (inners == null || inners.size() == 0) {
            return Collections.unmodifiableMap(new TreeMap());
        }
        TreeMap<String, VirtualMachineScaleSetNicIpConfigurationImpl> nicIpConfigurations = new TreeMap<String, VirtualMachineScaleSetNicIpConfigurationImpl>();
        for (NetworkInterfaceIPConfigurationInner inner : inners) {
            VirtualMachineScaleSetNicIpConfigurationImpl nicIpConfiguration = new VirtualMachineScaleSetNicIpConfigurationImpl(inner, this, this.networkManager);
            nicIpConfigurations.put(nicIpConfiguration.name(), nicIpConfiguration);
        }
        return Collections.unmodifiableMap(nicIpConfigurations);
    }

    @Override
    public VirtualMachineScaleSetNicIpConfiguration primaryIpConfiguration() {
        for (VirtualMachineScaleSetNicIpConfiguration ipConfiguration : this.ipConfigurations().values()) {
            if (!ipConfiguration.isPrimary()) continue;
            return ipConfiguration;
        }
        return null;
    }

    @Override
    public String networkSecurityGroupId() {
        if (((NetworkInterfaceInner)((Object)this.inner())).networkSecurityGroup() == null) {
            return null;
        }
        return ((NetworkInterfaceInner)((Object)this.inner())).networkSecurityGroup().id();
    }

    @Override
    public NetworkSecurityGroup getNetworkSecurityGroup() {
        String nsgId = this.networkSecurityGroupId();
        if (nsgId == null) {
            return null;
        }
        return (NetworkSecurityGroup)this.networkManager.networkSecurityGroups().getByGroup(ResourceUtils.groupFromResourceId((String)nsgId), ResourceUtils.nameFromResourceId((String)nsgId));
    }

    @Override
    public String virtualMachineId() {
        if (((NetworkInterfaceInner)((Object)this.inner())).virtualMachine() == null) {
            return null;
        }
        return ((NetworkInterfaceInner)((Object)this.inner())).virtualMachine().id();
    }

    public Observable<VirtualMachineScaleSetNetworkInterface> createResourceAsync() {
        throw new UnsupportedOperationException();
    }

    public VirtualMachineScaleSetNetworkInterface refresh() {
        this.setInner((Object)this.client.getVirtualMachineScaleSetNetworkInterface(this.resourceGroupName, this.scaleSetName, ResourceUtils.nameFromResourceId((String)this.virtualMachineId()), this.name()));
        return this;
    }
}

