/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.server;

import com.networknt.client.Http2Client;
import com.networknt.server.IConfigLoader;
import com.networknt.server.Server;
import com.networknt.utility.Util;
import io.undertow.UndertowOptions;
import io.undertow.client.ClientConnection;
import io.undertow.client.ClientRequest;
import io.undertow.client.ClientResponse;
import io.undertow.util.Headers;
import io.undertow.util.Methods;
import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Enumeration;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicReference;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnio.IoUtils;
import org.xnio.Option;
import org.xnio.OptionMap;

public class DefaultConfigLoader
implements IConfigLoader {
    static final Logger logger = LoggerFactory.getLogger(Server.class);
    static final String LIGHT_CONFIG_SERVER_URI = "light-config-server-uri";
    public static final String DEFAULT_ENV = "test";
    public static String lightEnv = System.getProperty("light-env");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void init() {
        String configUri;
        if (lightEnv == null) {
            logger.warn("Warning! No light-env has been passed in from command line. Defaulting to {}", (Object)DEFAULT_ENV);
            lightEnv = DEFAULT_ENV;
        }
        if ((configUri = System.getProperty(LIGHT_CONFIG_SERVER_URI)) != null) {
            String targetMergeDirectory = System.getProperty("light-4j-config-dir");
            if (targetMergeDirectory == null) {
                logger.warn("Warning! No light-4j-config-dir has been passed in from command line.");
                return;
            }
            String version = Util.getJarVersion();
            String service = Server.config.getServiceId();
            String tempDir = System.getProperty("java.io.tmpdir");
            String zipFile = tempDir + "/config.zip";
            String path = "/v1/config/" + version + "/" + lightEnv + "/" + service;
            Http2Client client = Http2Client.getInstance();
            ClientConnection connection = null;
            try {
                connection = (ClientConnection)client.connect(new URI(configUri), Http2Client.WORKER, Http2Client.SSL, Http2Client.BUFFER_POOL, OptionMap.create((Option)UndertowOptions.ENABLE_HTTP2, (Object)true)).get();
            }
            catch (Exception e) {
                logger.error("Exeption:", (Throwable)e);
            }
            CountDownLatch latch = new CountDownLatch(1);
            AtomicReference reference = new AtomicReference();
            try {
                ClientRequest request = new ClientRequest().setMethod(Methods.GET).setPath(path);
                request.getRequestHeaders().put(Headers.HOST, "localhost");
                connection.sendRequest(request, client.createClientCallback(reference, latch));
                latch.await();
                int statusCode = ((ClientResponse)reference.get()).getResponseCode();
                if (statusCode >= 300) {
                    logger.error("Failed to load config from config server" + statusCode + ":" + (String)((ClientResponse)reference.get()).getAttachment(Http2Client.RESPONSE_BODY));
                    throw new Exception("Failed to load config from config server: " + statusCode);
                }
                FileOutputStream fos = new FileOutputStream(zipFile);
                fos.write(((String)((ClientResponse)reference.get()).getAttachment(Http2Client.RESPONSE_BODY)).getBytes(StandardCharsets.UTF_8));
                fos.close();
                DefaultConfigLoader.unzipFile(zipFile, targetMergeDirectory);
            }
            catch (Exception e) {
                logger.error("Exception:", (Throwable)e);
            }
            finally {
                IoUtils.safeClose((Closeable)connection);
            }
        } else {
            logger.info("light-config-server-uri is missing in the command line. Use local config files");
        }
    }

    private static void unzipFile(String path, String target) {
        try (ZipFile file = new ZipFile(path);){
            FileSystem fileSystem = FileSystems.getDefault();
            Enumeration<? extends ZipEntry> entries = file.entries();
            Files.createDirectory(fileSystem.getPath(target, new String[0]), new FileAttribute[0]);
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                if (entry.isDirectory()) {
                    System.out.println("Creating Directory:" + target + entry.getName());
                    Files.createDirectories(fileSystem.getPath(target + entry.getName(), new String[0]), new FileAttribute[0]);
                    continue;
                }
                InputStream is = file.getInputStream(entry);
                BufferedInputStream bis = new BufferedInputStream(is);
                String uncompressedFileName = target + entry.getName();
                Path uncompressedFilePath = fileSystem.getPath(uncompressedFileName, new String[0]);
                Files.createFile(uncompressedFilePath, new FileAttribute[0]);
                FileOutputStream fileOutput = new FileOutputStream(uncompressedFileName);
                while (bis.available() > 0) {
                    fileOutput.write(bis.read());
                }
                fileOutput.close();
                System.out.println("Written :" + entry.getName());
            }
        }
        catch (IOException e) {
            logger.error("IOException", (Throwable)e);
        }
    }
}

