/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.server;

import com.networknt.config.Config;
import com.networknt.handler.Handler;
import com.networknt.handler.HandlerProvider;
import com.networknt.handler.MiddlewareHandler;
import com.networknt.handler.OrchestrationHandler;
import com.networknt.registry.Registry;
import com.networknt.registry.URL;
import com.networknt.registry.URLImpl;
import com.networknt.server.DefaultConfigLoader;
import com.networknt.server.DummyTrustManager;
import com.networknt.server.IConfigLoader;
import com.networknt.server.ServerConfig;
import com.networknt.server.ServerOption;
import com.networknt.server.ShutdownHookProvider;
import com.networknt.server.StartupHookProvider;
import com.networknt.service.SingletonServiceFactory;
import com.networknt.switcher.SwitcherUtil;
import com.networknt.utility.TlsUtil;
import com.networknt.utility.Util;
import io.undertow.Handlers;
import io.undertow.Undertow;
import io.undertow.UndertowOptions;
import io.undertow.server.HttpHandler;
import io.undertow.server.handlers.GracefulShutdownHandler;
import java.net.InetAddress;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ThreadLocalRandom;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.xnio.Options;
import org.xnio.SslClientAuthMode;

public class Server {
    static final Logger logger = LoggerFactory.getLogger(Server.class);
    public static final String SERVER_CONFIG_NAME = "server";
    public static final String SECRET_CONFIG_NAME = "secret";
    public static final String STARTUP_CONFIG_NAME = "startup";
    public static final String CONFIG_LOADER_CLASS = "configLoaderClass";
    public static final String[] STATUS_CONFIG_NAME = new String[]{"status", "app-status"};
    public static final String ENV_PROPERTY_KEY = "environment";
    static final String STATUS_HOST_IP = "STATUS_HOST_IP";
    static final String SID = "sId";
    @Deprecated
    public static ServerConfig config = Server.getServerConfig();
    public static final TrustManager[] TRUST_ALL_CERTS = new X509TrustManager[]{new DummyTrustManager()};
    public static List<String> serviceIds = new ArrayList<String>();
    public static List<URL> serviceUrls;
    protected static boolean shutdownRequested;
    static Undertow server;
    static Registry registry;
    static SSLContext sslContext;
    static GracefulShutdownHandler gracefulShutdownHandler;
    private static Set usedPorts;

    public static void main(String[] args) {
        Server.init();
    }

    public static void init() {
        logger.info("server starts");
        System.setProperty("org.jboss.logging.provider", "slf4j");
        try {
            Server.loadConfigs();
            MDC.put((String)SID, (String)config.getServiceId());
            Server.mergeStatusConfig();
            Server.start();
        }
        catch (RuntimeException e) {
            logger.error("Server is not operational! Failed with exception", (Throwable)e);
            System.out.println("Failed to start server:" + e.getMessage());
            System.exit(1);
        }
    }

    public static void loadConfigs() {
        IConfigLoader configLoader;
        Map startupConfig = Config.getInstance().getJsonMapConfig(STARTUP_CONFIG_NAME);
        if (startupConfig == null || startupConfig.get(CONFIG_LOADER_CLASS) == null) {
            configLoader = new DefaultConfigLoader();
        } else {
            try {
                Class<?> clazz = Class.forName((String)startupConfig.get(CONFIG_LOADER_CLASS));
                configLoader = (IConfigLoader)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception e) {
                throw new RuntimeException("configLoaderClass mentioned in startup.yml could not be found or constructed", e);
            }
        }
        configLoader.init();
    }

    public static void start() {
        Server.addDaemonShutdownHook();
        StartupHookProvider[] startupHookProviders = (StartupHookProvider[])SingletonServiceFactory.getBeans(StartupHookProvider.class);
        if (startupHookProviders != null) {
            Arrays.stream(startupHookProviders).forEach(s -> s.onStartup());
        }
        if (Handler.config == null || !Handler.config.isEnabled()) {
            HttpHandler handler = Server.middlewareInit();
            gracefulShutdownHandler = new GracefulShutdownHandler(handler);
        } else {
            Handler.init();
            gracefulShutdownHandler = new GracefulShutdownHandler((HttpHandler)new OrchestrationHandler());
        }
        ServerConfig serverConfig = Server.getServerConfig();
        if (serverConfig.dynamicPort) {
            if (serverConfig.minPort > serverConfig.maxPort) {
                String errMessage = "No ports available to bind to - the minPort is larger than the maxPort in server.yml";
                System.out.println(errMessage);
                logger.error(errMessage);
                throw new RuntimeException(errMessage);
            }
            int capacity = serverConfig.maxPort - serverConfig.minPort + 1;
            usedPorts = new HashSet(capacity);
            while (usedPorts.size() < capacity) {
                int randomPort = ThreadLocalRandom.current().nextInt(serverConfig.minPort, serverConfig.maxPort + 1);
                if (usedPorts.contains(randomPort)) continue;
                boolean b = Server.bind((HttpHandler)gracefulShutdownHandler, randomPort);
                if (b) {
                    usedPorts = null;
                    break;
                }
                usedPorts.add(randomPort);
            }
        } else {
            Server.bind((HttpHandler)gracefulShutdownHandler, -1);
        }
    }

    private static HttpHandler middlewareInit() {
        HttpHandler handler = null;
        HandlerProvider handlerProvider = (HandlerProvider)SingletonServiceFactory.getBean(HandlerProvider.class);
        if (handlerProvider != null) {
            handler = handlerProvider.getHandler();
        }
        if (handler == null) {
            logger.error("Unable to start the server - no route handler provider available in service.yml");
            throw new RuntimeException("Unable to start the server - no route handler provider available in service.yml");
        }
        MiddlewareHandler[] middlewareHandlers = (MiddlewareHandler[])SingletonServiceFactory.getBeans(MiddlewareHandler.class);
        if (middlewareHandlers != null) {
            for (int i = middlewareHandlers.length - 1; i >= 0; --i) {
                logger.info("Plugin: " + middlewareHandlers[i].getClass().getName());
                if (!middlewareHandlers[i].isEnabled()) continue;
                handler = middlewareHandlers[i].setNext(handler);
                middlewareHandlers[i].register();
            }
        }
        return handler;
    }

    private static void serverOptionInit() {
        Map mapConfig = Config.getInstance().getJsonMapConfigNoCache(SERVER_CONFIG_NAME);
        ServerOption.serverOptionInit(mapConfig, Server.getServerConfig());
    }

    private static boolean bind(HttpHandler handler, int port) {
        ServerConfig serverConfig = Server.getServerConfig();
        try {
            Undertow.Builder builder = Undertow.builder();
            if (serverConfig.enableHttps) {
                port = port < 0 ? serverConfig.getHttpsPort() : port;
                sslContext = Server.createSSLContext();
                builder.addHttpsListener(port, serverConfig.getIp(), sslContext);
            } else if (serverConfig.enableHttp) {
                port = port < 0 ? serverConfig.getHttpPort() : port;
                builder.addHttpListener(port, serverConfig.getIp());
            } else {
                throw new RuntimeException("Unable to start the server as both http and https are disabled in server.yml");
            }
            if (serverConfig.enableHttp2) {
                builder.setServerOption(UndertowOptions.ENABLE_HTTP2, (Object)true);
            }
            if (serverConfig.isEnableTwoWayTls()) {
                builder.setSocketOption(Options.SSL_CLIENT_AUTH_MODE, (Object)SslClientAuthMode.REQUIRED);
            }
            Server.serverOptionInit();
            server = builder.setBufferSize(serverConfig.getBufferSize()).setIoThreads(serverConfig.getIoThreads()).setSocketOption(Options.BACKLOG, (Object)serverConfig.getBacklog()).setServerOption(UndertowOptions.ALWAYS_SET_KEEP_ALIVE, (Object)false).setServerOption(UndertowOptions.ALWAYS_SET_DATE, (Object)serverConfig.isAlwaysSetDate()).setServerOption(UndertowOptions.RECORD_REQUEST_START_TIME, (Object)false).setServerOption(UndertowOptions.ALLOW_UNESCAPED_CHARACTERS_IN_URL, (Object)serverConfig.isAllowUnescapedCharactersInUrl()).setHandler((HttpHandler)Handlers.header((HttpHandler)handler, (String)"Server", (String)serverConfig.getServerString())).setWorkerThreads(serverConfig.getWorkerThreads()).build();
            server.start();
            System.out.println("HOST IP " + System.getenv(STATUS_HOST_IP));
        }
        catch (Exception e) {
            if (!serverConfig.dynamicPort || usedPorts.size() >= serverConfig.maxPort - serverConfig.minPort) {
                String triedPortsMessage = serverConfig.dynamicPort ? serverConfig.minPort + " to " + serverConfig.maxPort : port + "";
                String errMessage = "No ports available to bind to. Tried: " + triedPortsMessage;
                System.out.println(errMessage);
                logger.error(errMessage);
                throw new RuntimeException(errMessage, e);
            }
            System.out.println("Failed to bind to port " + port + ". Trying " + ++port);
            if (logger.isInfoEnabled()) {
                logger.info("Failed to bind to port " + port + ". Trying " + ++port);
            }
            return false;
        }
        if (serverConfig.enableRegistry) {
            serviceUrls = new ArrayList<URL>();
            serviceUrls.add(Server.register(serverConfig.getServiceId(), port));
            if (serviceIds.size() > 0) {
                for (String id : serviceIds) {
                    serviceUrls.add(Server.register(id, port));
                }
            }
            SwitcherUtil.setSwitcherValue((String)"RegistryHeartBeat", (boolean)true);
            if (logger.isInfoEnabled()) {
                logger.info("Registry heart beat switcher is on");
            }
        }
        if (serverConfig.enableHttp) {
            System.out.println("Http Server started on ip:" + serverConfig.getIp() + " Port:" + port);
            if (logger.isInfoEnabled()) {
                logger.info("Http Server started on ip:" + serverConfig.getIp() + " Port:" + port);
            }
        } else {
            System.out.println("Http port disabled.");
            if (logger.isInfoEnabled()) {
                logger.info("Http port disabled.");
            }
        }
        if (serverConfig.enableHttps) {
            System.out.println("Https Server started on ip:" + serverConfig.getIp() + " Port:" + port);
            if (logger.isInfoEnabled()) {
                logger.info("Https Server started on ip:" + serverConfig.getIp() + " Port:" + port);
            }
        } else {
            System.out.println("Https port disabled.");
            if (logger.isInfoEnabled()) {
                logger.info("Https port disabled.");
            }
        }
        return true;
    }

    public static void stop() {
        if (server != null) {
            server.stop();
        }
    }

    public static void shutdown() {
        ShutdownHookProvider[] shutdownHookProviders;
        if (Server.getServerConfig().enableRegistry && registry != null && serviceUrls != null) {
            for (URL serviceUrl : serviceUrls) {
                registry.unregister(serviceUrl);
                System.out.println("unregister serviceUrl " + serviceUrl);
                if (!logger.isInfoEnabled()) continue;
                logger.info("unregister serviceUrl " + serviceUrl);
            }
        }
        if (gracefulShutdownHandler != null) {
            logger.info("Starting graceful shutdown.");
            gracefulShutdownHandler.shutdown();
            try {
                gracefulShutdownHandler.awaitShutdown(60000L);
            }
            catch (InterruptedException e) {
                logger.error("Error occurred while waiting for pending requests to complete.", (Throwable)e);
            }
            logger.info("Graceful shutdown complete.");
        }
        if ((shutdownHookProviders = (ShutdownHookProvider[])SingletonServiceFactory.getBeans(ShutdownHookProvider.class)) != null) {
            Arrays.stream(shutdownHookProviders).forEach(s -> s.onShutdown());
        }
        Server.stop();
        logger.info("Cleaning up before server shutdown");
    }

    protected static void addDaemonShutdownHook() {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                Server.shutdown();
            }
        });
    }

    protected static KeyStore loadKeyStore() {
        Map secretConfig = Config.getInstance().getJsonMapConfig(SECRET_CONFIG_NAME);
        String name = Server.getServerConfig().getKeystoreName();
        char[] password = ((String)secretConfig.get("serverKeystorePass")).toCharArray();
        return TlsUtil.loadKeyStore((String)name, (char[])password);
    }

    protected static KeyStore loadTrustStore() {
        Map secretConfig = Config.getInstance().getJsonMapConfig(SECRET_CONFIG_NAME);
        String name = Server.getServerConfig().getTruststoreName();
        char[] password = ((String)secretConfig.get("serverTruststorePass")).toCharArray();
        return TlsUtil.loadTrustStore((String)name, (char[])password);
    }

    private static TrustManager[] buildTrustManagers(KeyStore trustStore) {
        TrustManager[] trustManagers = null;
        if (trustStore != null) {
            try {
                TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
                trustManagerFactory.init(trustStore);
                trustManagers = trustManagerFactory.getTrustManagers();
            }
            catch (KeyStoreException | NoSuchAlgorithmException e) {
                logger.error("Unable to initialise TrustManager[]", (Throwable)e);
                throw new RuntimeException("Unable to initialise TrustManager[]", e);
            }
        } else {
            trustManagers = TRUST_ALL_CERTS;
        }
        return trustManagers;
    }

    private static KeyManager[] buildKeyManagers(KeyStore keyStore, char[] keyPass) {
        KeyManager[] keyManagers;
        try {
            KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            keyManagerFactory.init(keyStore, keyPass);
            keyManagers = keyManagerFactory.getKeyManagers();
        }
        catch (KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException e) {
            logger.error("Unable to initialise KeyManager[]", (Throwable)e);
            throw new RuntimeException("Unable to initialise KeyManager[]", e);
        }
        return keyManagers;
    }

    private static SSLContext createSSLContext() throws RuntimeException {
        Map secretConfig = Config.getInstance().getJsonMapConfig(SECRET_CONFIG_NAME);
        try {
            KeyManager[] keyManagers = Server.buildKeyManagers(Server.loadKeyStore(), ((String)secretConfig.get("serverKeyPass")).toCharArray());
            TrustManager[] trustManagers = Server.getServerConfig().isEnableTwoWayTls() ? Server.buildTrustManagers(Server.loadTrustStore()) : Server.buildTrustManagers(null);
            SSLContext sslContext = SSLContext.getInstance("TLSv1");
            sslContext.init(keyManagers, trustManagers, null);
            return sslContext;
        }
        catch (Exception e) {
            logger.error("Unable to create SSLContext", (Throwable)e);
            throw new RuntimeException("Unable to create SSLContext", e);
        }
    }

    protected static void mergeStatusConfig() {
        Map appStatusConfig = Config.getInstance().getJsonMapConfigNoCache(STATUS_CONFIG_NAME[1]);
        if (appStatusConfig == null) {
            return;
        }
        Map statusConfig = Config.getInstance().getJsonMapConfig(STATUS_CONFIG_NAME[0]);
        HashSet duplicatedStatusSet = new HashSet(statusConfig.keySet());
        duplicatedStatusSet.retainAll(appStatusConfig.keySet());
        if (!duplicatedStatusSet.isEmpty()) {
            logger.error("The status code(s): " + ((Object)duplicatedStatusSet).toString() + " is already in use by light-4j and cannot be overwritten, please change to another status code in app-status.yml if necessary.");
            throw new RuntimeException("The status code(s): " + ((Object)duplicatedStatusSet).toString() + " in status.yml and app-status.yml are duplicated.");
        }
        statusConfig.putAll(appStatusConfig);
    }

    public static ServerConfig getServerConfig() {
        return (ServerConfig)Config.getInstance().getJsonObjectConfig(SERVER_CONFIG_NAME, ServerConfig.class);
    }

    public static URL register(String serviceId, int port) {
        try {
            registry = (Registry)SingletonServiceFactory.getBean(Registry.class);
            if (registry == null) {
                throw new RuntimeException("Could not find registry instance in service map");
            }
            String ipAddress = System.getenv(STATUS_HOST_IP);
            logger.info("Registry IP from STATUS_HOST_IP is " + ipAddress);
            if (ipAddress == null) {
                InetAddress inetAddress = Util.getInetAddress();
                ipAddress = inetAddress.getHostAddress();
                logger.info("Could not find IP from STATUS_HOST_IP, use the InetAddress " + ipAddress);
            }
            ServerConfig serverConfig = Server.getServerConfig();
            HashMap<String, String> parameters = new HashMap<String, String>();
            if (serverConfig.getEnvironment() != null) {
                parameters.put(ENV_PROPERTY_KEY, serverConfig.getEnvironment());
            }
            URLImpl serviceUrl = new URLImpl("light", ipAddress, port, serviceId, parameters);
            if (logger.isInfoEnabled()) {
                logger.info("register service: " + serviceUrl.toFullStr());
            }
            registry.register((URL)serviceUrl);
            return serviceUrl;
        }
        catch (Exception e) {
            System.out.println("Failed to register service, the server stopped.");
            e.printStackTrace();
            if (logger.isInfoEnabled()) {
                logger.info("Failed to register service, the server stopped.", (Throwable)e);
            }
            throw new RuntimeException(e.getMessage());
        }
    }

    static {
        shutdownRequested = false;
        server = null;
    }
}

