/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.xa.client;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;
import java.util.logging.Level;
import javax.sql.PooledConnection;
import javax.sql.XAConnection;
import javax.transaction.xa.XAException;
import oracle.jdbc.datasource.impl.OracleConnectionBuilderImpl;
import oracle.jdbc.diagnostics.SecurityLabel;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.T2CConnection;
import oracle.jdbc.driver.T4CXAConnection;
import oracle.jdbc.internal.Monitor;
import oracle.jdbc.internal.OpaqueString;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.logging.annotations.Blind;
import oracle.jdbc.logging.annotations.PropertiesBlinder;
import oracle.jdbc.pool.OraclePooledConnection;
import oracle.jdbc.xa.OracleXAConnectionBuilderImpl;
import oracle.jdbc.xa.client.OracleXAConnection;
import oracle.jdbc.xa.client.OracleXAHeteroCloseCallback;
import oracle.jdbc.xa.client.OracleXAHeteroConnection;

public class OracleXADataSource
extends oracle.jdbc.xa.OracleXADataSource {
    private static final boolean DEBUG = false;
    private int rmid = -1;
    private String xaOpenString = null;
    private static boolean libraryLoaded = false;
    private static Monitor LOAD_LIBRARY_MONITOR = Monitor.newInstance();
    private static final String dbSuffix = "HeteroXA";
    private static final String dllName = "heteroxa23";
    private static final char atSignChar = '@';
    private static int rmidSeed = 0;
    private static Monitor RMID_SEED_MONITOR = Monitor.newInstance();
    private static final int MAX_RMID_SEED = 65536;
    private String driverCharSetIdString = null;
    private String oldTnsEntry = null;

    public OracleXADataSource() throws SQLException {
        this.isOracleDataSource = true;
        this.setConnectionProperty("oracle.jdbc.enableACSupport", "false");
    }

    @Override
    public XAConnection getXAConnection() throws SQLException {
        Properties prop = new Properties(this.connectionProperties);
        if (this.user != null && this.password != null && this.password != OpaqueString.NULL) {
            prop.setProperty("user", this.user);
            prop.setProperty("password", this.password.get());
        }
        return this.getXAConnection(prop.getProperty("user"), prop.getProperty("password"));
    }

    @Override
    public XAConnection getXAConnection(String userName, @Blind String passwd) throws SQLException {
        String tempval = OracleXADataSource.getSystemProperty("oracle.jdbc.enableACSupport", null);
        if (tempval == null) {
            tempval = this.getConnectionProperty("oracle.jdbc.enableACSupport");
        }
        if (tempval == null) {
            tempval = "true";
        }
        boolean useProxy = tempval != null && tempval.equalsIgnoreCase("true");
        return this.getXAConnectionInternal((OracleXAConnectionBuilderImpl)((OracleXAConnectionBuilderImpl)this.createXAConnectionBuilder().user(userName)).password(OpaqueString.newOpaqueString(passwd)), useProxy);
    }

    @Override
    public XAConnection getXAConnection(@Blind(value=PropertiesBlinder.class) Properties prop) throws SQLException {
        return (XAConnection)this.getPooledConnection(prop);
    }

    public XAConnection getXAConnection(OracleXAConnectionBuilderImpl builder) throws SQLException {
        Properties prop = new Properties(this.connectionProperties);
        OpaqueString passwd = builder.getPassword();
        if (builder.getUser() != null && passwd != null && passwd != OpaqueString.NULL) {
            prop.setProperty("user", builder.getUser());
            prop.setProperty("password", passwd.get());
        }
        if (builder.getServiceName() != null) {
            prop.setProperty("oracle.jdbc.targetServiceName", builder.getServiceName());
        }
        if (builder.getInstanceName() != null) {
            prop.setProperty("oracle.jdbc.targetInstanceName", builder.getInstanceName());
        }
        if (builder.getShardingKey() != null) {
            String b64EncodedShardingKey = builder.getShardingKey().encodeKeyinB64Format();
            prop.setProperty("oracle.jdbc.targetShardingKey", b64EncodedShardingKey);
        }
        if (builder.getSuperShardingKey() != null) {
            String b64EncodedSuperKey = builder.getSuperShardingKey().encodeKeyinB64Format();
            prop.setProperty("oracle.jdbc.targetSuperShardingKey", b64EncodedSuperKey);
        }
        if (builder.getReadOnlyInstanceAllowed()) {
            prop.setProperty("oracle.jdbc.readOnlyInstanceAllowed", "true");
        }
        return (XAConnection)this.getPooledConnection(prop, builder);
    }

    @Override
    public OracleXAConnectionBuilderImpl createXAConnectionBuilder() {
        return new OracleXAConnectionBuilderImpl(){

            @Override
            public oracle.jdbc.datasource.OracleXAConnection build() throws SQLException {
                this.verifyBuildConfiguration();
                String tempval = OracleXADataSource.getSystemProperty("oracle.jdbc.enableACSupport", null);
                if (tempval == null) {
                    tempval = OracleXADataSource.this.getConnectionProperty("oracle.jdbc.enableACSupport");
                }
                if (tempval == null) {
                    tempval = "true";
                }
                boolean useProxy = tempval != null && tempval.equalsIgnoreCase("true");
                return (OracleXAConnection)OracleXADataSource.this.getXAConnectionInternal(this, useProxy);
            }
        };
    }

    private XAConnection getXAConnectionInternal(OracleXAConnectionBuilderImpl builder, boolean useProxy) throws SQLException {
        if (!useProxy) {
            return this.getXAConnection(builder);
        }
        this.setupACSpecificProperties(useProxy);
        OraclePooledConnection pc = (OraclePooledConnection)((Object)this.getXAConnection(builder));
        Connection _pconn = pc.getPhysicalHandle();
        OracleConnectionBuilderImpl connBldr = builder == null ? null : (OracleConnectionBuilderImpl)this.createConnectionBuilder().copy(builder);
        Connection retConn = this.enableACAndProxifyIfNecessary(_pconn, connBldr);
        if (_pconn != retConn) {
            pc.setConnection((OracleConnection)retConn);
        }
        return (XAConnection)((Object)pc);
    }

    @Override
    public PooledConnection getPooledConnection(String userName, @Blind String passwd) throws SQLException {
        Properties prop = new Properties();
        prop.setProperty("user", userName);
        prop.setProperty("password", passwd);
        return this.getPooledConnection(prop);
    }

    public PooledConnection getPooledConnection(@Blind(value=PropertiesBlinder.class) Properties info) throws SQLException {
        return this.getPooledConnection(info, null);
    }

    private final PooledConnection getPooledConnection(@Blind(value=PropertiesBlinder.class) Properties info, OracleXAConnectionBuilderImpl builder) throws SQLException {
        try {
            String url = this.getURL();
            String userName = info.getProperty("user");
            String passwd = info.getProperty("password");
            String localInstanceName = info.getProperty("oracle.jdbc.targetInstanceName");
            String localServiceName = info.getProperty("oracle.jdbc.targetServiceName");
            String shardingKeyStr = info.getProperty("oracle.jdbc.targetShardingKey");
            String superShardingKeyStr = info.getProperty("oracle.jdbc.targetSuperShardingKey");
            String isReadOnlyInstanceAllowed = info.getProperty("oracle.jdbc.readOnlyInstanceAllowed");
            String rmName = null;
            String xaclsstr = null;
            String localXaOpenString = null;
            int localRmid = 0;
            if (this.useNativeXA && (url.startsWith("jdbc:oracle:oci8") || url.startsWith("jdbc:oracle:oci"))) {
                long[] ociHandles = new long[]{0L, 0L};
                String tnsentry = null;
                String propNlsLangBackdoor = null;
                try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
                    block84: {
                        tnsentry = this.tnsEntry != null ? this.tnsEntry : this.getTNSEntryFromUrl(url);
                        if (tnsentry != null && tnsentry.length() == 0 || tnsentry.startsWith("(DESCRIPTION")) {
                            throw (SQLException)DatabaseError.createSqlException(207).fillInStackTrace();
                        }
                        if (!libraryLoaded) {
                            try (Monitor.CloseableLock libLock = LOAD_LIBRARY_MONITOR.acquireCloseableLock();){
                                if (libraryLoaded) break block84;
                                try {
                                    System.loadLibrary(dllName);
                                    libraryLoaded = true;
                                }
                                catch (Error exc) {
                                    libraryLoaded = false;
                                    this.debug(Level.WARNING, SecurityLabel.UNKNOWN, "oracle.jdbc.xa.client.OracleXADataSource", "getPooledConnection", "------ JNI JDBC XA lib not loaded properly. ------", null, exc);
                                    throw exc;
                                }
                            }
                        }
                    }
                    if (this.connectionProperties != null) {
                        propNlsLangBackdoor = this.connectionProperties.getProperty("oracle.jdbc.ociNlsLangBackwardCompatible");
                    }
                }
                if (propNlsLangBackdoor != null && propNlsLangBackdoor.equalsIgnoreCase("true")) {
                    short driverCharSetId = T2CConnection.getDriverCharSetIdFromNLS_LANG();
                    this.driverCharSetIdString = Integer.toString(driverCharSetId);
                } else if (!tnsentry.equals(this.oldTnsEntry)) {
                    short driverCharSetId = T2CConnection.getClientCharSetId();
                    this.driverCharSetIdString = Integer.toString(driverCharSetId);
                    this.oldTnsEntry = tnsentry;
                }
                lock = this.acquireCloseableLock();
                try {
                    rmName = this.databaseName + dbSuffix + rmidSeed;
                    this.rmid = localRmid = rmidSeed;
                    try (Monitor.CloseableLock rmidLock = RMID_SEED_MONITOR.acquireCloseableLock();){
                        rmidSeed = (rmidSeed + 1) % 65536;
                    }
                    int trcLevel = 0;
                    String l_xaLoose = this.connectionProperties != null ? this.connectionProperties.getProperty("oracle.jdbc.XATransLoose") : null;
                    this.xaOpenString = localXaOpenString = this.generateXAOpenString(rmName, tnsentry, userName, passwd, 60, 2000, true, true, ".", trcLevel, false, l_xaLoose != null && l_xaLoose.equalsIgnoreCase("true"), this.driverCharSetIdString, this.driverCharSetIdString);
                    xaclsstr = this.generateXACloseString(rmName, false);
                }
                finally {
                    if (lock != null) {
                        lock.close();
                    }
                }
                this.debug(Level.FINEST, SecurityLabel.UNKNOWN, "oracle.jdbc.xa.client.OracleXADataSource", "getPooledConnection", "before t2cDoXaOpen()", null, null);
                int status = this.t2cDoXaOpen(localXaOpenString, localRmid, 0, 0);
                if (status != 0) {
                    throw (SQLException)DatabaseError.createSqlException(null, -1 * status).fillInStackTrace();
                }
                this.debug(Level.FINEST, SecurityLabel.UNKNOWN, "oracle.jdbc.xa.client.OracleXADataSource", "getPooledConnection", "before t2cConvertOciHandles()", null, null);
                status = this.t2cConvertOciHandles(rmName, ociHandles);
                if (status != 0) {
                    throw (SQLException)DatabaseError.createSqlException(null, -1 * status).fillInStackTrace();
                }
                info.put("OCISvcCtxHandle", String.valueOf(ociHandles[0]));
                info.put("OCIEnvHandle", String.valueOf(ociHandles[1]));
                info.put("JDBCDriverCharSetId", this.driverCharSetIdString);
                if (this.loginTimeout != 0) {
                    info.put("oracle.net.CONNECT_TIMEOUT", "" + this.loginTimeout * 1000);
                }
                this.debug(Level.FINEST, SecurityLabel.UNKNOWN, "oracle.jdbc.xa.client.OracleXADataSource", "getPooledConnection", "before getConnection(url, info)", null, null);
                Connection conn = this.driver.connect(this.getURL(), info);
                if (this.maxStatementsSet) {
                    ((OracleConnection)conn).setStatementCacheSize(this.maxStatements);
                }
                if (this.explicitCachingEnabledSet) {
                    ((OracleConnection)conn).setExplicitCachingEnabled(this.explicitCachingEnabled);
                }
                if (this.implicitCachingEnabledSet) {
                    ((OracleConnection)conn).setImplicitCachingEnabled(this.implicitCachingEnabled);
                }
                if (this.maxStatements > 0 && !this.explicitCachingEnabled && !this.implicitCachingEnabled) {
                    ((OracleConnection)conn).setImplicitCachingEnabled(true);
                    ((OracleConnection)conn).setExplicitCachingEnabled(true);
                }
                OracleXAHeteroConnection xaconn = new OracleXAHeteroConnection(conn);
                xaconn.setRmid(localRmid);
                xaconn.setXaCloseString(xaclsstr);
                xaconn.registerCloseCallback(new OracleXAHeteroCloseCallback(), xaconn);
                return xaconn;
            }
            if (this.useNativeXA && url.startsWith("jdbc:oracle:thin")) {
                Properties prop = new Properties();
                try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
                    try (Monitor.CloseableLock rmidLock = RMID_SEED_MONITOR.acquireCloseableLock();){
                        this.rmid = rmidSeed = (rmidSeed + 1) % 65536;
                    }
                    if (this.connectionProperties == null) {
                        this.connectionProperties = new Properties();
                    }
                    this.connectionProperties.put("RessourceManagerId", Integer.toString(this.rmid));
                    if (userName != null) {
                        prop.setProperty("user", userName);
                    }
                    if (passwd != null) {
                        prop.setProperty("password", passwd);
                    }
                    if (this.maxStatementsSet) {
                        prop.setProperty("stmt_cache_size", "" + this.maxStatements);
                    }
                    if (this.implicitCachingEnabledSet) {
                        prop.setProperty("ImplicitStatementCachingEnabled", "" + this.implicitCachingEnabled);
                    }
                    if (this.explicitCachingEnabledSet) {
                        prop.setProperty("ExplicitStatementCachingEnabled", "" + this.explicitCachingEnabled);
                    }
                    if (this.loginTimeout != 0) {
                        prop.setProperty("LoginTimeout", "" + this.loginTimeout);
                    }
                    if (localInstanceName != null) {
                        prop.setProperty("oracle.jdbc.targetInstanceName", localInstanceName);
                    }
                    if (localServiceName != null) {
                        prop.setProperty("oracle.jdbc.targetServiceName", localServiceName);
                    }
                    if (shardingKeyStr != null) {
                        prop.setProperty("oracle.jdbc.targetShardingKey", shardingKeyStr);
                    }
                    if (superShardingKeyStr != null) {
                        prop.setProperty("oracle.jdbc.targetSuperShardingKey", superShardingKeyStr);
                    }
                    if ("true".equalsIgnoreCase(isReadOnlyInstanceAllowed)) {
                        prop.setProperty("oracle.jdbc.readOnlyInstanceAllowed", isReadOnlyInstanceAllowed);
                    }
                }
                T4CXAConnection conn = new T4CXAConnection(super.getPhysicalConnection(prop, builder));
                String l_xaLoose = this.connectionProperties != null ? this.connectionProperties.getProperty("oracle.jdbc.XATransLoose") : null;
                conn.isXAResourceTransLoose = l_xaLoose != null && (l_xaLoose.equals("true") || l_xaLoose.equalsIgnoreCase("true"));
                return conn;
            }
            this.debug(Level.FINEST, SecurityLabel.UNKNOWN, "oracle.jdbc.xa.client.OracleXADataSource", "getPooledConnection", "use Java-XA", null, null);
            Properties prop = new Properties();
            try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
                if (userName != null) {
                    prop.setProperty("user", userName);
                }
                if (passwd != null) {
                    prop.setProperty("password", passwd);
                }
                if (this.maxStatementsSet) {
                    prop.setProperty("stmt_cache_size", "" + this.maxStatements);
                }
                if (this.implicitCachingEnabledSet) {
                    prop.setProperty("ImplicitStatementCachingEnabled", "" + this.implicitCachingEnabled);
                }
                if (this.explicitCachingEnabledSet) {
                    prop.setProperty("ExplicitStatementCachingEnabled", "" + this.explicitCachingEnabled);
                }
                if (this.loginTimeout != 0) {
                    prop.setProperty("LoginTimeout", "" + this.loginTimeout);
                }
                if (localInstanceName != null) {
                    prop.setProperty("oracle.jdbc.targetInstanceName", localInstanceName);
                }
                if (localServiceName != null) {
                    prop.setProperty("oracle.jdbc.targetServiceName", localServiceName);
                }
                if (shardingKeyStr != null) {
                    prop.setProperty("oracle.jdbc.targetShardingKey", shardingKeyStr);
                }
                if (superShardingKeyStr != null) {
                    prop.setProperty("oracle.jdbc.targetSuperShardingKey", superShardingKeyStr);
                }
                if ("true".equalsIgnoreCase(isReadOnlyInstanceAllowed)) {
                    prop.setProperty("oracle.jdbc.readOnlyInstanceAllowed", isReadOnlyInstanceAllowed);
                }
            }
            OracleXAConnection l_xaconn = new OracleXAConnection(super.getPhysicalConnection(prop, null));
            String l_xaLoose = this.connectionProperties != null ? this.connectionProperties.getProperty("oracle.jdbc.XATransLoose") : null;
            l_xaconn.isXAResourceTransLoose = l_xaLoose != null && (l_xaLoose.equals("true") || l_xaLoose.equalsIgnoreCase("true"));
            return l_xaconn;
        }
        catch (XAException xae) {
            this.debug(Level.WARNING, SecurityLabel.UNKNOWN, "oracle.jdbc.xa.client.OracleXADataSource", "getPooledConnection", "hit XAException: " + String.valueOf(xae), null, xae);
            throw DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), xae);
        }
    }

    private native int t2cDoXaOpen(String var1, int var2, int var3, int var4);

    private native int t2cConvertOciHandles(String var1, long[] var2);

    void setRmid(int rmid) {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            this.rmid = rmid;
        }
    }

    int getRmid() {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            int n = this.rmid;
            return n;
        }
    }

    void setXaOpenString(String xaOpenString) {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            this.xaOpenString = xaOpenString;
        }
    }

    String getXaOpenString() {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            String string = this.xaOpenString;
            return string;
        }
    }

    @Blind
    private String generateXAOpenString(String rmName, String connectString, String userName, @Blind String passwd, int lockTimeout, int sessionTimeout, boolean threadFlag, boolean objectFlag, String logDir, int traceLevel, boolean cacheFlag, boolean isLoose, String dbCsId, String dbNCharCsId) {
        return "ORACLE_XA+DB=" + rmName + "+ACC=P/" + (userName == null ? "" : userName) + "/" + (passwd == null ? "" : passwd) + "+SESTM=" + sessionTimeout + "+SESWT=" + lockTimeout + "+LOGDIR=" + logDir + "+SQLNET=" + connectString + (threadFlag ? "+THREADS=true" : "") + (objectFlag ? "+OBJECTS=true" : "") + "+DBGFL=0x" + traceLevel + (cacheFlag ? "+CONNCACHE=t" : "+CONNCACHE=f") + (isLoose ? "+Loose_Coupling=t" : "") + "+CharSet=" + dbCsId + "+NCharSet=" + dbNCharCsId;
    }

    private String generateXACloseString(String rmName, boolean cacheFlag) {
        return "ORACLE_XA+DB=" + rmName + (cacheFlag ? "+CONNCACHE=t" : "+CONNCACHE=f");
    }

    private String getTNSEntryFromUrl(String url) {
        int at_sign = url.indexOf(64);
        return url.substring(at_sign + 1);
    }
}

