/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.xa.client;

import java.io.IOException;
import java.sql.Connection;
import java.util.logging.Level;
import javax.transaction.xa.XAException;
import javax.transaction.xa.Xid;
import oracle.jdbc.diagnostics.SecurityLabel;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.internal.Monitor;
import oracle.jdbc.oracore.Util;
import oracle.jdbc.xa.client.OracleXAConnection;
import oracle.jdbc.xa.client.OracleXAResource;

public class OracleXAHeteroResource
extends OracleXAResource {
    private int rmid = -1;

    public OracleXAHeteroResource(Connection pm_conn, OracleXAConnection xaconn) throws XAException {
        this.connection = pm_conn;
        this.xaconnection = xaconn;
        if (this.connection == null) {
            throw (XAException)DatabaseError.createXAException(-7).fillInStackTrace();
        }
    }

    @Override
    public void start(Xid xid, int flags) throws XAException {
        if (xid == null) {
            XAException xae = (XAException)DatabaseError.createXAException(-5).fillInStackTrace();
            this.debug(Level.WARNING, SecurityLabel.UNKNOWN, "oracle.jdbc.xa.client.OracleXAHeteroResource", "start", "XAER_INVAL: xid is null", null, xae);
            throw xae;
        }
        int isolFlag = flags & 0xFF00;
        if (((flags &= 0xFFFF00FF) & 0x8200002) != flags) {
            XAException xae = (XAException)DatabaseError.createXAException(-5).fillInStackTrace();
            this.debug(Level.WARNING, SecurityLabel.UNKNOWN, "oracle.jdbc.xa.client.OracleXAHeteroResource", "start", "xid= " + String.valueOf(xid) + ", XAER_INVAL: invalid flag: " + flags, null, xae);
            throw xae;
        }
        if ((isolFlag & 0xFF00) != 0 && isolFlag != 256 && isolFlag != 512 && isolFlag != 1024) {
            XAException xae = (XAException)DatabaseError.createXAException(-5).fillInStackTrace();
            this.debug(Level.WARNING, SecurityLabel.UNKNOWN, "oracle.jdbc.xa.client.OracleXAHeteroResource", "start", "xid= " + String.valueOf(xid) + ", XAER_INVAL: invalid Isolation flag: " + isolFlag, null, xae);
            throw xae;
        }
        if ((isolFlag & 0xFF00) != 0 && (flags & 0x8200000) != 0) {
            XAException xae = (XAException)DatabaseError.createXAException(-5).fillInStackTrace();
            this.debug(Level.WARNING, SecurityLabel.UNKNOWN, "oracle.jdbc.xa.client.OracleXAHeteroResource", "start", "xid= " + String.valueOf(xid) + ", XAER_INVAL: Isolation flags not allowed for JOIN/RESUME: " + isolFlag, null, xae);
            throw xae;
        }
        try {
            this.saveAndAlterAutoCommitModeForGlobalTransaction();
            int formatId = xid.getFormatId();
            byte[] gTrid = xid.getGlobalTransactionId();
            byte[] bQual = xid.getBranchQualifier();
            int status = this.t2cDoXaStart(formatId, gTrid, bQual, this.rmid, flags |= isolFlag, 0);
            this.debug(Level.FINER, SecurityLabel.UNKNOWN, "oracle.jdbc.xa.client.OracleXAHeteroResource", "start", "xid= " + String.valueOf(xid) + ", return status = " + status, null, null);
            this.checkStatus(status);
            this.enterGlobalTxnMode();
        }
        catch (XAException ea) {
            this.restoreAutoCommitModeForGlobalTransaction();
            throw ea;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void end(Xid xid, int flag) throws XAException {
        try {
            if (xid == null) {
                XAException xae = (XAException)DatabaseError.createXAException(-5).fillInStackTrace();
                this.debug(Level.WARNING, SecurityLabel.UNKNOWN, "oracle.jdbc.xa.client.OracleXAHeteroResource", "end", "XAER_INVAL: xid is null", null, xae);
                throw xae;
            }
            int validFlags = 638582786;
            if ((flag & validFlags) != flag) {
                XAException xae = (XAException)DatabaseError.createXAException(-5).fillInStackTrace();
                this.debug(Level.WARNING, SecurityLabel.UNKNOWN, "oracle.jdbc.xa.client.OracleXAHeteroResource", "end", "xid= " + String.valueOf(xid) + ", XAER_INVAL: invalid flag: " + flag, null, xae);
                throw xae;
            }
            int formatId = xid.getFormatId();
            byte[] gTrid = xid.getGlobalTransactionId();
            byte[] bQual = xid.getBranchQualifier();
            this.exitGlobalTxnMode();
            int status = this.t2cDoXaEnd(formatId, gTrid, bQual, this.rmid, flag, 0);
            this.debug(Level.FINER, SecurityLabel.UNKNOWN, "oracle.jdbc.xa.client.OracleXAHeteroResource", "end", "xid= " + String.valueOf(xid) + ", return status = " + status, null, null);
            this.checkStatus(status);
        }
        finally {
            this.restoreAutoCommitModeForGlobalTransaction();
        }
    }

    @Override
    public void commit(Xid xid, boolean onePhase) throws XAException {
        if (xid == null) {
            XAException xae = (XAException)DatabaseError.createXAException(-5).fillInStackTrace();
            this.debug(Level.WARNING, SecurityLabel.UNKNOWN, "oracle.jdbc.xa.client.OracleXAHeteroResource", "commit", "XAER_INVAL: xid is null", null, xae);
            throw xae;
        }
        int flags = onePhase ? 0x40000000 : 0;
        int formatId = xid.getFormatId();
        byte[] gTrid = xid.getGlobalTransactionId();
        byte[] bQual = xid.getBranchQualifier();
        int status = this.t2cDoXaCommit(formatId, gTrid, bQual, this.rmid, flags, 0);
        this.debug(Level.FINER, SecurityLabel.UNKNOWN, "oracle.jdbc.xa.client.OracleXAHeteroResource", "commit", "xid= " + String.valueOf(xid) + ", return status = " + status, null, null);
        this.checkStatus(status);
    }

    @Override
    public int prepare(Xid xid) throws XAException {
        if (xid == null) {
            XAException xae = (XAException)DatabaseError.createXAException(-5).fillInStackTrace();
            this.debug(Level.WARNING, SecurityLabel.UNKNOWN, "oracle.jdbc.xa.client.OracleXAHeteroResource", "prepare", "XAER_INVAL: xid is null", null, xae);
            throw xae;
        }
        int formatId = xid.getFormatId();
        byte[] gTrid = xid.getGlobalTransactionId();
        byte[] bQual = xid.getBranchQualifier();
        int status = this.t2cDoXaPrepare(formatId, gTrid, bQual, this.rmid, 0, 0);
        this.debug(Level.FINER, SecurityLabel.UNKNOWN, "oracle.jdbc.xa.client.OracleXAHeteroResource", "prepare", "xid= " + String.valueOf(xid) + ", return status = " + status, null, null);
        if (status != 0 && status != 3) {
            this.checkStatus(status);
        }
        return status;
    }

    @Override
    public void forget(Xid xid) throws XAException {
        if (xid == null) {
            XAException xae = (XAException)DatabaseError.createXAException(-5).fillInStackTrace();
            this.debug(Level.WARNING, SecurityLabel.UNKNOWN, "oracle.jdbc.xa.client.OracleXAHeteroResource", "forget", "XAER_INVAL: xid is null", null, xae);
            throw xae;
        }
        int formatId = xid.getFormatId();
        byte[] gTrid = xid.getGlobalTransactionId();
        byte[] bQual = xid.getBranchQualifier();
        int status = this.t2cDoXaForget(formatId, gTrid, bQual, this.rmid, 0, 0);
        this.debug(Level.FINER, SecurityLabel.UNKNOWN, "oracle.jdbc.xa.client.OracleXAHeteroResource", "forget", "xid= " + String.valueOf(xid) + ", return status = " + status, null, null);
        this.checkStatus(status);
    }

    @Override
    public void rollback(Xid xid) throws XAException {
        if (xid == null) {
            XAException xae = (XAException)DatabaseError.createXAException(-5).fillInStackTrace();
            this.debug(Level.WARNING, SecurityLabel.UNKNOWN, "oracle.jdbc.xa.client.OracleXAHeteroResource", "rollback", "XAER_INVAL: xid is null", null, xae);
            throw xae;
        }
        int formatId = xid.getFormatId();
        byte[] gTrid = xid.getGlobalTransactionId();
        byte[] bQual = xid.getBranchQualifier();
        int status = this.t2cDoXaRollback(formatId, gTrid, bQual, this.rmid, 0, 0);
        this.debug(Level.FINER, SecurityLabel.UNKNOWN, "oracle.jdbc.xa.client.OracleXAHeteroResource", "rollback", "xid= " + String.valueOf(xid) + ", return status = " + status, null, null);
        this.checkStatus(status);
    }

    private native int t2cDoXaStart(int var1, byte[] var2, byte[] var3, int var4, int var5, int var6);

    private native int t2cDoXaEnd(int var1, byte[] var2, byte[] var3, int var4, int var5, int var6);

    private native int t2cDoXaCommit(int var1, byte[] var2, byte[] var3, int var4, int var5, int var6);

    private native int t2cDoXaPrepare(int var1, byte[] var2, byte[] var3, int var4, int var5, int var6);

    private native int t2cDoXaForget(int var1, byte[] var2, byte[] var3, int var4, int var5, int var6);

    private native int t2cDoXaRollback(int var1, byte[] var2, byte[] var3, int var4, int var5, int var6);

    void setRmid(int rmid) {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            this.rmid = rmid;
        }
    }

    int getRmid() {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            int n = this.rmid;
            return n;
        }
    }

    private static byte[] getSerializedBytes(Xid xid) {
        try {
            return Util.serializeObject(xid);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            return null;
        }
    }

    private void checkStatus(int status) throws XAException {
        if (status != 0) {
            throw (XAException)DatabaseError.createXAException(status).fillInStackTrace();
        }
    }
}

