/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.jms.admin;

import com.rabbitmq.client.Address;
import com.rabbitmq.client.MetricsCollector;
import com.rabbitmq.client.NoOpMetricsCollector;
import com.rabbitmq.jms.client.AbstractReceivingContextConsumer;
import com.rabbitmq.jms.client.AmqpConnectionFactoryPostProcessor;
import com.rabbitmq.jms.client.AmqpPropertiesCustomiser;
import com.rabbitmq.jms.client.ConnectionParams;
import com.rabbitmq.jms.client.RMQConnection;
import com.rabbitmq.jms.client.RMQMessage;
import com.rabbitmq.jms.client.ReceivingContext;
import com.rabbitmq.jms.client.ReceivingContextConsumer;
import com.rabbitmq.jms.client.SendingContext;
import com.rabbitmq.jms.client.SendingContextConsumer;
import com.rabbitmq.jms.util.RMQJMSException;
import com.rabbitmq.jms.util.RMQJMSSecurityException;
import com.rabbitmq.jms.util.UriCodec;
import com.rabbitmq.jms.util.WhiteListObjectInputStream;
import java.io.IOException;
import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeoutException;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.JMSException;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.TopicConnection;
import javax.jms.TopicConnectionFactory;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.StringRefAddr;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RMQConnectionFactory
implements ConnectionFactory,
Referenceable,
Serializable,
QueueConnectionFactory,
TopicConnectionFactory {
    private final Logger logger = LoggerFactory.getLogger(RMQConnectionFactory.class);
    private static final long serialVersionUID = -4953157213762979615L;
    private static final int DEFAULT_RABBITMQ_SSL_PORT = 5671;
    private static final int DEFAULT_RABBITMQ_PORT = 5672;
    private String username = "guest";
    private String password = "guest";
    private String virtualHost = "/";
    private String host = "localhost";
    private int port = -1;
    private int onMessageTimeoutMs = 2000;
    private boolean preferProducerMessageProperty = true;
    private boolean requeueOnMessageListenerException = false;
    private boolean cleanUpServerNamedQueuesForNonDurableTopicsOnSessionClose = false;
    private AmqpPropertiesCustomiser amqpPropertiesCustomiser;
    private MetricsCollector metricsCollector = new NoOpMetricsCollector();
    private AmqpConnectionFactoryPostProcessor amqpConnectionFactoryPostProcessor = new AmqpConnectionFactoryPostProcessor(){

        @Override
        public void postProcess(com.rabbitmq.client.ConnectionFactory connectionFactory) {
        }
    };
    private boolean throwExceptionOnConsumerStartFailure = false;
    private SendingContextConsumer sendingContextConsumer = new SendingContextConsumer(){

        @Override
        public void accept(SendingContext ctx) {
        }
    };
    private ReceivingContextConsumer receivingContextConsumer = new ReceivingContextConsumer(){

        @Override
        public void accept(ReceivingContext ctx) {
        }
    };
    private boolean ssl = false;
    private String tlsProtocol;
    private SSLContext sslContext;
    private boolean useDefaultSslContext = false;
    private boolean hostnameVerification = false;
    private HostnameVerifier hostnameVerifier;
    private int queueBrowserReadMax = Math.max(0, Integer.getInteger("rabbit.jms.queueBrowserReadMax", 0));
    private volatile long terminationTimeout = Long.getLong("rabbit.jms.terminationTimeout", 15000L);
    private int channelsQos = -1;
    private List<String> trustedPackages = WhiteListObjectInputStream.DEFAULT_TRUSTED_PACKAGES;
    private List<URI> uris = new ArrayList<URI>();
    private boolean declareReplyToDestination = true;

    public Connection createConnection() throws JMSException {
        return this.createConnection(this.username, this.password);
    }

    public Connection createConnection(List<Address> endpoints) throws JMSException {
        return this.createConnection(this.username, this.password, endpoints);
    }

    public Connection createConnection(String username, String password) throws JMSException {
        if (this.uris == null || this.uris.isEmpty()) {
            return this.createConnection(username, password, new ConnectionCreator(){

                @Override
                public com.rabbitmq.client.Connection create(com.rabbitmq.client.ConnectionFactory cf) throws Exception {
                    return cf.newConnection();
                }
            });
        }
        final ArrayList<Address> addresses = new ArrayList<Address>(this.uris.size());
        for (URI uri : this.uris) {
            String host = uri.getHost();
            int port = uri.getPort();
            if (port == -1) {
                port = this.isSsl() ? 5671 : 5672;
            }
            addresses.add(new Address(host, port));
        }
        return this.createConnection(username, password, new ConnectionCreator(){

            @Override
            public com.rabbitmq.client.Connection create(com.rabbitmq.client.ConnectionFactory cf) throws Exception {
                return cf.newConnection(addresses);
            }
        });
    }

    public Connection createConnection(String username, String password, final List<Address> endpoints) throws JMSException {
        return this.createConnection(username, password, new ConnectionCreator(){

            @Override
            public com.rabbitmq.client.Connection create(com.rabbitmq.client.ConnectionFactory cf) throws Exception {
                return cf.newConnection(endpoints);
            }
        });
    }

    protected Connection createConnection(String username, String password, ConnectionCreator connectionCreator) throws JMSException {
        ReceivingContextConsumer rcc;
        this.logger.trace("Creating a connection for username '{}', password 'xxxxxxxx'.", (Object)username);
        this.username = username;
        this.password = password;
        com.rabbitmq.client.ConnectionFactory cf = this.createConnectionFactory();
        this.maybeEnableTLS(cf);
        RMQConnectionFactory.setRabbitUri(this.logger, this, cf, this.getUri());
        this.maybeEnableHostnameVerification(cf);
        cf.setMetricsCollector(this.metricsCollector);
        if (this.amqpConnectionFactoryPostProcessor != null) {
            this.amqpConnectionFactoryPostProcessor.postProcess(cf);
        }
        com.rabbitmq.client.Connection rabbitConnection = this.instantiateNodeConnection(cf, connectionCreator);
        if (this.declareReplyToDestination) {
            rcc = this.receivingContextConsumer;
        } else {
            rcc = new AbstractReceivingContextConsumer(){

                @Override
                public void accept(ReceivingContext ctx) throws JMSException {
                    RMQMessage.doNotDeclareReplyToDestination(ctx.getMessage());
                }
            };
            if (this.receivingContextConsumer != null) {
                rcc = ((AbstractReceivingContextConsumer)rcc).andThen(this.receivingContextConsumer);
            }
        }
        RMQConnection conn = new RMQConnection(new ConnectionParams().setRabbitConnection(rabbitConnection).setTerminationTimeout(this.getTerminationTimeout()).setQueueBrowserReadMax(this.getQueueBrowserReadMax()).setOnMessageTimeoutMs(this.getOnMessageTimeoutMs()).setChannelsQos(this.channelsQos).setPreferProducerMessageProperty(this.preferProducerMessageProperty).setRequeueOnMessageListenerException(this.requeueOnMessageListenerException).setCleanUpServerNamedQueuesForNonDurableTopicsOnSessionClose(this.cleanUpServerNamedQueuesForNonDurableTopicsOnSessionClose).setAmqpPropertiesCustomiser(this.amqpPropertiesCustomiser).setThrowExceptionOnConsumerStartFailure(this.throwExceptionOnConsumerStartFailure).setSendingContextConsumer(this.sendingContextConsumer).setReceivingContextConsumer(rcc));
        conn.setTrustedPackages(this.trustedPackages);
        this.logger.debug("Connection {} created.", (Object)conn);
        return conn;
    }

    protected com.rabbitmq.client.ConnectionFactory createConnectionFactory() {
        return new com.rabbitmq.client.ConnectionFactory();
    }

    private com.rabbitmq.client.Connection instantiateNodeConnection(com.rabbitmq.client.ConnectionFactory cf, ConnectionCreator connectionCreator) throws JMSException {
        try {
            return connectionCreator.create(cf);
        }
        catch (SSLException ssle) {
            throw new RMQJMSSecurityException("SSL Exception establishing RabbitMQ Connection", ssle);
        }
        catch (Exception x) {
            if (x instanceof IOException) {
                IOException ioe = (IOException)x;
                String msg = ioe.getMessage();
                if (msg != null) {
                    if (msg.contains("authentication failure") || msg.contains("refused using authentication")) {
                        throw new RMQJMSSecurityException(ioe);
                    }
                    if (msg.contains("Connection refused")) {
                        throw new RMQJMSException("RabbitMQ connection was refused. RabbitMQ broker may not be available.", ioe);
                    }
                }
                throw new RMQJMSException(ioe);
            }
            if (x instanceof TimeoutException) {
                TimeoutException te = (TimeoutException)x;
                throw new RMQJMSException("Timed out establishing RabbitMQ Connection", te);
            }
            throw new RMQJMSException("Unexpected exception thrown by newConnection()", x);
        }
    }

    public String getUri() {
        StringBuilder sb = new StringBuilder(RMQConnectionFactory.scheme(this.isSsl())).append("://");
        sb.append(RMQConnectionFactory.uriUInfoEscape(this.username, this.password)).append('@');
        sb.append(RMQConnectionFactory.uriHostEscape(this.host)).append(':').append(this.getPort()).append("/");
        sb.append(RMQConnectionFactory.uriVirtualHostEscape(this.virtualHost));
        return sb.toString();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("RMQConnectionFactory{");
        return (this.isSsl() ? sb.append("SSL, ") : sb).append("user='").append(this.username).append("', password").append(this.password != null ? "=xxxxxxxx" : " not set").append(", host='").append(this.host).append("', port=").append(this.getPort()).append(", virtualHost='").append(this.virtualHost).append("', onMessageTimeoutMs=").append(this.onMessageTimeoutMs).append(", queueBrowserReadMax=").append(this.queueBrowserReadMax).append('}').toString();
    }

    public void setUri(String uriString) throws JMSException {
        this.logger.trace("Set connection factory parameters by URI '{}'", (Object)uriString);
        if (uriString != null && !uriString.trim().isEmpty()) {
            com.rabbitmq.client.ConnectionFactory factory = this.createConnectionFactory();
            RMQConnectionFactory.setRabbitUri(this.logger, this, factory, uriString);
            this.host = factory.getHost();
            this.password = factory.getPassword();
            this.port = factory.getPort();
            this.ssl = factory.isSSL();
            this.username = factory.getUsername();
            this.virtualHost = factory.getVirtualHost();
        } else {
            this.host = null;
            this.password = null;
            this.port = -1;
            this.ssl = false;
            this.username = null;
            this.virtualHost = null;
        }
    }

    public void setUris(List<String> urisAsStrings) throws JMSException {
        if (urisAsStrings != null && !urisAsStrings.isEmpty()) {
            ArrayList<URI> uris = new ArrayList<URI>(urisAsStrings.size());
            for (String uriAsString : urisAsStrings) {
                try {
                    URI uri = new URI(uriAsString);
                    if (uri.getScheme() == null || !"amqp".equals(uri.getScheme()) && !"amqps".equals(uri.getScheme())) {
                        throw new IllegalArgumentException("Wrong scheme in AMQP URI: " + uri.getScheme());
                    }
                    uris.add(uri);
                }
                catch (URISyntaxException e) {
                    throw new IllegalArgumentException("Invalid URI: " + uriAsString);
                }
            }
            this.uris = uris;
            this.setUri(urisAsStrings.get(0));
        } else {
            this.uris = null;
            this.setUri(null);
        }
    }

    public void setTrustedPackages(List<String> value) {
        this.trustedPackages = value;
    }

    public List<String> getTrustedPackages() {
        return this.trustedPackages;
    }

    private static void setRabbitUri(Logger logger, RMQConnectionFactory rmqFactory, com.rabbitmq.client.ConnectionFactory factory, String uriString) throws RMQJMSException {
        if (uriString != null) {
            try {
                factory.setUri(uriString);
            }
            catch (Exception e) {
                logger.error("Could not set URI on {}", (Object)rmqFactory, (Object)e);
                throw new RMQJMSException("Could not set URI on RabbitMQ connection factory.", e);
            }
        }
    }

    private void maybeEnableTLS(com.rabbitmq.client.ConnectionFactory factory) {
        if (this.ssl) {
            try {
                if (this.useDefaultSslContext) {
                    factory.useSslProtocol(SSLContext.getDefault());
                } else if (this.sslContext != null) {
                    factory.useSslProtocol(this.sslContext);
                } else if (this.tlsProtocol != null) {
                    factory.useSslProtocol(this.tlsProtocol);
                } else {
                    factory.useSslProtocol();
                }
            }
            catch (Exception e) {
                this.logger.warn("Could not set SSL protocol on connection factory, {}. SSL set off.", (Object)this, (Object)e);
                this.ssl = false;
            }
        }
    }

    private void maybeEnableHostnameVerification(com.rabbitmq.client.ConnectionFactory factory) {
        if (this.hostnameVerification || this.hostnameVerifier != null) {
            if (this.ssl) {
                if (this.hostnameVerifier == null) {
                    factory.enableHostnameVerification();
                } else {
                    factory.enableHostnameVerification(this.hostnameVerifier);
                }
            } else {
                this.logger.warn("Hostname verification enabled, but not TLS, please enable TLS too.");
            }
        }
    }

    public boolean isSsl() {
        return this.ssl;
    }

    @Deprecated
    public void setSsl(boolean ssl) {
        this.ssl = ssl;
    }

    public void useSslProtocol() throws NoSuchAlgorithmException {
        this.useSslProtocol(com.rabbitmq.client.ConnectionFactory.computeDefaultTlsProcotol((String[])SSLContext.getDefault().getSupportedSSLParameters().getProtocols()));
    }

    public void useSslProtocol(String protocol) {
        this.tlsProtocol = protocol;
        this.ssl = true;
    }

    public void useSslProtocol(SSLContext context) {
        this.sslContext = context;
        this.ssl = true;
    }

    public void useDefaultSslContext(boolean useDefaultSslContext) {
        this.useDefaultSslContext = useDefaultSslContext;
        this.ssl = true;
    }

    public boolean isUseDefaultSslContext() {
        return this.useDefaultSslContext;
    }

    public void setUseDefaultSslContext(boolean useDefaultSslContext) {
        this.useDefaultSslContext(useDefaultSslContext);
    }

    private static String scheme(boolean isSsl) {
        return isSsl ? "amqps" : "amqp";
    }

    private static String uriUInfoEscape(String user, String pass) {
        if (null == user) {
            return null;
        }
        if (null == pass) {
            return UriCodec.encUserinfo(user, "UTF-8");
        }
        return UriCodec.encUserinfo(user + ":" + pass, "UTF-8");
    }

    private static String uriHostEscape(String host) {
        return UriCodec.encHost(host, "UTF-8");
    }

    private static String uriVirtualHostEscape(String vHost) {
        return UriCodec.encSegment(vHost, "UTF-8");
    }

    @Override
    public Reference getReference() throws NamingException {
        Reference ref = new Reference(RMQConnectionFactory.class.getName());
        RMQConnectionFactory.addStringRefProperty(ref, "uri", this.getUri());
        RMQConnectionFactory.addIntegerRefProperty(ref, "queueBrowserReadMax", this.getQueueBrowserReadMax());
        RMQConnectionFactory.addIntegerRefProperty(ref, "onMessageTimeoutMs", this.getOnMessageTimeoutMs());
        return ref;
    }

    private static void addStringRefProperty(Reference ref, String propertyName, String value) {
        if (value == null || propertyName == null) {
            return;
        }
        StringRefAddr ra = new StringRefAddr(propertyName, value);
        ref.add(ra);
    }

    private static void addIntegerRefProperty(Reference ref, String propertyName, Integer value) {
        if (value == null || propertyName == null) {
            return;
        }
        StringRefAddr ra = new StringRefAddr(propertyName, String.valueOf(value));
        ref.add(ra);
    }

    public TopicConnection createTopicConnection() throws JMSException {
        return (TopicConnection)this.createConnection();
    }

    public TopicConnection createTopicConnection(String userName, String password) throws JMSException {
        return (TopicConnection)this.createConnection(userName, password);
    }

    public QueueConnection createQueueConnection() throws JMSException {
        return (QueueConnection)this.createConnection();
    }

    public QueueConnection createQueueConnection(String userName, String password) throws JMSException {
        return (QueueConnection)this.createConnection(userName, password);
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        if (username != null) {
            this.username = username;
        } else {
            this.logger.warn("Cannot set username to null (on {})", (Object)this);
        }
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getVirtualHost() {
        return this.virtualHost;
    }

    public void setVirtualHost(String virtualHost) {
        if (virtualHost != null) {
            this.virtualHost = virtualHost;
        } else {
            this.logger.warn("Cannot set virtualHost to null (on {})", (Object)this);
        }
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        if (host != null) {
            this.host = host;
        } else {
            this.logger.warn("Cannot set host to null (on {})", (Object)this);
        }
    }

    public int getPort() {
        return this.port != -1 ? this.port : (this.isSsl() ? 5671 : 5672);
    }

    public void setPort(int port) {
        this.port = port;
    }

    public long getTerminationTimeout() {
        return this.terminationTimeout;
    }

    public void setTerminationTimeout(long terminationTimeout) {
        this.terminationTimeout = terminationTimeout;
    }

    public int getQueueBrowserReadMax() {
        return this.queueBrowserReadMax;
    }

    public void setQueueBrowserReadMax(int queueBrowserReadMax) {
        this.queueBrowserReadMax = Math.max(0, queueBrowserReadMax);
    }

    public int getOnMessageTimeoutMs() {
        return this.onMessageTimeoutMs;
    }

    public void setOnMessageTimeoutMs(int onMessageTimeoutMs) {
        if (onMessageTimeoutMs > 0) {
            this.onMessageTimeoutMs = onMessageTimeoutMs;
        } else {
            this.logger.warn("Cannot set onMessageTimeoutMs to non-positive value {} (on {})", (Object)onMessageTimeoutMs, (Object)this);
        }
    }

    public int getChannelsQos() {
        return this.channelsQos;
    }

    public void setChannelsQos(int channelsQos) {
        this.channelsQos = channelsQos;
    }

    public void setPreferProducerMessageProperty(boolean preferProducerMessageProperty) {
        this.preferProducerMessageProperty = preferProducerMessageProperty;
    }

    public boolean isPreferProducerMessageProperty() {
        return this.preferProducerMessageProperty;
    }

    public void setRequeueOnMessageListenerException(boolean requeueOnMessageListenerException) {
        this.requeueOnMessageListenerException = requeueOnMessageListenerException;
    }

    public boolean isRequeueOnMessageListenerException() {
        return this.requeueOnMessageListenerException;
    }

    public void setCleanUpServerNamedQueuesForNonDurableTopicsOnSessionClose(boolean cleanUpServerNamedQueuesForNonDurableTopicsOnSessionClose) {
        this.cleanUpServerNamedQueuesForNonDurableTopicsOnSessionClose = cleanUpServerNamedQueuesForNonDurableTopicsOnSessionClose;
    }

    public boolean isCleanUpServerNamedQueuesForNonDurableTopicsOnSessionClose() {
        return this.cleanUpServerNamedQueuesForNonDurableTopicsOnSessionClose;
    }

    public void setAmqpPropertiesCustomiser(AmqpPropertiesCustomiser amqpPropertiesCustomiser) {
        this.amqpPropertiesCustomiser = amqpPropertiesCustomiser;
    }

    public void setMetricsCollector(MetricsCollector metricsCollector) {
        this.metricsCollector = metricsCollector;
    }

    public void setHostnameVerification(boolean hostnameVerification) {
        this.hostnameVerification = hostnameVerification;
    }

    public void setHostnameVerifier(HostnameVerifier hostnameVerifier) {
        this.hostnameVerifier = hostnameVerifier;
    }

    public List<String> getUris() {
        ArrayList<String> urisAsStrings = new ArrayList<String>(this.uris.size());
        for (URI uri : this.uris) {
            urisAsStrings.add(uri.toString());
        }
        return urisAsStrings;
    }

    public void setAmqpConnectionFactoryPostProcessor(AmqpConnectionFactoryPostProcessor amqpConnectionFactoryPostProcessor) {
        this.amqpConnectionFactoryPostProcessor = amqpConnectionFactoryPostProcessor;
    }

    public void setThrowExceptionOnConsumerStartFailure(boolean throwExceptionOnConsumerStartFailure) {
        this.throwExceptionOnConsumerStartFailure = throwExceptionOnConsumerStartFailure;
    }

    public void setSendingContextConsumer(SendingContextConsumer sendingContextConsumer) {
        this.sendingContextConsumer = sendingContextConsumer;
    }

    public void setReceivingContextConsumer(ReceivingContextConsumer receivingContextConsumer) {
        this.receivingContextConsumer = receivingContextConsumer;
    }

    public void setDeclareReplyToDestination(boolean declareReplyToDestination) {
        this.declareReplyToDestination = declareReplyToDestination;
    }

    private static interface ConnectionCreator {
        public com.rabbitmq.client.Connection create(com.rabbitmq.client.ConnectionFactory var1) throws Exception;
    }
}

