/*
 * Decompiled with CFR 0.152.
 */
package com.reginald.editspinner;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.os.SystemClock;
import android.text.Editable;
import android.text.Selection;
import android.text.Spannable;
import android.text.TextWatcher;
import android.text.method.KeyListener;
import android.util.AttributeSet;
import android.util.Log;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.View;
import android.widget.AdapterView;
import android.widget.EditText;
import android.widget.ListAdapter;
import android.widget.ListPopupWindow;
import android.widget.PopupWindow;
import com.reginald.editspinner.R;

public class EditSpinner
extends EditText {
    private static final boolean DEBUG = false;
    private static final String TAG = "EditSpinner";
    private static final long TIMEOUT_POPUP_DISMISS = 200L;
    private ListPopupWindow mPopup;
    private ListAdapter mAdapter;
    private int mDropDownAnchorId;
    private Drawable mDropDownDrawable;
    private PopupWindow.OnDismissListener mOnDismissListener;
    private OnShowListener mOnShowListener;
    private AdapterView.OnItemClickListener mItemClickListener;
    private AdapterView.OnItemSelectedListener mItemSelectedListener;
    private ItemConverter mItemConverter;
    private boolean mDropDownDismissedOnCompletion = true;
    private long mLastDismissTime = 0L;
    private boolean mDropDownTouchedDown = false;
    private boolean mOpenBefore;
    private boolean mIsEditable = true;
    private KeyListener mKeyListener;

    public EditSpinner(Context context) {
        super(context, null);
        this.initFromAttributes(context, null, 0, 0);
    }

    public EditSpinner(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initFromAttributes(context, attrs, 0, 0);
    }

    public EditSpinner(Context context, AttributeSet attrs, int defStyleAttr) {
        this(context, attrs, defStyleAttr, 0);
    }

    @TargetApi(value=21)
    public EditSpinner(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.initFromAttributes(context, attrs, defStyleAttr, defStyleRes);
    }

    private void initFromAttributes(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        int dropDownAnimStyleResId;
        TypedArray a = this.getContext().obtainStyledAttributes(attrs, R.styleable.EditSpinner, defStyleAttr, defStyleRes);
        this.mPopup = new ListPopupWindow(context, attrs);
        this.mPopup.setSoftInputMode(16);
        this.mPopup.setPromptPosition(1);
        Drawable selector = a.getDrawable(R.styleable.EditSpinner_dropDownSelector);
        if (selector != null) {
            this.mPopup.setListSelector(selector);
        }
        if ((dropDownAnimStyleResId = a.getResourceId(R.styleable.EditSpinner_dropDownAnimStyle, -1)) > 0) {
            this.setDropDownAnimationStyle(dropDownAnimStyleResId);
        }
        this.mDropDownDrawable = a.getDrawable(R.styleable.EditSpinner_dropDownDrawable);
        int dropDownDrawableSpacing = a.getDimensionPixelOffset(R.styleable.EditSpinner_dropDownDrawableSpacing, 0);
        if (this.mDropDownDrawable != null) {
            int dropDownDrawableWidth = a.getDimensionPixelOffset(R.styleable.EditSpinner_dropDownDrawableWidth, -1);
            int dropDownDrawableHeight = a.getDimensionPixelOffset(R.styleable.EditSpinner_dropDownDrawableHeight, -1);
            this.setDropDownDrawable(this.mDropDownDrawable, dropDownDrawableWidth, dropDownDrawableHeight);
            this.setDropDownDrawableSpacing(dropDownDrawableSpacing);
        }
        this.mDropDownAnchorId = a.getResourceId(R.styleable.EditSpinner_dropDownAnchor, -1);
        this.mPopup.setWidth(a.getLayoutDimension(R.styleable.EditSpinner_dropDownWidth, -2));
        this.mPopup.setHeight(a.getLayoutDimension(R.styleable.EditSpinner_dropDownHeight, -2));
        this.mPopup.setOnItemClickListener((AdapterView.OnItemClickListener)new DropDownItemClickListener());
        this.mPopup.setOnDismissListener(new PopupWindow.OnDismissListener(){

            public void onDismiss() {
                EditSpinner.this.mLastDismissTime = SystemClock.elapsedRealtime();
                if (EditSpinner.this.mOnDismissListener != null) {
                    EditSpinner.this.mOnDismissListener.onDismiss();
                }
            }
        });
        a.recycle();
        this.mIsEditable = this.getKeyListener() != null;
        this.setFocusable(true);
        this.addTextChangedListener(new MyWatcher());
        Log.d((String)TAG, (String)("mIsEditable = " + this.mIsEditable));
    }

    public boolean onCheckIsTextEditor() {
        boolean isEdit = super.onCheckIsTextEditor();
        Log.d((String)TAG, (String)("onCheckIsTextEditor = " + isEdit));
        return isEdit;
    }

    public void setEditable(boolean isEditable) {
        if (this.mIsEditable == isEditable) {
            return;
        }
        this.mIsEditable = isEditable;
        if (isEditable) {
            if (this.mKeyListener != null) {
                this.setKeyListener(this.mKeyListener);
            }
        } else {
            this.mKeyListener = this.getKeyListener();
            this.setKeyListener(null);
        }
    }

    public int getDropDownWidth() {
        return this.mPopup.getWidth();
    }

    public void setDropDownWidth(int width) {
        this.mPopup.setWidth(width);
    }

    public int getDropDownHeight() {
        return this.mPopup.getHeight();
    }

    public void setDropDownHeight(int height) {
        this.mPopup.setHeight(height);
    }

    public int getDropDownAnchor() {
        return this.mDropDownAnchorId;
    }

    public void setDropDownAnchor(int id) {
        this.mDropDownAnchorId = id;
        this.mPopup.setAnchorView(null);
    }

    public Drawable getDropDownBackground() {
        return this.mPopup.getBackground();
    }

    public void setDropDownBackgroundDrawable(Drawable d) {
        this.mPopup.setBackgroundDrawable(d);
    }

    public void setDropDownBackgroundResource(int id) {
        this.mPopup.setBackgroundDrawable(this.getContext().getResources().getDrawable(id));
    }

    public int getDropDownVerticalOffset() {
        return this.mPopup.getVerticalOffset();
    }

    public void setDropDownVerticalOffset(int offset) {
        this.mPopup.setVerticalOffset(offset);
    }

    public int getDropDownHorizontalOffset() {
        return this.mPopup.getHorizontalOffset();
    }

    public void setDropDownHorizontalOffset(int offset) {
        this.mPopup.setHorizontalOffset(offset);
    }

    public int getDropDownAnimationStyle() {
        return this.mPopup.getAnimationStyle();
    }

    public void setDropDownAnimationStyle(int animationStyle) {
        this.mPopup.setAnimationStyle(animationStyle);
    }

    public boolean isDropDownDismissedOnCompletion() {
        return this.mDropDownDismissedOnCompletion;
    }

    public void setDropDownDismissedOnCompletion(boolean dropDownDismissedOnCompletion) {
        this.mDropDownDismissedOnCompletion = dropDownDismissedOnCompletion;
    }

    public void clearListSelection() {
        this.mPopup.clearListSelection();
    }

    public int getListSelection() {
        return this.mPopup.getSelectedItemPosition();
    }

    public void setListSelection(int position) {
        this.mPopup.setSelection(position);
    }

    public void selectItem(int index) {
        if (this.mAdapter != null && index >= 0 && index < this.mAdapter.getCount()) {
            this.selectItem(this.mAdapter.getItem(index));
        }
    }

    private void selectItem(Object selectedItem) {
        if (selectedItem != null) {
            this.replaceText(this.convertSelectionToString(selectedItem));
        }
    }

    public void setDropDownDrawable(Drawable drawable) {
        this.setDropDownDrawable(drawable, -1, -1);
    }

    public void setDropDownDrawable(Drawable drawable, int width, int height) {
        this.mDropDownDrawable = drawable;
        if (width >= 0 && height >= 0) {
            drawable.setBounds(new Rect(0, 0, width, height));
            this.setCompoundDrawables(null, null, drawable, null);
        } else {
            this.setCompoundDrawablesWithIntrinsicBounds(null, null, drawable, null);
        }
    }

    public boolean isPopupShowing() {
        return this.mPopup.isShowing();
    }

    public void showDropDown() {
        if (this.mPopup.getAnchorView() == null) {
            if (this.mDropDownAnchorId != -1) {
                this.mPopup.setAnchorView(this.getRootView().findViewById(this.mDropDownAnchorId));
            } else {
                this.mPopup.setAnchorView((View)this);
            }
        }
        if (!this.isPopupShowing()) {
            this.mPopup.setInputMethodMode(1);
        }
        this.requestFocus();
        this.mPopup.show();
        this.mPopup.getListView().setOverScrollMode(0);
        if (this.mOnShowListener != null) {
            this.mOnShowListener.onShow();
        }
    }

    public void dismissDropDown() {
        this.mPopup.dismiss();
    }

    public void setAdapter(ListAdapter adapter) {
        this.mAdapter = adapter;
        this.mPopup.setAdapter(this.mAdapter);
    }

    public void setDropDownDrawableSpacing(int spacing) {
        this.setCompoundDrawablePadding(spacing);
    }

    public int getDropDownDrawableSpacing() {
        return this.getCompoundDrawablePadding();
    }

    public void setOnDismissListener(PopupWindow.OnDismissListener dismissListener) {
        this.mOnDismissListener = dismissListener;
    }

    public void setOnShowListener(OnShowListener showListener) {
        this.mOnShowListener = showListener;
    }

    public void setOnItemClickListener(AdapterView.OnItemClickListener l) {
        this.mItemClickListener = l;
    }

    public void setItemConverter(ItemConverter itemConverter) {
        this.mItemConverter = itemConverter;
    }

    protected void performCompletion() {
        this.performCompletion(null, -1, -1L);
    }

    protected void performCompletion(View selectedView, int position, long id) {
        if (this.isPopupShowing()) {
            Object selectedItem = position < 0 ? this.mPopup.getSelectedItem() : this.mAdapter.getItem(position);
            if (selectedItem == null) {
                return;
            }
            this.selectItem(selectedItem);
            if (this.mItemClickListener != null) {
                ListPopupWindow list = this.mPopup;
                if (selectedView == null || position < 0) {
                    selectedView = list.getSelectedView();
                    position = list.getSelectedItemPosition();
                    id = list.getSelectedItemId();
                }
                this.mItemClickListener.onItemClick((AdapterView)list.getListView(), selectedView, position, id);
            }
        }
        if (this.mDropDownDismissedOnCompletion) {
            this.dismissDropDown();
        }
    }

    protected void replaceText(CharSequence text) {
        this.clearComposingText();
        this.setText(text);
        Editable spannable = this.getText();
        Selection.setSelection((Spannable)spannable, (int)spannable.length());
    }

    protected CharSequence convertSelectionToString(Object selectedItem) {
        if (this.mItemConverter != null) {
            return this.mItemConverter.convertItemToString(selectedItem);
        }
        return selectedItem.toString();
    }

    protected void onDisplayHint(int hint) {
        super.onDisplayHint(hint);
        switch (hint) {
            case 4: {
                this.dismissDropDown();
            }
        }
    }

    protected boolean setFrame(int l, int t, int r, int b) {
        boolean result = super.setFrame(l, t, r, b);
        if (this.isPopupShowing()) {
            this.showDropDown();
        }
        return result;
    }

    protected void onFocusChanged(boolean focused, int direction, Rect previouslyFocusedRect) {
        super.onFocusChanged(focused, direction, previouslyFocusedRect);
        if (!focused) {
            this.dismissDropDown();
        }
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
    }

    protected void onDetachedFromWindow() {
        this.dismissDropDown();
        super.onDetachedFromWindow();
    }

    public boolean onTouchEvent(MotionEvent event) {
        switch (event.getAction()) {
            case 0: {
                if (this.isInDropDownClickArea(event)) {
                    this.mDropDownTouchedDown = true;
                    return true;
                }
                this.mDropDownTouchedDown = false;
                break;
            }
            case 1: {
                if (!this.mDropDownTouchedDown || !this.isInDropDownClickArea(event)) break;
                if (SystemClock.elapsedRealtime() - this.mLastDismissTime > 200L) {
                    this.clearFocus();
                    this.showDropDown();
                    return true;
                }
                this.dismissDropDown();
            }
        }
        return super.onTouchEvent(event);
    }

    private boolean isInDropDownClickArea(MotionEvent event) {
        int areaLeft = this.mIsEditable ? this.getWidth() - this.getCompoundPaddingRight() : 0;
        int areaRight = this.getWidth();
        boolean areaTop = false;
        int areaBottom = this.getHeight();
        return event.getX() > (float)areaLeft && event.getX() < (float)areaRight && event.getY() > (float)areaTop && event.getY() < (float)areaBottom;
    }

    void doBeforeTextChanged() {
        this.mOpenBefore = this.isPopupShowing();
    }

    void doAfterTextChanged() {
        if (this.mOpenBefore && !this.isPopupShowing()) {
            return;
        }
        if (this.isPopupShowing()) {
            this.dismissDropDown();
        }
    }

    public boolean onKeyPreIme(int keyCode, KeyEvent event) {
        if (keyCode == 4 && this.isPopupShowing()) {
            if (event.getAction() == 0 && event.getRepeatCount() == 0) {
                KeyEvent.DispatcherState state = this.getKeyDispatcherState();
                if (state != null) {
                    state.startTracking(event, (Object)this);
                }
                return true;
            }
            if (event.getAction() == 1) {
                KeyEvent.DispatcherState state = this.getKeyDispatcherState();
                if (state != null) {
                    state.handleUpEvent(event);
                }
                if (event.isTracking() && !event.isCanceled()) {
                    this.dismissDropDown();
                    return true;
                }
            }
        }
        return super.onKeyPreIme(keyCode, event);
    }

    public boolean onKeyUp(int keyCode, KeyEvent event) {
        boolean consumed = this.mPopup.onKeyUp(keyCode, event);
        if (consumed) {
            switch (keyCode) {
                case 23: 
                case 61: 
                case 66: {
                    if (event.hasNoModifiers()) {
                        this.performCompletion();
                    }
                    return true;
                }
            }
        }
        if (this.isPopupShowing() && keyCode == 61 && event.hasNoModifiers()) {
            this.performCompletion();
            return true;
        }
        return super.onKeyUp(keyCode, event);
    }

    public boolean onKeyDown(int keyCode, KeyEvent event) {
        if (this.mPopup.onKeyDown(keyCode, event)) {
            return true;
        }
        if (this.isPopupShowing() && keyCode == 61 && event.hasNoModifiers()) {
            return true;
        }
        boolean handled = super.onKeyDown(keyCode, event);
        if (handled && this.isPopupShowing()) {
            this.clearListSelection();
        }
        return handled;
    }

    public void setCompoundDrawables(Drawable left, Drawable top, Drawable right, Drawable bottom) {
        super.setCompoundDrawables(left, top, this.mDropDownDrawable != null ? this.mDropDownDrawable : right, bottom);
    }

    private class DropDownItemClickListener
    implements AdapterView.OnItemClickListener {
        private DropDownItemClickListener() {
        }

        public void onItemClick(AdapterView parent, View v, int position, long id) {
            EditSpinner.this.performCompletion(v, position, id);
        }
    }

    private class MyWatcher
    implements TextWatcher {
        private MyWatcher() {
        }

        public void afterTextChanged(Editable s) {
            EditSpinner.this.doAfterTextChanged();
        }

        public void beforeTextChanged(CharSequence s, int start, int count, int after) {
            EditSpinner.this.doBeforeTextChanged();
        }

        public void onTextChanged(CharSequence s, int start, int before, int count) {
        }
    }

    public static interface OnShowListener {
        public void onShow();
    }

    public static interface ItemConverter {
        public String convertItemToString(Object var1);
    }
}

