/*
 * Decompiled with CFR 0.152.
 */
package com.rokid.glass.ui.button;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.BlurMaskFilter;
import android.graphics.Canvas;
import android.graphics.LinearGradient;
import android.graphics.MaskFilter;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Shader;
import android.util.AttributeSet;
import android.widget.Button;
import com.rokid.glass.ui.R;

@SuppressLint(value={"AppCompatCustomView"})
public class GlassButton
extends Button {
    private Paint mFocusedPaint;
    private Paint mFocusedStrokePaint;
    private Paint mUnfocusedStrokePaint;
    private final int mFocusedGlowWidth = 25;
    private final int mBtnPadding = 20;
    private final float mStrokeWidth = 4.0f;
    private int defaultButtonUnfocusedColor;
    private float defaultButtonCorner;

    public GlassButton(Context context) {
        super(context);
    }

    public GlassButton(Context context, AttributeSet attrs) {
        super(context, attrs);
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.GlassButton);
        this.defaultButtonUnfocusedColor = a.getColor(R.styleable.GlassButton_unfocused_border_color, this.getResources().getColor(R.color.glass_button_unfocused));
        this.defaultButtonCorner = a.getFloat(R.styleable.GlassButton_corner, 100.0f);
        a.recycle();
        this.setBackgroundDrawable(null);
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        super.onLayout(changed, left, top, right, bottom);
        this.init(bottom - top);
    }

    protected void init(int height) {
        int startColor = this.getResources().getColor(R.color.glass_button_focused_glow_top_edge);
        int centerColor = this.getResources().getColor(R.color.glass_button_focused_mid);
        int endColor = this.getResources().getColor(R.color.glass_button_focused_top_edge);
        int glowStartColor = this.getResources().getColor(R.color.glass_button_focused_glow_top_edge);
        int glowEndColor = this.getResources().getColor(R.color.glass_button_focused_bottom_edge);
        this.mFocusedPaint = new Paint();
        this.mFocusedPaint.setAntiAlias(true);
        this.mFocusedPaint.setStyle(Paint.Style.FILL);
        this.mFocusedStrokePaint = new Paint();
        this.mFocusedStrokePaint.setAntiAlias(true);
        this.mFocusedStrokePaint.setStyle(Paint.Style.STROKE);
        this.mFocusedStrokePaint.setStrokeWidth(4.0f);
        this.mUnfocusedStrokePaint = new Paint();
        this.mUnfocusedStrokePaint.setAntiAlias(true);
        this.mUnfocusedStrokePaint.setStyle(Paint.Style.STROKE);
        this.mUnfocusedStrokePaint.setStrokeWidth(4.0f);
        this.mUnfocusedStrokePaint.setColor(this.defaultButtonUnfocusedColor);
        LinearGradient storkeGradient = new LinearGradient(0.0f, 20.0f, 0.0f, (float)((int)((double)height * 1.4)), new int[]{startColor, centerColor, endColor}, null, Shader.TileMode.CLAMP);
        LinearGradient glowGradient = new LinearGradient(0.0f, 0.0f, 0.0f, (float)height, new int[]{glowStartColor, glowEndColor}, null, Shader.TileMode.CLAMP);
        this.mFocusedPaint.setShader((Shader)glowGradient);
        this.mFocusedStrokePaint.setShader((Shader)storkeGradient);
        this.mFocusedPaint.setMaskFilter((MaskFilter)new BlurMaskFilter(25.0f, BlurMaskFilter.Blur.OUTER));
        this.setLayerType(1, null);
    }

    protected void onFocusChanged(boolean focused, int direction, Rect previouslyFocusedRect) {
        super.onFocusChanged(focused, direction, previouslyFocusedRect);
        if (this.isFocused()) {
            this.setTextColor(this.getResources().getColor(R.color.glass_button_focused_text_color));
            this.setTypeface(null, 1);
        } else {
            this.setTextColor(this.getResources().getColor(R.color.glass_button_text_color));
            this.setTypeface(null, 0);
        }
    }

    protected void onDraw(Canvas canvas) {
        if (this.isFocused()) {
            canvas.drawRoundRect(new RectF(25.0f, 20.0f, (float)(this.getWidth() - 25), (float)(this.getHeight() - 20)), this.defaultButtonCorner, this.defaultButtonCorner, this.mFocusedPaint);
            canvas.drawRoundRect(new RectF(25.0f, 20.0f, (float)(this.getWidth() - 25), (float)(this.getHeight() - 20)), this.defaultButtonCorner, this.defaultButtonCorner, this.mFocusedStrokePaint);
        } else {
            canvas.drawRoundRect(new RectF(25.0f, 20.0f, (float)(this.getWidth() - 25), (float)(this.getHeight() - 20)), this.defaultButtonCorner, this.defaultButtonCorner, this.mUnfocusedStrokePaint);
        }
        super.onDraw(canvas);
    }
}

