/*
 * Decompiled with CFR 0.152.
 */
package com.rokid.glass.ui.dialog;

import android.app.Dialog;
import android.content.Context;
import android.graphics.Bitmap;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewStub;
import android.view.Window;
import android.view.WindowManager;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.TextView;
import com.rokid.glass.ui.R;
import com.rokid.glass.ui.dialog.GlassDialogBuilder;
import com.rokid.glass.ui.dialog.GlassDialogListener;
import com.rokid.glass.ui.imageview.RoundCornerImageView;
import com.rokid.glass.ui.util.Utils;

public class GlassDialog
extends Dialog {
    private GlassDialogBuilder mBuilder;

    GlassDialog(Context context, GlassDialogBuilder builder) {
        this(context, R.style.GlassDialogStyle, builder);
    }

    GlassDialog(Context context, int themeResId, GlassDialogBuilder builder) {
        super(context, themeResId);
        this.mBuilder = builder;
        this.init();
    }

    private void init() {
        this.setCancelable(false);
        this.setCanceledOnTouchOutside(false);
    }

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.initDialog();
    }

    private void initDialog() {
        Window window = this.getWindow();
        if (window == null) {
            return;
        }
        WindowManager.LayoutParams params = window.getAttributes();
        params.width = -1;
        params.height = -1;
        params.gravity = 49;
        window.setAttributes(params);
        if (Build.VERSION.SDK_INT >= 26) {
            window.setType(2038);
        } else {
            window.setType(2003);
        }
    }

    public void show() {
        super.show();
        if (null != this.mBuilder) {
            this.mBuilder.dialogShow();
        }
    }

    private static abstract class MessageDialogBuilder<T extends GlassDialogBuilder>
    extends GlassDialogBuilder<T> {
        protected Button mConfirmBtn;
        protected Button mCancelBtn;
        protected String mConfirmText;
        protected String mCancelText;
        protected GlassDialogListener mConfirmListener;
        protected GlassDialogListener mCancelListener;

        public MessageDialogBuilder(Context context) {
            super(context);
        }

        @Override
        protected void init() {
        }

        @Override
        protected void onCreateContent(Context context, ViewGroup parent, GlassDialog dialog) {
            View view = LayoutInflater.from((Context)context).inflate(this.layoutId(), parent, false);
            this.mTitleTv = (TextView)view.findViewById(R.id.dialog_title);
            this.mConfirmBtn = (Button)view.findViewById(R.id.confirm_btn);
            this.mCancelBtn = (Button)view.findViewById(R.id.cancel_btn);
            this.mTitleTv.setText((CharSequence)this.mTitle);
            if (!TextUtils.isEmpty((CharSequence)this.mConfirmText)) {
                this.mConfirmBtn.setText((CharSequence)this.mConfirmText);
            }
            if (!TextUtils.isEmpty((CharSequence)this.mCancelText)) {
                this.mCancelBtn.setText((CharSequence)this.mCancelText);
            } else {
                this.mCancelBtn.setVisibility(8);
            }
            this.mConfirmBtn.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    if (null != MessageDialogBuilder.this.mConfirmListener) {
                        MessageDialogBuilder.this.mConfirmListener.onClick(v);
                    }
                }
            });
            this.mCancelBtn.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    MessageDialogBuilder.this.dismiss();
                    if (null != MessageDialogBuilder.this.mCancelListener) {
                        MessageDialogBuilder.this.mCancelListener.onClick(v);
                    }
                }
            });
            this.onAfterCreateView(view);
            parent.addView(view);
        }

        @Override
        protected void onAfter(Context context, ViewGroup parent, GlassDialog dialog) {
            super.onAfter(context, parent, dialog);
            ViewGroup.LayoutParams params = parent.getLayoutParams();
            params.height = Utils.getScreenHeight(context);
            parent.setLayoutParams(params);
        }

        public T setConfirmText(String confirmText) {
            this.mConfirmText = confirmText;
            return (T)this;
        }

        public T setCancelText(String cancelText) {
            this.mCancelText = cancelText;
            return (T)this;
        }

        public T setConfirmListener(GlassDialogListener confirmListener) {
            this.mConfirmListener = confirmListener;
            return (T)this;
        }

        public T setCancelListener(GlassDialogListener cancelListener) {
            this.mCancelListener = cancelListener;
            return (T)this;
        }

        public void dynamicCancelText(String cancelText) {
            if (this.mGlassDialog.isShowing()) {
                this.mCancelBtn.setText((CharSequence)cancelText);
            }
        }

        public abstract int layoutId();

        public abstract void onAfterCreateView(View var1);
    }

    private static abstract class CustomerMessageDialogBuilder<T extends MessageDialogBuilder>
    extends MessageDialogBuilder<T> {
        private Button mCustomerBtn;
        protected String mCustomerText;
        private GlassDialogListener mCustomerListener;

        public CustomerMessageDialogBuilder(Context context) {
            super(context);
        }

        public T setCustomerText(String customerText) {
            this.mCustomerText = customerText;
            return (T)this;
        }

        public T setCustomerListener(GlassDialogListener customerListener) {
            this.mCustomerListener = customerListener;
            return (T)this;
        }

        @Override
        public void onAfterCreateView(View view) {
            if (!TextUtils.isEmpty((CharSequence)this.mCustomerText)) {
                ViewStub contentView = (ViewStub)view.findViewById(R.id.customer_btn);
                View inflateView = contentView.inflate();
                this.mCustomerBtn = (Button)inflateView;
                if (null == this.mCustomerBtn) {
                    return;
                }
                this.mCustomerBtn.setText((CharSequence)this.mCustomerText);
                this.mCustomerBtn.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        if (null != CustomerMessageDialogBuilder.this.mCustomerListener) {
                            CustomerMessageDialogBuilder.this.mCustomerListener.onClick(v);
                        }
                    }
                });
            }
        }
    }

    private static abstract class CustomerNormalImageDialogBuilder<T extends CustomerNormalImageDialogBuilder>
    extends CustomerMessageDialogBuilder<T> {
        private RoundCornerImageView mNotifyIv;
        private ViewGroup mVoiceLayout;
        private View mCustomConfirmView;
        private int mNotifyResId;
        private Bitmap mNotifyBitmap;

        public CustomerNormalImageDialogBuilder(Context context) {
            super(context);
        }

        @Override
        public void onAfterCreateView(View view) {
            super.onAfterCreateView(view);
            this.mVoiceLayout = (ViewGroup)view.findViewById(R.id.voice_layout);
            this.mNotifyIv = (RoundCornerImageView)view.findViewById(R.id.dialog_notify_img);
            if (this.mNotifyResId != 0) {
                this.mNotifyIv.setImageResource(this.mNotifyResId);
            }
            if (null != this.mNotifyBitmap) {
                this.mNotifyIv.setImageBitmap(this.mNotifyBitmap);
            }
        }

        public T setNotifyResId(int notifyResId) {
            this.mNotifyResId = notifyResId;
            return (T)this;
        }

        public T setNotifyBitmap(Bitmap notifyBitmap) {
            this.mNotifyBitmap = notifyBitmap;
            return (T)this;
        }

        public void dynamicConfirmText(String confirmText) {
            if (this.mGlassDialog.isShowing()) {
                this.mConfirmBtn.setEnabled(true);
                this.mConfirmBtn.setText((CharSequence)confirmText);
                if (null != this.mCustomConfirmView && null != this.mCustomConfirmView.getParent()) {
                    ((ViewGroup)this.mCustomConfirmView.getParent()).removeAllViews();
                }
            }
        }

        public void dynamicCustomConfirmView(View customConfirmView) {
            this.mConfirmBtn.setEnabled(false);
            this.mConfirmBtn.setText(null);
            this.mTitleTv.setText(null);
            if (null != this.mNotifyIv) {
                this.mNotifyIv.setMaskColor(this.mContext.getResources().getColor(R.color.transparent));
            }
            this.mCustomConfirmView = customConfirmView;
            this.mVoiceLayout.removeAllViews();
            if (null != this.mCustomConfirmView.getParent()) {
                ((ViewGroup)this.mCustomConfirmView.getParent()).removeAllViews();
            }
            this.mVoiceLayout.addView(this.mCustomConfirmView, new ViewGroup.LayoutParams(-1, -1));
        }
    }

    public static class NotificationDialogBuilder
    extends GlassDialogBuilder<NotificationDialogBuilder> {
        private static final int DEFAULT_DURATION = 3000;
        private TextView mMessageTv;
        private ImageView mIconResIv;
        private int mDuration = 3000;
        private Handler mHandler;
        private String mMessage;
        private int mIconRes;

        public NotificationDialogBuilder(Context context) {
            super(context);
        }

        @Override
        protected void init() {
            this.mHandler = new Handler();
        }

        public NotificationDialogBuilder setMessage(String message) {
            this.mMessage = message;
            return this;
        }

        public NotificationDialogBuilder setIconRes(int iconRes) {
            this.mIconRes = iconRes;
            return this;
        }

        public NotificationDialogBuilder setDuration(int duration) {
            this.mDuration = duration;
            return this;
        }

        @Override
        protected void onCreateContent(Context context, ViewGroup parent, GlassDialog dialog) {
            View view = LayoutInflater.from((Context)context).inflate(R.layout.layout_notification_dialog, parent, false);
            this.mGlassDialog.getWindow().addFlags(8);
            this.mTitleTv = (TextView)view.findViewById(R.id.dialog_notification_title);
            this.mMessageTv = (TextView)view.findViewById(R.id.dialog_notification_message);
            this.mIconResIv = (ImageView)view.findViewById(R.id.dialog_notification_icon);
            if (this.mIconRes != 0) {
                this.mIconResIv.setImageResource(this.mIconRes);
            }
            this.mTitleTv.setText((CharSequence)this.mTitle);
            if (!TextUtils.isEmpty((CharSequence)this.mMessage)) {
                this.mMessageTv.setText((CharSequence)this.mMessage);
                this.mMessageTv.setVisibility(0);
            } else {
                this.mMessageTv.setVisibility(8);
            }
            parent.addView(view);
        }

        @Override
        protected void dialogShow() {
            super.dialogShow();
            int n = this.mDuration = this.mDuration == 0 ? 3000 : this.mDuration;
            if (this.mDuration > 0) {
                this.mHandler.postDelayed(new Runnable(){

                    @Override
                    public void run() {
                        NotificationDialogBuilder.this.dismiss();
                    }
                }, (long)this.mDuration);
            }
        }

        @Override
        protected void onAfter(Context context, ViewGroup parent, GlassDialog dialog) {
            super.onAfter(context, parent, dialog);
            parent.setBackgroundColor(context.getResources().getColor(R.color.transparent));
        }
    }

    public static class NotificationBuilder
    extends GlassDialogBuilder<NotificationBuilder> {
        private static final int DEFAULT_DURATION = 2000;
        private int mDuration = 2000;
        private Handler mHandler;
        private TextView mTipTv;
        private String mTitle;
        private String mTip;

        public NotificationBuilder(Context context) {
            super(context);
        }

        @Override
        protected void init() {
            this.mHandler = new Handler();
        }

        public NotificationBuilder setDuration(int duration) {
            this.mDuration = duration;
            return this;
        }

        @Override
        public NotificationBuilder setTitle(String title) {
            this.mTitle = title;
            return this;
        }

        public NotificationBuilder setTip(String tip) {
            this.mTip = tip;
            return this;
        }

        @Override
        protected void onCreateContent(Context context, ViewGroup parent, GlassDialog dialog) {
            View view = LayoutInflater.from((Context)context).inflate(R.layout.layout_notification, parent, false);
            this.mGlassDialog.getWindow().addFlags(8);
            this.mTitleTv = (TextView)view.findViewById(R.id.notification_title);
            this.mTipTv = (TextView)view.findViewById(R.id.notification_tip);
            this.mTitleTv.setText((CharSequence)this.mTitle);
            if (!TextUtils.isEmpty((CharSequence)this.mTip)) {
                this.mTipTv.setText((CharSequence)this.mTip);
                this.mTipTv.setVisibility(0);
            } else {
                this.mTipTv.setVisibility(8);
            }
            parent.addView(view);
        }

        @Override
        protected void dialogShow() {
            super.dialogShow();
            int n = this.mDuration = this.mDuration == 0 ? 2000 : this.mDuration;
            if (this.mDuration > 0) {
                this.mHandler.postDelayed(new Runnable(){

                    @Override
                    public void run() {
                        NotificationBuilder.this.dismiss();
                    }
                }, (long)this.mDuration);
            }
        }

        @Override
        protected void onAfter(Context context, ViewGroup parent, GlassDialog dialog) {
            super.onAfter(context, parent, dialog);
            parent.setBackgroundColor(context.getResources().getColor(R.color.transparent));
        }
    }

    private static abstract class CustomerVoiceBaseDialogBuilder<T extends MessageDialogBuilder>
    extends MessageDialogBuilder<T> {
        private ViewGroup mVoiceLayout;
        private View mCustomConfirmView;

        public CustomerVoiceBaseDialogBuilder(Context context) {
            super(context);
        }

        @Override
        public int layoutId() {
            return R.layout.layout_simple_voice_dialog;
        }

        @Override
        public void onAfterCreateView(View view) {
            this.mVoiceLayout = (ViewGroup)view.findViewById(R.id.voice_layout);
        }

        public void dynamicConfirmText(String confirmText) {
            if (this.mGlassDialog.isShowing()) {
                this.mConfirmBtn.setEnabled(true);
                this.mConfirmBtn.setText((CharSequence)confirmText);
                if (null != this.mCustomConfirmView && null != this.mCustomConfirmView.getParent()) {
                    ((ViewGroup)this.mCustomConfirmView.getParent()).removeAllViews();
                }
            }
        }

        public void dynamicCustomConfirmView(View customConfirmView) {
            this.mConfirmBtn.setEnabled(false);
            this.mConfirmBtn.setText(null);
            this.mCustomConfirmView = customConfirmView;
            this.mVoiceLayout.removeAllViews();
            if (null != this.mCustomConfirmView.getParent()) {
                ((ViewGroup)this.mCustomConfirmView.getParent()).removeAllViews();
            }
            this.mVoiceLayout.addView(this.mCustomConfirmView, new ViewGroup.LayoutParams(-1, -1));
        }
    }

    public static class CustomerVoiceDialogBuilder
    extends CustomerVoiceBaseDialogBuilder<CustomerVoiceDialogBuilder> {
        private Button mCustomerBtn;
        protected String mCustomerText;
        private GlassDialogListener mCustomerListener;
        private int mLayoutWidth;

        public CustomerVoiceDialogBuilder(Context context) {
            super(context);
        }

        @Override
        protected void init() {
            super.init();
            this.mLayoutWidth = this.mContext.getResources().getDimensionPixelSize(R.dimen.dialog_customer_message_width);
        }

        @Override
        public void onAfterCreateView(View view) {
            super.onAfterCreateView(view);
            if (!TextUtils.isEmpty((CharSequence)this.mCustomerText)) {
                ViewStub contentView = (ViewStub)view.findViewById(R.id.customer_btn);
                View inflateView = contentView.inflate();
                this.mCustomerBtn = (Button)inflateView;
                if (null == this.mCustomerBtn) {
                    return;
                }
                this.mCustomerBtn.setText((CharSequence)this.mCustomerText);
                this.mCustomerBtn.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        if (null != CustomerVoiceDialogBuilder.this.mCustomerListener) {
                            CustomerVoiceDialogBuilder.this.mCustomerListener.onClick(v);
                        }
                    }
                });
                this.changeLayoutParams(view, this.mLayoutWidth, 0);
            }
        }

        public CustomerVoiceDialogBuilder setCustomerText(String customerText) {
            this.mCustomerText = customerText;
            return this;
        }

        public CustomerVoiceDialogBuilder setCstomerListener(GlassDialogListener customerListener) {
            this.mCustomerListener = customerListener;
            return this;
        }
    }

    public static class SimpleVoiceDialogBuilder
    extends CustomerVoiceBaseDialogBuilder<SimpleVoiceDialogBuilder> {
        public SimpleVoiceDialogBuilder(Context context) {
            super(context);
        }

        @Override
        public int layoutId() {
            return R.layout.layout_simple_voice_dialog;
        }
    }

    public static class ImageDialogBuilder
    extends MessageDialogBuilder<ImageDialogBuilder> {
        private RoundCornerImageView mNotifyIv;
        private ViewGroup mVoiceLayout;
        private View mCustomConfirmView;
        private int mNotifyResId;
        private Bitmap mNotifyBitmap;

        public ImageDialogBuilder(Context context) {
            super(context);
        }

        @Override
        public int layoutId() {
            return R.layout.layout_image_dialog;
        }

        @Override
        public void onAfterCreateView(View view) {
            this.mVoiceLayout = (ViewGroup)view.findViewById(R.id.voice_layout);
            this.mNotifyIv = (RoundCornerImageView)view.findViewById(R.id.dialog_notify_img);
            if (this.mNotifyResId != 0) {
                this.mNotifyIv.setImageResource(this.mNotifyResId);
            }
            if (null != this.mNotifyBitmap) {
                this.mNotifyIv.setImageBitmap(this.mNotifyBitmap);
            }
        }

        public ImageDialogBuilder setNotifyResId(int notifyResId) {
            this.mNotifyResId = notifyResId;
            return this;
        }

        public ImageDialogBuilder setNotifyBitmap(Bitmap notifyBitmap) {
            this.mNotifyBitmap = notifyBitmap;
            return this;
        }

        public void dynamicConfirmText(String confirmText) {
            if (this.mGlassDialog.isShowing()) {
                this.mConfirmBtn.setEnabled(true);
                this.mConfirmBtn.setText((CharSequence)confirmText);
                if (null != this.mCustomConfirmView && null != this.mCustomConfirmView.getParent()) {
                    ((ViewGroup)this.mCustomConfirmView.getParent()).removeAllViews();
                }
            }
        }

        public void dynamicCustomConfirmView(View customConfirmView) {
            this.mConfirmBtn.setEnabled(false);
            this.mConfirmBtn.setText(null);
            this.mTitleTv.setText(null);
            if (null != this.mNotifyIv) {
                this.mNotifyIv.setMaskColor(this.mContext.getResources().getColor(R.color.transparent));
            }
            this.mCustomConfirmView = customConfirmView;
            this.mVoiceLayout.removeAllViews();
            if (null != this.mCustomConfirmView.getParent()) {
                ((ViewGroup)this.mCustomConfirmView.getParent()).removeAllViews();
            }
            this.mVoiceLayout.addView(this.mCustomConfirmView, new ViewGroup.LayoutParams(-1, -1));
        }
    }

    public static class SimpleMessageDialogBuilder
    extends MessageDialogBuilder<SimpleMessageDialogBuilder> {
        public SimpleMessageDialogBuilder(Context context) {
            super(context);
        }

        @Override
        public int layoutId() {
            return R.layout.layout_simple_message_dialog;
        }

        @Override
        public void onAfterCreateView(View view) {
        }
    }

    public static class SingleContentDialogBuilder
    extends MessageDialogBuilder<SingleContentDialogBuilder> {
        public SingleContentDialogBuilder(Context context) {
            super(context);
        }

        @Override
        public int layoutId() {
            return R.layout.layout_single_message_dialog;
        }

        @Override
        public void onAfterCreateView(View view) {
        }
    }

    public static class SimpleContentDialogBuilder
    extends MessageDialogBuilder<SimpleContentDialogBuilder> {
        private int mMessageContentHeight;
        private String mContent;

        public SimpleContentDialogBuilder(Context context) {
            super(context);
        }

        @Override
        protected void init() {
            super.init();
            this.mMessageContentHeight = this.mContext.getResources().getDimensionPixelSize(R.dimen.dialog_simple_message_content_height);
        }

        @Override
        public int layoutId() {
            return R.layout.layout_simple_message_dialog;
        }

        @Override
        public void onAfterCreateView(View view) {
            this.changeLayoutParams(view, 0, this.mMessageContentHeight);
            if (!TextUtils.isEmpty((CharSequence)this.mContent)) {
                ViewStub contentView = (ViewStub)view.findViewById(R.id.dialog_content);
                View inflateView = contentView.inflate();
                ((TextView)inflateView).setText((CharSequence)this.mContent);
            }
        }

        public SimpleContentDialogBuilder setContent(String content) {
            this.mContent = content;
            return this;
        }
    }

    public static class ImageContentDialogBuilder
    extends MessageDialogBuilder<ImageContentDialogBuilder> {
        private RoundCornerImageView mNotifyIv;
        private int mNotifyResId;
        private Bitmap mNotifyBitmap;
        private String mContent;

        public ImageContentDialogBuilder(Context context) {
            super(context);
        }

        @Override
        public int layoutId() {
            return R.layout.layout_image_content_dialog;
        }

        @Override
        public void onAfterCreateView(View view) {
            this.mNotifyIv = (RoundCornerImageView)view.findViewById(R.id.dialog_notify_img);
            if (this.mNotifyResId != 0) {
                this.mNotifyIv.setImageResource(this.mNotifyResId);
            }
            if (null != this.mNotifyBitmap) {
                this.mNotifyIv.setImageBitmap(this.mNotifyBitmap);
            }
            if (!TextUtils.isEmpty((CharSequence)this.mContent)) {
                ViewStub contentView = (ViewStub)view.findViewById(R.id.dialog_content);
                View inflateView = contentView.inflate();
                ((TextView)inflateView).setText((CharSequence)this.mContent);
            }
        }

        public ImageContentDialogBuilder setNotifyResId(int notifyResId) {
            this.mNotifyResId = notifyResId;
            return this;
        }

        public ImageContentDialogBuilder setNotifyBitmap(Bitmap notifyBitmap) {
            this.mNotifyBitmap = notifyBitmap;
            return this;
        }

        public ImageContentDialogBuilder setContent(String content) {
            this.mContent = content;
            return this;
        }
    }

    public static class CustomerSimpleMsgDialogBuilder
    extends CustomerMessageDialogBuilder<CustomerSimpleMsgDialogBuilder> {
        private int mLayoutWidth;
        private int mLayoutHeight;
        private int mLayoutContentHeight;
        private String mVoiceTitle;
        private String mContent;

        public CustomerSimpleMsgDialogBuilder(Context context) {
            super(context);
        }

        @Override
        protected void init() {
            super.init();
            this.mLayoutHeight = this.mContext.getResources().getDimensionPixelSize(R.dimen.dialog_simple_voice_height);
            this.mLayoutWidth = this.mContext.getResources().getDimensionPixelSize(R.dimen.dialog_customer_message_width);
            this.mLayoutContentHeight = this.mContext.getResources().getDimensionPixelSize(R.dimen.dialog_simple_message_content_height);
        }

        @Override
        public int layoutId() {
            return R.layout.layout_simple_message_dialog;
        }

        public CustomerSimpleMsgDialogBuilder setVoiceTitle(String voiceTitle) {
            this.mVoiceTitle = voiceTitle;
            return this;
        }

        public CustomerSimpleMsgDialogBuilder setContent(String content) {
            this.mContent = content;
            return this;
        }

        @Override
        public void onAfterCreateView(View view) {
            super.onAfterCreateView(view);
            if (!TextUtils.isEmpty((CharSequence)this.mVoiceTitle)) {
                this.changeLayoutParams(view, this.mLayoutWidth, this.mLayoutHeight);
                this.mTitleTv.setSingleLine(false);
                this.mTitleTv.setText((CharSequence)this.mVoiceTitle);
            } else if (!TextUtils.isEmpty((CharSequence)this.mContent)) {
                ViewStub contentView = (ViewStub)view.findViewById(R.id.dialog_content);
                View inflateView = contentView.inflate();
                ((TextView)inflateView).setText((CharSequence)this.mContent);
                this.changeLayoutParams(view, 0, this.mLayoutContentHeight);
            } else {
                this.changeLayoutParams(view, this.mLayoutWidth, 0);
            }
        }
    }

    public static class CustomerImageDialogBuilder
    extends CustomerNormalImageDialogBuilder<CustomerImageDialogBuilder> {
        public CustomerImageDialogBuilder(Context context) {
            super(context);
        }

        @Override
        public int layoutId() {
            return R.layout.layout_image_dialog;
        }
    }

    public static class CustomerImageContentDialogBuilder
    extends CustomerMessageDialogBuilder<CustomerImageContentDialogBuilder> {
        private RoundCornerImageView mNotifyIv;
        private int mNotifyResId;
        private Bitmap mNotifyBitmap;
        private String mContent;
        private int mLayoutHeight;

        public CustomerImageContentDialogBuilder(Context context) {
            super(context);
        }

        @Override
        protected void init() {
            super.init();
            this.mLayoutHeight = this.mContext.getResources().getDimensionPixelSize(R.dimen.dialog_image_customer_height);
        }

        @Override
        public int layoutId() {
            return R.layout.layout_image_content_dialog;
        }

        @Override
        public void onAfterCreateView(View view) {
            super.onAfterCreateView(view);
            this.mNotifyIv = (RoundCornerImageView)view.findViewById(R.id.dialog_notify_img);
            if (this.mNotifyResId != 0) {
                this.mNotifyIv.setImageResource(this.mNotifyResId);
            }
            if (null != this.mNotifyBitmap) {
                this.mNotifyIv.setImageBitmap(this.mNotifyBitmap);
            }
            if (!TextUtils.isEmpty((CharSequence)this.mContent)) {
                ViewStub contentView = (ViewStub)view.findViewById(R.id.dialog_content);
                View inflateView = contentView.inflate();
                ((TextView)inflateView).setText((CharSequence)this.mContent);
                ((TextView)inflateView).setMaxLines(3);
                ((TextView)inflateView).setEllipsize(TextUtils.TruncateAt.END);
            }
            this.changeLayoutParams(view, 0, this.mLayoutHeight);
        }

        public CustomerImageContentDialogBuilder setNotifyResId(int notifyResId) {
            this.mNotifyResId = notifyResId;
            return this;
        }

        public CustomerImageContentDialogBuilder setNotifyBitmap(Bitmap notifyBitmap) {
            this.mNotifyBitmap = notifyBitmap;
            return this;
        }

        public CustomerImageContentDialogBuilder setContent(String content) {
            this.mContent = content;
            return this;
        }
    }
}

