/*
 * Decompiled with CFR 0.152.
 */
package com.rokid.glass.ui.dialog;

import android.content.Context;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import com.rokid.glass.ui.R;
import com.rokid.glass.ui.dialog.GlassDialog;

public abstract class GlassDialogBuilder<T extends GlassDialogBuilder> {
    protected GlassDialog mGlassDialog;
    protected Context mContext;
    private ViewGroup mRootView;
    protected TextView mTitleTv;
    protected String mTitle;
    private boolean mCancelable;
    private boolean mCanceledOnTouchOutside;

    public GlassDialogBuilder(Context context) {
        this.mContext = context;
        this.init();
    }

    public GlassDialog show() {
        GlassDialog dialog = this.create();
        dialog.show();
        return dialog;
    }

    public GlassDialog create() {
        return this.create(R.style.GlassDialogStyle);
    }

    public GlassDialog create(int style2) {
        this.mGlassDialog = new GlassDialog(this.mContext, style2, this);
        Context context = this.mGlassDialog.getContext();
        this.mRootView = (ViewGroup)LayoutInflater.from((Context)context).inflate(R.layout.layout_glass_dialog, null);
        this.onCreateContent(context, this.mRootView, this.mGlassDialog);
        this.mGlassDialog.setCancelable(this.mCancelable);
        this.mGlassDialog.setCanceledOnTouchOutside(this.mCanceledOnTouchOutside);
        this.mGlassDialog.addContentView((View)this.mRootView, new ViewGroup.LayoutParams(-1, -2));
        this.onAfter(context, this.mRootView, this.mGlassDialog);
        return this.mGlassDialog;
    }

    public void dynamicTitle(String title) {
        if (!TextUtils.isEmpty((CharSequence)title) && this.mGlassDialog.isShowing()) {
            this.mTitleTv.setText((CharSequence)title);
        }
    }

    public T setCancelable(boolean cancelable) {
        this.mCancelable = cancelable;
        return (T)this;
    }

    public T setCanceledOnTouchOutside(boolean canceledOnTouchOutside) {
        this.mCanceledOnTouchOutside = canceledOnTouchOutside;
        return (T)this;
    }

    public T setTitle(String title) {
        this.mTitle = title;
        return (T)this;
    }

    protected void dismiss() {
        if (null != this.mGlassDialog && this.mGlassDialog.isShowing()) {
            this.mGlassDialog.dismiss();
        }
    }

    protected void changeLayoutParams(View view, int width, int height) {
        ViewGroup.LayoutParams params = view.getLayoutParams();
        if (width > 0) {
            params.width = width;
        }
        if (height > 0) {
            params.height = height;
        }
        view.setLayoutParams(params);
    }

    protected void dialogShow() {
    }

    protected void onAfter(Context context, ViewGroup parent, GlassDialog dialog) {
    }

    protected abstract void init();

    protected abstract void onCreateContent(Context var1, ViewGroup var2, GlassDialog var3);
}

