/*
 * Decompiled with CFR 0.152.
 */
package com.rokid.glass.ui.imageview;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.RectF;
import android.graphics.Xfermode;
import android.os.Build;
import android.util.AttributeSet;
import android.widget.ImageView;
import com.rokid.glass.ui.R;
import com.rokid.glass.ui.util.Utils;

@SuppressLint(value={"AppCompatCustomView"})
public class RoundCornerImageView
extends ImageView {
    private Context context;
    private boolean isCircle;
    private boolean isCoverSrc;
    private int borderWidth;
    private int borderColor = -1;
    private int innerBorderWidth;
    private int innerBorderColor = -1;
    private int cornerRadius;
    private int cornerTopLeftRadius;
    private int cornerTopRightRadius;
    private int cornerBottomLeftRadius;
    private int cornerBottomRightRadius;
    private int maskColor;
    private Xfermode xfermode;
    private int width;
    private int height;
    private float radius;
    private float[] borderRadii;
    private float[] srcRadii;
    private RectF srcRectF;
    private RectF borderRectF;
    private Paint paint;
    private Path path;
    private Path srcPath;

    public RoundCornerImageView(Context context) {
        this(context, null);
    }

    public RoundCornerImageView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public RoundCornerImageView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.context = context;
        TypedArray ta = context.obtainStyledAttributes(attrs, R.styleable.RoundCornerImageView, 0, 0);
        for (int i = 0; i < ta.getIndexCount(); ++i) {
            int attr = ta.getIndex(i);
            if (attr == R.styleable.RoundCornerImageView_is_cover_src) {
                this.isCoverSrc = ta.getBoolean(attr, this.isCoverSrc);
                continue;
            }
            if (attr == R.styleable.RoundCornerImageView_is_circle) {
                this.isCircle = ta.getBoolean(attr, this.isCircle);
                continue;
            }
            if (attr == R.styleable.RoundCornerImageView_border_width) {
                this.borderWidth = ta.getDimensionPixelSize(attr, this.borderWidth);
                continue;
            }
            if (attr == R.styleable.RoundCornerImageView_border_color) {
                this.borderColor = ta.getColor(attr, this.borderColor);
                continue;
            }
            if (attr == R.styleable.RoundCornerImageView_inner_border_width) {
                this.innerBorderWidth = ta.getDimensionPixelSize(attr, this.innerBorderWidth);
                continue;
            }
            if (attr == R.styleable.RoundCornerImageView_inner_border_color) {
                this.innerBorderColor = ta.getColor(attr, this.innerBorderColor);
                continue;
            }
            if (attr == R.styleable.RoundCornerImageView_corner_radius) {
                this.cornerRadius = ta.getDimensionPixelSize(attr, this.cornerRadius);
                continue;
            }
            if (attr == R.styleable.RoundCornerImageView_corner_top_left_radius) {
                this.cornerTopLeftRadius = ta.getDimensionPixelSize(attr, this.cornerTopLeftRadius);
                continue;
            }
            if (attr == R.styleable.RoundCornerImageView_corner_top_right_radius) {
                this.cornerTopRightRadius = ta.getDimensionPixelSize(attr, this.cornerTopRightRadius);
                continue;
            }
            if (attr == R.styleable.RoundCornerImageView_corner_bottom_left_radius) {
                this.cornerBottomLeftRadius = ta.getDimensionPixelSize(attr, this.cornerBottomLeftRadius);
                continue;
            }
            if (attr == R.styleable.RoundCornerImageView_corner_bottom_right_radius) {
                this.cornerBottomRightRadius = ta.getDimensionPixelSize(attr, this.cornerBottomRightRadius);
                continue;
            }
            if (attr != R.styleable.RoundCornerImageView_mask_color) continue;
            this.maskColor = ta.getColor(attr, this.maskColor);
        }
        ta.recycle();
        this.borderRadii = new float[8];
        this.srcRadii = new float[8];
        this.borderRectF = new RectF();
        this.srcRectF = new RectF();
        this.paint = new Paint();
        this.path = new Path();
        if (Build.VERSION.SDK_INT <= 27) {
            this.xfermode = new PorterDuffXfermode(PorterDuff.Mode.DST_IN);
        } else {
            this.xfermode = new PorterDuffXfermode(PorterDuff.Mode.DST_OUT);
            this.srcPath = new Path();
        }
        this.calculateRadii();
        this.clearInnerBorderWidth();
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        this.width = w;
        this.height = h;
        this.initBorderRectF();
        this.initSrcRectF();
    }

    protected void onDraw(Canvas canvas) {
        canvas.saveLayer(this.srcRectF, null, 31);
        if (!this.isCoverSrc) {
            float sx = 1.0f * (float)(this.width - 2 * this.borderWidth - 2 * this.innerBorderWidth) / (float)this.width;
            float sy = 1.0f * (float)(this.height - 2 * this.borderWidth - 2 * this.innerBorderWidth) / (float)this.height;
            canvas.scale(sx, sy, (float)this.width / 2.0f, (float)this.height / 2.0f);
        }
        super.onDraw(canvas);
        this.paint.reset();
        this.path.reset();
        if (this.isCircle) {
            this.path.addCircle((float)this.width / 2.0f, (float)this.height / 2.0f, this.radius, Path.Direction.CCW);
        } else {
            this.path.addRoundRect(this.srcRectF, this.srcRadii, Path.Direction.CCW);
        }
        this.paint.setAntiAlias(true);
        this.paint.setStyle(Paint.Style.FILL);
        this.paint.setXfermode(this.xfermode);
        if (Build.VERSION.SDK_INT <= 27) {
            canvas.drawPath(this.path, this.paint);
        } else {
            this.srcPath.addRect(this.srcRectF, Path.Direction.CCW);
            this.srcPath.op(this.path, Path.Op.DIFFERENCE);
            canvas.drawPath(this.srcPath, this.paint);
        }
        this.paint.setXfermode(null);
        if (this.maskColor != 0) {
            this.paint.setColor(this.maskColor);
            canvas.drawPath(this.path, this.paint);
        }
        canvas.restore();
        this.drawBorders(canvas);
    }

    private void drawBorders(Canvas canvas) {
        if (this.isCircle) {
            if (this.borderWidth > 0) {
                this.drawCircleBorder(canvas, this.borderWidth, this.borderColor, this.radius - (float)this.borderWidth / 2.0f);
            }
            if (this.innerBorderWidth > 0) {
                this.drawCircleBorder(canvas, this.innerBorderWidth, this.innerBorderColor, this.radius - (float)this.borderWidth - (float)this.innerBorderWidth / 2.0f);
            }
        } else if (this.borderWidth > 0) {
            this.drawRectFBorder(canvas, this.borderWidth, this.borderColor, this.borderRectF, this.borderRadii);
        }
    }

    private void drawCircleBorder(Canvas canvas, int borderWidth, int borderColor, float radius) {
        this.initBorderPaint(borderWidth, borderColor);
        this.path.addCircle((float)this.width / 2.0f, (float)this.height / 2.0f, radius, Path.Direction.CCW);
        canvas.drawPath(this.path, this.paint);
    }

    private void drawRectFBorder(Canvas canvas, int borderWidth, int borderColor, RectF rectF, float[] radii) {
        this.initBorderPaint(borderWidth, borderColor);
        this.path.addRoundRect(rectF, radii, Path.Direction.CCW);
        canvas.drawPath(this.path, this.paint);
    }

    private void initBorderPaint(int borderWidth, int borderColor) {
        this.path.reset();
        this.paint.setStrokeWidth((float)borderWidth);
        this.paint.setColor(borderColor);
        this.paint.setStyle(Paint.Style.STROKE);
    }

    private void initBorderRectF() {
        if (!this.isCircle) {
            this.borderRectF.set((float)this.borderWidth / 2.0f, (float)this.borderWidth / 2.0f, (float)this.width - (float)this.borderWidth / 2.0f, (float)this.height - (float)this.borderWidth / 2.0f);
        }
    }

    private void initSrcRectF() {
        if (this.isCircle) {
            this.radius = (float)Math.min(this.width, this.height) / 2.0f;
            this.srcRectF.set((float)this.width / 2.0f - this.radius, (float)this.height / 2.0f - this.radius, (float)this.width / 2.0f + this.radius, (float)this.height / 2.0f + this.radius);
        } else {
            this.srcRectF.set(0.0f, 0.0f, (float)this.width, (float)this.height);
            if (this.isCoverSrc) {
                this.srcRectF = this.borderRectF;
            }
        }
    }

    private void calculateRadii() {
        if (this.isCircle) {
            return;
        }
        if (this.cornerRadius > 0) {
            for (int i = 0; i < this.borderRadii.length; ++i) {
                this.borderRadii[i] = this.cornerRadius;
                this.srcRadii[i] = (float)this.cornerRadius - (float)this.borderWidth / 2.0f;
            }
        } else {
            this.borderRadii[0] = this.borderRadii[1] = (float)this.cornerTopLeftRadius;
            this.borderRadii[2] = this.borderRadii[3] = (float)this.cornerTopRightRadius;
            this.borderRadii[4] = this.borderRadii[5] = (float)this.cornerBottomRightRadius;
            this.borderRadii[6] = this.borderRadii[7] = (float)this.cornerBottomLeftRadius;
            this.srcRadii[0] = this.srcRadii[1] = (float)this.cornerTopLeftRadius - (float)this.borderWidth / 2.0f;
            this.srcRadii[2] = this.srcRadii[3] = (float)this.cornerTopRightRadius - (float)this.borderWidth / 2.0f;
            this.srcRadii[4] = this.srcRadii[5] = (float)this.cornerBottomRightRadius - (float)this.borderWidth / 2.0f;
            this.srcRadii[6] = this.srcRadii[7] = (float)this.cornerBottomLeftRadius - (float)this.borderWidth / 2.0f;
        }
    }

    private void calculateRadiiAndRectF(boolean reset) {
        if (reset) {
            this.cornerRadius = 0;
        }
        this.calculateRadii();
        this.initBorderRectF();
        this.invalidate();
    }

    private void clearInnerBorderWidth() {
        if (!this.isCircle) {
            this.innerBorderWidth = 0;
        }
    }

    public void isCoverSrc(boolean isCoverSrc) {
        this.isCoverSrc = isCoverSrc;
        this.initSrcRectF();
        this.invalidate();
    }

    public void isCircle(boolean isCircle) {
        this.isCircle = isCircle;
        this.clearInnerBorderWidth();
        this.initSrcRectF();
        this.invalidate();
    }

    public void setBorderWidth(int borderWidth) {
        this.borderWidth = Utils.dp2px(this.context, borderWidth);
        this.calculateRadiiAndRectF(false);
    }

    public void setBorderColor(int borderColor) {
        this.borderColor = borderColor;
        this.invalidate();
    }

    public void setInnerBorderWidth(int innerBorderWidth) {
        this.innerBorderWidth = Utils.dp2px(this.context, innerBorderWidth);
        this.clearInnerBorderWidth();
        this.invalidate();
    }

    public void setInnerBorderColor(int innerBorderColor) {
        this.innerBorderColor = innerBorderColor;
        this.invalidate();
    }

    public void setCornerRadius(int cornerRadius) {
        this.cornerRadius = Utils.dp2px(this.context, cornerRadius);
        this.calculateRadiiAndRectF(false);
    }

    public void setCornerTopLeftRadius(int cornerTopLeftRadius) {
        this.cornerTopLeftRadius = Utils.dp2px(this.context, cornerTopLeftRadius);
        this.calculateRadiiAndRectF(true);
    }

    public void setCornerTopRightRadius(int cornerTopRightRadius) {
        this.cornerTopRightRadius = Utils.dp2px(this.context, cornerTopRightRadius);
        this.calculateRadiiAndRectF(true);
    }

    public void setCornerBottomLeftRadius(int cornerBottomLeftRadius) {
        this.cornerBottomLeftRadius = Utils.dp2px(this.context, cornerBottomLeftRadius);
        this.calculateRadiiAndRectF(true);
    }

    public void setCornerBottomRightRadius(int cornerBottomRightRadius) {
        this.cornerBottomRightRadius = Utils.dp2px(this.context, cornerBottomRightRadius);
        this.calculateRadiiAndRectF(true);
    }

    public void setMaskColor(int maskColor) {
        this.maskColor = maskColor;
        this.invalidate();
    }
}

