/*
 * Decompiled with CFR 0.152.
 */
package com.rokid.glass.ui.toast;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.StringRes;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.widget.LinearLayout;
import android.widget.TextView;
import android.widget.Toast;
import com.rokid.glass.ui.R;
import java.util.Timer;
import java.util.TimerTask;

public class GlassToastUtil {
    public static int DURATION_DEFAULT = 1500;
    private static TextView mTextView;
    private static LinearLayout ll_root;

    public static void showToast(@NonNull Context context, String message, int duration) {
        if (duration >= 3500) {
            duration = 3500;
        }
        View toastRoot = LayoutInflater.from((Context)context).inflate(R.layout.layout_toast, null);
        WindowManager wm = (WindowManager)context.getSystemService("window");
        LinearLayout.LayoutParams layoutParams = new LinearLayout.LayoutParams(wm.getDefaultDisplay().getWidth(), -2);
        ll_root = (LinearLayout)toastRoot.findViewById(R.id.ll_root);
        ll_root.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        mTextView = (TextView)toastRoot.findViewById(R.id.tv_message);
        mTextView.setText((CharSequence)message);
        final Toast toastStart = Toast.makeText((Context)context, (CharSequence)"", (int)1);
        toastStart.setView(toastRoot);
        int height = wm.getDefaultDisplay().getHeight();
        toastStart.setGravity(80, 0, height / 5);
        toastStart.show();
        new Timer().schedule(new TimerTask(){

            @Override
            public void run() {
                toastStart.cancel();
            }
        }, duration);
    }

    public static void showToast(@NonNull Context context, String message) {
        GlassToastUtil.showToast(context, message, DURATION_DEFAULT);
    }

    public static void showToast(@NonNull Context context, @StringRes int resId) {
        GlassToastUtil.showToast(context, context.getResources().getString(resId));
    }
}

