/*
 * Decompiled with CFR 0.152.
 */
package com.rokid.glass.ui.util;

import android.os.CountDownTimer;

public class CountDownManager {
    private CountDownTimer countDownTimer;
    private long millisInFuture;
    private long countDownInterval;
    private CountDownListener countDownListener;

    public CountDownManager(Builder builder) {
        this.millisInFuture = builder.millisInFuture;
        this.countDownInterval = builder.countDownInterval;
        this.countDownListener = builder.countDownListener;
        this.countDownTimer = new CountDownTimer(this.millisInFuture + 100L, this.countDownInterval){

            public void onTick(long millisUntilFinished) {
                if (null != CountDownManager.this.countDownListener) {
                    CountDownManager.this.countDownListener.onTick(millisUntilFinished);
                }
            }

            public void onFinish() {
                if (null != CountDownManager.this.countDownListener) {
                    CountDownManager.this.countDownListener.onFinish();
                }
            }
        };
    }

    public void cancel() {
        if (null != this.countDownTimer) {
            this.countDownTimer.cancel();
        }
    }

    public void start() {
        if (null != this.countDownTimer) {
            this.countDownTimer.start();
        }
    }

    public static interface CountDownListener {
        public void onTick(long var1);

        public void onFinish();
    }

    public static class Builder {
        private long millisInFuture;
        private long countDownInterval;
        private CountDownListener countDownListener;

        public Builder setMillisInFuture(long millisInFuture) {
            this.millisInFuture = millisInFuture;
            return this;
        }

        public Builder setCountDownInterval(long countDownInterval) {
            this.countDownInterval = countDownInterval;
            return this;
        }

        public Builder setCountDownListener(CountDownListener countDownListener) {
            this.countDownListener = countDownListener;
            return this;
        }

        public CountDownManager build() {
            return new CountDownManager(this);
        }
    }
}

