/*
 * Decompiled with CFR 0.152.
 */
package com.rokid.glass.ui.util;

import android.graphics.Rect;
import android.graphics.RectF;
import android.opengl.Matrix;
import android.text.TextUtils;

public class RokidSystem {
    private static final String ALIGNMENT_LEFT = "ro.rokid.alignment.left";
    private static final String ALIGNMENT_TOP = "ro.rokid.alignment.top";
    private static final String ALIGNMENT_RIGHT = "ro.rokid.alignment.right";
    private static final String ALIGNMENT_BOTTOM = "ro.rokid.alignment.bottom";
    private static final String ALIGNMENT_LEFT_HD = "ro.rokid.fhdalignment.left";
    private static final String ALIGNMENT_TOP_HD = "ro.rokid.fhdalignment.top";
    private static final String ALIGNMENT_RIGHT_HD = "ro.rokid.fhdalignment.right";
    private static final String ALIGNMENT_BOTTOM_HD = "ro.rokid.fhdalignment.bottom";
    private static final String ALIGNMENT_LEFT_2K = "ro.rokid.2kalignment.left";
    private static final String ALIGNMENT_TOP_2K = "ro.rokid.2kalignment.top";
    private static final String ALIGNMENT_RIGHT_2K = "ro.rokid.2kalignment.right";
    private static final String ALIGNMENT_BOTTOM_2K = "ro.rokid.2kalignment.bottom";
    private static final String HARDWARE_VERSION = "ro.rokid.hardware.version";
    private static final int BASE_WIDTH = 1280;
    private static final int BASE_HEIGHT = 720;
    private static final int BASE_WIDTH_720P = 1280;
    private static final int BASE_HEIGHT_720P = 720;
    private static final int BASE_WIDTH_HD = 1920;
    private static final int BASE_HEIGHT_HD = 1080;

    @Deprecated
    public static Rect getWindowRect2K(int previewWidth, int previewHeight, Rect windowRect) {
        return RokidSystem.getWindowRect(previewWidth, previewHeight, windowRect);
    }

    public static Rect getWindowRect(int previewWidth, int previewHeight, Rect windowRect) {
        RectF rectF = RokidSystem.getAlignmentRectF(previewWidth);
        if (null == rectF) {
            return null;
        }
        float w = (rectF.right - rectF.left) * (float)previewWidth;
        float h = (rectF.bottom - rectF.top) * (float)previewHeight;
        int left = (int)((float)windowRect.left * w * 1.0f / 1280.0f + rectF.left * (float)previewWidth);
        int top = (int)((float)windowRect.top * h * 1.0f / 720.0f + rectF.top * (float)previewHeight);
        int right = (int)((float)windowRect.right * w * 1.0f / 1280.0f + rectF.left * (float)previewWidth);
        int bottom = (int)((float)windowRect.bottom * h * 1.0f / 720.0f + rectF.top * (float)previewHeight);
        return new Rect(left, top, right, bottom);
    }

    @Deprecated
    public static Rect getAlignmentRect2K(int previewWidth, int previewHeight, Rect previewRect) {
        return RokidSystem.getAlignmentRect(previewWidth, previewHeight, previewRect);
    }

    public static Rect getAlignmentRect(int previewWidth, int previewHeight, Rect previewRect) {
        int height;
        int width;
        RectF rectF = RokidSystem.getAlignmentRectF(previewWidth);
        if (null == rectF) {
            return null;
        }
        float w = (rectF.right - rectF.left) * (float)previewWidth;
        float h = (rectF.bottom - rectF.top) * (float)previewHeight;
        int type = RokidSystem.getBenefitResolution(previewWidth);
        if (type == 1) {
            width = 1920;
            height = 1080;
        } else {
            width = 1280;
            height = 720;
        }
        int left = (int)(((float)previewRect.left - rectF.left * (float)previewWidth) * 1.0f / w * (float)width);
        int top = (int)(((float)previewRect.top - rectF.top * (float)previewHeight) * 1.0f / h * (float)height);
        int right = (int)(((float)previewRect.right - rectF.left * (float)previewWidth) * 1.0f / w * (float)width);
        int bottom = (int)(((float)previewRect.bottom - rectF.top * (float)previewHeight) * 1.0f / h * (float)height);
        return new Rect(left, top, right, bottom);
    }

    public static RectF getAlignmentPercent(int width, int height) {
        Rect rect = width == 1920 ? RokidSystem.getAlignmentBaseRectHD() : RokidSystem.getAlignmentBaseRect();
        return new RectF((float)rect.left * 1.0f / (float)width, (float)rect.top * 1.0f / (float)height, (float)rect.right * 1.0f / (float)width, (float)rect.bottom * 1.0f / (float)height);
    }

    private static RectF getAlignmentRectF(int previewWidth) {
        int height;
        int width;
        int type = RokidSystem.getBenefitResolution(previewWidth);
        if (type == 1) {
            if (RokidSystem.noAlignmentHD()) {
                return null;
            }
            width = 1920;
            height = 1080;
        } else {
            if (RokidSystem.noAlignment()) {
                return null;
            }
            width = 1280;
            height = 720;
        }
        return RokidSystem.getAlignmentPercent(width, height);
    }

    private static int getBenefitResolution(int width) {
        int close720p;
        int closeHD = Math.abs(1920 - width);
        return closeHD < (close720p = Math.abs(1280 - width)) ? 1 : 0;
    }

    public static Rect getAlignmentBaseRect() {
        return new Rect(RokidSystem.toInt(RokidSystem.getSystemProperty(ALIGNMENT_LEFT)), RokidSystem.toInt(RokidSystem.getSystemProperty(ALIGNMENT_TOP)), RokidSystem.toInt(RokidSystem.getSystemProperty(ALIGNMENT_RIGHT)), RokidSystem.toInt(RokidSystem.getSystemProperty(ALIGNMENT_BOTTOM)));
    }

    public static Rect getAlignmentBaseRectHD() {
        return new Rect(RokidSystem.toInt(RokidSystem.getSystemProperty(ALIGNMENT_LEFT_HD)), RokidSystem.toInt(RokidSystem.getSystemProperty(ALIGNMENT_TOP_HD)), RokidSystem.toInt(RokidSystem.getSystemProperty(ALIGNMENT_RIGHT_HD)), RokidSystem.toInt(RokidSystem.getSystemProperty(ALIGNMENT_BOTTOM_HD)));
    }

    private static Rect getAlignmentBaseRect2K() {
        return new Rect(RokidSystem.toInt(RokidSystem.getSystemProperty(ALIGNMENT_LEFT_2K)), RokidSystem.toInt(RokidSystem.getSystemProperty(ALIGNMENT_TOP_2K)), RokidSystem.toInt(RokidSystem.getSystemProperty(ALIGNMENT_RIGHT_2K)), RokidSystem.toInt(RokidSystem.getSystemProperty(ALIGNMENT_BOTTOM_2K)));
    }

    public static float[] getProjectionMatrix_OpticalSeeThrough() {
        float[] rawProjectionMatrixGL2 = new float[]{5.2f, 0.0f, 0.0f, 0.0f, 0.0f, 9.0f, 0.0f, 0.0f, 0.001f, 0.004f, -1.0f, -1.0f, 0.0f, 0.0f, -0.02f, 0.0f};
        double[] tmp = new double[]{1.0, 0.011, -0.001, 0.0, -0.011, 0.994, 0.047, 0.0, 0.002, -0.047, 0.994, 0.0, -35.4, 10.4, -55.4, 1.0};
        float[] eyeAdjustmentGL2 = new float[16];
        for (int i = 0; i < 16; ++i) {
            eyeAdjustmentGL2[i] = (float)tmp[i];
        }
        float[] projectionMatrix = new float[16];
        Matrix.multiplyMM((float[])projectionMatrix, (int)0, (float[])rawProjectionMatrixGL2, (int)0, (float[])eyeAdjustmentGL2, (int)0);
        return projectionMatrix;
    }

    public static String getHardwareVersion() {
        return RokidSystem.getSystemProperty(HARDWARE_VERSION);
    }

    private static int toInt(String value) {
        return !TextUtils.isEmpty((CharSequence)value) && TextUtils.isDigitsOnly((CharSequence)value) ? Integer.parseInt(value) : 0;
    }

    public static String getSystemProperty(String key) {
        String value = null;
        try {
            value = (String)Class.forName("android.os.SystemProperties").getMethod("get", String.class).invoke(null, key);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return value;
    }

    private static boolean noAlignment() {
        return TextUtils.isEmpty((CharSequence)RokidSystem.getSystemProperty(ALIGNMENT_LEFT));
    }

    private static boolean noAlignmentHD() {
        return TextUtils.isEmpty((CharSequence)RokidSystem.getSystemProperty(ALIGNMENT_LEFT_HD));
    }

    private static boolean noAlignment2K() {
        return TextUtils.isEmpty((CharSequence)RokidSystem.getSystemProperty(ALIGNMENT_LEFT_2K));
    }
}

