/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.docker.client.shaded.jnr.ffi;

import com.spotify.docker.client.shaded.jnr.ffi.NativeType;
import com.spotify.docker.client.shaded.jnr.ffi.ObjectReferenceManager;
import com.spotify.docker.client.shaded.jnr.ffi.Type;
import com.spotify.docker.client.shaded.jnr.ffi.TypeAlias;
import com.spotify.docker.client.shaded.jnr.ffi.provider.ClosureManager;
import com.spotify.docker.client.shaded.jnr.ffi.provider.FFIProvider;
import com.spotify.docker.client.shaded.jnr.ffi.provider.LoadedLibrary;
import com.spotify.docker.client.shaded.jnr.ffi.provider.MemoryManager;
import java.nio.ByteOrder;

public abstract class Runtime {
    public static Runtime getSystemRuntime() {
        return SingletonHolder.SYSTEM_RUNTIME;
    }

    public static Runtime getRuntime(Object library) {
        return ((LoadedLibrary)library).getRuntime();
    }

    public abstract Type findType(NativeType var1);

    public abstract Type findType(TypeAlias var1);

    public abstract MemoryManager getMemoryManager();

    public abstract ClosureManager getClosureManager();

    public abstract <T> ObjectReferenceManager<T> newObjectReferenceManager();

    public abstract int getLastError();

    public abstract void setLastError(int var1);

    public abstract long addressMask();

    public abstract int addressSize();

    public abstract int longSize();

    public abstract ByteOrder byteOrder();

    public abstract boolean isCompatible(Runtime var1);

    private static final class SingletonHolder {
        public static final Runtime SYSTEM_RUNTIME = FFIProvider.getSystemProvider().getRuntime();

        private SingletonHolder() {
        }
    }
}

